/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ActiveSetData {
    private boolean hasData = false;
    private int segmentNumber = -1;
    private int numberOfVariablesInSegment = -1;
    private int numberOfInequalityConstraints = -1;
    private final TIntArrayList activeInequalityIndices = new TIntArrayList();
    private final DMatrixRMaj previousSolution = new DMatrixRMaj(1, 1);

    public void reset() {
        this.hasData = false;
        this.segmentNumber = -1;
        this.numberOfVariablesInSegment = -1;
        this.numberOfInequalityConstraints = 0;
        this.clearActiveSet();
    }

    public void resetConstraintCounter() {
        this.numberOfInequalityConstraints = 0;
    }

    public void clearActiveSet() {
        CommonOps_DDRM.fill((DMatrixD1)this.previousSolution, (double)Double.NaN);
        this.activeInequalityIndices.reset();
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setNumberOfVariablesInSegment(int numberOfVariablesInSegment) {
        this.numberOfVariablesInSegment = numberOfVariablesInSegment;
        this.previousSolution.reshape(numberOfVariablesInSegment, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.previousSolution, (double)Double.NaN);
    }

    public DMatrixRMaj getPreviousSolution() {
        return this.previousSolution;
    }

    public void addInequalityConstraints(int numberOfConstraints) {
        this.numberOfInequalityConstraints += numberOfConstraints;
    }

    public void addActiveInequalityConstraint(int constraintIndex) {
        this.activeInequalityIndices.add(constraintIndex);
    }

    public int getNumberOfInequalityConstraints() {
        return this.numberOfInequalityConstraints;
    }

    public int getNumberOfActiveInequalityConstraints() {
        return this.activeInequalityIndices.size();
    }

    public int getActiveInequalityIndex(int constraint) {
        return this.activeInequalityIndices.get(constraint);
    }
}

