/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.messageHandlers;

import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionsListCommand;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class PlanarRegionsListHandler {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final int maxNumberOfPlanarRegions = 100;
    private final YoBoolean hasNewPlanarRegionsList = new YoBoolean("hasNewPlanarRegionsList", this.registry);
    private final YoInteger currentNumberOfPlanarRegions = new YoInteger("currentNumberOfPlanarRegions", this.registry);
    private final RecyclingArrayList<PlanarRegion> planarRegions = new RecyclingArrayList(100, PlanarRegion.class);
    private final YoBoolean waitingOnNewPlanarRegions = new YoBoolean("waitingOnNewPlanarRegions", this.registry);

    public PlanarRegionsListHandler(StatusMessageOutputManager requestOutputManager, YoRegistry parentRegistry) {
        this.planarRegions.clear();
        parentRegistry.addChild(this.registry);
    }

    public void handlePlanarRegionsListCommand(PlanarRegionsListCommand planarRegionsListCommand) {
        this.planarRegions.clear();
        for (int i = 0; i < planarRegionsListCommand.getNumberOfPlanarRegions(); ++i) {
            planarRegionsListCommand.getPlanarRegionCommand(i).getPlanarRegion((PlanarRegion)this.planarRegions.add());
            this.currentNumberOfPlanarRegions.increment();
        }
        this.hasNewPlanarRegionsList.set(true);
        this.waitingOnNewPlanarRegions.set(false);
    }

    public void requestPlanarRegions() {
        this.waitingOnNewPlanarRegions.set(true);
    }

    public boolean hasNewPlanarRegions() {
        return this.hasNewPlanarRegionsList.getBooleanValue();
    }

    public boolean pollHasNewPlanarRegionsList(PlanarRegionsList planarRegionsListToPack) {
        if (!this.hasNewPlanarRegionsList.getBooleanValue()) {
            return false;
        }
        planarRegionsListToPack.clear();
        for (int i = 0; i < this.planarRegions.size(); ++i) {
            planarRegionsListToPack.addPlanarRegion((PlanarRegion)this.planarRegions.get(i));
        }
        this.hasNewPlanarRegionsList.set(false);
        this.planarRegions.clear();
        return true;
    }

    public RecyclingArrayList<PlanarRegion> pollHasNewPlanarRegionsList() {
        this.hasNewPlanarRegionsList.set(false);
        return this.planarRegions;
    }
}

