/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.messageHandlers;

import us.ihmc.commonWalkingControlModules.messageHandlers.EuclideanTrajectoryHandler;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.MomentumTrajectoryCommand;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class MomentumTrajectoryHandler
extends EuclideanTrajectoryHandler {
    public MomentumTrajectoryHandler(YoDouble yoTime, YoRegistry parentRegistry) {
        super("AngularMomentum", (DoubleProvider)yoTime, parentRegistry);
    }

    public void handleMomentumTrajectory(MomentumTrajectoryCommand command) {
        this.handleTrajectory(command.getAngularMomentumTrajectory());
    }

    public void getAngularMomentumTrajectory(double startTime, double endTime, int numberOfPoints, RecyclingArrayList<EuclideanTrajectoryPoint> trajectoryToPack) {
        trajectoryToPack.clear();
        if (!this.isWithinInterval(startTime) || !this.isWithinInterval(endTime)) {
            return;
        }
        for (int pointIndex = 0; pointIndex < numberOfPoints; ++pointIndex) {
            double phaseThroughTrajectory = (double)pointIndex / (double)(numberOfPoints - 1);
            double time = InterpolationTools.linearInterpolate((double)startTime, (double)endTime, (double)phaseThroughTrajectory);
            this.packDesiredsAtTime(time);
            FramePoint3DReadOnly position = this.getPosition();
            FrameVector3DReadOnly velocity = this.getVelocity();
            if (!Double.isFinite(time) || position.containsNaN() || velocity.containsNaN()) {
                PrintTools.warn((String)("Position or velocity of AM contains NaN at time " + time + ". Skipping this trajectory."));
                trajectoryToPack.clear();
                return;
            }
            EuclideanTrajectoryPoint trajectoryPoint = (EuclideanTrajectoryPoint)trajectoryToPack.add();
            trajectoryPoint.setTime(time - startTime);
            trajectoryPoint.setPosition((Point3DReadOnly)this.getPosition());
            trajectoryPoint.setLinearVelocity((Vector3DReadOnly)this.getVelocity());
        }
    }

    public boolean packDesiredAngularMomentumAtTime(double time, FrameVector3DBasics angularMomentumToPack, FrameVector3DBasics angularMomentumRateToPack) {
        if (!this.isWithinInterval(time)) {
            if (angularMomentumToPack != null) {
                angularMomentumToPack.setToNaN(ReferenceFrame.getWorldFrame());
            }
            if (angularMomentumRateToPack != null) {
                angularMomentumRateToPack.setToNaN(ReferenceFrame.getWorldFrame());
            }
            return false;
        }
        this.packDesiredsAtTime(time);
        if (angularMomentumToPack != null) {
            angularMomentumToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.getPosition());
        }
        if (angularMomentumRateToPack != null) {
            angularMomentumRateToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.getVelocity());
        }
        return true;
    }
}

