/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.messageHandlers;

import us.ihmc.commonWalkingControlModules.messageHandlers.EuclideanTrajectoryHandler;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.CenterOfMassTrajectoryCommand;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CenterOfMassTrajectoryHandler
extends EuclideanTrajectoryHandler {
    private final Point3D icpPosition = new Point3D();
    private final Vector3D icpVelocity = new Vector3D();
    private final FrameVector3D offset = new FrameVector3D();

    public CenterOfMassTrajectoryHandler(YoDouble yoTime, YoRegistry parentRegistry) {
        super("CenterOfMass", (DoubleProvider)yoTime, parentRegistry);
    }

    public void handleComTrajectory(CenterOfMassTrajectoryCommand command) {
        this.handleTrajectory(command.getEuclideanTrajectory());
    }

    public boolean packCurrentDesiredICP(double omega0, FramePoint3D desiredICPPositionToPack, FrameVector3D desiredICPVelocityToPack) {
        return this.packCurrentDesiredICP(omega0, desiredICPPositionToPack, desiredICPVelocityToPack, null);
    }

    public boolean packCurrentDesiredICP(double omega0, FramePoint3D desiredICPPositionToPack, FrameVector3D desiredICPVelocityToPack, FramePoint3D comPositionToPack) {
        return this.packDesiredICPAtTime(this.getCurrentTime(), omega0, desiredICPPositionToPack, desiredICPVelocityToPack, comPositionToPack);
    }

    public boolean packDesiredICPAtTime(double controllerTime, double omega0, FramePoint3D desiredICPPositionToPack, FrameVector3D desiredICPVelocityToPack) {
        return this.packDesiredICPAtTime(controllerTime, omega0, desiredICPPositionToPack, desiredICPVelocityToPack, null);
    }

    public boolean packDesiredICPAtTime(double controllerTime, double omega0, FramePoint3D desiredICPPositionToPack, FrameVector3D desiredICPVelocityToPack, FramePoint3D comPositionToPack) {
        if (!this.isWithinInterval(controllerTime)) {
            desiredICPPositionToPack.setToNaN(ReferenceFrame.getWorldFrame());
            desiredICPVelocityToPack.setToNaN(ReferenceFrame.getWorldFrame());
            if (comPositionToPack != null) {
                comPositionToPack.setToNaN(ReferenceFrame.getWorldFrame());
            }
            return false;
        }
        this.packDesiredsAtTime(controllerTime);
        this.icpPosition.scaleAdd(1.0 / omega0, (Tuple3DReadOnly)this.getVelocity(), (Tuple3DReadOnly)this.getPosition());
        this.icpVelocity.scaleAdd(1.0 / omega0, (Tuple3DReadOnly)this.getAcceleration(), (Tuple3DReadOnly)this.getVelocity());
        desiredICPPositionToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.icpPosition);
        desiredICPVelocityToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.icpVelocity);
        desiredICPPositionToPack.add((FrameTuple3DReadOnly)this.offset);
        if (comPositionToPack != null) {
            comPositionToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.getPosition());
            comPositionToPack.add((FrameTuple3DReadOnly)this.offset);
        }
        return true;
    }

    public void setPositionOffset(FrameVector3DReadOnly offset) {
        this.offset.setIncludingFrame((FrameTuple3DReadOnly)offset);
    }
}

