/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.inverseKinematics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.math.QuaternionCalculus;

public class RobotJointVelocityAccelerationIntegrator {
    private final DMatrixRMaj jointConfigurations = new DMatrixRMaj(100, 0);
    private final DMatrixRMaj jointVelocities = new DMatrixRMaj(100, 0);
    private final DMatrixRMaj jointAccelerations = new DMatrixRMaj(100, 0);
    private final double controlDT;
    private double maximumOneDoFJointVelocity = Double.POSITIVE_INFINITY;
    private double maximumSixDoFJointLinearVelocity = Double.POSITIVE_INFINITY;
    private double maximumSixDoFJointAngularVelocity = Double.POSITIVE_INFINITY;
    private double maximumOneDoFJointAcceleration = Double.POSITIVE_INFINITY;
    private double maximumSixDoFJointLinearAcceleration = Double.POSITIVE_INFINITY;
    private double maximumSixDoFJointAngularAcceleration = Double.POSITIVE_INFINITY;
    private final QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
    private final Quaternion previousOrientation = new Quaternion();
    private final Vector3D previousTranslation = new Vector3D();
    private final Vector3D previousLinearVelocity = new Vector3D();
    private final Vector3D previousAngularVelocity = new Vector3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D rotationVectorIntegrated = new Vector3D();
    private final Quaternion rotationIntegrated = new Quaternion();
    private final Quaternion rotation = new Quaternion();
    private final Vector3D translationIntegrated = new Vector3D();
    private final Vector3D translation = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D linearAcceleration = new Vector3D();
    private final Vector3D angularAccelerationIntegrated = new Vector3D();
    private final Vector3D linearAccelerationIntegrated = new Vector3D();

    public RobotJointVelocityAccelerationIntegrator(double controlDT) {
        this.controlDT = controlDT;
    }

    public void setMaximumOneDoFJointVelocity(double maximumOneDoFJointVelocity) {
        this.maximumOneDoFJointVelocity = maximumOneDoFJointVelocity;
    }

    public void setMaximumSixDoFJointLinearVelocity(double maximumSixDoFJointLinearVelocity) {
        this.maximumSixDoFJointLinearVelocity = maximumSixDoFJointLinearVelocity;
    }

    public void setMaximumSixDoFJointAngularVelocity(double maximumSixDoFJointAngularVelocity) {
        this.maximumSixDoFJointAngularVelocity = maximumSixDoFJointAngularVelocity;
    }

    public void integrateJointVelocities(JointBasics[] joints, DMatrixRMaj jointVelocitiesToIntegrate) {
        int jointConfigurationStartIndex = 0;
        int jointStartIndex = 0;
        int numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])joints);
        int sixDofJoints = 0;
        for (JointBasics joint : joints) {
            if (!(joint instanceof FloatingJointReadOnly)) continue;
            ++sixDofJoints;
        }
        this.jointConfigurations.reshape(numberOfDoFs + sixDofJoints, 1);
        this.jointVelocities.reshape(numberOfDoFs, 1);
        for (int i = 0; i < joints.length; ++i) {
            if (joints[i] instanceof OneDoFJointBasics) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints[i];
                double qDot = MathTools.clamp((double)jointVelocitiesToIntegrate.get(jointStartIndex, 0), (double)this.maximumOneDoFJointVelocity);
                double q = joint.getQ() + qDot * this.controlDT;
                q = MathTools.clamp((double)q, (double)joint.getJointLimitLower(), (double)joint.getJointLimitUpper());
                qDot = (q - joint.getQ()) / this.controlDT;
                this.jointConfigurations.set(jointConfigurationStartIndex, 0, q);
                this.jointVelocities.set(jointStartIndex, 0, qDot);
                ++jointConfigurationStartIndex;
                ++jointStartIndex;
                continue;
            }
            if (!(joints[i] instanceof SixDoFJoint)) continue;
            SixDoFJoint joint = (SixDoFJoint)joints[i];
            this.previousOrientation.set((QuaternionReadOnly)joint.getJointPose().getOrientation());
            this.previousTranslation.set((Tuple3DReadOnly)joint.getJointPose().getPosition());
            this.angularVelocity.set(jointStartIndex, (DMatrix)jointVelocitiesToIntegrate);
            double angularVelocityMagnitude = this.angularVelocity.length();
            if (angularVelocityMagnitude > this.maximumSixDoFJointAngularVelocity) {
                this.angularVelocity.scale(this.maximumSixDoFJointAngularVelocity / angularVelocityMagnitude);
            }
            this.rotationVectorIntegrated.setAndScale(this.controlDT, (Tuple3DReadOnly)this.angularVelocity);
            this.quaternionCalculus.exp((Vector3DReadOnly)this.rotationVectorIntegrated, (QuaternionBasics)this.rotationIntegrated);
            this.rotation.set(this.previousOrientation);
            this.rotation.multiply((QuaternionReadOnly)this.rotationIntegrated);
            this.linearVelocity.set(jointStartIndex + 3, (DMatrix)jointVelocitiesToIntegrate);
            double linearVelocityMagnitude = this.linearVelocity.length();
            if (linearVelocityMagnitude > this.maximumSixDoFJointLinearVelocity) {
                this.linearVelocity.scale(this.maximumSixDoFJointLinearVelocity / linearVelocityMagnitude);
            }
            this.translationIntegrated.setAndScale(this.controlDT, (Tuple3DReadOnly)this.linearVelocity);
            this.rotation.transform((Tuple3DBasics)this.translationIntegrated);
            this.translation.add((Tuple3DReadOnly)this.previousTranslation, (Tuple3DReadOnly)this.translationIntegrated);
            this.rotation.get(jointConfigurationStartIndex, (DMatrix)this.jointConfigurations);
            this.translation.get(jointConfigurationStartIndex += 4, (DMatrix)this.jointConfigurations);
            jointConfigurationStartIndex += 3;
            this.angularVelocity.get(jointStartIndex, (DMatrix)this.jointVelocities);
            this.linearVelocity.get(jointStartIndex + 3, (DMatrix)this.jointVelocities);
            jointStartIndex += 6;
        }
    }

    public void integrateJointAccelerations(JointBasics[] joints, DMatrixRMaj jointAccelerationsToIntegrate) {
        int jointStartIndex = 0;
        int numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])joints);
        this.jointVelocities.reshape(numberOfDoFs, 1);
        this.jointAccelerations.reshape(numberOfDoFs, 1);
        for (int i = 0; i < joints.length; ++i) {
            OneDoFJointBasics joint;
            if (joints[i] instanceof OneDoFJointBasics) {
                joint = (OneDoFJointBasics)joints[i];
                double qDDot = MathTools.clamp((double)jointAccelerationsToIntegrate.get(jointStartIndex, 0), (double)this.maximumOneDoFJointAcceleration);
                double qDot = joint.getQd() + qDDot * this.controlDT;
                qDot = MathTools.clamp((double)qDot, (double)this.maximumOneDoFJointVelocity);
                qDDot = (qDot - joint.getQd()) / this.controlDT;
                this.jointVelocities.set(jointStartIndex, 0, qDot);
                this.jointAccelerations.set(jointStartIndex, 0, qDDot);
                ++jointStartIndex;
                continue;
            }
            if (!(joints[i] instanceof SixDoFJoint)) continue;
            joint = (SixDoFJoint)joints[i];
            this.previousOrientation.set((QuaternionReadOnly)joint.getJointPose().getOrientation());
            this.previousTranslation.set((Tuple3DReadOnly)joint.getJointPose().getPosition());
            this.previousLinearVelocity.set((Tuple3DReadOnly)joint.getJointTwist().getLinearPart());
            this.previousAngularVelocity.set((Tuple3DReadOnly)joint.getJointTwist().getAngularPart());
            this.angularAcceleration.set(jointStartIndex, (DMatrix)jointAccelerationsToIntegrate);
            double angularAccelerationMagnitude = this.angularAcceleration.length();
            if (angularAccelerationMagnitude > this.maximumSixDoFJointAngularAcceleration) {
                this.angularAcceleration.scale(this.maximumSixDoFJointAngularAcceleration / angularAccelerationMagnitude);
            }
            this.angularAccelerationIntegrated.setAndScale(this.controlDT, (Tuple3DReadOnly)this.angularAcceleration);
            this.linearAcceleration.set(jointStartIndex + 3, (DMatrix)jointAccelerationsToIntegrate);
            double linearAccelerationMagnitude = this.linearAcceleration.length();
            if (linearAccelerationMagnitude > this.maximumSixDoFJointLinearAcceleration) {
                this.linearAcceleration.scale(this.maximumSixDoFJointLinearAcceleration / linearAccelerationMagnitude);
            }
            this.linearAccelerationIntegrated.setAndScale(this.controlDT, (Tuple3DReadOnly)this.linearAcceleration);
            this.angularVelocity.add((Tuple3DReadOnly)this.previousAngularVelocity, (Tuple3DReadOnly)this.angularAccelerationIntegrated);
            this.linearVelocity.add((Tuple3DReadOnly)this.previousLinearVelocity, (Tuple3DReadOnly)this.linearAccelerationIntegrated);
            this.angularVelocity.get(jointStartIndex, (DMatrix)this.jointVelocities);
            this.linearVelocity.get(jointStartIndex + 3, (DMatrix)this.jointVelocities);
            this.angularAcceleration.get(jointStartIndex, (DMatrix)this.jointAccelerations);
            this.linearAcceleration.get(jointStartIndex + 3, (DMatrix)this.jointAccelerations);
            jointStartIndex += 6;
        }
    }

    public DMatrixRMaj getJointConfigurations() {
        return this.jointConfigurations;
    }

    public DMatrixRMaj getJointVelocities() {
        return this.jointVelocities;
    }

    public DMatrixRMaj getJointAccelerations() {
        return this.jointAccelerations;
    }
}

