/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.inverseKinematics;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.OneDoFJointPrivilegedConfigurationParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointPrivilegedConfigurationHandler {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean isJointPrivilegedConfigurationEnabled = new YoBoolean("isJointPrivilegedConfigurationEnabled", this.registry);
    private boolean hasDefaultConfigurationWeightChanged = true;
    private final YoDouble defaultConfigurationWeight = new YoDouble("jointPrivilegedConfigurationDefaultWeight", this.registry);
    private boolean hasDefaultConfigurationGainChanged = true;
    private final YoDouble defaultConfigurationGain = new YoDouble("jointPrivilegedConfigurationDefaultGain", this.registry);
    private boolean hasDefaultVelocityGainChanged = true;
    private final YoDouble defaultVelocityGain = new YoDouble("jointPrivilegedVelocityDefaultGain", this.registry);
    private boolean hasDefaultMaxVelocityChanged = true;
    private final YoDouble defaultMaxVelocity = new YoDouble("jointPrivilegedConfigurationDefaultMaxVelocity", this.registry);
    private boolean hasDefaultMaxAccelerationChanged = true;
    private final YoDouble defaultMaxAcceleration = new YoDouble("jointPrivilegedConfigurationDefaultMaxAcceleration", this.registry);
    private final YoDouble[] yoJointPrivilegedConfigurations;
    private final YoDouble[] yoJointPrivilegedVelocities;
    private final YoDouble[] yoJointPrivilegedAccelerations;
    private final DMatrixRMaj privilegedConfigurations;
    private final DMatrixRMaj privilegedVelocities;
    private final DMatrixRMaj privilegedAccelerations;
    private final DMatrixRMaj selectionMatrix;
    private final DMatrixRMaj privilegedConfigurationWeights;
    private final DMatrixRMaj privilegedConfigurationGains;
    private final DMatrixRMaj privilegedVelocityGains;
    private final DMatrixRMaj privilegedMaxVelocities;
    private final DMatrixRMaj privilegedMaxAccelerations;
    private final DMatrixRMaj jointSquaredRangeOfMotions;
    private final DMatrixRMaj positionsAtMidRangeOfMotion;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final TObjectIntHashMap<OneDoFJointBasics> jointIndices;
    private final int numberOfDoFs;
    private final ArrayList<PrivilegedJointSpaceCommand> accelerationCommandList = new ArrayList();
    private final ArrayList<PrivilegedJointSpaceCommand> velocityCommandList = new ArrayList();
    private final ArrayList<PrivilegedConfigurationCommand> configurationCommandList = new ArrayList();
    private final ArrayList<OneDoFJointBasics> jointsWithConfiguration = new ArrayList();

    public JointPrivilegedConfigurationHandler(OneDoFJointBasics[] oneDoFJoints, JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters, YoRegistry parentRegistry) {
        int i;
        this.oneDoFJoints = oneDoFJoints;
        this.numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])oneDoFJoints);
        this.privilegedConfigurations = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.privilegedVelocities = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.privilegedAccelerations = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.selectionMatrix = CommonOps_DDRM.identity((int)this.numberOfDoFs);
        this.privilegedConfigurationWeights = new DMatrixRMaj(this.numberOfDoFs, this.numberOfDoFs);
        this.privilegedConfigurationGains = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.privilegedVelocityGains = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.privilegedMaxVelocities = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.privilegedMaxAccelerations = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.jointSquaredRangeOfMotions = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.positionsAtMidRangeOfMotion = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.jointIndices = new TObjectIntHashMap(this.numberOfDoFs, 0.5f, -1);
        this.defaultConfigurationGain.set(jointPrivilegedConfigurationParameters.getDefaultConfigurationGain());
        this.defaultVelocityGain.set(jointPrivilegedConfigurationParameters.getDefaultVelocityGain());
        this.defaultMaxVelocity.set(jointPrivilegedConfigurationParameters.getDefaultMaxVelocity());
        this.defaultMaxAcceleration.set(jointPrivilegedConfigurationParameters.getDefaultMaxAcceleration());
        this.defaultConfigurationWeight.set(jointPrivilegedConfigurationParameters.getDefaultWeight());
        this.defaultConfigurationGain.addListener(v -> {
            this.hasDefaultConfigurationGainChanged = true;
        });
        this.defaultVelocityGain.addListener(v -> {
            this.hasDefaultVelocityGainChanged = true;
        });
        this.defaultMaxVelocity.addListener(v -> {
            this.hasDefaultMaxVelocityChanged = true;
        });
        this.defaultMaxAcceleration.addListener(v -> {
            this.hasDefaultMaxAccelerationChanged = true;
        });
        this.defaultConfigurationWeight.addListener(v -> {
            this.hasDefaultConfigurationWeightChanged = true;
        });
        this.yoJointPrivilegedConfigurations = new YoDouble[this.numberOfDoFs];
        this.yoJointPrivilegedVelocities = new YoDouble[this.numberOfDoFs];
        this.yoJointPrivilegedAccelerations = new YoDouble[this.numberOfDoFs];
        for (i = 0; i < this.numberOfDoFs; ++i) {
            double jointLimitLower;
            OneDoFJointBasics joint = oneDoFJoints[i];
            this.jointIndices.put((Object)joint, i);
            double jointLimitUpper = joint.getJointLimitUpper();
            if (Double.isNaN(jointLimitUpper) || Double.isInfinite(jointLimitUpper)) {
                jointLimitUpper = Math.PI;
            }
            if (Double.isNaN(jointLimitLower = joint.getJointLimitLower()) || Double.isInfinite(jointLimitLower)) {
                jointLimitLower = -Math.PI;
            }
            this.jointSquaredRangeOfMotions.set(i, 0, MathTools.square((double)(jointLimitUpper - jointLimitLower)));
            this.positionsAtMidRangeOfMotion.set(i, 0, 0.5 * (jointLimitUpper + jointLimitLower));
            String jointName = joint.getName();
            this.yoJointPrivilegedConfigurations[i] = new YoDouble("q_priv_" + jointName, this.registry);
            this.yoJointPrivilegedVelocities[i] = new YoDouble("qd_priv_" + jointName, this.registry);
            this.yoJointPrivilegedAccelerations[i] = new YoDouble("qdd_priv_" + jointName, this.registry);
        }
        for (i = 0; i < this.numberOfDoFs; ++i) {
            this.setPrivilegedConfigurationFromOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_MID_RANGE, i);
        }
        parentRegistry.addChild(this.registry);
    }

    public void computePrivilegedJointVelocities() {
        this.processPrivilegedConfigurationCommands();
        for (int jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
            OneDoFJointBasics joint = this.oneDoFJoints[jointIndex];
            double qd = 2.0 * this.privilegedConfigurationGains.get(jointIndex, 0) * (this.privilegedConfigurations.get(jointIndex, 0) - joint.getQ()) / this.jointSquaredRangeOfMotions.get(jointIndex, 0);
            qd = MathTools.clamp((double)qd, (double)this.privilegedMaxVelocities.get(jointIndex, 0));
            this.privilegedVelocities.set(jointIndex, 0, qd);
            this.yoJointPrivilegedVelocities[jointIndex].set(qd);
        }
        this.processPrivilegedVelocityCommands();
    }

    public void computePrivilegedJointAccelerations() {
        this.processPrivilegedConfigurationCommands();
        for (int jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
            OneDoFJointBasics joint = this.oneDoFJoints[jointIndex];
            double qdd = 2.0 * this.privilegedConfigurationGains.get(jointIndex, 0) * (this.privilegedConfigurations.get(jointIndex, 0) - joint.getQ()) / this.jointSquaredRangeOfMotions.get(jointIndex, 0);
            qdd -= this.privilegedVelocityGains.get(jointIndex, 0) * joint.getQd();
            qdd = MathTools.clamp((double)qdd, (double)this.privilegedMaxAccelerations.get(jointIndex, 0));
            this.privilegedAccelerations.set(jointIndex, 0, qdd);
            this.yoJointPrivilegedAccelerations[jointIndex].set(qdd);
        }
        this.processPrivilegedAccelerationCommands();
    }

    public void submitPrivilegedAccelerations(PrivilegedJointSpaceCommand command) {
        this.accelerationCommandList.add(command);
        this.isJointPrivilegedConfigurationEnabled.set(command.isEnabled());
    }

    public void submitPrivilegedVelocities(PrivilegedJointSpaceCommand command) {
        this.velocityCommandList.add(command);
        this.isJointPrivilegedConfigurationEnabled.set(command.isEnabled());
    }

    public void submitPrivilegedConfigurationCommand(PrivilegedConfigurationCommand command) {
        this.configurationCommandList.add(command);
        this.isJointPrivilegedConfigurationEnabled.set(command.isEnabled());
        OneDoFJointPrivilegedConfigurationParameters defaultParameters = command.getDefaultParameters();
        if (defaultParameters.hasWeight()) {
            this.defaultConfigurationWeight.set(defaultParameters.getWeight());
        }
        if (defaultParameters.hasConfigurationGain()) {
            this.defaultConfigurationGain.set(defaultParameters.getConfigurationGain());
        }
        if (defaultParameters.hasVelocityGain()) {
            this.defaultVelocityGain.set(defaultParameters.getVelocityGain());
        }
        if (defaultParameters.hasMaxVelocity()) {
            this.defaultMaxVelocity.set(defaultParameters.getMaxVelocity());
        }
        if (defaultParameters.hasMaxAcceleration()) {
            this.defaultMaxAcceleration.set(defaultParameters.getMaxAcceleration());
        }
    }

    private void processPrivilegedAccelerationCommands() {
        for (int commandIndex = 0; commandIndex < this.accelerationCommandList.size(); ++commandIndex) {
            PrivilegedJointSpaceCommand command = this.accelerationCommandList.get(commandIndex);
            for (int jointNumber = 0; jointNumber < command.getNumberOfJoints(); ++jointNumber) {
                OneDoFJointBasics joint = command.getJoint(jointNumber);
                int jointIndex = this.jointIndices.get((Object)joint);
                if (jointIndex == this.jointIndices.getNoEntryValue()) continue;
                OneDoFJointBasics configuredJoint = this.oneDoFJoints[jointIndex];
                if (command.hasNewPrivilegedCommand(jointNumber)) {
                    double qdd = command.getPrivilegedCommand(jointNumber);
                    qdd = MathTools.clamp((double)qdd, (double)this.privilegedMaxAccelerations.get(jointIndex, 0));
                    this.privilegedAccelerations.set(jointIndex, 0, qdd);
                    this.yoJointPrivilegedAccelerations[jointIndex].set(qdd);
                }
                if (command.hasWeight(jointNumber)) {
                    this.privilegedConfigurationWeights.set(jointIndex, jointIndex, command.getWeight(jointNumber));
                }
                if (!this.jointsWithConfiguration.contains(configuredJoint)) {
                    this.jointsWithConfiguration.add(configuredJoint);
                    continue;
                }
                LogTools.warn((String)("Overwriting privileged acceleration for joint " + configuredJoint.getName() + "."));
            }
        }
        this.accelerationCommandList.clear();
    }

    private void processPrivilegedVelocityCommands() {
        for (int commandIndex = 0; commandIndex < this.velocityCommandList.size(); ++commandIndex) {
            PrivilegedJointSpaceCommand command = this.velocityCommandList.get(commandIndex);
            for (int jointNumber = 0; jointNumber < command.getNumberOfJoints(); ++jointNumber) {
                OneDoFJointBasics joint = command.getJoint(jointNumber);
                int jointIndex = this.jointIndices.get((Object)joint);
                if (jointIndex == this.jointIndices.getNoEntryValue()) continue;
                OneDoFJointBasics configuredJoint = this.oneDoFJoints[jointIndex];
                if (command.hasNewPrivilegedCommand(jointNumber)) {
                    double qd = command.getPrivilegedCommand(jointNumber);
                    qd = MathTools.clamp((double)qd, (double)this.privilegedMaxVelocities.get(jointIndex, 0));
                    this.privilegedVelocities.set(jointIndex, 0, qd);
                    this.yoJointPrivilegedVelocities[jointIndex].set(qd);
                }
                if (command.hasWeight(jointNumber)) {
                    this.privilegedConfigurationWeights.set(jointIndex, jointIndex, command.getWeight(jointNumber));
                }
                if (!this.jointsWithConfiguration.contains(configuredJoint)) {
                    this.jointsWithConfiguration.add(configuredJoint);
                    continue;
                }
                LogTools.warn((String)("Overwriting privileged velocity for joint " + configuredJoint.getName() + "."));
            }
        }
        this.velocityCommandList.clear();
    }

    private void processPrivilegedConfigurationCommands() {
        this.processDefaultPrivilegedConfigurationOptions();
        this.processDefaultParameters();
        this.processPrivilegedConfigurations();
        this.configurationCommandList.clear();
        this.jointsWithConfiguration.clear();
    }

    private void processDefaultPrivilegedConfigurationOptions() {
        for (int commandIndex = 0; commandIndex < this.configurationCommandList.size(); ++commandIndex) {
            OneDoFJointPrivilegedConfigurationParameters defaultParameters = this.configurationCommandList.get(commandIndex).getDefaultParameters();
            if (!defaultParameters.hasPrivilegedConfigurationOption()) continue;
            PrivilegedConfigurationCommand.PrivilegedConfigurationOption defaultOption = defaultParameters.getPrivilegedConfigurationOption();
            for (int jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.setPrivilegedConfigurationFromOption(defaultOption, jointIndex);
            }
        }
    }

    private void processDefaultParameters() {
        int jointIndex;
        if (this.hasDefaultConfigurationWeightChanged) {
            for (jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.privilegedConfigurationWeights.set(jointIndex, jointIndex, this.defaultConfigurationWeight.getDoubleValue());
            }
            this.hasDefaultConfigurationWeightChanged = false;
        }
        if (this.hasDefaultConfigurationGainChanged) {
            for (jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.privilegedConfigurationGains.set(jointIndex, 0, this.defaultConfigurationGain.getDoubleValue());
            }
            this.hasDefaultConfigurationGainChanged = false;
        }
        if (this.hasDefaultVelocityGainChanged) {
            for (jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.privilegedVelocityGains.set(jointIndex, 0, this.defaultVelocityGain.getDoubleValue());
            }
            this.hasDefaultVelocityGainChanged = false;
        }
        if (this.hasDefaultMaxVelocityChanged) {
            for (jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.privilegedMaxVelocities.set(jointIndex, 0, this.defaultMaxVelocity.getDoubleValue());
            }
            this.hasDefaultMaxVelocityChanged = false;
        }
        if (this.hasDefaultMaxAccelerationChanged) {
            for (jointIndex = 0; jointIndex < this.numberOfDoFs; ++jointIndex) {
                this.privilegedMaxAccelerations.set(jointIndex, 0, this.defaultMaxAcceleration.getDoubleValue());
            }
            this.hasDefaultMaxAccelerationChanged = false;
        }
    }

    private void processPrivilegedConfigurations() {
        for (int commandIndex = 0; commandIndex < this.configurationCommandList.size(); ++commandIndex) {
            PrivilegedConfigurationCommand command = this.configurationCommandList.get(commandIndex);
            for (int jointNumber = 0; jointNumber < command.getNumberOfJoints(); ++jointNumber) {
                OneDoFJointBasics configuredJoint;
                OneDoFJointBasics joint = command.getJoint(jointNumber);
                int jointIndex = this.jointIndices.get((Object)joint);
                if (jointIndex == this.jointIndices.getNoEntryValue()) continue;
                OneDoFJointPrivilegedConfigurationParameters jointSpecificParameters = command.getJointSpecificParameters(jointNumber);
                if (jointSpecificParameters.hasPrivilegedConfiguration()) {
                    configuredJoint = this.oneDoFJoints[jointIndex];
                    double qPrivileged = jointSpecificParameters.getPrivilegedConfiguration();
                    this.privilegedConfigurations.set(jointIndex, 0, qPrivileged);
                    this.yoJointPrivilegedConfigurations[jointIndex].set(qPrivileged);
                    if (!this.jointsWithConfiguration.contains(configuredJoint)) {
                        this.jointsWithConfiguration.add(configuredJoint);
                    } else {
                        LogTools.warn((String)("Overwriting privileged configuration angle for joint " + configuredJoint.getName() + "."));
                    }
                }
                if (jointSpecificParameters.hasPrivilegedConfigurationOption()) {
                    configuredJoint = this.oneDoFJoints[jointIndex];
                    PrivilegedConfigurationCommand.PrivilegedConfigurationOption option = jointSpecificParameters.getPrivilegedConfigurationOption();
                    this.setPrivilegedConfigurationFromOption(option, jointIndex);
                    if (!this.jointsWithConfiguration.contains(configuredJoint)) {
                        this.jointsWithConfiguration.add(configuredJoint);
                    } else {
                        LogTools.warn((String)("Overwriting privileged configuration option for joint " + configuredJoint.getName() + "."));
                    }
                }
                this.processConfigurationWeightsAndGains(jointSpecificParameters, jointIndex);
            }
        }
    }

    private void processConfigurationWeightsAndGains(OneDoFJointPrivilegedConfigurationParameters jointSpecificParameters, int jointIndex) {
        if (jointSpecificParameters.hasWeight()) {
            this.privilegedConfigurationWeights.set(jointIndex, jointIndex, jointSpecificParameters.getWeight());
        }
        if (jointSpecificParameters.hasConfigurationGain()) {
            this.privilegedConfigurationGains.set(jointIndex, 0, jointSpecificParameters.getConfigurationGain());
        }
        if (jointSpecificParameters.hasVelocityGain()) {
            this.privilegedVelocityGains.set(jointIndex, 0, jointSpecificParameters.getVelocityGain());
        }
        if (jointSpecificParameters.hasMaxVelocity()) {
            this.privilegedMaxVelocities.set(jointIndex, 0, jointSpecificParameters.getMaxVelocity());
        }
        if (jointSpecificParameters.hasMaxAcceleration()) {
            this.privilegedMaxAccelerations.set(jointIndex, 0, jointSpecificParameters.getMaxAcceleration());
        }
    }

    private void setPrivilegedConfigurationFromOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption option, int jointIndex) {
        double qPrivileged;
        switch (option) {
            case AT_CURRENT: {
                qPrivileged = this.oneDoFJoints[jointIndex].getQ();
                break;
            }
            case AT_ZERO: {
                qPrivileged = 0.0;
                break;
            }
            case AT_MID_RANGE: {
                qPrivileged = this.positionsAtMidRangeOfMotion.get(jointIndex);
                break;
            }
            default: {
                throw new RuntimeException("Cannot handle the PrivilegedConfigurationOption:" + (Object)((Object)option));
            }
        }
        this.privilegedConfigurations.set(jointIndex, 0, qPrivileged);
        this.yoJointPrivilegedConfigurations[jointIndex].set(qPrivileged);
    }

    public boolean isEnabled() {
        return this.isJointPrivilegedConfigurationEnabled.getBooleanValue();
    }

    public DMatrixRMaj getPrivilegedJointVelocities() {
        return this.privilegedVelocities;
    }

    public DMatrixRMaj getPrivilegedJointAccelerations() {
        return this.privilegedAccelerations;
    }

    public double getPrivilegedJointAcceleration(OneDoFJointBasics joint) {
        return this.privilegedAccelerations.get(this.jointIndices.get((Object)joint), 0);
    }

    public DMatrixRMaj getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public OneDoFJointBasics[] getJoints() {
        return this.oneDoFJoints;
    }

    public DMatrixRMaj getWeights() {
        return this.privilegedConfigurationWeights;
    }

    public double getWeight(OneDoFJointBasics joint) {
        int jointIndex = this.jointIndices.get((Object)joint);
        return this.privilegedConfigurationWeights.get(jointIndex, jointIndex);
    }
}

