/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.inverseKinematics;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPVariableSubstitution;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class InverseKinematicsQPSolver {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("qpSolverTimer", 0.5, this.registry);
    private final YoBoolean firstCall = new YoBoolean("firstCall", this.registry);
    private final ActiveSetQPSolverWithInactiveVariablesInterface qpSolver;
    private final QPVariableSubstitution variableSubstitution = new QPVariableSubstitution();
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_f;
    private final DMatrixRMaj solverInput_Aeq;
    private final DMatrixRMaj solverInput_beq;
    private final DMatrixRMaj solverInput_Ain;
    private final DMatrixRMaj solverInput_bin;
    private final DMatrixRMaj solverInput_lb;
    private final DMatrixRMaj solverInput_ub;
    private final DMatrixRMaj solverOutput;
    private final DMatrixRMaj desiredJointVelocities;
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoInteger numberOfEqualityConstraints = new YoInteger("numberOfEqualityConstraints", this.registry);
    private final YoInteger numberOfInequalityConstraints = new YoInteger("numberOfInequalityConstraints", this.registry);
    private final YoInteger numberOfConstraints = new YoInteger("numberOfConstraints", this.registry);
    private final YoDouble jointVelocityRegularization = new YoDouble("jointVelocityRegularization", this.registry);
    private final YoDouble jointAccelerationRegularization = new YoDouble("jointAccelerationRegularization", this.registry);
    private final int numberOfDoFs;
    private boolean resetActiveSet = false;
    private boolean useWarmStart = false;
    private int maxNumberOfIterations = 100;
    private final double dt;
    private final DMatrixRMaj tempJtW = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempTask_H = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempTask_f = new DMatrixRMaj(1, 1);

    public InverseKinematicsQPSolver(ActiveSetQPSolverWithInactiveVariablesInterface qpSolver, int numberOfDoFs, double dt, YoRegistry parentRegistry) {
        this.qpSolver = qpSolver;
        this.numberOfDoFs = numberOfDoFs;
        this.dt = dt;
        this.firstCall.set(true);
        this.solverInput_H = new DMatrixRMaj(numberOfDoFs, numberOfDoFs);
        this.solverInput_f = new DMatrixRMaj(numberOfDoFs, 1);
        this.solverInput_lb = new DMatrixRMaj(numberOfDoFs, 1);
        this.solverInput_ub = new DMatrixRMaj(numberOfDoFs, 1);
        this.solverInput_Aeq = new DMatrixRMaj(0, numberOfDoFs);
        this.solverInput_beq = new DMatrixRMaj(0, 1);
        this.solverInput_Ain = new DMatrixRMaj(0, numberOfDoFs);
        this.solverInput_bin = new DMatrixRMaj(0, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_lb, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_ub, (double)Double.POSITIVE_INFINITY);
        this.solverOutput = new DMatrixRMaj(numberOfDoFs, 1);
        this.jointVelocityRegularization.set(0.5);
        this.jointAccelerationRegularization.set(10.0);
        this.desiredJointVelocities = new DMatrixRMaj(numberOfDoFs, 1);
        this.variableSubstitution.setIgnoreBias(true);
        parentRegistry.addChild(this.registry);
    }

    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void notifyResetActiveSet() {
        this.resetActiveSet = true;
    }

    private boolean pollResetActiveSet() {
        boolean ret = this.resetActiveSet;
        this.resetActiveSet = false;
        return ret;
    }

    public void reset() {
        this.variableSubstitution.reset();
        this.solverInput_H.zero();
        for (int i = 0; i < this.numberOfDoFs; ++i) {
            this.solverInput_H.set(i, i, this.jointVelocityRegularization.getDoubleValue());
        }
        this.solverInput_f.reshape(this.numberOfDoFs, 1);
        this.solverInput_f.zero();
        this.solverInput_Aeq.reshape(0, this.numberOfDoFs);
        this.solverInput_beq.reshape(0, 1);
        this.solverInput_Ain.reshape(0, this.numberOfDoFs);
        this.solverInput_bin.reshape(0, 1);
        if (!this.firstCall.getBooleanValue()) {
            this.addJointAccelerationRegularization();
        }
    }

    private void addJointAccelerationRegularization() {
        double factor = this.dt * this.dt / this.jointAccelerationRegularization.getDoubleValue();
        for (int i = 0; i < this.numberOfDoFs; ++i) {
            this.solverInput_H.add(i, i, 1.0 / factor);
            this.solverInput_f.add(i, 0, -this.desiredJointVelocities.get(i, 0) / factor);
        }
    }

    public void addMotionInput(QPInputTypeA input) {
        switch (input.getConstraintType()) {
            case OBJECTIVE: {
                if (input.useWeightScalar()) {
                    this.addMotionTask(input.taskJacobian, input.taskObjective, input.getWeightScalar());
                    break;
                }
                this.addMotionTask(input.taskJacobian, input.taskObjective, input.taskWeightMatrix);
                break;
            }
            case EQUALITY: {
                this.addMotionEqualityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case LEQ_INEQUALITY: {
                this.addMotionLesserOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case GEQ_INEQUALITY: {
                this.addMotionGreaterOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected constraint type: " + (Object)((Object)input.getConstraintType()));
            }
        }
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.numberOfDoFs, taskSize);
        MatrixTools.scaleTranspose((double)taskWeight, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempJtW);
        this.addMotionTaskInternal(this.tempJtW, taskJacobian, taskObjective);
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.numberOfDoFs, taskSize);
        CommonOps_DDRM.multTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        this.addMotionTaskInternal(this.tempJtW, taskJacobian, taskObjective);
    }

    private void addMotionTaskInternal(DMatrixRMaj taskJtW, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.tempTask_H.reshape(this.numberOfDoFs, this.numberOfDoFs);
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempTask_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.tempTask_H);
        this.tempTask_f.reshape(this.numberOfDoFs, 1);
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempTask_f);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.solverInput_f, (DMatrixD1)this.tempTask_f);
    }

    public void addMotionEqualityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_beq.getNumRows();
        this.solverInput_Aeq.reshape(previousSize + taskSize, this.numberOfDoFs, true);
        this.solverInput_beq.reshape(previousSize + taskSize, 1, true);
        CommonOps_DDRM.insert((DMatrix)taskJacobian, (DMatrix)this.solverInput_Aeq, (int)previousSize, (int)0);
        CommonOps_DDRM.insert((DMatrix)taskObjective, (DMatrix)this.solverInput_beq, (int)previousSize, (int)0);
    }

    public void addMotionLesserOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, 1.0);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, -1.0);
    }

    private void addMotionInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_bin.getNumRows();
        this.solverInput_Ain.reshape(previousSize + taskSize, this.numberOfDoFs, true);
        this.solverInput_bin.reshape(previousSize + taskSize, 1, true);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Ain, (int)previousSize, (int)0, (DMatrix)taskJacobian, (int)0, (int)0, (int)taskSize, (int)this.numberOfDoFs, (double)sign);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bin, (int)previousSize, (int)0, (DMatrix)taskObjective, (int)0, (int)0, (int)taskSize, (int)1, (double)sign);
    }

    public void addVariableSubstitution(QPVariableSubstitution substitution) {
        this.variableSubstitution.concatenate(substitution);
    }

    public void solve() throws NoConvergenceException {
        this.numberOfEqualityConstraints.set(this.solverInput_Aeq.getNumRows());
        this.numberOfInequalityConstraints.set(this.solverInput_Ain.getNumRows());
        this.numberOfConstraints.set(this.solverInput_Aeq.getNumRows() + this.solverInput_Ain.getNumRows());
        this.qpSolverTimer.startMeasurement();
        this.qpSolver.clear();
        this.qpSolver.setUseWarmStart(this.useWarmStart);
        this.qpSolver.setMaxNumberOfIterations(this.maxNumberOfIterations);
        if (this.useWarmStart && this.pollResetActiveSet()) {
            this.qpSolver.resetActiveSet();
        }
        TIntArrayList inactiveIndices = this.applySubstitution();
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_f, 0.0);
        this.qpSolver.setVariableBounds((DMatrix)this.solverInput_lb, (DMatrix)this.solverInput_ub);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.solverInput_Ain, (DMatrix)this.solverInput_bin);
        this.qpSolver.setLinearEqualityConstraints((DMatrix)this.solverInput_Aeq, (DMatrix)this.solverInput_beq);
        if (inactiveIndices != null) {
            for (int i = 0; i < inactiveIndices.size(); ++i) {
                this.qpSolver.setVariableInactive(inactiveIndices.get(i));
            }
        }
        this.numberOfIterations.set(this.qpSolver.solve((DMatrix)this.solverOutput));
        this.removeSubstitution();
        this.qpSolverTimer.stopMeasurement();
        if (MatrixTools.containsNaN((DMatrix1Row)this.solverOutput)) {
            throw new NoConvergenceException(this.numberOfIterations.getIntegerValue());
        }
        this.desiredJointVelocities.set((DMatrixD1)this.solverOutput);
        this.firstCall.set(false);
    }

    private TIntArrayList applySubstitution() {
        if (this.variableSubstitution.isEmpty()) {
            return null;
        }
        this.variableSubstitution.applySubstitutionToObjectiveFunction(this.solverInput_H, this.solverInput_f);
        this.variableSubstitution.applySubstitutionToLinearConstraint(this.solverInput_Aeq, this.solverInput_beq);
        this.variableSubstitution.applySubstitutionToLinearConstraint(this.solverInput_Ain, this.solverInput_bin);
        this.variableSubstitution.applySubstitutionToBounds(this.solverInput_lb, this.solverInput_ub, this.solverInput_Ain, this.solverInput_bin);
        return this.variableSubstitution.getInactiveIndices();
    }

    private void removeSubstitution() {
        if (this.variableSubstitution.isEmpty()) {
            return;
        }
        this.variableSubstitution.removeSubstitutionToSolution(this.solverOutput);
    }

    public DMatrixRMaj getJointVelocities() {
        return this.desiredJointVelocities;
    }

    public void setVelocityRegularizationWeight(double weight) {
        this.jointVelocityRegularization.set(weight);
    }

    public void setAccelerationRegularizationWeight(double weight) {
        this.jointAccelerationRegularization.set(weight);
    }

    public void setMinJointVelocities(DMatrixRMaj qDotMin) {
        this.solverInput_lb.set((DMatrixD1)qDotMin);
    }

    public void setMaxJointVelocities(DMatrixRMaj qDotMax) {
        this.solverInput_ub.set((DMatrixD1)qDotMax);
    }
}

