/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions;

import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.math.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FeetLoadedTransition
implements StateTransitionCondition {
    protected final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final double MINIMUM_WEIGHT_FRACTION = 0.16666666666666666;
    private static final double TIME_WINDOW = 3.0;
    private final SideDependentList<ForceSensorDataReadOnly> footSensors = new SideDependentList();
    private final YoBoolean areFeetLoaded;
    private final YoDouble weightPerFootForLoaded;
    private final SideDependentList<YoDouble> prepFootFzs = new SideDependentList();
    private final SideDependentList<SimpleMovingAverageFilteredYoVariable> prepFootFzAverages = new SideDependentList();
    private final Wrench temporaryFootWrench = new Wrench();

    public FeetLoadedTransition(ForceSensorDataHolderReadOnly forceSensorDataHolder, SideDependentList<String> feetForceSensors, double controlDT, double gravityZ, double totalMass, YoRegistry parentRegistry) {
        for (RobotSide robotSide : RobotSide.values) {
            this.footSensors.put((Enum)robotSide, (Object)forceSensorDataHolder.getByName((String)feetForceSensors.get((Enum)robotSide)));
        }
        int windowSize = (int)Math.floor(3.0 / controlDT);
        this.areFeetLoaded = new YoBoolean("areFeetLoaded", this.registry);
        this.weightPerFootForLoaded = new YoDouble("weightPerFootForLoaded", this.registry);
        this.weightPerFootForLoaded.set(gravityZ * totalMass * 0.16666666666666666);
        for (RobotSide robotSide : RobotSide.values) {
            YoDouble prepFootFz = new YoDouble("prep" + robotSide.getCamelCaseName() + "FootFz", this.registry);
            SimpleMovingAverageFilteredYoVariable prepFootFzAverage = new SimpleMovingAverageFilteredYoVariable("prep" + robotSide.getCamelCaseName() + "FootFzAverage", windowSize, prepFootFz, this.registry);
            this.prepFootFzs.put((Enum)robotSide, (Object)prepFootFz);
            this.prepFootFzAverages.put((Enum)robotSide, (Object)prepFootFzAverage);
        }
        parentRegistry.addChild(this.registry);
    }

    private boolean areFeetLoaded() {
        double averageWeight = 0.0;
        for (RobotSide robotSide : RobotSide.values) {
            YoDouble prepFootFz = (YoDouble)this.prepFootFzs.get((Enum)robotSide);
            SimpleMovingAverageFilteredYoVariable prepFootFzAverage = (SimpleMovingAverageFilteredYoVariable)this.prepFootFzAverages.get((Enum)robotSide);
            ((ForceSensorDataReadOnly)this.footSensors.get((Enum)robotSide)).getWrench(this.temporaryFootWrench);
            prepFootFz.set(this.temporaryFootWrench.getLinearPartZ());
            prepFootFzAverage.update();
            averageWeight += prepFootFzAverage.getDoubleValue();
        }
        this.areFeetLoaded.set(averageWeight > 2.0 * this.weightPerFootForLoaded.getDoubleValue());
        return this.areFeetLoaded.getBooleanValue();
    }

    public boolean testCondition(double timeInState) {
        return this.areFeetLoaded();
    }
}

