/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions;

import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions.FeetLoadedTransition;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FeetLoadedToWalkingStandTransition
extends FeetLoadedTransition {
    private final HighLevelControllerName nextStateEnum;
    private final YoEnum<HighLevelControllerName> requestedState;
    private final YoBoolean waitForRequest;
    private final YoDouble minimumTimeInState;

    public FeetLoadedToWalkingStandTransition(HighLevelControllerName nextStateEnum, YoEnum<HighLevelControllerName> requestedState, ForceSensorDataHolderReadOnly forceSensorDataHolder, SideDependentList<String> feetForceSensors, double controlDT, double totalMass, double gravityZ, HighLevelControllerParameters highLevelControllerParameters, YoRegistry parentRegistry) {
        super(forceSensorDataHolder, feetForceSensors, controlDT, totalMass, gravityZ, parentRegistry);
        this.nextStateEnum = nextStateEnum;
        this.requestedState = requestedState;
        this.minimumTimeInState = new YoDouble("minimumTimeLoadingFeet", this.registry);
        this.minimumTimeInState.set(highLevelControllerParameters.getMinimumTimeInStandReady());
        this.waitForRequest = new YoBoolean("waitForRequestToTransitionToWalking", this.registry);
        this.waitForRequest.set(!highLevelControllerParameters.automaticallyTransitionToWalkingWhenReady());
    }

    @Override
    public boolean testCondition(double timeInState) {
        if (!super.testCondition(timeInState)) {
            return false;
        }
        if (timeInState < this.minimumTimeInState.getDoubleValue()) {
            return false;
        }
        boolean transitionRequested = this.nextStateEnum.equals((Object)this.requestedState.getEnumValue());
        if (this.waitForRequest.getBooleanValue()) {
            return transitionRequested;
        }
        return true;
    }
}

