/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.TouchdownErrorCompensator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.SingleSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingSingleSupportState
extends SingleSupportState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final int additionalFootstepsToConsider;
    private final Footstep nextFootstep = new Footstep();
    private final FootstepTiming footstepTiming = new FootstepTiming();
    private double swingTime;
    private final Footstep[] footsteps;
    private final FootstepTiming[] footstepTimings;
    private final FramePose3D actualFootPoseInWorld = new FramePose3D(worldFrame);
    private final FramePose3D desiredFootPoseInWorld = new FramePose3D(worldFrame);
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final CenterOfMassHeightManager comHeightManager;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final FeetManager feetManager;
    private final LegConfigurationManager legConfigurationManager;
    private final YoDouble fractionOfSwingToStraightenSwingLeg = new YoDouble("fractionOfSwingToStraightenSwingLeg", this.registry);
    private final YoDouble fractionOfSwingToCollapseStanceLeg = new YoDouble("fractionOfSwingToCollapseStanceLeg", this.registry);
    private final YoDouble remainingSwingTimeAccordingToPlan = new YoDouble("remainingSwingTimeAccordingToPlan", this.registry);
    private final YoDouble estimatedRemainingSwingTimeUnderDisturbance = new YoDouble("estimatedRemainingSwingTimeUnderDisturbance", this.registry);
    private final YoDouble optimizedRemainingSwingTime = new YoDouble("optimizedRemainingSwingTime", this.registry);
    private final YoDouble icpErrorThresholdToSpeedUpSwing = new YoDouble("icpErrorThresholdToSpeedUpSwing", this.registry);
    private final YoBoolean finishSingleSupportWhenICPPlannerIsDone = new YoBoolean("finishSingleSupportWhenICPPlannerIsDone", this.registry);
    private final YoBoolean resubmitStepsInSwingEveryTick = new YoBoolean("resubmitStepsInSwingEveryTick", this.registry);
    private final BooleanProvider minimizeAngularMomentumRateZDuringSwing;
    private final DoubleProvider timeOverrunToInitializeFreeFall;
    private final FrameQuaternion tempOrientation = new FrameQuaternion();
    private final FrameVector3D tempAngularVelocity = new FrameVector3D();
    private final TouchdownErrorCompensator touchdownErrorCompensator;
    private final FramePoint2D filteredDesiredCoP = new FramePoint2D(worldFrame);
    private final FramePoint2D desiredCoP = new FramePoint2D(worldFrame);
    private final FramePoint2D currentICP = new FramePoint2D(worldFrame);

    public WalkingSingleSupportState(WalkingStateEnum stateEnum, WalkingMessageHandler walkingMessageHandler, TouchdownErrorCompensator touchdownErrorCompensator, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(stateEnum, walkingMessageHandler, controllerToolbox, managerFactory, parentRegistry);
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.touchdownErrorCompensator = touchdownErrorCompensator;
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        this.fractionOfSwingToStraightenSwingLeg.set(walkingControllerParameters.getLegConfigurationParameters().getFractionOfSwingToStraightenLeg());
        this.fractionOfSwingToCollapseStanceLeg.set(walkingControllerParameters.getLegConfigurationParameters().getFractionOfSwingToCollapseStanceLeg());
        this.icpErrorThresholdToSpeedUpSwing.set(walkingControllerParameters.getICPErrorThresholdToSpeedUpSwing());
        this.finishSingleSupportWhenICPPlannerIsDone.set(walkingControllerParameters.finishSingleSupportWhenICPPlannerIsDone());
        this.minimizeAngularMomentumRateZDuringSwing = new BooleanParameter("minimizeAngularMomentumRateZDuringSwing", this.registry, walkingControllerParameters.minimizeAngularMomentumRateZDuringSwing());
        this.timeOverrunToInitializeFreeFall = ParameterProvider.getOrCreateParameter(parentRegistry.getName(), this.getClass().getSimpleName(), "swingTimeOverrunToInitializeFreeFall", this.registry, walkingControllerParameters.getSwingTimeOverrunToInitializeFreeFall());
        this.resubmitStepsInSwingEveryTick.set(walkingControllerParameters.resubmitStepsInTransferEveryTick());
        this.additionalFootstepsToConsider = this.balanceManager.getMaxNumberOfStepsToConsider();
        this.footsteps = Footstep.createFootsteps((int)this.additionalFootstepsToConsider);
        this.footstepTimings = FootstepTiming.createTimings((int)this.additionalFootstepsToConsider);
        this.setYoVariablesToNaN();
    }

    private void setYoVariablesToNaN() {
        this.optimizedRemainingSwingTime.setToNaN();
        this.estimatedRemainingSwingTimeUnderDisturbance.setToNaN();
        this.remainingSwingTimeAccordingToPlan.setToNaN();
    }

    @Override
    public void doAction(double timeInState) {
        boolean requestSwingSpeedUp;
        if (this.resubmitStepsInSwingEveryTick.getBooleanValue()) {
            this.balanceManager.clearICPPlan();
            this.balanceManager.addFootstepToPlan(this.nextFootstep, this.footstepTiming);
            int stepsToAdd = Math.min(this.additionalFootstepsToConsider, this.walkingMessageHandler.getCurrentNumberOfFootsteps());
            for (int i = 0; i < stepsToAdd; ++i) {
                this.walkingMessageHandler.peekFootstep(i, this.footsteps[i]);
                this.walkingMessageHandler.peekTiming(i, this.footstepTimings[i]);
                this.balanceManager.addFootstepToPlan(this.footsteps[i], this.footstepTimings[i]);
            }
        }
        this.balanceManager.setSwingFootTrajectory(this.swingSide, this.feetManager.getSwingTrajectory(this.swingSide));
        this.balanceManager.computeICPPlan();
        super.doAction(timeInState);
        boolean bl = requestSwingSpeedUp = this.balanceManager.getICPErrorMagnitude() > this.icpErrorThresholdToSpeedUpSwing.getDoubleValue();
        if (this.walkingMessageHandler.hasRequestedFootstepAdjustment()) {
            boolean footstepHasBeenAdjusted = this.walkingMessageHandler.pollRequestedFootstepAdjustment(this.nextFootstep);
            if (footstepHasBeenAdjusted) {
                this.walkingMessageHandler.updateVisualizationAfterFootstepAdjustement(this.nextFootstep);
                this.failureDetectionControlModule.setNextFootstep(this.nextFootstep);
                this.updateFootstepParameters();
                this.feetManager.adjustSwingTrajectory(this.swingSide, this.nextFootstep, this.swingTime);
                this.balanceManager.adjustFootstep(this.nextFootstep);
                this.balanceManager.computeICPPlan();
                this.updateHeightManager();
            }
        } else {
            boolean footstepIsBeingAdjusted = this.balanceManager.checkAndUpdateStepAdjustment(this.nextFootstep);
            if (footstepIsBeingAdjusted) {
                requestSwingSpeedUp = true;
                this.walkingMessageHandler.updateVisualizationAfterFootstepAdjustement(this.nextFootstep);
                this.failureDetectionControlModule.setNextFootstep(this.nextFootstep);
                this.updateFootstepParameters();
                this.feetManager.adjustSwingTrajectory(this.swingSide, this.nextFootstep, this.swingTime);
                this.balanceManager.adjustFootstep(this.nextFootstep);
                this.balanceManager.computeICPPlan();
                this.updateHeightManager();
            }
            this.walkingMessageHandler.setPlanOffsetFromAdjustment(this.balanceManager.getEffectiveICPAdjustment());
        }
        if (requestSwingSpeedUp) {
            double swingTimeRemaining = this.requestSwingSpeedUpIfNeeded();
            this.balanceManager.updateSwingTimeRemaining(swingTimeRemaining);
        }
        boolean feetAreWellPositioned = this.legConfigurationManager.areFeetWellPositionedForCollapse(this.swingSide.getOppositeSide(), this.nextFootstep.getSoleReferenceFrame());
        if (timeInState > this.fractionOfSwingToStraightenSwingLeg.getDoubleValue() * this.swingTime) {
            this.legConfigurationManager.straightenLegDuringSwing(this.swingSide);
        }
        if (timeInState > this.fractionOfSwingToCollapseStanceLeg.getDoubleValue() * this.swingTime && !this.legConfigurationManager.isLegCollapsed(this.supportSide) && feetAreWellPositioned) {
            this.legConfigurationManager.collapseLegDuringSwing(this.swingSide.getOppositeSide());
        }
        if (timeInState > this.swingTime + this.timeOverrunToInitializeFreeFall.getValue()) {
            this.comHeightManager.initializeTransitionToFall(this.swingTime / 6.0);
        }
        this.walkingMessageHandler.clearFootTrajectory();
        this.switchToToeOffIfPossible(this.supportSide);
    }

    @Override
    public boolean isDone(double timeInState) {
        if (super.isDone(timeInState)) {
            return true;
        }
        return this.finishSingleSupportWhenICPPlannerIsDone.getBooleanValue() && this.balanceManager.isICPPlanDone();
    }

    @Override
    public void onEntry() {
        super.onEntry();
        double defaultSwingTime = this.walkingMessageHandler.getDefaultSwingTime();
        double defaultTransferTime = this.walkingMessageHandler.getDefaultTransferTime();
        double finalTransferTime = this.walkingMessageHandler.getFinalTransferTime();
        if (this.balanceManager.isRecoveringFromDoubleSupportFall()) {
            this.swingTime = defaultSwingTime;
            this.footstepTiming.setTimings(this.swingTime, defaultTransferTime);
            this.balanceManager.packFootstepForRecoveringFromDisturbance(this.swingSide, defaultSwingTime, this.nextFootstep);
            this.nextFootstep.setTrajectoryType(TrajectoryType.DEFAULT);
            this.nextFootstep.setIsAdjustable(true);
            this.walkingMessageHandler.reportWalkingAbortRequested();
            this.walkingMessageHandler.clearFootsteps();
        } else {
            this.swingTime = this.walkingMessageHandler.getNextSwingTime();
            this.walkingMessageHandler.poll(this.nextFootstep, this.footstepTiming);
        }
        this.feetManager.setContactStateForSwing(this.swingSide);
        this.updateFootstepParameters();
        this.balanceManager.minimizeAngularMomentumRateZ(this.minimizeAngularMomentumRateZDuringSwing.getValue());
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.addFootstepToPlan(this.nextFootstep, this.footstepTiming);
        int stepsToAdd = Math.min(this.additionalFootstepsToConsider, this.walkingMessageHandler.getCurrentNumberOfFootsteps());
        boolean isLastStep = stepsToAdd == 0;
        for (int i = 0; i < stepsToAdd; ++i) {
            this.walkingMessageHandler.peekFootstep(i, this.footsteps[i]);
            this.walkingMessageHandler.peekTiming(i, this.footstepTimings[i]);
            this.balanceManager.addFootstepToPlan(this.footsteps[i], this.footstepTimings[i]);
        }
        this.balanceManager.setICPPlanSupportSide(this.supportSide);
        this.balanceManager.initializeICPPlanForSingleSupport();
        this.updateHeightManager();
        this.feetManager.requestSwing(this.swingSide, this.nextFootstep, this.swingTime, this.balanceManager.getFinalDesiredCoMVelocity(), this.balanceManager.getFinalDesiredCoMAcceleration());
        if (this.feetManager.adjustHeightIfNeeded(this.nextFootstep)) {
            this.walkingMessageHandler.updateVisualizationAfterFootstepAdjustement(this.nextFootstep);
            this.feetManager.adjustSwingTrajectory(this.swingSide, this.nextFootstep, this.swingTime);
        }
        this.balanceManager.setSwingFootTrajectory(this.swingSide, this.feetManager.getSwingTrajectory(this.swingSide));
        if (this.balanceManager.isRecoveringFromDoubleSupportFall()) {
            this.balanceManager.computeICPPlan();
            this.balanceManager.requestICPPlannerToHoldCurrentCoMInNextDoubleSupport();
        }
        this.legConfigurationManager.startSwing(this.swingSide);
        this.legConfigurationManager.useHighWeight(this.swingSide.getOppositeSide());
        this.legConfigurationManager.setStepDuration(this.supportSide, this.footstepTiming.getStepTime());
        if (isLastStep) {
            this.pelvisOrientationManager.initializeSwing(this.supportSide, this.swingTime, finalTransferTime, 0.0);
        } else {
            FootstepTiming nextTiming = this.footstepTimings[0];
            this.pelvisOrientationManager.initializeSwing(this.supportSide, this.swingTime, nextTiming.getTransferTime(), nextTiming.getSwingTime());
        }
        this.nextFootstep.getPose(this.desiredFootPoseInWorld);
        this.desiredFootPoseInWorld.changeFrame(worldFrame);
        this.actualFootPoseInWorld.setToZero((ReferenceFrame)this.fullRobotModel.getSoleFrame((Enum)this.swingSide));
        this.actualFootPoseInWorld.changeFrame(worldFrame);
        this.walkingMessageHandler.reportFootstepStarted(this.swingSide, (FramePose3DReadOnly)this.desiredFootPoseInWorld, (FramePose3DReadOnly)this.actualFootPoseInWorld, this.swingTime);
    }

    @Override
    public void onExit() {
        super.onExit();
        this.balanceManager.minimizeAngularMomentumRateZ(false);
        this.actualFootPoseInWorld.setToZero((ReferenceFrame)this.fullRobotModel.getSoleFrame((Enum)this.swingSide));
        this.actualFootPoseInWorld.changeFrame(worldFrame);
        this.touchdownErrorCompensator.registerDesiredFootstepPosition(this.swingSide, (FramePoint3DReadOnly)this.desiredFootPoseInWorld.getPosition());
        this.walkingMessageHandler.reportFootstepCompleted(this.swingSide, (FramePose3DReadOnly)this.desiredFootPoseInWorld, (FramePose3DReadOnly)this.actualFootPoseInWorld, this.swingTime);
        this.walkingMessageHandler.registerCompletedDesiredFootstep(this.nextFootstep);
        MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.nextFootstep.getRobotSide());
        this.tempOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.nextFootstep.getFootstepPose().getOrientation());
        this.tempOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
        double pitch = this.tempOrientation.getPitch();
        if (this.doManualTouchdown()) {
            FrameSE3TrajectoryPoint lastWaypoint = (FrameSE3TrajectoryPoint)this.nextFootstep.getSwingTrajectory().get(this.nextFootstep.getSwingTrajectory().size() - 1);
            this.tempOrientation.setIncludingFrame(lastWaypoint.getOrientation());
            this.tempOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
            this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)lastWaypoint.getAngularVelocity());
            this.tempAngularVelocity.changeFrame((ReferenceFrame)soleZUpFrame);
        } else {
            MovingReferenceFrame soleFrame = this.controllerToolbox.getReferenceFrames().getSoleFrame((Enum)this.nextFootstep.getRobotSide());
            this.tempOrientation.setToZero((ReferenceFrame)soleFrame);
            this.tempOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
            this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)soleFrame.getTwistOfFrame().getAngularPart());
            this.tempAngularVelocity.changeFrame((ReferenceFrame)soleZUpFrame);
        }
        double initialPitch = this.tempOrientation.getPitch();
        double initialPitchVelocity = this.tempAngularVelocity.getY();
        this.feetManager.touchDown(this.nextFootstep.getRobotSide(), initialPitch, initialPitchVelocity, pitch, this.footstepTiming.getTouchdownDuration());
        this.setYoVariablesToNaN();
    }

    private boolean doManualTouchdown() {
        return this.nextFootstep.getTrajectoryType() == TrajectoryType.WAYPOINTS && Precision.equals((double)((FrameSE3TrajectoryPoint)this.nextFootstep.getSwingTrajectory().get(0)).getTime(), (double)0.0);
    }

    public void switchToToeOffIfPossible(RobotSide supportSide) {
        boolean shouldComputeToeLineContact = this.feetManager.shouldComputeToeLineContact();
        boolean shouldComputeToePointContact = this.feetManager.shouldComputeToePointContact();
        if (shouldComputeToeLineContact || shouldComputeToePointContact) {
            this.currentICP.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
            this.controllerToolbox.getDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)supportSide), this.desiredCoP);
            this.controllerToolbox.getFilteredDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)supportSide), this.filteredDesiredCoP);
            FramePoint3DReadOnly supportFootExitCMP = this.balanceManager.getFirstExitCMPForToeOff(false);
            this.feetManager.updateToeOffStatusSingleSupport(this.nextFootstep, supportFootExitCMP, this.balanceManager.getDesiredCMP(), (FramePoint2DReadOnly)this.desiredCoP, this.balanceManager.getDesiredICP(), (FramePoint2DReadOnly)this.currentICP, this.balanceManager.getFinalDesiredICP());
            if (this.feetManager.okForPointToeOff() && shouldComputeToePointContact) {
                this.feetManager.requestPointToeOff(supportSide, supportFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
            } else if (this.feetManager.okForLineToeOff() && shouldComputeToeLineContact) {
                this.feetManager.requestLineToeOff(supportSide, supportFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
            }
        }
    }

    private double requestSwingSpeedUpIfNeeded() {
        this.remainingSwingTimeAccordingToPlan.set(this.balanceManager.getTimeRemainingInCurrentState());
        double remainingTime = this.balanceManager.estimateTimeRemainingForSwingUnderDisturbance();
        this.estimatedRemainingSwingTimeUnderDisturbance.set(remainingTime);
        if (remainingTime > 0.001) {
            double swingSpeedUpFactor = this.remainingSwingTimeAccordingToPlan.getDoubleValue() / remainingTime;
            return this.feetManager.requestSwingSpeedUp(this.swingSide, swingSpeedUpFactor);
        }
        if (this.remainingSwingTimeAccordingToPlan.getDoubleValue() > 0.001) {
            return this.feetManager.requestSwingSpeedUp(this.swingSide, Double.POSITIVE_INFINITY);
        }
        return this.remainingSwingTimeAccordingToPlan.getDoubleValue();
    }

    private void updateFootstepParameters() {
        this.controllerToolbox.updateContactPointsForUpcomingFootstep(this.nextFootstep);
        this.controllerToolbox.updateBipedSupportPolygons();
        this.pelvisOrientationManager.setTrajectoryTime(this.swingTime);
        this.pelvisOrientationManager.setUpcomingFootstep(this.nextFootstep);
        this.pelvisOrientationManager.updateTrajectoryFromFootstep();
    }

    private void updateHeightManager() {
        TransferToAndNextFootstepsData transferToAndNextFootstepsData = this.walkingMessageHandler.createTransferToAndNextFootstepDataForSingleSupport(this.nextFootstep, this.swingSide);
        transferToAndNextFootstepsData.setComAtEndOfState(this.balanceManager.getFinalDesiredCoMPosition());
        double extraToeOffHeight = 0.0;
        if (this.feetManager.canDoSingleSupportToeOff((FramePoint3DReadOnly)this.nextFootstep.getFootstepPose().getPosition(), this.swingSide) && this.feetManager.getToeOffManager().isSteppingUp()) {
            extraToeOffHeight = this.feetManager.getToeOffManager().getExtraCoMMaxHeightWithToes();
        }
        this.comHeightManager.initialize(transferToAndNextFootstepsData, extraToeOffHeight);
    }

    @Override
    protected boolean hasMinimumTimePassed(double timeInState) {
        if (this.balanceManager.isRecoveringFromDoubleSupportFall()) {
            double minimumSwingTime = 0.15;
            return timeInState > minimumSwingTime;
        }
        return this.feetManager.getFractionThroughSwing(this.swingSide) > this.minimumSwingFraction.getDoubleValue();
    }
}

