/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.TouchdownErrorCompensator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.TransferState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class TransferToWalkingSingleSupportState
extends TransferState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final int numberOfFootstepsToConsider;
    private final Footstep[] footsteps;
    private final FootstepTiming[] footstepTimings;
    private final DoubleProvider minimumTransferTime;
    private final LegConfigurationManager legConfigurationManager;
    private final YoDouble fractionOfTransferToCollapseLeg;
    private final YoDouble currentTransferDuration;
    private final YoBoolean resubmitStepsInTransferEveryTick;
    private final YoDouble originalTransferTime;
    private final BooleanProvider minimizeAngularMomentumRateZDuringTransfer;
    private final DoubleProvider icpErrorThresholdForSlowTransfer;
    private final DoubleProvider minimumSlowTransferDuration;
    private final FramePoint3D actualFootPositionInWorld;
    private final FrameVector3D tempAngularVelocity;
    private final FrameQuaternion tempOrientation;
    private final TouchdownErrorCompensator touchdownErrorCompensator;

    public TransferToWalkingSingleSupportState(WalkingStateEnum stateEnum, WalkingMessageHandler walkingMessageHandler, TouchdownErrorCompensator touchdownErrorCompensator, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, WalkingFailureDetectionControlModule failureDetectionControlModule, DoubleProvider minimumTransferTime, DoubleProvider unloadFraction, DoubleProvider rhoMin, YoRegistry parentRegistry) {
        super(stateEnum, walkingMessageHandler, controllerToolbox, managerFactory, failureDetectionControlModule, unloadFraction, rhoMin, parentRegistry);
        this.fractionOfTransferToCollapseLeg = new YoDouble("fractionOfTransferToCollapseLeg", this.registry);
        this.currentTransferDuration = new YoDouble("CurrentTransferDuration", this.registry);
        this.resubmitStepsInTransferEveryTick = new YoBoolean("resubmitStepsInTransferEveryTick", this.registry);
        this.originalTransferTime = new YoDouble("OriginalTransferTime", this.registry);
        this.actualFootPositionInWorld = new FramePoint3D();
        this.tempAngularVelocity = new FrameVector3D();
        this.tempOrientation = new FrameQuaternion();
        this.minimumTransferTime = minimumTransferTime;
        this.touchdownErrorCompensator = touchdownErrorCompensator;
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        this.fractionOfTransferToCollapseLeg.set(walkingControllerParameters.getLegConfigurationParameters().getFractionOfTransferToCollapseLeg());
        this.minimizeAngularMomentumRateZDuringTransfer = new BooleanParameter("minimizeAngularMomentumRateZDuringTransfer", this.registry, walkingControllerParameters.minimizeAngularMomentumRateZDuringTransfer());
        this.icpErrorThresholdForSlowTransfer = ParameterProvider.getOrCreateParameter(parentRegistry.getName(), this.getClass().getSimpleName(), "icpErrorThresholdForSlowTransfer", this.registry, walkingControllerParameters.getInitialICPErrorToSlowDownTransfer());
        this.minimumSlowTransferDuration = ParameterProvider.getOrCreateParameter(parentRegistry.getName(), this.getClass().getSimpleName(), "minimumSlowTransferDuration", this.registry, walkingControllerParameters.getMinimumSlowTransferDuration());
        this.resubmitStepsInTransferEveryTick.set(walkingControllerParameters.resubmitStepsInSwingEveryTick());
        this.numberOfFootstepsToConsider = this.balanceManager.getMaxNumberOfStepsToConsider();
        this.footsteps = Footstep.createFootsteps((int)this.numberOfFootstepsToConsider);
        this.footstepTimings = FootstepTiming.createTimings((int)this.numberOfFootstepsToConsider);
    }

    @Override
    protected void updateICPPlan() {
        super.updateICPPlan();
        if (this.getPreviousWalkingStateEnum() == WalkingStateEnum.STANDING || this.getPreviousWalkingStateEnum() == WalkingStateEnum.TO_STANDING) {
            this.walkingMessageHandler.reportWalkingStarted();
        }
        if (this.isInitialTransfer()) {
            this.pelvisOrientationManager.moveToAverageInSupportFoot(this.transferToSide);
        } else {
            this.pelvisOrientationManager.setToHoldCurrentDesiredInSupportFoot(this.transferToSide);
        }
        double finalTransferTime = this.walkingMessageHandler.getFinalTransferTime();
        this.walkingMessageHandler.requestPlanarRegions();
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        int stepsToAdd = Math.min(this.numberOfFootstepsToConsider, this.walkingMessageHandler.getCurrentNumberOfFootsteps());
        if (stepsToAdd < 1) {
            throw new RuntimeException("Can not go to walking single support if there are no upcoming footsteps.");
        }
        for (int i = 0; i < stepsToAdd; ++i) {
            Footstep footstep = this.footsteps[i];
            FootstepTiming timing = this.footstepTimings[i];
            this.walkingMessageHandler.peekFootstep(i, footstep);
            this.walkingMessageHandler.peekTiming(i, timing);
            if (i == 0) {
                this.adjustTiming(timing);
                this.walkingMessageHandler.adjustTiming(timing.getSwingTime(), timing.getTransferTime());
            }
            this.balanceManager.addFootstepToPlan(footstep, timing);
        }
        FootstepTiming firstTiming = this.footstepTimings[0];
        this.currentTransferDuration.set(firstTiming.getTransferTime());
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.initializeICPPlanForTransfer();
        this.pelvisOrientationManager.setUpcomingFootstep(this.footsteps[0]);
        this.pelvisOrientationManager.initializeTransfer(this.transferToSide, firstTiming.getTransferTime(), firstTiming.getSwingTime());
        this.legConfigurationManager.beginStraightening(this.transferToSide);
        this.legConfigurationManager.setFullyExtendLeg(this.transferToSide, false);
    }

    @Override
    public void doAction(double timeInState) {
        if (this.resubmitStepsInTransferEveryTick.getBooleanValue()) {
            this.balanceManager.clearICPPlan();
            int stepsToAdd = Math.min(this.numberOfFootstepsToConsider, this.walkingMessageHandler.getCurrentNumberOfFootsteps());
            for (int i = 0; i < stepsToAdd; ++i) {
                Footstep footstep = this.footsteps[i];
                FootstepTiming timing = this.footstepTimings[i];
                this.walkingMessageHandler.peekFootstep(i, footstep);
                this.walkingMessageHandler.peekTiming(i, timing);
                this.balanceManager.addFootstepToPlan(footstep, timing);
            }
        }
        RobotSide swingSide = this.transferToSide.getOppositeSide();
        this.feetManager.updateSwingTrajectoryPreview(swingSide);
        this.balanceManager.setSwingFootTrajectory(swingSide, this.feetManager.getSwingTrajectory(swingSide));
        this.balanceManager.computeICPPlan();
        if (!this.doManualLiftOff() && this.switchToToeOffIfPossible()) {
            this.feetManager.initializeSwingTrajectoryPreview(swingSide, this.footsteps[0], this.footstepTimings[0].getSwingTime());
        }
        super.doAction(timeInState);
        double transferDuration = this.currentTransferDuration.getDoubleValue();
        boolean pastMinimumTime = timeInState > this.fractionOfTransferToCollapseLeg.getDoubleValue() * transferDuration;
        boolean isFootWellPosition = this.legConfigurationManager.areFeetWellPositionedForCollapse(this.transferToSide.getOppositeSide());
        if (pastMinimumTime && isFootWellPosition && !this.legConfigurationManager.isLegCollapsed(this.transferToSide.getOppositeSide())) {
            this.legConfigurationManager.collapseLegDuringTransfer(this.transferToSide);
        }
        this.updateFootPlanOffset();
        double toeOffDuration = this.footstepTimings[0].getLiftoffDuration();
        if (this.doManualLiftOff() && transferDuration - timeInState < toeOffDuration) {
            Footstep upcomingFootstep = this.footsteps[0];
            FrameSE3TrajectoryPoint firstWaypoint = (FrameSE3TrajectoryPoint)upcomingFootstep.getSwingTrajectory().get(0);
            MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.transferToSide.getOppositeSide());
            this.tempOrientation.setIncludingFrame(firstWaypoint.getOrientation());
            this.tempOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
            this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)firstWaypoint.getAngularVelocity());
            this.tempAngularVelocity.changeFrame((ReferenceFrame)soleZUpFrame);
            this.feetManager.liftOff(this.transferToSide.getOppositeSide(), this.tempOrientation.getPitch(), this.tempAngularVelocity.getY(), toeOffDuration);
        }
    }

    private boolean doManualLiftOff() {
        Footstep upcomingFootstep = this.footsteps[0];
        return upcomingFootstep.getTrajectoryType() == TrajectoryType.WAYPOINTS && Precision.equals((double)((FrameSE3TrajectoryPoint)upcomingFootstep.getSwingTrajectory().get(0)).getTime(), (double)0.0);
    }

    @Override
    public void onEntry() {
        if (this.balanceManager.getICPErrorMagnitude() > this.icpErrorThresholdForSlowTransfer.getValue()) {
            this.walkingMessageHandler.peekTiming(0, this.footstepTimings[0]);
            double transferDuration = Math.max(this.minimumSlowTransferDuration.getValue(), 2.0 * this.footstepTimings[0].getTransferTime());
            this.walkingMessageHandler.setUpcomingFootstepTransferDuration(transferDuration);
        }
        super.onEntry();
        this.feetManager.initializeSwingTrajectoryPreview(this.transferToSide.getOppositeSide(), this.footsteps[0], this.footstepTimings[0].getSwingTime());
        this.balanceManager.minimizeAngularMomentumRateZ(this.minimizeAngularMomentumRateZDuringTransfer.getValue());
        this.updateFootPlanOffset();
    }

    @Override
    public boolean isDone(double timeInState) {
        return super.isDone(timeInState) || this.feetManager.isFootToeingOffSlipping(this.transferToSide.getOppositeSide());
    }

    @Override
    public void onExit() {
        super.onExit();
        this.balanceManager.minimizeAngularMomentumRateZ(false);
    }

    private void adjustTiming(FootstepTiming stepTiming) {
        if (!stepTiming.hasAbsoluteTime()) {
            this.originalTransferTime.setToNaN();
            return;
        }
        double originalSwingTime = stepTiming.getSwingTime();
        double originalTransferTime = stepTiming.getTransferTime();
        this.originalTransferTime.set(originalTransferTime);
        double currentTime = this.controllerToolbox.getYoTime().getDoubleValue();
        double timeInFootstepPlan = currentTime - stepTiming.getExecutionStartTime();
        double adjustedTransferTime = stepTiming.getSwingStartTime() - timeInFootstepPlan;
        adjustedTransferTime = Math.max(adjustedTransferTime, this.minimumTransferTime.getValue());
        stepTiming.setTimings(originalSwingTime, adjustedTransferTime);
    }

    private void updateFootPlanOffset() {
        WalkingStateEnum previousStateEnum = this.getPreviousWalkingStateEnum();
        if (previousStateEnum == null) {
            return;
        }
        RobotSide previousSupportSide = previousStateEnum.getSupportSide();
        if (previousSupportSide == null) {
            return;
        }
        RobotSide previousSwingSide = previousSupportSide.getOppositeSide();
        if (this.touchdownErrorCompensator.planShouldBeOffsetFromStep(previousSwingSide) && this.touchdownErrorCompensator.isFootPositionTrusted(previousSwingSide)) {
            this.actualFootPositionInWorld.setToZero((ReferenceFrame)this.controllerToolbox.getReferenceFrames().getSoleFrame((Enum)previousSwingSide));
            this.actualFootPositionInWorld.changeFrame(worldFrame);
            this.touchdownErrorCompensator.addOffsetVectorFromTouchdownError(previousSwingSide, (FramePoint3DReadOnly)this.actualFootPositionInWorld);
        }
    }
}

