/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public abstract class TransferState
extends WalkingState {
    protected final RobotSide transferToSide;
    protected final WalkingMessageHandler walkingMessageHandler;
    protected final HighLevelHumanoidControllerToolbox controllerToolbox;
    protected final WalkingFailureDetectionControlModule failureDetectionControlModule;
    protected final CenterOfMassHeightManager comHeightManager;
    protected final BalanceManager balanceManager;
    protected final PelvisOrientationManager pelvisOrientationManager;
    protected final FeetManager feetManager;
    private final FramePoint2D capturePoint2d = new FramePoint2D();
    private final FramePoint2D filteredDesiredCoP = new FramePoint2D();
    private final FramePoint2D desiredCoP = new FramePoint2D();
    private final FootstepTiming stepTiming = new FootstepTiming();
    private final Footstep nextFootstep = new Footstep();
    private final YoBoolean isUnloading;
    private final DoubleProvider unloadFraction;
    private final DoubleProvider rhoMin;

    public TransferState(WalkingStateEnum transferStateEnum, WalkingMessageHandler walkingMessageHandler, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, DoubleProvider unloadFraction, DoubleProvider rhoMin, YoRegistry parentRegistry) {
        super(transferStateEnum, parentRegistry);
        this.transferToSide = transferStateEnum.getTransferToSide();
        this.walkingMessageHandler = walkingMessageHandler;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.controllerToolbox = controllerToolbox;
        this.unloadFraction = unloadFraction;
        this.rhoMin = rhoMin;
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.isUnloading = unloadFraction != null ? new YoBoolean(this.transferToSide.getOppositeSide().getLowerCaseName() + "FootIsUnloading", this.registry) : null;
    }

    @Override
    public RobotSide getTransferToSide() {
        return this.transferToSide;
    }

    public void doAction(double timeInState) {
        this.feetManager.updateContactStatesInDoubleSupport(this.transferToSide);
        this.balanceManager.computeNormalizedEllipticICPError(this.transferToSide);
        if (this.isUnloading != null && this.unloadFraction.getValue() > 0.0) {
            double percentInTransfer = MathTools.clamp((double)(timeInState / this.stepTiming.getTransferTime()), (double)0.0, (double)1.0);
            if (!this.isUnloading.getValue()) {
                this.isUnloading.set(percentInTransfer > this.unloadFraction.getValue());
            }
            if (this.isUnloading.getValue()) {
                double nominalPercentInUnloading = (percentInTransfer - this.unloadFraction.getValue()) / (1.0 - this.unloadFraction.getValue());
                double icpBasedPercentInUnloading = 1.0 - MathTools.clamp((double)(this.balanceManager.getNormalizedEllipticICPError() - 1.0), (double)0.0, (double)1.0);
                double percentInUnloading = Math.min(nominalPercentInUnloading, icpBasedPercentInUnloading);
                this.feetManager.unload(this.transferToSide.getOppositeSide(), percentInUnloading, this.rhoMin.getValue());
            }
        }
        if (this.balanceManager.getNormalizedEllipticICPError() > this.balanceManager.getEllipticICPErrorForMomentumRecovery()) {
            this.balanceManager.setUseMomentumRecoveryModeForBalance(true);
        }
    }

    public boolean isDone(double timeInState) {
        boolean transferTimeElapsedUnderPrecomputedICPPlan = false;
        if (this.balanceManager.isPrecomputedICPPlannerActive()) {
            boolean bl = transferTimeElapsedUnderPrecomputedICPPlan = timeInState > this.walkingMessageHandler.getNextTransferTime();
        }
        if (this.balanceManager.isICPPlanDone() || transferTimeElapsedUnderPrecomputedICPPlan) {
            this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
            FrameConvexPolygon2DReadOnly supportPolygonInWorld = this.controllerToolbox.getBipedSupportPolygons().getSupportPolygonInWorld();
            FrameConvexPolygon2DReadOnly nextPolygonInWorld = this.failureDetectionControlModule.getCombinedFootPolygonWithNextFootstep();
            double distanceToSupport = supportPolygonInWorld.distance((FramePoint2DReadOnly)this.capturePoint2d);
            boolean isICPInsideNextSupportPolygon = nextPolygonInWorld.isPointInside((FramePoint2DReadOnly)this.capturePoint2d);
            if (distanceToSupport > this.balanceManager.getICPDistanceOutsideSupportForStep() || distanceToSupport > 0.0 && isICPInsideNextSupportPolygon) {
                return true;
            }
            if (this.balanceManager.getNormalizedEllipticICPError() < 1.0) {
                return true;
            }
            this.balanceManager.setUseMomentumRecoveryModeForBalance(true);
        }
        return false;
    }

    public boolean switchToToeOffIfPossible() {
        RobotSide trailingLeg = this.transferToSide.getOppositeSide();
        if (this.feetManager.getCurrentConstraintType(trailingLeg) != FootControlModule.ConstraintType.TOES) {
            this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
            this.controllerToolbox.getFilteredDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)trailingLeg), this.filteredDesiredCoP);
            this.controllerToolbox.getDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)trailingLeg), this.desiredCoP);
            FramePoint3DReadOnly trailingFootExitCMP = this.balanceManager.getFirstExitCMPForToeOff(true);
            this.feetManager.updateToeOffStatusDoubleSupport(trailingLeg, this.nextFootstep, trailingFootExitCMP, this.balanceManager.getDesiredCMP(), (FramePoint2DReadOnly)this.desiredCoP, this.balanceManager.getDesiredICP(), (FramePoint2DReadOnly)this.capturePoint2d, this.balanceManager.getFinalDesiredICP());
            if (this.feetManager.okForPointToeOff()) {
                this.feetManager.requestPointToeOff(trailingLeg, trailingFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
                return true;
            }
            if (this.feetManager.okForLineToeOff()) {
                this.feetManager.requestLineToeOff(trailingLeg, trailingFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
                return true;
            }
        } else if (!this.feetManager.isUsingPointContactInToeOff(trailingLeg) && !this.feetManager.useToeLineContactInTransfer()) {
            FramePoint3DReadOnly trailingFootExitCMP = this.balanceManager.getFirstExitCMPForToeOff(true);
            this.controllerToolbox.getFilteredDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)trailingLeg), this.filteredDesiredCoP);
            this.feetManager.requestPointToeOff(trailingLeg, trailingFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
            return true;
        }
        return false;
    }

    public void onEntry() {
        this.updateICPPlan();
        if (this.walkingMessageHandler.hasUpcomingFootsteps()) {
            this.walkingMessageHandler.peekTiming(0, this.stepTiming);
        } else {
            this.stepTiming.setTimings(Double.NaN, Double.NaN);
        }
        double extraToeOffHeight = 0.0;
        if (this.feetManager.canDoDoubleSupportToeOff(null, this.transferToSide)) {
            extraToeOffHeight = this.feetManager.getToeOffManager().getExtraCoMMaxHeightWithToes();
        }
        TransferToAndNextFootstepsData transferToAndNextFootstepsData = this.walkingMessageHandler.createTransferToAndNextFootstepDataForDoubleSupport(this.transferToSide);
        transferToAndNextFootstepsData.setComAtEndOfState(this.balanceManager.getFinalDesiredCoMPosition());
        this.comHeightManager.setSupportLeg(this.transferToSide);
        this.comHeightManager.initialize(transferToAndNextFootstepsData, extraToeOffHeight);
    }

    protected void updateICPPlan() {
        this.balanceManager.clearICPPlan();
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.setHoldSplitFractions(false);
        if (this.walkingMessageHandler.hasUpcomingFootsteps()) {
            this.walkingMessageHandler.peekFootstep(0, this.nextFootstep);
            this.failureDetectionControlModule.setNextFootstep(this.nextFootstep);
        } else {
            this.failureDetectionControlModule.setNextFootstep(null);
        }
        this.balanceManager.resetPushRecovery();
        double transferTime = this.walkingMessageHandler.getNextTransferTime();
        this.pelvisOrientationManager.setTrajectoryTime(transferTime);
    }

    public boolean isInitialTransfer() {
        return this.getPreviousWalkingStateEnum() == WalkingStateEnum.STANDING;
    }

    public void onExit() {
        if (this.isUnloading != null) {
            this.isUnloading.set(false);
            this.feetManager.resetLoadConstraints(this.transferToSide.getOppositeSide());
        }
        this.feetManager.reset();
        this.balanceManager.setUseMomentumRecoveryModeForBalance(false);
    }
}

