/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.SingleSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootLoadBearingCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.LoadBearingRequest;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FlamingoStanceState
extends SingleSupportState {
    private final FramePoint2D capturePoint2d = new FramePoint2D();
    private final YoBoolean loadFoot;
    private final YoDouble loadFootStartTime;
    private final YoDouble loadFootDuration;
    private final YoDouble loadFootTransferDuration;
    private final BipedSupportPolygons bipedSupportPolygons;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final CenterOfMassHeightManager comHeightManager;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final FeetManager feetManager;
    private final LegConfigurationManager legConfigurationManager;
    private final FootstepTiming footstepTiming = new FootstepTiming();
    private final HighLevelHumanoidControllerToolbox controllerToolbox;

    public FlamingoStanceState(WalkingStateEnum stateEnum, WalkingMessageHandler walkingMessageHandler, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(stateEnum, walkingMessageHandler, controllerToolbox, managerFactory, parentRegistry);
        this.controllerToolbox = controllerToolbox;
        this.bipedSupportPolygons = controllerToolbox.getBipedSupportPolygons();
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        String namePrefix = this.supportSide.getOppositeSide().getLowerCaseName();
        this.loadFoot = new YoBoolean(namePrefix + "LoadFoot", this.registry);
        this.loadFootStartTime = new YoDouble(namePrefix + "LoadFootStartTime", this.registry);
        this.loadFootDuration = new YoDouble(namePrefix + "LoadFootDuration", this.registry);
        this.loadFootTransferDuration = new YoDouble(namePrefix + "LoadFootTransferDuration", this.registry);
        this.loadFoot.set(false);
        this.loadFootDuration.set(1.2);
        this.loadFootTransferDuration.set(0.8);
    }

    @Override
    public void doAction(double timeInState) {
        boolean icpErrorIsTooLarge;
        this.balanceManager.computeFlamingoStateICPPlan();
        super.doAction(timeInState);
        if (this.loadFoot.getBooleanValue() && this.loadFootStartTime.isNaN()) {
            this.loadFootStartTime.set(timeInState);
        }
        if (this.walkingMessageHandler.hasFootTrajectoryForFlamingoStance(this.swingSide)) {
            while (this.walkingMessageHandler.hasFootTrajectoryForFlamingoStance(this.swingSide)) {
                this.feetManager.handleFootTrajectoryCommand(this.walkingMessageHandler.pollFootTrajectoryForFlamingoStance(this.swingSide));
            }
        }
        this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
        boolean bl = icpErrorIsTooLarge = this.balanceManager.getICPErrorMagnitude() > 0.05;
        if (icpErrorIsTooLarge) {
            FrameConvexPolygon2DReadOnly supportPolygonInWorld = this.bipedSupportPolygons.getSupportPolygonInWorld();
            FrameConvexPolygon2D combinedFootPolygon = this.failureDetectionControlModule.getCombinedFootPolygon();
            if (!supportPolygonInWorld.isPointInside((FramePoint2DReadOnly)this.capturePoint2d, 0.02) && combinedFootPolygon.isPointInside((FramePoint2DReadOnly)this.capturePoint2d)) {
                this.feetManager.requestMoveStraightTouchdownForDisturbanceRecovery(this.swingSide);
                this.initiateFootLoadingProcedure(this.swingSide);
                this.balanceManager.requestICPPlannerToHoldCurrentCoMInNextDoubleSupport();
            }
        }
        this.walkingMessageHandler.clearFootTrajectory(this.supportSide);
    }

    @Override
    public boolean isDone(double timeInState) {
        if (super.isDone(timeInState)) {
            return true;
        }
        if (this.loadFoot.getBooleanValue() && timeInState > this.loadFootStartTime.getDoubleValue() + this.loadFootDuration.getDoubleValue()) {
            this.loadFoot.set(false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasMinimumTimePassed(double timeInState) {
        double minimumSwingTime = this.balanceManager.isRecoveringFromDoubleSupportFall() ? 0.15 : this.walkingMessageHandler.getDefaultSwingTime() * this.minimumSwingFraction.getDoubleValue();
        return timeInState > minimumSwingTime;
    }

    @Override
    public void onEntry() {
        super.onEntry();
        this.balanceManager.enablePelvisXYControl();
        this.feetManager.handleFootTrajectoryCommand(this.walkingMessageHandler.pollFootTrajectoryForFlamingoStance(this.swingSide));
        double swingTime = Double.POSITIVE_INFINITY;
        double initialTransferTime = this.walkingMessageHandler.getInitialTransferTime();
        double finalTransferTime = this.walkingMessageHandler.getFinalTransferTime();
        this.footstepTiming.setTimings(swingTime, initialTransferTime);
        Footstep footstep = this.walkingMessageHandler.getFootstepAtCurrentLocation(this.swingSide);
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.addFootstepToPlan(footstep, this.footstepTiming);
        this.balanceManager.setICPPlanSupportSide(this.supportSide);
        this.balanceManager.initializeICPPlanForSingleSupport();
        this.pelvisOrientationManager.setToHoldCurrentDesiredInSupportFoot(this.supportSide);
        this.comHeightManager.setSupportLeg(this.getSupportSide());
        this.loadFoot.set(false);
        this.loadFootStartTime.setToNaN();
        this.legConfigurationManager.startSwing(this.swingSide);
        this.controllerToolbox.updateContactPointsForUpcomingFootstep(this.walkingMessageHandler.getFootstepAtCurrentLocation(this.swingSide));
    }

    @Override
    public void onExit() {
        super.onExit();
        this.feetManager.initializeContactStatesForDoubleSupport(this.swingSide);
        this.balanceManager.disablePelvisXYControl();
    }

    @Override
    public boolean isStateSafeToConsumePelvisTrajectoryCommand() {
        return true;
    }

    @Override
    public boolean isStateSafeToConsumeManipulationCommands() {
        return true;
    }

    @Override
    public void handleFootLoadBearingCommand(FootLoadBearingCommand command) {
        if (command.getRequest(this.swingSide) == LoadBearingRequest.LOAD) {
            this.initiateFootLoadingProcedure(this.swingSide);
        }
    }

    private void initiateFootLoadingProcedure(RobotSide swingSide) {
        this.loadFoot.set(true);
        this.balanceManager.clearICPPlan();
        double swingTime = this.loadFootDuration.getDoubleValue();
        double transferTime = this.loadFootTransferDuration.getDoubleValue();
        double finalTransferTime = this.walkingMessageHandler.getFinalTransferTime();
        this.footstepTiming.setTimings(swingTime, transferTime);
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.addFootstepToPlan(this.walkingMessageHandler.getFootstepAtCurrentLocation(swingSide), this.footstepTiming);
        this.balanceManager.setICPPlanSupportSide(this.supportSide);
        this.balanceManager.initializeICPPlanForSingleSupport();
        this.balanceManager.freezePelvisXYControl();
    }
}

