/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController;

import controller_msgs.msg.dds.ManipulationAbortedStatus;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.CommandConsumerWithDelayBuffers;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.AbortWalkingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.AdjustFootstepCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ArmDesiredAccelerationsCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ArmTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.AutomaticManipulationAbortCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.CenterOfMassTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ChestHybridJointspaceTaskspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ChestTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.DesiredAccelerationsCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootLoadBearingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.GoHomeCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandHybridJointspaceTaskspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandLoadBearingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandWrenchTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HeadHybridJointspaceTaskspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HeadTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.LoadBearingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.MomentumTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.NeckDesiredAccelerationsCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.NeckTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PauseWalkingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisOrientationTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionsListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PrepareForLocomotionCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SpineDesiredAccelerationsCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SpineTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StepConstraintRegionCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.WrenchTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.HumanoidBodyPart;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingCommandConsumer {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean isAutomaticManipulationAbortEnabled = new YoBoolean("isAutomaticManipulationAbortEnabled", this.registry);
    private final YoBoolean hasManipulationBeenAborted = new YoBoolean("hasManipulationBeenAborted", this.registry);
    private final YoDouble icpErrorThresholdToAbortManipulation = new YoDouble("icpErrorThresholdToAbortManipulation", this.registry);
    private final YoDouble minimumDurationBetweenTwoManipulationAborts = new YoDouble("minimumDurationBetweenTwoManipulationAborts", this.registry);
    private final YoDouble timeOfLastManipulationAbortRequest = new YoDouble("timeOfLastManipulationAbortRequest", this.registry);
    private final YoDouble manipulationIgnoreInputsDurationAfterAbort = new YoDouble("manipulationIgnoreInputsDurationAfterAbort", this.registry);
    private final YoDouble allowManipulationAbortAfterThisTime = new YoDouble("allowManipulationAbortAfterThisTime", this.registry);
    private final YoDouble yoTime;
    private final WalkingMessageHandler walkingMessageHandler;
    private final CommandConsumerWithDelayBuffers commandConsumerWithDelayBuffers;
    private final StatusMessageOutputManager statusMessageOutputManager;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final FeetManager feetManager;
    private final BalanceManager balanceManager;
    private final CenterOfMassHeightManager comHeightManager;
    private final RigidBodyControlManager chestManager;
    private final RigidBodyControlManager headManager;
    private final SideDependentList<RigidBodyControlManager> handManagers = new SideDependentList();
    private final ManipulationAbortedStatus manipulationAbortedStatus = new ManipulationAbortedStatus();

    public WalkingCommandConsumer(CommandInputManager commandInputManager, StatusMessageOutputManager statusMessageOutputManager, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this(commandInputManager, statusMessageOutputManager, controllerToolbox.getWalkingMessageHandler(), controllerToolbox.getYoTime(), controllerToolbox.getFullRobotModel(), controllerToolbox.getPelvisZUpFrame(), managerFactory, walkingControllerParameters, parentRegistry);
    }

    public WalkingCommandConsumer(CommandInputManager commandInputManager, StatusMessageOutputManager statusMessageOutputManager, WalkingMessageHandler walkingMessageHandler, YoDouble yoTime, FullHumanoidRobotModel fullRobotModel, ReferenceFrame pelvisZUpFrame, HighLevelControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this.walkingMessageHandler = walkingMessageHandler;
        this.yoTime = yoTime;
        this.commandConsumerWithDelayBuffers = new CommandConsumerWithDelayBuffers(commandInputManager, yoTime);
        this.statusMessageOutputManager = statusMessageOutputManager;
        RigidBodyBasics head = fullRobotModel.getHead();
        RigidBodyBasics chest = fullRobotModel.getChest();
        RigidBodyBasics pelvis = fullRobotModel.getPelvis();
        MovingReferenceFrame chestBodyFrame = null;
        if (chest != null) {
            chestBodyFrame = chest.getBodyFixedFrame();
            this.chestManager = managerFactory.getOrCreateRigidBodyManager(chest, pelvis, (ReferenceFrame)chestBodyFrame, pelvisZUpFrame);
        } else {
            this.chestManager = null;
        }
        if (head != null) {
            MovingReferenceFrame headBodyFrame = head.getBodyFixedFrame();
            this.headManager = managerFactory.getOrCreateRigidBodyManager(head, chest, (ReferenceFrame)headBodyFrame, (ReferenceFrame)chestBodyFrame);
        } else {
            this.headManager = null;
        }
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
            if (hand == null) continue;
            MovingReferenceFrame handControlFrame = fullRobotModel.getHandControlFrame(robotSide);
            RigidBodyControlManager handManager = managerFactory.getOrCreateRigidBodyManager(hand, chest, (ReferenceFrame)handControlFrame, (ReferenceFrame)chestBodyFrame);
            handManager.setDoPrepareForLocomotion(walkingControllerParameters.doPrepareManipulationForLocomotion());
            this.handManagers.put((Enum)robotSide, (Object)handManager);
        }
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.isAutomaticManipulationAbortEnabled.set(walkingControllerParameters.allowAutomaticManipulationAbort());
        this.icpErrorThresholdToAbortManipulation.set(walkingControllerParameters.getICPErrorThresholdForManipulationAbort());
        this.minimumDurationBetweenTwoManipulationAborts.set(5.0);
        this.manipulationIgnoreInputsDurationAfterAbort.set(2.0);
        this.timeOfLastManipulationAbortRequest.set(Double.NEGATIVE_INFINITY);
        this.allowManipulationAbortAfterThisTime.set(Double.NEGATIVE_INFINITY);
        parentRegistry.addChild(this.registry);
    }

    public void avoidManipulationAbortForDuration(double durationToAvoidAbort) {
        this.allowManipulationAbortAfterThisTime.set(this.yoTime.getDoubleValue() + durationToAvoidAbort);
    }

    public void update() {
        this.commandConsumerWithDelayBuffers.update();
    }

    public void consumeHeadCommands() {
        HeadTrajectoryCommand command;
        if (this.headManager == null) {
            return;
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(HeadTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(HeadTrajectoryCommand.class);
            SO3TrajectoryControllerCommand so3Trajectory = command.getSO3Trajectory();
            so3Trajectory.setSequenceId(command.getSequenceId());
            this.headManager.handleTaskspaceTrajectoryCommand(so3Trajectory);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(NeckTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(NeckTrajectoryCommand.class);
            JointspaceTrajectoryCommand jointspaceTrajectory = command.getJointspaceTrajectory();
            jointspaceTrajectory.setSequenceId(command.getSequenceId());
            this.headManager.handleJointspaceTrajectoryCommand(jointspaceTrajectory);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(NeckDesiredAccelerationsCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(NeckDesiredAccelerationsCommand.class);
            DesiredAccelerationsCommand desiredAccelerations = command.getDesiredAccelerations();
            desiredAccelerations.setSequenceId(command.getSequenceId());
            this.headManager.handleDesiredAccelerationsCommand(desiredAccelerations);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(HeadHybridJointspaceTaskspaceTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(HeadHybridJointspaceTaskspaceTrajectoryCommand.class);
            SO3TrajectoryControllerCommand taskspaceTrajectoryCommand = command.getTaskspaceTrajectoryCommand();
            JointspaceTrajectoryCommand jointspaceTrajectoryCommand = command.getJointspaceTrajectoryCommand();
            taskspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            jointspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            this.headManager.handleHybridTrajectoryCommand(taskspaceTrajectoryCommand, jointspaceTrajectoryCommand);
        }
    }

    public void consumeChestCommands() {
        ChestTrajectoryCommand command;
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(ChestTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(ChestTrajectoryCommand.class);
            SO3TrajectoryControllerCommand so3Trajectory = command.getSO3Trajectory();
            so3Trajectory.setSequenceId(command.getSequenceId());
            this.chestManager.handleTaskspaceTrajectoryCommand(so3Trajectory);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(SpineTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(SpineTrajectoryCommand.class);
            JointspaceTrajectoryCommand jointspaceTrajectory = command.getJointspaceTrajectory();
            jointspaceTrajectory.setSequenceId(command.getSequenceId());
            this.chestManager.handleJointspaceTrajectoryCommand(jointspaceTrajectory);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(SpineDesiredAccelerationsCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(SpineDesiredAccelerationsCommand.class);
            DesiredAccelerationsCommand desiredAccelerations = command.getDesiredAccelerations();
            desiredAccelerations.setSequenceId(command.getSequenceId());
            this.chestManager.handleDesiredAccelerationsCommand(desiredAccelerations);
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(ChestHybridJointspaceTaskspaceTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(ChestHybridJointspaceTaskspaceTrajectoryCommand.class);
            SO3TrajectoryControllerCommand taskspaceTrajectoryCommand = command.getTaskspaceTrajectoryCommand();
            JointspaceTrajectoryCommand jointspaceTrajectoryCommand = command.getJointspaceTrajectoryCommand();
            taskspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            jointspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            this.chestManager.handleHybridTrajectoryCommand(taskspaceTrajectoryCommand, jointspaceTrajectoryCommand);
        }
    }

    public void consumePelvisHeightCommands() {
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PelvisHeightTrajectoryCommand.class)) {
            PelvisHeightTrajectoryCommand command = this.commandConsumerWithDelayBuffers.pollNewestCommand(PelvisHeightTrajectoryCommand.class);
            this.comHeightManager.handlePelvisHeightTrajectoryCommand(command);
        }
    }

    public void consumeGoHomeMessages() {
        if (!this.commandConsumerWithDelayBuffers.isNewCommandAvailable(GoHomeCommand.class)) {
            return;
        }
        List<GoHomeCommand> commands = this.commandConsumerWithDelayBuffers.pollNewCommands(GoHomeCommand.class);
        for (int i = 0; i < commands.size(); ++i) {
            GoHomeCommand command = commands.get(i);
            for (RobotSide robotSide : RobotSide.values) {
                RigidBodyControlManager handManager;
                if (!command.getRequest(robotSide, HumanoidBodyPart.ARM) || (handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide)) == null) continue;
                handManager.goHome(command.getTrajectoryTime());
            }
            if (command.getRequest(HumanoidBodyPart.PELVIS)) {
                this.pelvisOrientationManager.goToHomeFromCurrentDesired(command.getTrajectoryTime());
                this.balanceManager.goHome();
                this.comHeightManager.goHome(command.getTrajectoryTime());
            }
            if (!command.getRequest(HumanoidBodyPart.CHEST)) continue;
            this.chestManager.goHome(command.getTrajectoryTime());
        }
    }

    public void consumePelvisCommands(WalkingState currentState, boolean allowMotionRegardlessOfState) {
        PelvisOrientationTrajectoryCommand command;
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PelvisOrientationTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(PelvisOrientationTrajectoryCommand.class);
            if (allowMotionRegardlessOfState || currentState.isStateSafeToConsumePelvisTrajectoryCommand() || command.getForceExecution()) {
                this.pelvisOrientationManager.handlePelvisOrientationTrajectoryCommands(command);
            }
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PelvisTrajectoryCommand.class)) {
            command = this.commandConsumerWithDelayBuffers.pollNewestCommand(PelvisTrajectoryCommand.class);
            if (allowMotionRegardlessOfState || currentState.isStateSafeToConsumePelvisTrajectoryCommand() || command.getForceExecution()) {
                if (!this.pelvisOrientationManager.handlePelvisTrajectoryCommand((PelvisTrajectoryCommand)command)) {
                    return;
                }
                this.balanceManager.handlePelvisTrajectoryCommand((PelvisTrajectoryCommand)command);
                this.comHeightManager.handlePelvisTrajectoryCommand((PelvisTrajectoryCommand)command);
            }
        }
    }

    public void consumeManipulationCommands(WalkingState currentState, boolean allowMotionRegardlessOfState) {
        RigidBodyControlManager handManager;
        RobotSide robotSide;
        HandTrajectoryCommand command;
        int i;
        if (this.yoTime.getDoubleValue() - this.timeOfLastManipulationAbortRequest.getDoubleValue() < this.manipulationIgnoreInputsDurationAfterAbort.getDoubleValue()) {
            this.commandConsumerWithDelayBuffers.clearCommands(HandTrajectoryCommand.class);
            this.commandConsumerWithDelayBuffers.clearCommands(HandWrenchTrajectoryCommand.class);
            this.commandConsumerWithDelayBuffers.clearCommands(ArmTrajectoryCommand.class);
            this.commandConsumerWithDelayBuffers.clearCommands(ArmDesiredAccelerationsCommand.class);
            this.commandConsumerWithDelayBuffers.clearCommands(HandHybridJointspaceTaskspaceTrajectoryCommand.class);
            return;
        }
        List<HandTrajectoryCommand> handTrajectoryCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(HandTrajectoryCommand.class);
        List<HandWrenchTrajectoryCommand> handWrenchTrajectoryCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(HandWrenchTrajectoryCommand.class);
        List<ArmTrajectoryCommand> armTrajectoryCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(ArmTrajectoryCommand.class);
        List<ArmDesiredAccelerationsCommand> armDesiredAccelerationCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(ArmDesiredAccelerationsCommand.class);
        List<HandHybridJointspaceTaskspaceTrajectoryCommand> handHybridCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(HandHybridJointspaceTaskspaceTrajectoryCommand.class);
        boolean allowCommand = allowMotionRegardlessOfState || currentState.isStateSafeToConsumeManipulationCommands();
        for (i = 0; i < handTrajectoryCommands.size(); ++i) {
            command = handTrajectoryCommands.get(i);
            robotSide = command.getRobotSide();
            handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
            if (handManager == null || !allowCommand && !command.getForceExecution()) continue;
            SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
            se3Trajectory.setSequenceId(command.getSequenceId());
            handManager.handleTaskspaceTrajectoryCommand(se3Trajectory);
        }
        for (i = 0; i < handWrenchTrajectoryCommands.size(); ++i) {
            command = handWrenchTrajectoryCommands.get(i);
            robotSide = command.getRobotSide();
            handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
            if (handManager == null || !allowCommand && !command.getForceExecution()) continue;
            WrenchTrajectoryControllerCommand wrenchTrajectory = command.getWrenchTrajectory();
            wrenchTrajectory.setSequenceId(command.getSequenceId());
            handManager.handleWrenchTrajectoryCommand(wrenchTrajectory);
        }
        for (i = 0; i < armTrajectoryCommands.size(); ++i) {
            command = armTrajectoryCommands.get(i);
            robotSide = command.getRobotSide();
            handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
            if (handManager == null || !allowCommand && !command.getForceExecution()) continue;
            JointspaceTrajectoryCommand jointspaceTrajectory = command.getJointspaceTrajectory();
            jointspaceTrajectory.setSequenceId(command.getSequenceId());
            handManager.handleJointspaceTrajectoryCommand(jointspaceTrajectory);
        }
        for (i = 0; i < handHybridCommands.size(); ++i) {
            command = handHybridCommands.get(i);
            robotSide = command.getRobotSide();
            handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
            if (handManager == null || !allowCommand && !command.getForceExecution()) continue;
            SE3TrajectoryControllerCommand taskspaceTrajectoryCommand = command.getTaskspaceTrajectoryCommand();
            JointspaceTrajectoryCommand jointspaceTrajectoryCommand = command.getJointspaceTrajectoryCommand();
            taskspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            jointspaceTrajectoryCommand.setSequenceId(command.getSequenceId());
            handManager.handleHybridTrajectoryCommand(taskspaceTrajectoryCommand, jointspaceTrajectoryCommand);
        }
        for (i = 0; i < armDesiredAccelerationCommands.size(); ++i) {
            command = armDesiredAccelerationCommands.get(i);
            robotSide = command.getRobotSide();
            handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
            if (handManager == null || !allowCommand) continue;
            DesiredAccelerationsCommand desiredAccelerations = command.getDesiredAccelerations();
            desiredAccelerations.setSequenceId(command.getSequenceId());
            handManager.handleDesiredAccelerationsCommand(desiredAccelerations);
        }
    }

    public void handleAutomaticManipulationAbortOnICPError(WalkingState currentState) {
        if (!currentState.isStateSafeToConsumeManipulationCommands()) {
            return;
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(AutomaticManipulationAbortCommand.class)) {
            AutomaticManipulationAbortCommand message = this.commandConsumerWithDelayBuffers.pollNewestCommand(AutomaticManipulationAbortCommand.class);
            this.isAutomaticManipulationAbortEnabled.set(message.isEnable());
        }
        if (!this.isAutomaticManipulationAbortEnabled.getBooleanValue()) {
            return;
        }
        if (this.yoTime.getDoubleValue() - this.timeOfLastManipulationAbortRequest.getDoubleValue() < this.minimumDurationBetweenTwoManipulationAborts.getDoubleValue()) {
            return;
        }
        if (this.yoTime.getDoubleValue() < this.allowManipulationAbortAfterThisTime.getDoubleValue()) {
            return;
        }
        if (this.balanceManager.getICPErrorMagnitude() > this.icpErrorThresholdToAbortManipulation.getDoubleValue()) {
            this.hasManipulationBeenAborted.set(true);
            for (RobotSide robotSide : RobotSide.values) {
                RigidBodyControlManager handManager = (RigidBodyControlManager)this.handManagers.get((Enum)robotSide);
                if (handManager == null || handManager.isLoadBearing()) continue;
                handManager.holdInJointspace();
                handManager.resetJointIntegrators();
            }
            this.timeOfLastManipulationAbortRequest.set(this.yoTime.getDoubleValue());
            this.statusMessageOutputManager.reportStatusMessage((Object)this.manipulationAbortedStatus);
        } else {
            this.hasManipulationBeenAborted.set(false);
        }
    }

    public void consumeFootLoadBearingCommands(WalkingState currentState) {
        if (!this.commandConsumerWithDelayBuffers.isNewCommandAvailable(FootLoadBearingCommand.class)) {
            return;
        }
        List<FootLoadBearingCommand> footLoadBearingCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(FootLoadBearingCommand.class);
        for (int i = 0; i < footLoadBearingCommands.size(); ++i) {
            FootLoadBearingCommand command = footLoadBearingCommands.get(i);
            currentState.handleFootLoadBearingCommand(command);
        }
    }

    public void consumeLoadBearingCommands() {
        List<HandLoadBearingCommand> handLoadBearingCommands = this.commandConsumerWithDelayBuffers.pollNewCommands(HandLoadBearingCommand.class);
        for (int i = 0; i < handLoadBearingCommands.size(); ++i) {
            HandLoadBearingCommand command = handLoadBearingCommands.get(i);
            RobotSide robotSide = command.getRobotSide();
            if (this.handManagers.get((Enum)robotSide) == null) continue;
            JointspaceTrajectoryCommand jointspaceTrajectory = null;
            if (command.isUseJointspaceCommand()) {
                jointspaceTrajectory = command.getJointspaceTrajectory();
                jointspaceTrajectory.setSequenceId(command.getSequenceId());
            }
            LoadBearingCommand loadBearingCommand = command.getLoadBearingCommand();
            loadBearingCommand.setSequenceId(command.getSequenceId());
            ((RigidBodyControlManager)this.handManagers.get((Enum)robotSide)).handleLoadBearingCommand(loadBearingCommand, jointspaceTrajectory);
        }
    }

    public void consumeStopAllTrajectoryCommands() {
        if (!this.commandConsumerWithDelayBuffers.isNewCommandAvailable(StopAllTrajectoryCommand.class)) {
            return;
        }
        StopAllTrajectoryCommand command = this.commandConsumerWithDelayBuffers.pollNewestCommand(StopAllTrajectoryCommand.class);
        for (RobotSide robotSide : RobotSide.values) {
            if (this.handManagers.get((Enum)robotSide) == null) continue;
            ((RigidBodyControlManager)this.handManagers.get((Enum)robotSide)).handleStopAllTrajectoryCommand(command);
        }
        if (this.chestManager != null) {
            this.chestManager.handleStopAllTrajectoryCommand(command);
        }
        this.feetManager.handleStopAllTrajectoryCommand(command);
        this.comHeightManager.handleStopAllTrajectoryCommand(command);
        this.balanceManager.handleStopAllTrajectoryCommand(command);
        this.pelvisOrientationManager.handleStopAllTrajectoryCommand(command);
    }

    public void consumeFootCommands() {
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(FootTrajectoryCommand.class)) {
            this.walkingMessageHandler.handleFootTrajectoryCommand(this.commandConsumerWithDelayBuffers.pollNewCommands(FootTrajectoryCommand.class));
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PauseWalkingCommand.class)) {
            this.walkingMessageHandler.handlePauseWalkingCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(PauseWalkingCommand.class));
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(FootstepDataListCommand.class)) {
            this.walkingMessageHandler.handleFootstepDataListCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(FootstepDataListCommand.class));
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(AdjustFootstepCommand.class)) {
            this.walkingMessageHandler.handleAdjustFootstepCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(AdjustFootstepCommand.class));
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(MomentumTrajectoryCommand.class)) {
            this.walkingMessageHandler.handleMomentumTrajectoryCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(MomentumTrajectoryCommand.class));
        }
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(CenterOfMassTrajectoryCommand.class)) {
            this.walkingMessageHandler.handleComTrajectoryCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(CenterOfMassTrajectoryCommand.class));
        }
    }

    public void consumeAbortWalkingCommands(YoBoolean abortWalkingRequested) {
        if (!this.commandConsumerWithDelayBuffers.isNewCommandAvailable(AbortWalkingCommand.class)) {
            return;
        }
        abortWalkingRequested.set(this.commandConsumerWithDelayBuffers.pollNewestCommand(AbortWalkingCommand.class).isAbortWalkingRequested());
    }

    public void consumePlanarRegionsListCommand() {
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PlanarRegionsListCommand.class)) {
            this.walkingMessageHandler.handlePlanarRegionsListCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(PlanarRegionsListCommand.class));
        }
    }

    public void consumePlanarRegionStepConstraintCommand() {
        if (this.commandConsumerWithDelayBuffers.isNewCommandAvailable(StepConstraintRegionCommand.class)) {
            this.walkingMessageHandler.handleStepConstraintRegionCommand(this.commandConsumerWithDelayBuffers.pollNewestCommand(StepConstraintRegionCommand.class));
        }
    }

    public void consumePrepareForLocomotionCommands() {
        if (!this.commandConsumerWithDelayBuffers.isNewCommandAvailable(PrepareForLocomotionCommand.class)) {
            return;
        }
        PrepareForLocomotionCommand command = this.commandConsumerWithDelayBuffers.pollNewestCommand(PrepareForLocomotionCommand.class);
        for (RobotSide robotSide : RobotSide.values) {
            ((RigidBodyControlManager)this.handManagers.get((Enum)robotSide)).setDoPrepareForLocomotion(command.isPrepareManipulation());
        }
        this.pelvisOrientationManager.setPrepareForLocomotion(command.isPreparePelvis());
        this.comHeightManager.setPrepareForLocomotion(command.isPreparePelvis());
    }
}

