/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.CommandExecutionTimeComparator;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.concurrent.Builder;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ClearDelayQueueCommand;
import us.ihmc.log.LogTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class CommandConsumerWithDelayBuffers {
    public static final int NUMBER_OF_COMMANDS_TO_QUEUE = 16;
    private final YoDouble yoTime;
    private final CommandInputManager commandInputManager;
    private final Map<Class<? extends Command<?, ?>>, RecyclingArrayList<? extends Command<?, ?>>> queuedCommands = new HashMap();
    private final Map<Class<? extends Command<?, ?>>, RecyclingArrayList<? extends Command<?, ?>>> outgoingCommands = new HashMap();
    private final Map<Class<?>, PriorityQueue<Command<?, ?>>> priorityQueues = new HashMap();
    private final Map<Class<? extends Settable<?>>, Class<? extends Command<?, ?>>> messageToCommandMap = new HashMap();
    private final List<Class<? extends Command<?, ?>>> listOfSupportedCommands;

    public CommandConsumerWithDelayBuffers(CommandInputManager commandInputManager, YoDouble yoTime) {
        this.yoTime = yoTime;
        this.commandInputManager = commandInputManager;
        this.listOfSupportedCommands = commandInputManager.getListOfSupportedCommands();
        this.registerNewCommands(this.listOfSupportedCommands);
    }

    private <C extends Command<C, M>, M extends Settable<M>> void registerNewCommands(List<Class<? extends Command<?, ?>>> commandClasses) {
        for (int i = 0; i < commandClasses.size(); ++i) {
            Class<? extends Command<?, ?>> commandClass = commandClasses.get(i);
            this.registerNewCommand(commandClass);
            Builder commandConstructor = CommandInputManager.createBuilderWithEmptyConstructor(commandClass);
            Command command = (Command)commandConstructor.newInstance();
            this.messageToCommandMap.put(command.getMessageClass(), commandClass);
        }
    }

    private <C extends Command<C, M>, M extends Settable<M>> void registerNewCommand(Class<C> commandClass) {
        this.queuedCommands.put(commandClass, new RecyclingArrayList(16, commandClass));
        this.outgoingCommands.put(commandClass, new RecyclingArrayList(16, commandClass));
        CommandExecutionTimeComparator commandComparator = new CommandExecutionTimeComparator();
        this.priorityQueues.put(commandClass, new PriorityQueue(16, commandComparator));
    }

    public <C extends Command<C, ?>> void update() {
        for (int i = 0; i < this.listOfSupportedCommands.size(); ++i) {
            Class<? extends Command<?, ?>> commandClass = this.listOfSupportedCommands.get(i);
            RecyclingArrayList newCommands = (RecyclingArrayList)this.commandInputManager.pollNewCommands(commandClass);
            for (int commandIndex = 0; commandIndex < newCommands.size(); ++commandIndex) {
                Command command = (Command)newCommands.get(commandIndex);
                if (commandClass == ClearDelayQueueCommand.class) {
                    ClearDelayQueueCommand clearDelayQueueCommand = (ClearDelayQueueCommand)command;
                    this.handleClearQueueCommand(clearDelayQueueCommand);
                    continue;
                }
                this.queueCommand(command);
            }
        }
    }

    private void handleClearQueueCommand(ClearDelayQueueCommand clearDelayQueueCommand) {
        Class classToClear;
        Class messageClassToClear;
        if (clearDelayQueueCommand.getClearAllDelayBuffers()) {
            for (int commandIndex = 0; commandIndex < this.listOfSupportedCommands.size(); ++commandIndex) {
                Class<? extends Command<?, ?>> commandClassToFlush = this.listOfSupportedCommands.get(commandIndex);
                this.clearDelayQueue(commandClassToFlush);
            }
        }
        if ((messageClassToClear = clearDelayQueueCommand.getMessageClassToClear()) != null) {
            Class<? extends Command<?, ?>> commandClassToClear = this.messageToCommandMap.get(messageClassToClear);
            clearDelayQueueCommand.setCommandClassToClear(commandClassToClear);
        }
        if ((classToClear = clearDelayQueueCommand.getCommandClassToClear()) != null) {
            this.clearDelayQueue(classToClear);
        }
    }

    private void clearDelayQueue(Class<? extends Command<?, ?>> commandClassToFlush) {
        PriorityQueue<Command<?, ?>> queueableCommandPriorityQueue = this.priorityQueues.get(commandClassToFlush);
        queueableCommandPriorityQueue.clear();
        RecyclingArrayList<? extends Command<?, ?>> recyclingArrayList = this.queuedCommands.get(commandClassToFlush);
        recyclingArrayList.clear();
    }

    public <C extends Command<C, ?>> boolean isNewCommandAvailable(Class<? extends Command<?, ?>> clazz) {
        PriorityQueue<Command<?, ?>> priorityQueue = this.priorityQueues.get(clazz);
        Command<?, ?> command = priorityQueue.peek();
        if (command != null) {
            double startTime = command.getExecutionTime();
            if (this.yoTime.getDoubleValue() >= startTime) {
                return true;
            }
        }
        return false;
    }

    private <C extends Command<C, ?>> void queueCommand(C command) {
        PriorityQueue<Command<?, ?>> priorityQueue = this.priorityQueues.get(command.getClass());
        if (priorityQueue.size() >= 16) {
            LogTools.error((String)"Tried to add {} to the delay queue, but the queue was full. Try increasing the queue size", (Object)command.getClass().getSimpleName());
            return;
        }
        RecyclingArrayList<? extends Command<?, ?>> recyclingArrayList = this.queuedCommands.get(command.getClass());
        Command commandCopy = (Command)recyclingArrayList.add();
        commandCopy.set(command);
        if (commandCopy.isDelayedExecutionSupported()) {
            commandCopy.setExecutionTime(commandCopy.getExecutionDelayTime() + this.yoTime.getDoubleValue());
        }
        priorityQueue.add(commandCopy);
    }

    public <C extends Command<C, ?>> C pollNewestCommand(Class<C> commandClassToPoll) {
        if (this.isNewCommandAvailable(commandClassToPoll)) {
            RecyclingArrayList<? extends Command<?, ?>> recyclingArrayList = this.queuedCommands.get(commandClassToPoll);
            PriorityQueue<Command<?, ?>> priorityQueue = this.priorityQueues.get(commandClassToPoll);
            Command<?, ?> command = priorityQueue.poll();
            recyclingArrayList.remove(command);
            return (C)command;
        }
        return null;
    }

    public <C extends Command<C, ?>> List<C> pollNewCommands(Class<C> commandClassToPoll) {
        RecyclingArrayList<? extends Command<?, ?>> commands = this.outgoingCommands.get(commandClassToPoll);
        PriorityQueue<Command<?, ?>> priorityQueue = this.priorityQueues.get(commandClassToPoll);
        RecyclingArrayList<? extends Command<?, ?>> recyclingArrayList = this.queuedCommands.get(commandClassToPoll);
        commands.clear();
        while (this.isNewCommandAvailable(commandClassToPoll)) {
            Command<?, ?> queuedCommand = priorityQueue.poll();
            recyclingArrayList.remove(queuedCommand);
            ((Command)commands.add()).set(queuedCommand);
        }
        return commands;
    }

    @Deprecated
    public <C extends Command<C, ?>> void flushCommands(Class<C> commandClassToFlush) {
        this.clearCommands(commandClassToFlush);
    }

    public <C extends Command<C, ?>> void clearCommands(Class<C> commandClassToFlush) {
        this.clearDelayQueue(commandClassToFlush);
        this.commandInputManager.clearCommands(commandClassToFlush);
    }
}

