/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.saveableModule.YoSaveableModule;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StandingCoPTrajectoryGenerator
extends YoSaveableModule<JumpingCoPTrajectoryGeneratorState> {
    private final CoPTrajectoryParameters parameters;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<ContactPlaneProvider> contactStateProviders = new RecyclingArrayList(ContactPlaneProvider::new);
    private final FramePoint3D tempFramePoint = new FramePoint3D();
    private final FramePoint3D tempPointForCoPCalculation = new FramePoint3D();

    public StandingCoPTrajectoryGenerator(CoPTrajectoryParameters parameters, YoRegistry parentRegistry) {
        super(StandingCoPTrajectoryGenerator.class, parentRegistry);
        this.parameters = parameters;
        this.clear();
    }

    public void registerState(JumpingCoPTrajectoryGeneratorState state) {
        super.registerState((YoSaveableModuleState)state);
    }

    public void clear() {
        this.contactStateProviders.clear();
    }

    public void compute(JumpingCoPTrajectoryGeneratorState state) {
        this.clear();
        ContactPlaneProvider contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartTime(0.0);
        contactState.setStartECMPPosition(state.getInitialCoP());
        contactState.setPlaneProviderId(0);
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact(state.getFootPose(robotSide), (ConvexPolygon2DReadOnly)state.getFootPolygonInSole(robotSide));
        }
        ContactPlaneProvider previousContactState = contactState;
        this.tempPointForCoPCalculation.setIncludingFrame((FrameTuple2DReadOnly)state.getFootPolygonInSole(RobotSide.LEFT).getCentroid(), 0.0);
        this.tempPointForCoPCalculation.changeFrame(worldFrame);
        this.tempFramePoint.setIncludingFrame((FrameTuple2DReadOnly)state.getFootPolygonInSole(RobotSide.RIGHT).getCentroid(), 0.0);
        this.tempFramePoint.changeFrame(worldFrame);
        this.tempPointForCoPCalculation.interpolate((FrameTuple3DReadOnly)this.tempFramePoint, 0.5);
        double segmentDuration = this.parameters.getDefaultFinalTransferSplitFraction() * state.getFinalTransferDuration();
        previousContactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        previousContactState.setDuration(segmentDuration);
        previousContactState.setLinearECMPVelocity();
        segmentDuration = state.getFinalTransferDuration() - segmentDuration;
        contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactState.setDuration(segmentDuration);
        contactState.setLinearECMPVelocity();
        contactState.setPlaneProviderId(1);
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact(state.getFootPose(robotSide), (ConvexPolygon2DReadOnly)state.getFootPolygonInSole(robotSide));
        }
        previousContactState = contactState;
        contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition(previousContactState.getECMPStartPosition());
        contactState.setDuration(Double.POSITIVE_INFINITY);
        contactState.setLinearECMPVelocity();
        contactState.setPlaneProviderId(2);
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact(state.getFootPose(robotSide), (ConvexPolygon2DReadOnly)state.getFootPolygonInSole(robotSide));
        }
    }

    public RecyclingArrayList<ContactPlaneProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }
}

