/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalHandler;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStateEnum;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JumpingSupportState
extends JumpingState {
    private final JumpingControllerToolbox controllerToolbox;
    private final JumpingParameters jumpingParameters;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final JumpingGoalHandler jumpingGoalHandler;
    private final JumpingGoal jumpingGoal = new JumpingGoal();
    private final JumpingBalanceManager balanceManager;
    private final JumpingPelvisOrientationManager pelvisOrientationManager;

    public JumpingSupportState(JumpingGoalHandler jumpingGoalHandler, JumpingControllerToolbox controllerToolbox, JumpingControlManagerFactory managerFactory, JumpingParameters jumpingParameters, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(JumpingStateEnum.SUPPORT, parentRegistry);
        this.jumpingGoalHandler = jumpingGoalHandler;
        this.controllerToolbox = controllerToolbox;
        this.jumpingParameters = jumpingParameters;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
    }

    public void doAction(double timeInState) {
        this.balanceManager.computeCoMPlanForJumping(this.jumpingGoal);
    }

    public void onEntry() {
        this.jumpingGoalHandler.peekNextJumpingGoal(this.jumpingGoal);
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.setDesiredCoMHeight(this.controllerToolbox.getStandingHeight());
        this.balanceManager.initializeCoMPlanForSupport(this.jumpingGoal);
        this.balanceManager.setMinimizeAngularMomentumRate(true);
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.initializeStanding();
        }
    }

    public boolean isDone(double timeInState) {
        if (timeInState >= this.jumpingGoal.getSupportDuration()) {
            return true;
        }
        return this.areLegsStraight();
    }

    private boolean areLegsStraight() {
        double minKneeAngle = Double.POSITIVE_INFINITY;
        for (RobotSide robotSide : RobotSide.values) {
            minKneeAngle = Math.min(minKneeAngle, this.controllerToolbox.getFullRobotModel().getLegJoint((Enum)robotSide, LegJointName.KNEE_PITCH).getQ());
        }
        return minKneeAngle <= this.jumpingParameters.getMinKneeAngleForTakeOff();
    }
}

