/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlState;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingSupportFootState
implements JumpingFootControlState {
    protected static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final JumpingFootControlHelper footControlHelper;
    private final RobotSide robotSide;
    private final RigidBodyBasics rootBody;
    private final RigidBodyBasics pelvis;
    private final ContactableFoot contactableFoot;
    private final SpatialAcceleration footAcceleration = new SpatialAcceleration();
    private final JumpingControllerToolbox controllerToolbox;
    private final YoRegistry registry;
    private final FootSwitchInterface footSwitch;
    private final PoseReferenceFrame controlFrame;
    private final YoGraphicReferenceFrame frameViz;
    private Vector3DReadOnly angularWeight;
    private Vector3DReadOnly linearWeight;
    private final DoubleProvider loadingDuration;
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private final InverseDynamicsCommandList inverseDynamicsCommandList = new InverseDynamicsCommandList();
    private final YoDouble maxWeightFractionPerFoot;
    private final DoubleProvider rhoMin;
    private final double robotWeightFz;
    private final ContactWrenchCommand maxWrenchCommand;
    private final ContactWrenchCommand minWrenchCommand;
    private final YoDouble minZForce;
    private final YoDouble maxZForce;
    private final int numberOfBasisVectors;
    private final SelectionMatrix6D accelerationSelectionMatrix = new SelectionMatrix6D();
    private final FramePoint2D cop2d = new FramePoint2D();
    private final FramePoint3D framePosition = new FramePoint3D();
    private final FrameQuaternion frameOrientation = new FrameQuaternion();
    private final FrameVector3D contactNormal = new FrameVector3D();
    private final FrameVector3D normalVector = new FrameVector3D();

    public JumpingSupportFootState(JumpingFootControlHelper footControlHelper, YoRegistry parentRegistry) {
        this.footControlHelper = footControlHelper;
        this.contactableFoot = footControlHelper.getContactableFoot();
        this.controllerToolbox = footControlHelper.getJumpingControllerToolbox();
        this.rhoMin = () -> footControlHelper.getWalkingControllerParameters().getMomentumOptimizationSettings().getRhoMin();
        this.robotSide = footControlHelper.getRobotSide();
        FullHumanoidRobotModel fullRobotModel = footControlHelper.getJumpingControllerToolbox().getFullRobotModel();
        this.pelvis = fullRobotModel.getPelvis();
        this.rootBody = fullRobotModel.getElevator();
        String prefix = footControlHelper.getRobotSide().getLowerCaseName() + "Foot";
        this.registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.footSwitch = (FootSwitchInterface)footControlHelper.getJumpingControllerToolbox().getFootSwitches().get((Enum)this.robotSide);
        this.controlFrame = new PoseReferenceFrame(prefix + "HoldPositionFrame", this.contactableFoot.getSoleFrame());
        this.loadingDuration = new DoubleParameter(prefix + "LoadingDuration", this.registry, 0.05);
        this.spatialAccelerationCommand.setWeight(50.0);
        this.spatialAccelerationCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.spatialAccelerationCommand.setPrimaryBase(this.pelvis);
        this.minWrenchCommand = new ContactWrenchCommand(ConstraintType.GEQ_INEQUALITY);
        this.maxWrenchCommand = new ContactWrenchCommand(ConstraintType.LEQ_INEQUALITY);
        this.robotWeightFz = this.controllerToolbox.getFullRobotModel().getTotalMass() * this.controllerToolbox.getGravityZ();
        this.numberOfBasisVectors = footControlHelper.getWalkingControllerParameters().getMomentumOptimizationSettings().getNumberOfBasisVectorsPerContactPoint();
        this.setupWrenchCommand(this.maxWrenchCommand);
        this.setupWrenchCommand(this.minWrenchCommand);
        this.minZForce = new YoDouble(this.robotSide.getLowerCaseName() + "MinZForce", this.registry);
        this.maxZForce = new YoDouble(this.robotSide.getLowerCaseName() + "MaxZForce", this.registry);
        this.maxWeightFractionPerFoot = new YoDouble(this.robotSide.getLowerCaseName() + "MaxWeightFractionPerFoot", this.registry);
        this.maxWeightFractionPerFoot.set(2.0);
        this.minWrenchCommand.getWrench().setLinearPartZ(this.minZForce.getValue());
        this.setLoadedPercent(1.0);
        YoGraphicsListRegistry graphicsListRegistry = footControlHelper.getJumpingControllerToolbox().getYoGraphicsListRegistry();
        if (graphicsListRegistry != null) {
            this.frameViz = new YoGraphicReferenceFrame((ReferenceFrame)this.controlFrame, this.registry, false, 0.2);
            graphicsListRegistry.registerYoGraphic(prefix + this.getClass().getSimpleName(), (YoGraphic)this.frameViz);
        } else {
            this.frameViz = null;
        }
    }

    public void onEntry() {
        this.contactNormal.setIncludingFrame(this.contactableFoot.getSoleFrame(), 0.0, 0.0, 1.0);
        this.controllerToolbox.setFootContactStateNormalContactVector(this.robotSide, this.contactNormal);
    }

    public void onExit() {
        if (this.frameViz != null) {
            this.frameViz.hide();
        }
    }

    public void doAction(double timeInState) {
        this.footSwitch.computeAndPackCoP(this.cop2d);
        if (this.cop2d.containsNaN()) {
            this.cop2d.setToZero(this.contactableFoot.getSoleFrame());
        }
        this.setLoadedPercent(Math.min(timeInState / this.loadingDuration.getValue(), 1.0));
        YoPlaneContactState planeContactState = this.controllerToolbox.getFootContactState(this.robotSide);
        for (int i = 0; i < planeContactState.getTotalNumberOfContactPoints(); ++i) {
            YoContactPoint contactPoint = planeContactState.getContactPoints().get(i);
            planeContactState.setMaxContactPointNormalForce(contactPoint, Double.POSITIVE_INFINITY);
        }
        this.framePosition.setIncludingFrame((FrameTuple2DReadOnly)this.cop2d, 0.0);
        this.frameOrientation.setToZero(this.contactableFoot.getSoleFrame());
        this.controlFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.framePosition, (FrameOrientation3DReadOnly)this.frameOrientation);
        MovingReferenceFrame bodyFixedFrame = this.contactableFoot.getRigidBody().getBodyFixedFrame();
        this.footAcceleration.setToZero((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)this.rootBody.getBodyFixedFrame(), (ReferenceFrame)this.controlFrame);
        this.footAcceleration.setBodyFrame((ReferenceFrame)bodyFixedFrame);
        this.spatialAccelerationCommand.setSpatialAcceleration((ReferenceFrame)this.controlFrame, (SpatialAccelerationReadOnly)this.footAcceleration);
        this.spatialAccelerationCommand.setWeights((Tuple3DReadOnly)this.angularWeight, (Tuple3DReadOnly)this.linearWeight);
        MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.robotSide);
        this.accelerationSelectionMatrix.resetSelection();
        this.accelerationSelectionMatrix.setSelectionFrame((ReferenceFrame)soleZUpFrame);
        this.spatialAccelerationCommand.setSelectionMatrix(this.accelerationSelectionMatrix);
        if (this.frameViz != null) {
            this.frameViz.setToReferenceFrame((ReferenceFrame)this.controlFrame);
        }
    }

    private void setupWrenchCommand(ContactWrenchCommand command) {
        command.setRigidBody(this.contactableFoot.getRigidBody());
        command.getSelectionMatrix().clearSelection();
        command.getSelectionMatrix().setSelectionFrame(ReferenceFrame.getWorldFrame());
        command.getSelectionMatrix().selectLinearZ(true);
        command.getWrench().setToZero((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame(), ReferenceFrame.getWorldFrame());
    }

    public void setLoadedPercent(double percentLoaded) {
        if (this.minWrenchCommand == null) {
            return;
        }
        this.maxZForce.set(InterpolationTools.linearInterpolate((double)this.minZForce.getDoubleValue(), (double)(this.maxWeightFractionPerFoot.getValue() * this.robotWeightFz), (double)percentLoaded));
        this.maxZForce.set(Math.max(this.maxZForce.getValue(), this.computeMinZForceBasedOnRhoMin(this.rhoMin.getValue()) + 1.0E-5));
        this.updateWrenchCommands();
    }

    private void updateWrenchCommands() {
        this.maxZForce.set(Math.max(this.maxZForce.getValue(), this.minZForce.getValue() + 1.0E-5));
        this.minWrenchCommand.getWrench().setLinearPartZ(this.minZForce.getValue());
        this.maxWrenchCommand.getWrench().setLinearPartZ(this.maxZForce.getValue());
    }

    private double computeMinZForceBasedOnRhoMin(double rhoMin) {
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        contactState.getContactNormalFrameVector(this.normalVector);
        this.normalVector.changeFrame(ReferenceFrame.getWorldFrame());
        this.normalVector.normalize();
        double friction = contactState.getCoefficientOfFriction();
        int points = contactState.getNumberOfContactPointsInContact();
        return this.normalVector.getZ() * rhoMin * (double)this.numberOfBasisVectors * (double)points / Math.sqrt(1.0 + friction * friction);
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandList.clear();
        this.inverseDynamicsCommandList.addCommand(this.maxWrenchCommand);
        this.inverseDynamicsCommandList.addCommand(this.minWrenchCommand);
        this.inverseDynamicsCommandList.addCommand(this.spatialAccelerationCommand);
        return this.inverseDynamicsCommandList;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return null;
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.angularWeight = angularWeight;
        this.linearWeight = linearWeight;
    }
}

