/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStateEnum;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class JumpingStandingState
extends JumpingState {
    private final JumpingControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final JumpingBalanceManager balanceManager;
    private final JumpingPelvisOrientationManager pelvisOrientationManager;
    private final RigidBodyControlManager chestManager;
    private final YoBoolean squat;

    public JumpingStandingState(JumpingControllerToolbox controllerToolbox, JumpingControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(JumpingStateEnum.STANDING, parentRegistry);
        this.squat = new YoBoolean("ShouldBeSquatting", this.registry);
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.squat.addListener(v -> {
            if (this.squat.getBooleanValue()) {
                this.balanceManager.setDesiredCoMHeight(controllerToolbox.getSquattingHeight());
            } else {
                this.balanceManager.setDesiredCoMHeight(controllerToolbox.getStandingHeight());
            }
        });
        this.squat.notifyListeners();
        RigidBodyBasics chest = controllerToolbox.getFullRobotModel().getChest();
        RigidBodyBasics pelvis = controllerToolbox.getFullRobotModel().getPelvis();
        MovingReferenceFrame chestBodyFrame = chest.getBodyFixedFrame();
        MovingReferenceFrame pelvisBodyFrame = pelvis.getBodyFixedFrame();
        this.chestManager = managerFactory.getOrCreateRigidBodyManager(chest, pelvis, (ReferenceFrame)chestBodyFrame, (ReferenceFrame)pelvisBodyFrame);
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
    }

    public void doAction(double timeInState) {
        this.balanceManager.computeCoMPlanForStanding();
    }

    public void onEntry() {
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.initializeCoMPlanForStanding();
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.initializeStanding();
        }
        this.failureDetectionControlModule.setNextFootstep(null);
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.STANDING);
    }

    public void onExit() {
        this.squat.set(false);
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.IN_MOTION);
    }

    public boolean isDone(double timeInState) {
        return true;
    }
}

