/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.JointLoadStatusProvider;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.ParameterizedControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFeetManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFlightState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalHandler;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStandingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStateEnum;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.TransferToJumpingStandingState;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitEnforcement;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.ScrewTools;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingHumanoidController
implements JointLoadStatusProvider {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoDouble yoTime;
    private final JumpingGoalHandler jumpingGoalHandler;
    private final JumpingControlManagerFactory managerFactory;
    private final JumpingPelvisOrientationManager pelvisOrientationManager;
    private final JumpingFeetManager feetManager;
    private final JumpingBalanceManager balanceManager;
    private final JumpingParameters jumpingParameters;
    private final ArrayList<RigidBodyControlManager> bodyManagers = new ArrayList();
    private final Map<String, RigidBodyControlManager> bodyManagerByJointName = new HashMap<String, RigidBodyControlManager>();
    private final SideDependentList<Set<String>> legJointNames = new SideDependentList();
    private final FullHumanoidRobotModel fullRobotModel;
    private final JumpingControllerToolbox controllerToolbox;
    private final StateMachine<JumpingStateEnum, JumpingState> stateMachine;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final JointLimitEnforcementMethodCommand jointLimitEnforcementMethodCommand = new JointLimitEnforcementMethodCommand();
    private final YoBoolean limitCommandSent = new YoBoolean("limitCommandSent", this.registry);
    private final PrivilegedConfigurationCommand privilegedConfigurationCommand = new PrivilegedConfigurationCommand();
    private final ControllerCoreCommand controllerCoreCommand = new ControllerCoreCommand(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
    private final WalkingControllerParameters walkingControllerParameters;
    private final ParameterizedControllerCoreOptimizationSettings controllerCoreOptimizationSettings;
    private boolean firstTick = true;
    private final RecyclingArrayList<PlaneContactStateCommand> planeContactStateCommandPool = new RecyclingArrayList(4, PlaneContactStateCommand.class);
    private final FramePoint2D capturePoint2d = new FramePoint2D();
    private final FramePoint2D desiredCapturePoint2d = new FramePoint2D();

    public JumpingHumanoidController(JumpingGoalHandler jumpingGoalHandler, JumpingControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, JumpingParameters jumpingParameters, JumpingControllerToolbox controllerToolbox) {
        OneDoFJointBasics[] jointsWithRestrictiveLimit;
        this.jumpingGoalHandler = jumpingGoalHandler;
        this.managerFactory = managerFactory;
        this.walkingControllerParameters = walkingControllerParameters;
        this.jumpingParameters = jumpingParameters;
        this.controllerToolbox = controllerToolbox;
        this.fullRobotModel = controllerToolbox.getFullRobotModel();
        this.yoTime = controllerToolbox.getYoTime();
        OneDoFJointBasics[] allOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])controllerToolbox.getControlledJoints(), OneDoFJointBasics.class);
        this.privilegedConfigurationCommand.enable();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        RigidBodyBasics head = this.fullRobotModel.getHead();
        RigidBodyBasics chest = this.fullRobotModel.getChest();
        RigidBodyBasics pelvis = this.fullRobotModel.getPelvis();
        ReferenceFrame pelvisZUpFrame = controllerToolbox.getPelvisZUpFrame();
        MovingReferenceFrame chestBodyFrame = null;
        if (chest != null) {
            chestBodyFrame = chest.getBodyFixedFrame();
            RigidBodyControlManager chestManager = managerFactory.getOrCreateRigidBodyManager(chest, pelvis, (ReferenceFrame)chestBodyFrame, pelvisZUpFrame);
            this.bodyManagers.add(chestManager);
        }
        if (head != null) {
            MovingReferenceFrame headBodyFrame = head.getBodyFixedFrame();
            RigidBodyControlManager headManager = managerFactory.getOrCreateRigidBodyManager(head, chest, (ReferenceFrame)headBodyFrame, (ReferenceFrame)chestBodyFrame);
            this.bodyManagers.add(headManager);
        }
        for (MovingReferenceFrame movingReferenceFrame : RobotSide.values) {
            RigidBodyBasics hand = this.fullRobotModel.getHand((RobotSide)movingReferenceFrame);
            MovingReferenceFrame handControlFrame = this.fullRobotModel.getHandControlFrame((RobotSide)movingReferenceFrame);
            RigidBodyControlManager handManager = managerFactory.getOrCreateRigidBodyManager(hand, chest, (ReferenceFrame)handControlFrame, (ReferenceFrame)chestBodyFrame);
            this.bodyManagers.add(handManager);
        }
        for (RigidBodyControlManager manager : this.bodyManagers) {
            if (manager == null) continue;
            Arrays.asList(manager.getControlledJoints()).forEach(joint -> this.bodyManagerByJointName.put(joint.getName(), manager));
        }
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.fullRobotModel.getFoot((Enum)robotSide);
            OneDoFJointBasics[] legJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)pelvis, (RigidBodyBasics)foot), OneDoFJointBasics.class);
            HashSet jointNames = new HashSet();
            Arrays.asList(legJoints).forEach(legJoint -> jointNames.add(legJoint.getName()));
            this.legJointNames.put((Enum)robotSide, jointNames);
        }
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.failureDetectionControlModule = new WalkingFailureDetectionControlModule(controllerToolbox.getContactableFeet(), this.registry);
        this.stateMachine = this.setupStateMachine();
        String[] jointNamesRestrictiveLimits = walkingControllerParameters.getJointsWithRestrictiveLimits();
        for (OneDoFJointBasics joint2 : jointsWithRestrictiveLimit = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])ScrewTools.findJointsWithNames((JointBasics[])allOneDoFJoints, (String[])jointNamesRestrictiveLimits), OneDoFJointBasics.class)) {
            JointLimitParameters limitParameters = walkingControllerParameters.getJointLimitParametersForJointsWithRestrictiveLimits(joint2.getName());
            if (limitParameters == null) {
                throw new RuntimeException("Must define joint limit parameters if using joints with restrictive limits.");
            }
            this.jointLimitEnforcementMethodCommand.addLimitEnforcementMethod(joint2, JointLimitEnforcement.RESTRICTIVE, limitParameters);
        }
        MomentumOptimizationSettings defaultControllerCoreOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        this.controllerCoreOptimizationSettings = new ParameterizedControllerCoreOptimizationSettings(defaultControllerCoreOptimizationSettings, this.registry);
    }

    private StateMachine<JumpingStateEnum, JumpingState> setupStateMachine() {
        StateMachineFactory factory = new StateMachineFactory(JumpingStateEnum.class);
        factory.setNamePrefix("jumping").setRegistry(this.registry).buildYoClock((DoubleProvider)this.yoTime);
        JumpingStandingState standingState = new JumpingStandingState(this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.registry);
        TransferToJumpingStandingState toStandingState = new TransferToJumpingStandingState(this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.registry);
        JumpingSupportState supportState = new JumpingSupportState(this.jumpingGoalHandler, this.controllerToolbox, this.managerFactory, this.jumpingParameters, this.failureDetectionControlModule, this.registry);
        JumpingFlightState flightState = new JumpingFlightState(this.jumpingGoalHandler, this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.jumpingParameters, this.registry);
        factory.addState((Enum)JumpingStateEnum.TO_STANDING, (State)toStandingState);
        factory.addState((Enum)JumpingStateEnum.STANDING, (State)standingState);
        factory.addState((Enum)JumpingStateEnum.SUPPORT, (State)supportState);
        factory.addState((Enum)JumpingStateEnum.FLIGHT, (State)flightState);
        factory.addDoneTransition((Enum)JumpingStateEnum.TO_STANDING, (Enum)JumpingStateEnum.STANDING);
        factory.addTransition((Enum)JumpingStateEnum.STANDING, (Enum)JumpingStateEnum.SUPPORT, time -> this.jumpingGoalHandler.hasJumpingGoal());
        factory.addDoneTransition((Enum)JumpingStateEnum.SUPPORT, (Enum)JumpingStateEnum.FLIGHT);
        factory.addDoneTransition((Enum)JumpingStateEnum.FLIGHT, (Enum)JumpingStateEnum.TO_STANDING);
        factory.getRegisteredStates().forEach(state -> factory.addStateChangedListener((from, to) -> state.setPreviousJumpingStateEnum((JumpingStateEnum)((Object)((Object)from)))));
        factory.addStateChangedListener(this.controllerToolbox::reportControllerStateChangeToListeners);
        return factory.build((Enum)JumpingStateEnum.TO_STANDING);
    }

    public void initialize() {
        this.controllerCoreCommand.requestReinitialization();
        this.controllerToolbox.initialize();
        this.managerFactory.initializeManagers();
        this.balanceManager.initialize();
        this.privilegedConfigurationCommand.clear();
        this.privilegedConfigurationCommand.enable();
        this.privilegedConfigurationCommand.setPrivilegedConfigurationOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_ZERO);
        for (RobotSide robotSide : RobotSide.values) {
            LegJointName[] legJointNames;
            ArmJointName[] armJointNames = this.fullRobotModel.getRobotSpecificJointNames().getArmJointNames();
            for (int i = 0; i < armJointNames.length; ++i) {
                this.privilegedConfigurationCommand.addJoint(this.fullRobotModel.getArmJoint(robotSide, armJointNames[i]), PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_MID_RANGE);
            }
            for (LegJointName legJointName : legJointNames = this.fullRobotModel.getRobotSpecificJointNames().getLegJointNames()) {
                this.privilegedConfigurationCommand.addJoint(this.fullRobotModel.getLegJoint((Enum)robotSide, legJointName), PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_MID_RANGE);
            }
        }
        for (int i = 0; i < this.privilegedConfigurationCommand.getNumberOfJoints(); ++i) {
            for (RobotSide robotSide : RobotSide.values) {
                if (!this.fullRobotModel.getLegJoint((Enum)robotSide, LegJointName.KNEE_PITCH).equals(this.privilegedConfigurationCommand.getJoint(i))) continue;
                this.privilegedConfigurationCommand.setConfigurationGain(i, 200.0);
                this.privilegedConfigurationCommand.setVelocityGain(i, 20.0);
                this.privilegedConfigurationCommand.setWeight(i, 20.0);
            }
        }
        this.initializeContacts();
        this.stateMachine.resetToInitialState();
        this.initializeManagers();
        this.firstTick = true;
    }

    private void initializeManagers() {
        double stepTime = this.walkingControllerParameters.getDefaultSwingTime() + this.walkingControllerParameters.getDefaultTransferTime();
        this.pelvisOrientationManager.setTrajectoryTime(stepTime);
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            bodyManager.initialize();
        }
        this.pelvisOrientationManager.initialize();
        this.feetManager.initialize();
    }

    private void initializeContacts() {
        this.controllerToolbox.clearContacts();
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerToolbox.resetFootPlaneContactPoint(robotSide);
            this.feetManager.setFlatFootContactState(robotSide);
        }
    }

    public void doAction() {
        this.updateFailureDetection();
        if (!this.firstTick) {
            this.stateMachine.doTransitions();
        }
        this.stateMachine.doAction();
        this.updateManagers();
        this.handleChangeInContactState();
        this.submitControllerCoreCommands();
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerToolbox.getFootContactState(robotSide).pollContactHasChangedNotification();
        }
        this.firstTick = false;
    }

    private void handleChangeInContactState() {
        boolean haveContactStatesChanged = false;
        for (RobotSide robotSide : RobotSide.values) {
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(robotSide);
            if (!contactState.peekContactHasChangedNotification()) continue;
            haveContactStatesChanged = true;
        }
        if (!haveContactStatesChanged) {
            return;
        }
        this.controllerToolbox.updateBipedSupportPolygons();
    }

    public void updateFailureDetection() {
        this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
        this.desiredCapturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getDesiredDCM());
        this.failureDetectionControlModule.checkIfRobotIsFalling((FramePoint2DReadOnly)this.capturePoint2d, (FramePoint2DReadOnly)this.desiredCapturePoint2d);
    }

    public void updateManagers() {
        this.feetManager.compute();
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            bodyManager.compute();
        }
        this.pelvisOrientationManager.compute();
        this.balanceManager.compute();
    }

    private void submitControllerCoreCommands() {
        this.planeContactStateCommandPool.clear();
        this.controllerCoreCommand.addInverseDynamicsCommand(this.privilegedConfigurationCommand);
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerCoreCommand.addFeedbackControlCommand(this.feetManager.getFeedbackControlCommand(robotSide));
            this.controllerCoreCommand.addInverseDynamicsCommand(this.feetManager.getInverseDynamicsCommand(robotSide));
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(robotSide);
            PlaneContactStateCommand planeContactStateCommand = (PlaneContactStateCommand)this.planeContactStateCommandPool.add();
            contactState.getPlaneContactStateCommand(planeContactStateCommand);
            this.controllerCoreCommand.addInverseDynamicsCommand(planeContactStateCommand);
        }
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            this.controllerCoreCommand.addFeedbackControlCommand(bodyManager.getFeedbackControlCommand());
            this.controllerCoreCommand.addInverseDynamicsCommand(bodyManager.getInverseDynamicsCommand());
        }
        this.controllerCoreCommand.addFeedbackControlCommand(this.pelvisOrientationManager.getFeedbackControlCommand());
        this.controllerCoreCommand.addInverseDynamicsCommand(this.controllerCoreOptimizationSettings.getCommand());
    }

    public ControllerCoreCommand getControllerCoreCommand() {
        return this.controllerCoreCommand;
    }

    public JumpingMomentumRateControlModuleInput getJumpingMomentumRateControlModuleInput() {
        return this.balanceManager.getJumpingMomentumRateControlModuleInput();
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    @Override
    public boolean isJointLoadBearing(String jointName) {
        for (RobotSide robotSide : RobotSide.values) {
            boolean legLoaded = this.feetManager.getCurrentConstraintType(robotSide).isLoadBearing();
            if (!legLoaded || !((Set)this.legJointNames.get((Enum)robotSide)).contains(jointName)) continue;
            return true;
        }
        RigidBodyControlManager manager = this.bodyManagerByJointName.get(jointName);
        return manager != null && manager.isLoadBearing();
    }
}

