/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;

public class JumpingGoalHandler {
    private final List<JumpingGoal> jumpingGoalList = new ArrayList<JumpingGoal>();
    private final JumpingParameters parameters;

    public JumpingGoalHandler(JumpingParameters parameters) {
        this.parameters = parameters;
    }

    public void consumeJumpingGoal(JumpingGoal jumpingGoal) {
        if (JumpingGoalHandler.isInvalidDuration(jumpingGoal.getSupportDuration())) {
            jumpingGoal.setSupportDuration(this.parameters.getDefaultSupportDuration());
        }
        if (JumpingGoalHandler.isInvalidDuration(jumpingGoal.getFlightDuration())) {
            jumpingGoal.setFlightDuration(this.parameters.getDefaultFlightDuration());
        }
        this.jumpingGoalList.add(jumpingGoal);
    }

    private static boolean isInvalidDuration(double duration) {
        return Double.isNaN(duration) || duration <= 0.001;
    }

    public boolean hasJumpingGoal() {
        return !this.jumpingGoalList.isEmpty();
    }

    public JumpingGoal pollNextJumpingGoal() {
        return this.jumpingGoalList.remove(0);
    }

    public void pollNextJumpingGoal(JumpingGoal jumpingGoal) {
        jumpingGoal.set(this.jumpingGoalList.remove(0));
    }

    public void peekNextJumpingGoal(JumpingGoal jumpingGoal) {
        jumpingGoal.set(this.jumpingGoalList.get(0));
    }
}

