/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.robotSide.RobotSide;

public class JumpingFootControlHelper {
    private final RobotSide robotSide;
    private final ContactableFoot contactableFoot;
    private final JumpingControllerToolbox controllerToolbox;
    private final WalkingControllerParameters walkingControllerParameters;
    private final FrameVector3D fullyConstrainedNormalContactVector;

    public JumpingFootControlHelper(RobotSide robotSide, WalkingControllerParameters walkingControllerParameters, JumpingControllerToolbox controllerToolbox) {
        this.robotSide = robotSide;
        this.controllerToolbox = controllerToolbox;
        this.walkingControllerParameters = walkingControllerParameters;
        this.contactableFoot = (ContactableFoot)controllerToolbox.getContactableFeet().get((Enum)robotSide);
        RigidBodyBasics foot = this.contactableFoot.getRigidBody();
        this.fullyConstrainedNormalContactVector = new FrameVector3D(this.contactableFoot.getSoleFrame(), 0.0, 0.0, 1.0);
    }

    public RobotSide getRobotSide() {
        return this.robotSide;
    }

    public ContactableFoot getContactableFoot() {
        return this.contactableFoot;
    }

    public JumpingControllerToolbox getJumpingControllerToolbox() {
        return this.controllerToolbox;
    }

    public WalkingControllerParameters getWalkingControllerParameters() {
        return this.walkingControllerParameters;
    }

    public SwingTrajectoryParameters getSwingTrajectoryParameters() {
        return this.walkingControllerParameters.getSwingTrajectoryParameters();
    }

    public void setFullyConstrainedNormalContactVector(FrameVector3D normalContactVector) {
        if (normalContactVector != null) {
            this.fullyConstrainedNormalContactVector.setIncludingFrame((FrameTuple3DReadOnly)normalContactVector);
        } else {
            this.fullyConstrainedNormalContactVector.setIncludingFrame(this.contactableFoot.getSoleFrame(), 0.0, 0.0, 1.0);
        }
    }
}

