/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.configurations.ParameterTools;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFeetManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ParameterizedPIDSE3Gains;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingControlManagerFactory {
    public static final String weightRegistryName = "MomentumOptimizationSettings";
    public static final String jointspaceGainRegistryName = "JointspaceGains";
    public static final String rigidBodyGainRegistryName = "RigidBodyGains";
    public static final String footGainRegistryName = "FootGains";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoRegistry momentumRegistry = new YoRegistry("MomentumOptimizationSettings");
    private final YoRegistry jointGainRegistry = new YoRegistry("JointspaceGains");
    private final YoRegistry bodyGainRegistry = new YoRegistry("RigidBodyGains");
    private final YoRegistry footGainRegistry = new YoRegistry("FootGains");
    private JumpingFeetManager feetManager;
    private JumpingPelvisOrientationManager pelvisOrientationManager;
    private JumpingBalanceManager balanceManager;
    private final Map<String, RigidBodyControlManager> rigidBodyManagerMapByBodyName = new HashMap<String, RigidBodyControlManager>();
    private JumpingControllerToolbox controllerToolbox;
    private WalkingControllerParameters walkingControllerParameters;
    private CoPTrajectoryParameters copTrajectoryParameters;
    private JumpingCoPTrajectoryParameters jumpingCopTrajectoryParameters;
    private JumpingParameters jumpingParameters;
    private MomentumOptimizationSettings momentumOptimizationSettings;
    private final Map<String, PIDGainsReadOnly> jointGainMap = new HashMap<String, PIDGainsReadOnly>();
    private final Map<String, PID3DGainsReadOnly> taskspaceOrientationGainMap = new HashMap<String, PID3DGainsReadOnly>();
    private final Map<String, PID3DGainsReadOnly> taskspacePositionGainMap = new HashMap<String, PID3DGainsReadOnly>();
    private final Map<String, DoubleProvider> jointspaceWeightMap = new HashMap<String, DoubleProvider>();
    private final Map<String, DoubleProvider> userModeWeightMap = new HashMap<String, DoubleProvider>();
    private final Map<String, Vector3DReadOnly> taskspaceAngularWeightMap = new HashMap<String, Vector3DReadOnly>();
    private final Map<String, Vector3DReadOnly> taskspaceLinearWeightMap = new HashMap<String, Vector3DReadOnly>();
    private Vector3DReadOnly loadedFootAngularWeight;
    private Vector3DReadOnly loadedFootLinearWeight;
    private PIDSE3GainsReadOnly swingFootGains;

    public JumpingControlManagerFactory(YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        parentRegistry.addChild(this.momentumRegistry);
        parentRegistry.addChild(this.jointGainRegistry);
        parentRegistry.addChild(this.bodyGainRegistry);
        parentRegistry.addChild(this.footGainRegistry);
    }

    public void setHighLevelHumanoidControllerToolbox(JumpingControllerToolbox controllerToolbox) {
        this.controllerToolbox = controllerToolbox;
    }

    public void setCoPTrajectoryParameters(CoPTrajectoryParameters copTrajectoryParameters) {
        this.copTrajectoryParameters = copTrajectoryParameters;
    }

    public void setJumpingCoPTrajectoryParameters(JumpingCoPTrajectoryParameters jumpingCopTrajectoryParameters) {
        this.jumpingCopTrajectoryParameters = jumpingCopTrajectoryParameters;
    }

    public void setJumpingParameters(JumpingParameters jumpingCopTrajectoryParameters) {
        this.jumpingParameters = jumpingCopTrajectoryParameters;
    }

    public void setWalkingControllerParameters(WalkingControllerParameters walkingControllerParameters) {
        this.walkingControllerParameters = walkingControllerParameters;
        this.momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        ParameterTools.extractJointGainMap(walkingControllerParameters.getJointSpaceControlGains(), this.jointGainMap, this.jointGainRegistry);
        ParameterTools.extract3DGainMap("Orientation", walkingControllerParameters.getTaskspaceOrientationControlGains(), this.taskspaceOrientationGainMap, this.bodyGainRegistry);
        ParameterTools.extract3DGainMap("Position", walkingControllerParameters.getTaskspacePositionControlGains(), this.taskspacePositionGainMap, this.bodyGainRegistry);
        ParameterTools.extractJointWeightMap("JointspaceWeight", this.momentumOptimizationSettings.getJointspaceWeights(), this.jointspaceWeightMap, this.momentumRegistry);
        ParameterTools.extractJointWeightMap("UserModeWeight", this.momentumOptimizationSettings.getUserModeWeights(), this.userModeWeightMap, this.momentumRegistry);
        ParameterTools.extract3DWeightMap("AngularWeight", this.momentumOptimizationSettings.getTaskspaceAngularWeights(), this.taskspaceAngularWeightMap, this.momentumRegistry);
        ParameterTools.extract3DWeightMap("LinearWeight", this.momentumOptimizationSettings.getTaskspaceLinearWeights(), this.taskspaceLinearWeightMap, this.momentumRegistry);
        this.loadedFootAngularWeight = new ParameterVector3D("LoadedFootAngularWeight", (Tuple3DReadOnly)this.momentumOptimizationSettings.getLoadedFootAngularWeight(), this.momentumRegistry);
        this.loadedFootLinearWeight = new ParameterVector3D("LoadedFootLinearWeight", (Tuple3DReadOnly)this.momentumOptimizationSettings.getLoadedFootLinearWeight(), this.momentumRegistry);
        this.swingFootGains = new ParameterizedPIDSE3Gains("SwingFoot", walkingControllerParameters.getSwingFootControlGains(), this.footGainRegistry);
    }

    public RigidBodyControlManager getOrCreateRigidBodyManager(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, ReferenceFrame controlFrame, ReferenceFrame baseFrame) {
        RigidBodyControlManager manager;
        if (bodyToControl == null) {
            return null;
        }
        String bodyName = bodyToControl.getName();
        if (this.rigidBodyManagerMapByBodyName.containsKey(bodyName) && (manager = this.rigidBodyManagerMapByBodyName.get(bodyName)) != null) {
            return manager;
        }
        if (!this.hasWalkingControllerParameters(RigidBodyControlManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(RigidBodyControlManager.class)) {
            return null;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(BalanceManager.class)) {
            return null;
        }
        PID3DGainsReadOnly taskspaceOrientationGains = this.taskspaceOrientationGainMap.get(bodyName);
        PID3DGainsReadOnly taskspacePositionGains = this.taskspacePositionGainMap.get(bodyName);
        Vector3DReadOnly taskspaceAngularWeight = this.taskspaceAngularWeightMap.get(bodyName);
        Vector3DReadOnly taskspaceLinearWeight = this.taskspaceLinearWeightMap.get(bodyName);
        TObjectDoubleHashMap<String> homeConfiguration = this.walkingControllerParameters.getOrCreateJointHomeConfiguration();
        Pose3D homePose = this.walkingControllerParameters.getOrCreateBodyHomeConfiguration().get(bodyName);
        RigidBodyBasics elevator = this.controllerToolbox.getFullRobotModel().getElevator();
        YoDouble yoTime = this.controllerToolbox.getYoTime();
        YoGraphicsListRegistry graphicsListRegistry = this.controllerToolbox.getYoGraphicsListRegistry();
        RigidBodyControlMode defaultControlMode = this.walkingControllerParameters.getDefaultControlModesForRigidBodies().get(bodyName);
        RigidBodyControlManager manager2 = new RigidBodyControlManager(bodyToControl, baseBody, elevator, homeConfiguration, homePose, controlFrame, baseFrame, taskspaceAngularWeight, taskspaceLinearWeight, taskspaceOrientationGains, taskspacePositionGains, null, defaultControlMode, yoTime, graphicsListRegistry, this.registry);
        manager2.setGains(this.jointGainMap);
        manager2.setWeights(this.jointspaceWeightMap, this.userModeWeightMap);
        this.rigidBodyManagerMapByBodyName.put(bodyName, manager2);
        return manager2;
    }

    public JumpingFeetManager getOrCreateFeetManager() {
        if (this.feetManager != null) {
            return this.feetManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(JumpingFeetManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(JumpingFeetManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(JumpingFeetManager.class)) {
            return null;
        }
        this.feetManager = new JumpingFeetManager(this.controllerToolbox, this.walkingControllerParameters, this.swingFootGains, this.registry);
        String footName = this.controllerToolbox.getFullRobotModel().getFoot((Enum)RobotSide.LEFT).getName();
        Vector3DReadOnly angularWeight = this.taskspaceAngularWeightMap.get(footName);
        Vector3DReadOnly linearWeight = this.taskspaceLinearWeightMap.get(footName);
        if (angularWeight == null || linearWeight == null) {
            throw new RuntimeException("Not all weights defined for the foot control: " + footName + " needs weights.");
        }
        String otherFootName = this.controllerToolbox.getFullRobotModel().getFoot((Enum)RobotSide.RIGHT).getName();
        if (this.taskspaceAngularWeightMap.get(otherFootName) != angularWeight || this.taskspaceLinearWeightMap.get(otherFootName) != linearWeight) {
            throw new RuntimeException("There can only be one weight defined for both feet. Make sure they are in the same GroupParameter");
        }
        this.feetManager.setWeights(this.loadedFootAngularWeight, this.loadedFootLinearWeight, angularWeight, linearWeight);
        return this.feetManager;
    }

    public JumpingBalanceManager getOrCreateBalanceManager() {
        if (this.balanceManager != null) {
            return this.balanceManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(JumpingBalanceManager.class)) {
            return null;
        }
        if (!this.hasCoPTrajectoryParameters(JumpingBalanceManager.class)) {
            return null;
        }
        if (!this.hasJumpingCoPTrajectoryParameters(JumpingBalanceManager.class)) {
            return null;
        }
        this.balanceManager = new JumpingBalanceManager(this.controllerToolbox, this.copTrajectoryParameters, this.jumpingCopTrajectoryParameters, this.jumpingParameters, this.registry);
        return this.balanceManager;
    }

    public JumpingPelvisOrientationManager getOrCreatePelvisOrientationManager() {
        if (this.pelvisOrientationManager != null) {
            return this.pelvisOrientationManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(JumpingPelvisOrientationManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(JumpingPelvisOrientationManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(JumpingPelvisOrientationManager.class)) {
            return null;
        }
        String pelvisName = this.controllerToolbox.getFullRobotModel().getPelvis().getName();
        PID3DGainsReadOnly pelvisGains = this.taskspaceOrientationGainMap.get(pelvisName);
        Vector3DReadOnly pelvisAngularWeight = this.taskspaceAngularWeightMap.get(pelvisName);
        this.pelvisOrientationManager = new JumpingPelvisOrientationManager(pelvisGains, this.controllerToolbox, this.registry);
        this.pelvisOrientationManager.setWeights(pelvisAngularWeight);
        this.pelvisOrientationManager.setPrepareForLocomotion(this.walkingControllerParameters.doPreparePelvisForLocomotion());
        return this.pelvisOrientationManager;
    }

    private boolean hasHighLevelHumanoidControllerToolbox(Class<?> managerClass) {
        if (this.controllerToolbox != null) {
            return true;
        }
        this.missingObjectWarning(JumpingControllerToolbox.class, managerClass);
        return false;
    }

    private boolean hasWalkingControllerParameters(Class<?> managerClass) {
        if (this.walkingControllerParameters != null) {
            return true;
        }
        this.missingObjectWarning(WalkingControllerParameters.class, managerClass);
        return false;
    }

    private boolean hasCoPTrajectoryParameters(Class<?> managerClass) {
        if (this.copTrajectoryParameters != null) {
            return true;
        }
        this.missingObjectWarning(CoPTrajectoryParameters.class, managerClass);
        return false;
    }

    private boolean hasJumpingCoPTrajectoryParameters(Class<?> managerClass) {
        if (this.jumpingCopTrajectoryParameters != null) {
            return true;
        }
        this.missingObjectWarning(JumpingCoPTrajectoryParameters.class, managerClass);
        return false;
    }

    private boolean hasMomentumOptimizationSettings(Class<?> managerClass) {
        if (this.momentumOptimizationSettings != null) {
            return true;
        }
        this.missingObjectWarning(MomentumOptimizationSettings.class, managerClass);
        return false;
    }

    private void missingObjectWarning(Class<?> missingObjectClass, Class<?> managerClass) {
        LogTools.warn((String)(missingObjectClass.getSimpleName() + " has not been set, cannot create: " + managerClass.getSimpleName()));
    }

    public void initializeManagers() {
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.initialize();
        }
        Collection<RigidBodyControlManager> bodyManagers = this.rigidBodyManagerMapByBodyName.values();
        for (RigidBodyControlManager bodyManager : bodyManagers) {
            if (bodyManager == null) continue;
            bodyManager.initialize();
        }
    }

    public FeedbackControllerTemplate createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        if (this.feetManager != null) {
            FeedbackControlCommandList template = this.feetManager.createFeedbackControlTemplate();
            for (int i = 0; i < template.getNumberOfCommands(); ++i) {
                ret.addCommand(template.getCommand(i));
            }
        }
        Collection<RigidBodyControlManager> bodyManagers = this.rigidBodyManagerMapByBodyName.values();
        for (RigidBodyControlManager bodyManager : bodyManagers) {
            if (bodyManager == null) continue;
            ret.addCommand(bodyManager.createFeedbackControlTemplate());
        }
        if (this.pelvisOrientationManager != null) {
            ret.addCommand(this.pelvisOrientationManager.createFeedbackControlTemplate());
        }
        return new FeedbackControllerTemplate(ret);
    }
}

