/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.ArrayList;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalVariable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.tools.saveableModule.YoSaveableModuleStateTools;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.YoTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class JumpingCoPTrajectoryGeneratorState
extends YoSaveableModuleState {
    private final YoDouble finalTransferDuration;
    private final YoFramePoint3D initialCoP;
    private final JumpingGoalVariable jumpingGoal;
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footPolygonsInSole = new SideDependentList();
    private final SideDependentList<FixedFramePose3DBasics> footPoses = new SideDependentList();
    private final SideDependentList<PoseReferenceFrame> soleContactFrames = new SideDependentList();

    public JumpingCoPTrajectoryGeneratorState(YoRegistry registry) {
        this.jumpingGoal = new JumpingGoalVariable("", registry);
        this.registerStateToSave(this.jumpingGoal);
        this.finalTransferDuration = new YoDouble("finalTransferDuration", registry);
        this.registerVariableToSave((YoVariable)this.finalTransferDuration);
        this.initialCoP = new YoFramePoint3D("initialCoP", ReferenceFrame.getWorldFrame(), registry);
        YoSaveableModuleStateTools.registerYoTuple3DToSave((YoTuple3D)this.initialCoP, (YoSaveableModuleState)this);
        for (RobotSide robotSide : RobotSide.values) {
            YoFramePose3D footPose = new YoFramePose3D(robotSide.getCamelCaseName() + "FootPose", ReferenceFrame.getWorldFrame(), registry);
            YoSaveableModuleStateTools.registerYoFramePose3DToSave((YoFramePose3D)footPose, (YoSaveableModuleState)this);
            this.footPoses.put((Enum)robotSide, (Object)footPose);
            PoseReferenceFrame soleFrame = new PoseReferenceFrame(robotSide.getCamelCaseName() + "SoleFrame", (FramePose3DReadOnly)footPose);
            this.soleContactFrames.put((Enum)robotSide, (Object)soleFrame);
            footPose.attachVariableChangedListener(v -> soleFrame.setPoseAndUpdate((FramePose3DReadOnly)footPose));
            ArrayList<YoFramePoint2D> vertexBuffer = new ArrayList<YoFramePoint2D>();
            String prefix = robotSide.getCamelCaseName() + "FootPolygonInSole";
            for (int i = 0; i < 6; ++i) {
                YoFramePoint2D vertex = new YoFramePoint2D(prefix + "_" + i, (ReferenceFrame)soleFrame, registry);
                YoSaveableModuleStateTools.registerYoTuple2DToSave((YoTuple2D)vertex, (YoSaveableModuleState)this);
                vertexBuffer.add(vertex);
            }
            YoInteger numberOfVertices = new YoInteger(prefix + "NumVertices", registry);
            this.registerVariableToSave((YoVariable)numberOfVertices);
            YoFrameConvexPolygon2D footPolygonInSole = new YoFrameConvexPolygon2D(vertexBuffer, numberOfVertices, (ReferenceFrame)soleFrame);
            footPolygonInSole.clearAndUpdate();
            this.footPolygonsInSole.put((Enum)robotSide, (Object)footPolygonInSole);
        }
    }

    public void initializeStance(SideDependentList<? extends FrameConvexPolygon2DReadOnly> feetInSoleZUpFrames, SideDependentList<? extends ReferenceFrame> soleFrames) {
        for (RobotSide robotSide : RobotSide.values) {
            this.initializeStance(robotSide, (FrameConvexPolygon2DReadOnly)feetInSoleZUpFrames.get((Enum)robotSide), (ReferenceFrame)soleFrames.get((Enum)robotSide));
        }
    }

    public void initializeStance(RobotSide robotSide, FrameConvexPolygon2DReadOnly supportPolygon, ReferenceFrame soleFrame) {
        ((FixedFramePose3DBasics)this.footPoses.get((Enum)robotSide)).setFromReferenceFrame(soleFrame);
        ((FixedFrameConvexPolygon2DBasics)this.footPolygonsInSole.get((Enum)robotSide)).setMatchingFrame((FrameVertex2DSupplier)supportPolygon, false);
    }

    public void setJumpingGoal(JumpingGoal jumpingGoal) {
        this.jumpingGoal.set(jumpingGoal);
    }

    public FramePoint3DReadOnly getInitialCoP() {
        return this.initialCoP;
    }

    public FramePose3DReadOnly getFootPose(RobotSide robotSide) {
        return (FramePose3DReadOnly)this.footPoses.get((Enum)robotSide);
    }

    public FrameConvexPolygon2DReadOnly getFootPolygonInSole(RobotSide robotSide) {
        return (FrameConvexPolygon2DReadOnly)this.footPolygonsInSole.get((Enum)robotSide);
    }

    public JumpingGoalVariable getJumpingGoal() {
        return this.jumpingGoal;
    }

    public double getFinalTransferDuration() {
        return this.finalTransferDuration.getDoubleValue();
    }

    public void setFinalTransferDuration(double transferDuration) {
        this.finalTransferDuration.set(transferDuration);
    }

    public void clear() {
        this.jumpingGoal.reset();
    }

    public void setInitialCoP(FramePoint3DReadOnly initialCoP) {
        this.initialCoP.set((FrameTuple3DReadOnly)initialCoP);
    }
}

