/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.saveableModule.YoSaveableModule;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JumpingCoPTrajectoryGenerator
extends YoSaveableModule<JumpingCoPTrajectoryGeneratorState> {
    private final CoPTrajectoryParameters parameters;
    private final JumpingCoPTrajectoryParameters jumpingParameters;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<ContactPlaneProvider> contactStateProviders = new RecyclingArrayList(ContactPlaneProvider::new);
    private final FramePoint3D tempFramePoint = new FramePoint3D();
    private final FramePoint3D footMidpoint = new FramePoint3D();
    private final FramePose3D midFootPose = new FramePose3D();
    private final FramePose3D midstancePose = new FramePose3D();
    private final PoseReferenceFrame midstanceFrame = new PoseReferenceFrame("midstanceFrame", worldFrame);
    private final ZUpFrame midstanceZUpFrame = new ZUpFrame(worldFrame, (ReferenceFrame)this.midstanceFrame, "midstanceZUpFrame");
    private final JumpingParameters regularParameters;
    private final ConvexPolygon2DReadOnly defaultSupportPolygon;
    private final FramePose3D goalPose = new FramePose3D();
    private final PoseReferenceFrame goalPoseFrame = new PoseReferenceFrame("goalPoseFrame", ReferenceFrame.getWorldFrame());
    private final SideDependentList<FramePose3D> footGoalPoses = new SideDependentList((Object)new FramePose3D(), (Object)new FramePose3D());

    public JumpingCoPTrajectoryGenerator(CoPTrajectoryParameters parameters, ConvexPolygon2DReadOnly defaultSupportPolygon, JumpingCoPTrajectoryParameters jumpingParameters, JumpingParameters regularParameters, YoRegistry parentRegistry) {
        super(JumpingCoPTrajectoryGenerator.class, parentRegistry);
        this.regularParameters = regularParameters;
        this.defaultSupportPolygon = defaultSupportPolygon;
        this.parameters = parameters;
        this.jumpingParameters = jumpingParameters;
        this.clear();
    }

    public void registerState(JumpingCoPTrajectoryGeneratorState state) {
        super.registerState((YoSaveableModuleState)state);
    }

    public void clear() {
        this.contactStateProviders.clear();
    }

    public void compute(JumpingCoPTrajectoryGeneratorState state) {
        this.clear();
        this.footMidpoint.setIncludingFrame((FrameTuple2DReadOnly)state.getFootPolygonInSole(RobotSide.LEFT).getCentroid(), 0.0);
        this.footMidpoint.changeFrame(worldFrame);
        this.tempFramePoint.setIncludingFrame((FrameTuple2DReadOnly)state.getFootPolygonInSole(RobotSide.RIGHT).getCentroid(), 0.0);
        this.tempFramePoint.changeFrame(worldFrame);
        this.footMidpoint.interpolate((FrameTuple3DReadOnly)this.tempFramePoint, 0.5);
        this.midstancePose.interpolate(state.getFootPose(RobotSide.LEFT), state.getFootPose(RobotSide.RIGHT), 0.5);
        this.midstanceFrame.setPoseAndUpdate((FramePose3DReadOnly)this.midstancePose);
        this.midstanceZUpFrame.update();
        ContactPlaneProvider contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartTime(0.0);
        contactState.setStartECMPPosition(state.getInitialCoP());
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact(state.getFootPose(robotSide), (ConvexPolygon2DReadOnly)state.getFootPolygonInSole(robotSide));
        }
        this.computeForSupport();
        this.computeForFlight();
        this.computeForFinalTransfer();
    }

    private void computeForSupport() {
        ContactPlaneProvider previousContactState = (ContactPlaneProvider)this.contactStateProviders.getLast();
        double supportDuration = ((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getSupportDuration();
        double segmentDuration = this.jumpingParameters.getFractionSupportForShift() * supportDuration;
        previousContactState.setEndECMPPosition((FramePoint3DReadOnly)this.footMidpoint);
        previousContactState.setDuration(segmentDuration);
        previousContactState.setLinearECMPVelocity();
        ContactPlaneProvider contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.footMidpoint);
        contactState.setDuration(supportDuration - segmentDuration);
        contactState.setLinearECMPVelocity();
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact(((JumpingCoPTrajectoryGeneratorState)this.state).getFootPose(robotSide), (ConvexPolygon2DReadOnly)((JumpingCoPTrajectoryGeneratorState)this.state).getFootPolygonInSole(robotSide));
        }
    }

    private void computeForFlight() {
        double flightDuration = ((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getFlightDuration();
        ContactPlaneProvider previousContactState = (ContactPlaneProvider)this.contactStateProviders.getLast();
        ContactPlaneProvider contactSate = (ContactPlaneProvider)this.contactStateProviders.add();
        contactSate.setStartTime(previousContactState.getTimeInterval().getEndTime());
        contactSate.setDuration(flightDuration);
        contactSate.setContactState(ContactState.FLIGHT);
    }

    private void computeForFinalTransfer() {
        ContactPlaneProvider previousContactState = (ContactPlaneProvider)this.contactStateProviders.getLast();
        ContactPlaneProvider contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        double goalLength = ((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalLength();
        goalLength = Double.isNaN(goalLength) ? 0.0 : goalLength;
        this.midFootPose.setToZero((ReferenceFrame)this.midstanceZUpFrame);
        this.goalPose.setIncludingFrame((FramePose3DReadOnly)this.midFootPose);
        this.goalPose.setX(goalLength);
        if (!Double.isNaN(((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalHeight())) {
            this.goalPose.setZ(((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalHeight());
        }
        if (!Double.isNaN(((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalRotation())) {
            this.goalPose.getOrientation().setToYawOrientation(((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalRotation());
        }
        this.goalPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.goalPoseFrame.setPoseAndUpdate((FramePose3DReadOnly)this.goalPose);
        for (RobotSide robotSide : RobotSide.values) {
            FramePose3D footGoalPose = (FramePose3D)this.footGoalPoses.get((Enum)robotSide);
            footGoalPose.setToZero((ReferenceFrame)this.goalPoseFrame);
            double width = !Double.isNaN(((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalFootWidth()) ? 0.5 * ((JumpingCoPTrajectoryGeneratorState)this.state).getJumpingGoal().getGoalFootWidth() : 0.5 * this.regularParameters.getDefaultFootWidth();
            width = robotSide.negateIfRightSide(width);
            footGoalPose.setY(width);
            footGoalPose.changeFrame(worldFrame);
        }
        double segmentDuration = this.parameters.getDefaultFinalTransferSplitFraction() * ((JumpingCoPTrajectoryGeneratorState)this.state).getFinalTransferDuration();
        contactState.reset();
        contactState.setStartECMPPosition((FramePoint3DReadOnly)this.goalPose.getPosition());
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.goalPose.getPosition());
        contactState.setStartTime(previousContactState.getTimeInterval().getEndTime());
        contactState.setDuration(segmentDuration);
        contactState.setLinearECMPVelocity();
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact((FramePose3DReadOnly)this.footGoalPoses.get((Enum)robotSide), this.defaultSupportPolygon);
        }
        previousContactState = contactState;
        segmentDuration = ((JumpingCoPTrajectoryGeneratorState)this.state).getFinalTransferDuration() - segmentDuration;
        contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.goalPose.getPosition());
        contactState.setDuration(segmentDuration);
        contactState.setLinearECMPVelocity();
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact((FramePose3DReadOnly)this.footGoalPoses.get((Enum)robotSide), this.defaultSupportPolygon);
        }
        previousContactState = contactState;
        contactState = (ContactPlaneProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition(previousContactState.getECMPStartPosition());
        contactState.setDuration(Double.POSITIVE_INFINITY);
        contactState.setLinearECMPVelocity();
        for (RobotSide robotSide : RobotSide.values) {
            contactState.addContact((FramePose3DReadOnly)this.footGoalPoses.get((Enum)robotSide), this.defaultSupportPolygon);
        }
    }

    public RecyclingArrayList<ContactPlaneProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }
}

