/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleOutput;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.JointLoadStatusProvider;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.LegElasticityDebuggator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.ParameterizedControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.TouchdownErrorCompensator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.WalkingCommandConsumer;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.DoubSuppToSingSuppCond4DistRecov;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.SingleSupportToTransferToCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.StartFlamingoCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.StartWalkingCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.StopFlamingoCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.StopWalkingFromSingleSupportCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.stateTransitionConditions.StopWalkingFromTransferCondition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.FlamingoStanceState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.SingleSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.StandingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.TransferState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.TransferToFlamingoStanceState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.TransferToStandingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.TransferToWalkingSingleSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingSingleSupportState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitEnforcement;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.ScrewTools;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingHighLevelHumanoidController
implements JointLoadStatusProvider {
    private static final boolean ENABLE_LEG_ELASTICITY_DEBUGGATOR = false;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoDouble yoTime;
    private final HighLevelControlManagerFactory managerFactory;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final FeetManager feetManager;
    private final LegConfigurationManager legConfigurationManager;
    private final BalanceManager balanceManager;
    private final CenterOfMassHeightManager comHeightManager;
    private final TouchdownErrorCompensator touchdownErrorCompensator;
    private final ArrayList<RigidBodyControlManager> bodyManagers = new ArrayList();
    private final Map<String, RigidBodyControlManager> bodyManagerByJointName = new HashMap<String, RigidBodyControlManager>();
    private final SideDependentList<Set<String>> legJointNames = new SideDependentList();
    private final OneDoFJointBasics[] allOneDoFjoints;
    private final FullHumanoidRobotModel fullRobotModel;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WalkingControllerParameters walkingControllerParameters;
    private final SideDependentList<? extends ContactablePlaneBody> feet;
    private final StateMachine<WalkingStateEnum, WalkingState> stateMachine;
    private final WalkingMessageHandler walkingMessageHandler;
    private final YoBoolean abortWalkingRequested = new YoBoolean("requestAbortWalking", this.registry);
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final YoBoolean enablePushRecoveryOnFailure = new YoBoolean("enablePushRecoveryOnFailure", this.registry);
    private final YoBoolean allowUpperBodyMotionDuringLocomotion = new YoBoolean("allowUpperBodyMotionDuringLocomotion", this.registry);
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final WalkingCommandConsumer commandConsumer;
    private final TaskspaceTrajectoryStatusMessage pelvisStatusMessage = new TaskspaceTrajectoryStatusMessage();
    private final JointLimitEnforcementMethodCommand jointLimitEnforcementMethodCommand = new JointLimitEnforcementMethodCommand();
    private final YoBoolean limitCommandSent = new YoBoolean("limitCommandSent", this.registry);
    private final LegElasticityDebuggator legElasticityDebuggator;
    private final PrivilegedConfigurationCommand privilegedConfigurationCommand = new PrivilegedConfigurationCommand();
    private final ControllerCoreCommand controllerCoreCommand = new ControllerCoreCommand(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
    private ControllerCoreOutputReadOnly controllerCoreOutput;
    private final DoubleProvider unloadFraction;
    private final ParameterizedControllerCoreOptimizationSettings controllerCoreOptimizationSettings;
    private final YoBoolean enableHeightFeedbackControl = new YoBoolean("enableHeightFeedbackControl", this.registry);
    private boolean firstTick = true;
    private final FrameVector2D desiredCoMVelocityAsFrameVector = new FrameVector2D();
    private final SideDependentList<FramePoint2D> footDesiredCoPs = new SideDependentList((Object)new FramePoint2D(), (Object)new FramePoint2D());
    private final RecyclingArrayList<PlaneContactStateCommand> planeContactStateCommandPool = new RecyclingArrayList(4, PlaneContactStateCommand.class);
    private final FramePoint2D capturePoint2d = new FramePoint2D();

    public WalkingHighLevelHumanoidController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, HighLevelControlManagerFactory managerFactory, WalkingControllerParameters walkingControllerParameters, HighLevelHumanoidControllerToolbox controllerToolbox) {
        OneDoFJointBasics[] jointsWithRestrictiveLimit;
        this.managerFactory = managerFactory;
        this.controllerToolbox = controllerToolbox;
        this.fullRobotModel = controllerToolbox.getFullRobotModel();
        this.yoTime = controllerToolbox.getYoTime();
        this.feet = controllerToolbox.getContactableFeet();
        this.allOneDoFjoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])controllerToolbox.getControlledJoints(), OneDoFJointBasics.class);
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        RigidBodyBasics head = this.fullRobotModel.getHead();
        RigidBodyBasics chest = this.fullRobotModel.getChest();
        RigidBodyBasics pelvis = this.fullRobotModel.getPelvis();
        this.pelvisStatusMessage.setEndEffectorName(pelvis.getName());
        this.unloadFraction = walkingControllerParameters.enforceSmoothFootUnloading() ? new DoubleParameter("unloadFraction", this.registry, 0.5) : null;
        ReferenceFrame pelvisZUpFrame = controllerToolbox.getPelvisZUpFrame();
        MovingReferenceFrame chestBodyFrame = null;
        if (chest != null) {
            chestBodyFrame = chest.getBodyFixedFrame();
            RigidBodyControlManager chestManager = managerFactory.getOrCreateRigidBodyManager(chest, pelvis, (ReferenceFrame)chestBodyFrame, pelvisZUpFrame);
            this.bodyManagers.add(chestManager);
        }
        if (head != null) {
            MovingReferenceFrame headBodyFrame = head.getBodyFixedFrame();
            RigidBodyControlManager headManager = managerFactory.getOrCreateRigidBodyManager(head, chest, (ReferenceFrame)headBodyFrame, (ReferenceFrame)chestBodyFrame);
            this.bodyManagers.add(headManager);
        }
        for (MovingReferenceFrame movingReferenceFrame : RobotSide.values) {
            RigidBodyBasics hand = this.fullRobotModel.getHand((RobotSide)movingReferenceFrame);
            MovingReferenceFrame handControlFrame = this.fullRobotModel.getHandControlFrame((RobotSide)movingReferenceFrame);
            RigidBodyBasics handBaseBody = chest != null ? chest : pelvis;
            OneDoFJointBasics[] handManager = managerFactory.getOrCreateRigidBodyManager(hand, handBaseBody, (ReferenceFrame)handControlFrame, (ReferenceFrame)chestBodyFrame);
            this.bodyManagers.add((RigidBodyControlManager)handManager);
        }
        for (RigidBodyControlManager manager : this.bodyManagers) {
            if (manager == null) continue;
            Arrays.asList(manager.getControlledJoints()).stream().forEach(joint -> this.bodyManagerByJointName.put(joint.getName(), manager));
        }
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.fullRobotModel.getFoot((Enum)robotSide);
            OneDoFJointBasics[] legJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)pelvis, (RigidBodyBasics)foot), OneDoFJointBasics.class);
            HashSet jointNames = new HashSet();
            Arrays.asList(legJoints).stream().forEach(legJoint -> jointNames.add(legJoint.getName()));
            this.legJointNames.put((Enum)robotSide, jointNames);
        }
        this.walkingControllerParameters = walkingControllerParameters;
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.allowUpperBodyMotionDuringLocomotion.set(walkingControllerParameters.allowUpperBodyMotionDuringLocomotion());
        this.enableHeightFeedbackControl.set(walkingControllerParameters.enableHeightFeedbackControl());
        this.failureDetectionControlModule = new WalkingFailureDetectionControlModule(controllerToolbox.getContactableFeet(), this.registry);
        this.walkingMessageHandler = controllerToolbox.getWalkingMessageHandler();
        this.commandConsumer = new WalkingCommandConsumer(commandInputManager, statusOutputManager, controllerToolbox, managerFactory, walkingControllerParameters, this.registry);
        this.touchdownErrorCompensator = new TouchdownErrorCompensator(this.walkingMessageHandler, (SideDependentList<MovingReferenceFrame>)controllerToolbox.getReferenceFrames().getSoleFrames(), this.registry);
        this.stateMachine = this.setupStateMachine();
        double highCoPDampingDuration = walkingControllerParameters.getHighCoPDampingDurationToPreventFootShakies();
        double coPErrorThreshold = walkingControllerParameters.getCoPErrorThresholdForHighCoPDamping();
        boolean enableHighCoPDamping = highCoPDampingDuration > 0.0 && !Double.isInfinite(coPErrorThreshold);
        controllerToolbox.setHighCoPDampingParameters(enableHighCoPDamping, highCoPDampingDuration, coPErrorThreshold);
        String[] jointNamesRestrictiveLimits = walkingControllerParameters.getJointsWithRestrictiveLimits();
        for (OneDoFJointBasics joint2 : jointsWithRestrictiveLimit = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])ScrewTools.findJointsWithNames((JointBasics[])this.allOneDoFjoints, (String[])jointNamesRestrictiveLimits), OneDoFJointBasics.class)) {
            JointLimitParameters limitParameters = walkingControllerParameters.getJointLimitParametersForJointsWithRestrictiveLimits(joint2.getName());
            if (limitParameters == null) {
                throw new RuntimeException("Must define joint limit parameters for joint " + joint2.getName() + " if using joints with restrictive limits.");
            }
            this.jointLimitEnforcementMethodCommand.addLimitEnforcementMethod(joint2, JointLimitEnforcement.RESTRICTIVE, limitParameters);
        }
        this.legElasticityDebuggator = null;
        MomentumOptimizationSettings defaultControllerCoreOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        this.controllerCoreOptimizationSettings = new ParameterizedControllerCoreOptimizationSettings(defaultControllerCoreOptimizationSettings, this.registry);
    }

    private StateMachine<WalkingStateEnum, WalkingState> setupStateMachine() {
        WalkingStateEnum singleSupportStateEnum;
        WalkingStateEnum transferStateEnum;
        WalkingState singleSupportState;
        WalkingState transferState;
        StateMachineFactory factory = new StateMachineFactory(WalkingStateEnum.class);
        factory.setNamePrefix("walking").setRegistry(this.registry).buildYoClock((DoubleProvider)this.yoTime);
        StandingState standingState = new StandingState(this.commandInputManager, this.walkingMessageHandler, this.touchdownErrorCompensator, this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.walkingControllerParameters, this.registry);
        TransferToStandingState toStandingState = new TransferToStandingState(this.walkingMessageHandler, this.touchdownErrorCompensator, this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.registry);
        factory.addState((Enum)WalkingStateEnum.TO_STANDING, (State)toStandingState);
        factory.addState((Enum)WalkingStateEnum.STANDING, (State)standingState);
        SideDependentList walkingTransferStates = new SideDependentList();
        DoubleParameter minimumTransferTime = new DoubleParameter("MinimumTransferTime", this.registry, this.walkingControllerParameters.getMinimumTransferTime());
        DoubleProvider rhoMin = () -> this.controllerCoreOptimizationSettings.getRhoMin();
        for (RobotSide transferToSide : RobotSide.values) {
            WalkingStateEnum stateEnum = WalkingStateEnum.getWalkingTransferState(transferToSide);
            TransferToWalkingSingleSupportState transferState2 = new TransferToWalkingSingleSupportState(stateEnum, this.walkingMessageHandler, this.touchdownErrorCompensator, this.controllerToolbox, this.managerFactory, this.walkingControllerParameters, this.failureDetectionControlModule, (DoubleProvider)minimumTransferTime, this.unloadFraction, rhoMin, this.registry);
            walkingTransferStates.put((Enum)transferToSide, (Object)transferState2);
            factory.addState((Enum)stateEnum, (State)transferState2);
        }
        SideDependentList walkingSingleSupportStates = new SideDependentList();
        for (RobotSide supportSide : RobotSide.values) {
            WalkingStateEnum stateEnum = WalkingStateEnum.getWalkingSingleSupportState(supportSide);
            WalkingSingleSupportState singleSupportState2 = new WalkingSingleSupportState(stateEnum, this.walkingMessageHandler, this.touchdownErrorCompensator, this.controllerToolbox, this.managerFactory, this.walkingControllerParameters, this.failureDetectionControlModule, this.registry);
            walkingSingleSupportStates.put((Enum)supportSide, (Object)singleSupportState2);
            factory.addState((Enum)stateEnum, (State)singleSupportState2);
        }
        SideDependentList flamingoTransferStates = new SideDependentList();
        for (RobotSide transferToSide : RobotSide.values) {
            WalkingStateEnum stateEnum = WalkingStateEnum.getFlamingoTransferState(transferToSide);
            transferState = new TransferToFlamingoStanceState(stateEnum, this.walkingMessageHandler, this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, null, rhoMin, this.registry);
            flamingoTransferStates.put((Enum)transferToSide, (Object)transferState);
            factory.addState((Enum)stateEnum, (State)transferState);
        }
        SideDependentList flamingoSingleSupportStates = new SideDependentList();
        for (RobotSide supportSide : RobotSide.values) {
            WalkingStateEnum stateEnum = WalkingStateEnum.getFlamingoSingleSupportState(supportSide);
            singleSupportState = new FlamingoStanceState(stateEnum, this.walkingMessageHandler, this.controllerToolbox, this.managerFactory, this.failureDetectionControlModule, this.registry);
            flamingoSingleSupportStates.put((Enum)supportSide, (Object)singleSupportState);
            factory.addState((Enum)stateEnum, (State)singleSupportState);
        }
        factory.addDoneTransition((Enum)WalkingStateEnum.TO_STANDING, (Enum)WalkingStateEnum.STANDING);
        for (RobotSide robotSide : RobotSide.values) {
            transferState = (TransferToWalkingSingleSupportState)walkingTransferStates.get((Enum)robotSide);
            singleSupportState = (SingleSupportState)walkingSingleSupportStates.get((Enum)robotSide);
            transferStateEnum = transferState.getStateEnum();
            singleSupportStateEnum = singleSupportState.getStateEnum();
            factory.addTransition(Arrays.asList(WalkingStateEnum.STANDING, WalkingStateEnum.TO_STANDING), (Enum)transferStateEnum, (StateTransitionCondition)new StartWalkingCondition(transferStateEnum.getTransferToSide(), this.walkingMessageHandler));
            factory.addTransition((Enum)transferStateEnum, (Enum)WalkingStateEnum.TO_STANDING, (StateTransitionCondition)new StopWalkingFromTransferCondition((TransferState)transferState, this.walkingMessageHandler));
            factory.addTransition((Enum)singleSupportStateEnum, (Enum)WalkingStateEnum.TO_STANDING, (StateTransitionCondition)new StopWalkingFromSingleSupportCondition((SingleSupportState)singleSupportState, this.walkingMessageHandler));
        }
        for (RobotSide robotSide : RobotSide.values) {
            transferState = (WalkingState)walkingTransferStates.get((Enum)robotSide);
            singleSupportState = (WalkingState)walkingSingleSupportStates.get((Enum)robotSide);
            transferStateEnum = transferState.getStateEnum();
            singleSupportStateEnum = singleSupportState.getStateEnum();
            factory.addDoneTransition((Enum)transferStateEnum, (Enum)singleSupportStateEnum);
        }
        for (RobotSide robotSide : RobotSide.values) {
            SingleSupportState singleSupportState3 = (SingleSupportState)walkingSingleSupportStates.get((Enum)robotSide);
            WalkingStateEnum singleSupportStateEnum2 = singleSupportState3.getStateEnum();
            TransferToWalkingSingleSupportState transferState3 = (TransferToWalkingSingleSupportState)walkingTransferStates.get((Enum)robotSide);
            WalkingStateEnum transferStateEnum2 = transferState3.getStateEnum();
            factory.addTransition((Enum)singleSupportStateEnum2, (Enum)transferStateEnum2, (StateTransitionCondition)new SingleSupportToTransferToCondition(singleSupportState3, transferState3, this.walkingMessageHandler));
            transferState3 = (TransferToWalkingSingleSupportState)walkingTransferStates.get((Enum)robotSide.getOppositeSide());
            transferStateEnum2 = transferState3.getStateEnum();
            factory.addTransition((Enum)singleSupportStateEnum2, (Enum)transferStateEnum2, (StateTransitionCondition)new SingleSupportToTransferToCondition(singleSupportState3, transferState3, this.walkingMessageHandler));
        }
        for (RobotSide robotSide : RobotSide.values) {
            transferState = (TransferToFlamingoStanceState)flamingoTransferStates.get((Enum)robotSide);
            singleSupportState = (FlamingoStanceState)flamingoSingleSupportStates.get((Enum)robotSide);
            transferStateEnum = transferState.getStateEnum();
            singleSupportStateEnum = singleSupportState.getStateEnum();
            factory.addTransition(Arrays.asList(WalkingStateEnum.STANDING, WalkingStateEnum.TO_STANDING), (Enum)transferStateEnum, (StateTransitionCondition)new StartFlamingoCondition(((TransferState)transferState).getTransferToSide(), this.walkingMessageHandler));
            factory.addTransition((Enum)singleSupportStateEnum, (Enum)WalkingStateEnum.TO_STANDING, (StateTransitionCondition)new StopFlamingoCondition((FlamingoStanceState)singleSupportState, this.walkingMessageHandler));
        }
        for (RobotSide robotSide : RobotSide.values) {
            transferState = (TransferToFlamingoStanceState)flamingoTransferStates.get((Enum)robotSide);
            singleSupportState = (FlamingoStanceState)flamingoSingleSupportStates.get((Enum)robotSide);
            transferStateEnum = transferState.getStateEnum();
            singleSupportStateEnum = singleSupportState.getStateEnum();
            factory.addDoneTransition((Enum)transferStateEnum, (Enum)singleSupportStateEnum);
        }
        EnumSet<WalkingStateEnum> allButStandingStates = EnumSet.complementOf(EnumSet.of(WalkingStateEnum.STANDING, WalkingStateEnum.TO_STANDING));
        factory.addTransition(allButStandingStates, (Enum)WalkingStateEnum.TO_STANDING, (StateTransitionCondition)new AbortCondition());
        Set allDoubleSupportStates = Stream.of(WalkingStateEnum.values).filter(state -> state.isDoubleSupport()).collect(Collectors.toSet());
        for (RobotSide robotSide : RobotSide.values) {
            WalkingStateEnum singleSupportStateEnum3 = WalkingStateEnum.getWalkingSingleSupportState(robotSide);
            RobotSide swingSide = singleSupportStateEnum3.getSupportSide().getOppositeSide();
            factory.addTransition(allDoubleSupportStates, (Enum)singleSupportStateEnum3, (StateTransitionCondition)new DoubSuppToSingSuppCond4DistRecov(swingSide, this.balanceManager));
        }
        factory.getRegisteredStates().forEach(state -> factory.addStateChangedListener((from, to) -> state.setPreviousWalkingStateEnum((WalkingStateEnum)((Object)((Object)from)))));
        factory.addStateChangedListener((from, to) -> this.controllerToolbox.reportControllerStateChangeToListeners((Enum<?>)from, (Enum<?>)to));
        return factory.build((Enum)WalkingStateEnum.TO_STANDING);
    }

    public void setControllerCoreOutput(ControllerCoreOutputReadOnly controllerCoreOutput) {
        this.controllerCoreOutput = controllerCoreOutput;
    }

    public void setLinearMomentumRateControlModuleOutput(LinearMomentumRateControlModuleOutput output) {
        this.balanceManager.setLinearMomentumRateControlModuleOutput(output);
    }

    public void initialize() {
        this.controllerCoreCommand.requestReinitialization();
        this.controllerToolbox.initialize();
        this.managerFactory.initializeManagers();
        this.commandInputManager.clearAllCommands();
        this.walkingMessageHandler.clearFootsteps();
        this.walkingMessageHandler.clearFootTrajectory();
        this.privilegedConfigurationCommand.clear();
        this.privilegedConfigurationCommand.setPrivilegedConfigurationOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_ZERO);
        for (RobotSide robotSide : RobotSide.values) {
            ArmJointName[] armJointNames = this.fullRobotModel.getRobotSpecificJointNames().getArmJointNames();
            for (int i = 0; i < armJointNames.length; ++i) {
                this.privilegedConfigurationCommand.addJoint(this.fullRobotModel.getArmJoint(robotSide, armJointNames[i]), PrivilegedConfigurationCommand.PrivilegedConfigurationOption.AT_MID_RANGE);
            }
        }
        this.initializeContacts();
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePoint2D)this.footDesiredCoPs.get((Enum)robotSide)).setToZero(((ContactablePlaneBody)this.feet.get((Enum)robotSide)).getSoleFrame());
            this.controllerToolbox.setDesiredCenterOfPressure((ContactablePlaneBody)this.feet.get((Enum)robotSide), (FramePoint2DReadOnly)this.footDesiredCoPs.get((Enum)robotSide));
        }
        this.stateMachine.resetToInitialState();
        this.initializeManagers();
        this.commandConsumer.avoidManipulationAbortForDuration(2.0);
        this.firstTick = true;
    }

    private void initializeManagers() {
        this.balanceManager.disablePelvisXYControl();
        double stepTime = this.walkingMessageHandler.getDefaultStepTime();
        this.pelvisOrientationManager.setTrajectoryTime(stepTime);
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            bodyManager.initialize();
        }
        this.pelvisOrientationManager.initialize();
        this.feetManager.initialize();
        this.comHeightManager.initialize();
        this.feetManager.resetHeightCorrectionParametersForSingularityAvoidance();
    }

    public void requestImmediateTransitionToStandingAndHoldCurrent() {
        this.stateMachine.performTransition((Enum)WalkingStateEnum.STANDING);
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            bodyManager.hold();
        }
        this.pelvisOrientationManager.setToHoldCurrentInWorldFrame();
        this.comHeightManager.initializeDesiredHeightToCurrent();
        this.balanceManager.requestICPPlannerToHoldCurrentCoM();
    }

    private void initializeContacts() {
        this.controllerToolbox.clearContacts();
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerToolbox.resetFootPlaneContactPoint(robotSide);
            this.feetManager.setFlatFootContactState(robotSide);
        }
    }

    public void doAction() {
        WalkingState currentState = (WalkingState)this.stateMachine.getCurrentState();
        this.commandConsumer.update();
        this.commandConsumer.consumeHeadCommands();
        this.commandConsumer.consumeChestCommands();
        this.commandConsumer.consumePelvisHeightCommands();
        this.commandConsumer.consumeGoHomeMessages();
        this.commandConsumer.consumeFootLoadBearingCommands(currentState);
        this.commandConsumer.consumeStopAllTrajectoryCommands();
        this.commandConsumer.consumeFootCommands();
        this.commandConsumer.consumeAbortWalkingCommands(this.abortWalkingRequested);
        this.commandConsumer.consumePelvisCommands(currentState, this.allowUpperBodyMotionDuringLocomotion.getBooleanValue());
        this.commandConsumer.consumeManipulationCommands(currentState, this.allowUpperBodyMotionDuringLocomotion.getBooleanValue());
        this.commandConsumer.handleAutomaticManipulationAbortOnICPError(currentState);
        this.commandConsumer.consumeLoadBearingCommands();
        this.commandConsumer.consumePlanarRegionsListCommand();
        this.commandConsumer.consumePlanarRegionStepConstraintCommand();
        this.commandConsumer.consumePrepareForLocomotionCommands();
        this.updateFailureDetection();
        if (!this.firstTick) {
            this.stateMachine.doTransitions();
        }
        this.stateMachine.doAction();
        currentState = (WalkingState)this.stateMachine.getCurrentState();
        this.updateManagers(currentState);
        this.reportStatusMessages();
        this.handleChangeInContactState();
        this.submitControllerCoreCommands();
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerCoreOutput.getDesiredCenterOfPressure((FramePoint2DBasics)this.footDesiredCoPs.get((Enum)robotSide), ((ContactablePlaneBody)this.feet.get((Enum)robotSide)).getRigidBody());
            if (((FramePoint2D)this.footDesiredCoPs.get((Enum)robotSide)).getReferenceFrame() != ((ContactablePlaneBody)this.feet.get((Enum)robotSide)).getSoleFrame()) {
                ((FramePoint2D)this.footDesiredCoPs.get((Enum)robotSide)).setToZero(((ContactablePlaneBody)this.feet.get((Enum)robotSide)).getSoleFrame());
            }
            this.controllerToolbox.setDesiredCenterOfPressure((ContactablePlaneBody)this.feet.get((Enum)robotSide), (FramePoint2DReadOnly)this.footDesiredCoPs.get((Enum)robotSide));
            this.controllerToolbox.getFootContactState(robotSide).pollContactHasChangedNotification();
        }
        this.statusOutputManager.reportStatusMessage((Object)this.balanceManager.updateAndReturnCapturabilityBasedStatus());
        this.firstTick = false;
    }

    private void handleChangeInContactState() {
        boolean haveContactStatesChanged = false;
        for (RobotSide robotSide : RobotSide.values) {
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(robotSide);
            if (!contactState.peekContactHasChangedNotification()) continue;
            haveContactStatesChanged = true;
        }
        if (!haveContactStatesChanged) {
            return;
        }
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.computeICPPlan();
    }

    public void updateFailureDetection() {
        this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getCapturePoint());
        this.failureDetectionControlModule.checkIfRobotIsFalling((FramePoint2DReadOnly)this.capturePoint2d, this.balanceManager.getDesiredICP());
        if (this.failureDetectionControlModule.isRobotFalling()) {
            this.walkingMessageHandler.clearFootsteps();
            this.walkingMessageHandler.clearFootTrajectory();
            this.commandInputManager.clearAllCommands();
            if (this.enablePushRecoveryOnFailure.getBooleanValue() && !this.balanceManager.isPushRecoveryEnabled()) {
                this.balanceManager.enablePushRecovery();
            } else if (!this.balanceManager.isPushRecoveryEnabled() || this.balanceManager.isRecoveryImpossible()) {
                this.walkingMessageHandler.reportControllerFailure(this.failureDetectionControlModule.getFallingDirection3D());
                this.controllerToolbox.reportControllerFailureToListeners(this.failureDetectionControlModule.getFallingDirection2D());
            }
        }
        if (this.enablePushRecoveryOnFailure.getBooleanValue() && this.balanceManager.isPushRecoveryEnabled() && this.balanceManager.isRobotBackToSafeState()) {
            this.balanceManager.disablePushRecovery();
        }
    }

    public void updateManagers(WalkingState currentState) {
        boolean keepCMPInsideSupportPolygon;
        this.desiredCoMVelocityAsFrameVector.setIncludingFrame((FrameTuple3DReadOnly)this.balanceManager.getDesiredCoMVelocity());
        boolean isInDoubleSupport = currentState.isDoubleSupportState();
        double omega0 = this.controllerToolbox.getOmega0();
        boolean isRecoveringFromPush = this.balanceManager.isRecovering();
        this.feetManager.compute();
        this.legConfigurationManager.compute();
        boolean bodyManagerIsLoadBearing = false;
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            bodyManager.compute();
            if (!bodyManager.isLoadBearing()) continue;
            bodyManagerIsLoadBearing = true;
        }
        this.pelvisOrientationManager.compute();
        this.comHeightManager.compute(this.balanceManager.getDesiredICPVelocity(), (FrameVector2DReadOnly)this.desiredCoMVelocityAsFrameVector, isInDoubleSupport, omega0, isRecoveringFromPush, this.feetManager);
        FeedbackControlCommand<?> heightControlCommand = this.comHeightManager.getHeightControlCommand();
        boolean controlHeightWithMomentum = this.comHeightManager.getControlHeightWithMomentum() && this.enableHeightFeedbackControl.getValue();
        boolean bl = keepCMPInsideSupportPolygon = !bodyManagerIsLoadBearing;
        if (currentState.isDoubleSupportState()) {
            this.balanceManager.compute(currentState.getTransferToSide(), heightControlCommand, keepCMPInsideSupportPolygon, controlHeightWithMomentum);
        } else {
            this.balanceManager.compute(currentState.getSupportSide(), heightControlCommand, keepCMPInsideSupportPolygon, controlHeightWithMomentum);
        }
    }

    private void reportStatusMessages() {
        TaskspaceTrajectoryStatusMessage pelvisHeightStatus;
        TaskspaceTrajectoryStatusMessage pelvisXYStatus;
        Object statusMessage;
        for (RobotSide robotSide : RobotSide.values) {
            statusMessage = this.feetManager.pollStatusToReport(robotSide);
            if (statusMessage == null) continue;
            this.statusOutputManager.reportStatusMessage(statusMessage);
        }
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null || (statusMessage = bodyManager.pollStatusToReport()) == null) continue;
            this.statusOutputManager.reportStatusMessage(statusMessage);
        }
        TaskspaceTrajectoryStatusMessage pelvisOrientationStatus = this.pelvisOrientationManager.pollStatusToReport();
        TaskspaceTrajectoryStatusMessage mergedPelvisStatus = this.mergePelvisStatusMessages(pelvisOrientationStatus, pelvisXYStatus = this.balanceManager.pollPelvisXYTranslationStatusToReport(), pelvisHeightStatus = this.comHeightManager.pollStatusToReport());
        if (mergedPelvisStatus != null) {
            this.statusOutputManager.reportStatusMessage((Object)mergedPelvisStatus);
        }
    }

    private TaskspaceTrajectoryStatusMessage mergePelvisStatusMessages(TaskspaceTrajectoryStatusMessage pelvisOrientationStatus, TaskspaceTrajectoryStatusMessage pelvisXYStatus, TaskspaceTrajectoryStatusMessage pelvisHeightStatus) {
        int numberOfStatus = pelvisOrientationStatus != null ? 1 : 0;
        numberOfStatus += pelvisXYStatus != null ? 1 : 0;
        if ((numberOfStatus += pelvisHeightStatus != null ? 1 : 0) <= 1) {
            if (pelvisOrientationStatus != null) {
                return pelvisOrientationStatus;
            }
            if (pelvisXYStatus != null) {
                return pelvisXYStatus;
            }
            if (pelvisHeightStatus != null) {
                return pelvisHeightStatus;
            }
            return null;
        }
        Quaternion desiredEndEffectorOrientation = this.pelvisStatusMessage.getDesiredEndEffectorOrientation();
        Point3D desiredEndEffectorPosition = this.pelvisStatusMessage.getDesiredEndEffectorPosition();
        Quaternion actualEndEffectorOrientation = this.pelvisStatusMessage.getActualEndEffectorOrientation();
        Point3D actualEndEffectorPosition = this.pelvisStatusMessage.getActualEndEffectorPosition();
        desiredEndEffectorOrientation.setToNaN();
        desiredEndEffectorPosition.setToNaN();
        actualEndEffectorOrientation.setToNaN();
        actualEndEffectorPosition.setToNaN();
        if (pelvisOrientationStatus != null) {
            this.pelvisStatusMessage.setSequenceId(pelvisOrientationStatus.getSequenceId());
            this.pelvisStatusMessage.setTimestamp(pelvisOrientationStatus.getTimestamp());
            this.pelvisStatusMessage.setTrajectoryExecutionStatus(pelvisOrientationStatus.getTrajectoryExecutionStatus());
            desiredEndEffectorOrientation.set(pelvisOrientationStatus.getDesiredEndEffectorOrientation());
            actualEndEffectorOrientation.set(pelvisOrientationStatus.getActualEndEffectorOrientation());
        }
        if (pelvisXYStatus != null) {
            this.pelvisStatusMessage.setSequenceId(pelvisXYStatus.getSequenceId());
            this.pelvisStatusMessage.setTimestamp(pelvisXYStatus.getTimestamp());
            this.pelvisStatusMessage.setTrajectoryExecutionStatus(pelvisXYStatus.getTrajectoryExecutionStatus());
            desiredEndEffectorPosition.set(pelvisXYStatus.getDesiredEndEffectorPosition());
            actualEndEffectorPosition.set(pelvisXYStatus.getActualEndEffectorPosition());
        }
        if (pelvisHeightStatus != null) {
            this.pelvisStatusMessage.setSequenceId(pelvisHeightStatus.getSequenceId());
            this.pelvisStatusMessage.setTimestamp(pelvisHeightStatus.getTimestamp());
            this.pelvisStatusMessage.setTrajectoryExecutionStatus(pelvisHeightStatus.getTrajectoryExecutionStatus());
            desiredEndEffectorPosition.setZ(pelvisHeightStatus.getDesiredEndEffectorPosition().getZ());
            actualEndEffectorPosition.setZ(pelvisHeightStatus.getActualEndEffectorPosition().getZ());
        }
        return this.pelvisStatusMessage;
    }

    private void submitControllerCoreCommands() {
        this.planeContactStateCommandPool.clear();
        this.controllerCoreCommand.addInverseDynamicsCommand(this.privilegedConfigurationCommand);
        if (!this.limitCommandSent.getBooleanValue()) {
            this.controllerCoreCommand.addInverseDynamicsCommand(this.jointLimitEnforcementMethodCommand);
            this.limitCommandSent.set(true);
        }
        boolean isHighCoPDampingNeeded = this.controllerToolbox.estimateIfHighCoPDampingNeeded(this.footDesiredCoPs);
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerCoreCommand.addFeedbackControlCommand(this.feetManager.getFeedbackControlCommand(robotSide));
            this.controllerCoreCommand.addInverseDynamicsCommand(this.feetManager.getInverseDynamicsCommand(robotSide));
            this.controllerCoreCommand.completeLowLevelJointData(this.feetManager.getJointDesiredData(robotSide));
            this.controllerCoreCommand.addFeedbackControlCommand(this.legConfigurationManager.getFeedbackControlCommand(robotSide));
            this.controllerCoreCommand.addInverseDynamicsCommand(this.legConfigurationManager.getInverseDynamicsCommand(robotSide));
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(robotSide);
            PlaneContactStateCommand planeContactStateCommand = (PlaneContactStateCommand)this.planeContactStateCommandPool.add();
            contactState.getPlaneContactStateCommand(planeContactStateCommand);
            planeContactStateCommand.setUseHighCoPDamping(isHighCoPDampingNeeded);
            this.controllerCoreCommand.addInverseDynamicsCommand(planeContactStateCommand);
        }
        for (int managerIdx = 0; managerIdx < this.bodyManagers.size(); ++managerIdx) {
            RigidBodyControlManager bodyManager = this.bodyManagers.get(managerIdx);
            if (bodyManager == null) continue;
            this.controllerCoreCommand.addFeedbackControlCommand(bodyManager.getFeedbackControlCommand());
            this.controllerCoreCommand.addInverseDynamicsCommand(bodyManager.getInverseDynamicsCommand());
        }
        this.controllerCoreCommand.addFeedbackControlCommand(this.pelvisOrientationManager.getFeedbackControlCommand());
        this.controllerCoreCommand.addFeedbackControlCommand(this.comHeightManager.getFeedbackControlCommand());
        this.controllerCoreCommand.addInverseDynamicsCommand(this.controllerCoreOptimizationSettings.getCommand());
    }

    public ControllerCoreCommand getControllerCoreCommand() {
        return this.controllerCoreCommand;
    }

    public LinearMomentumRateControlModuleInput getLinearMomentumRateControlModuleInput() {
        return this.balanceManager.getLinearMomentumRateControlModuleInput();
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public WalkingStateEnum getWalkingStateEnum() {
        return (WalkingStateEnum)this.stateMachine.getCurrentStateKey();
    }

    @Override
    public boolean isJointLoadBearing(String jointName) {
        for (RobotSide robotSide : RobotSide.values) {
            boolean legLoaded = this.feetManager.getCurrentConstraintType(robotSide).isLoadBearing();
            if (!legLoaded || !((Set)this.legJointNames.get((Enum)robotSide)).contains(jointName)) continue;
            return true;
        }
        RigidBodyControlManager manager = this.bodyManagerByJointName.get(jointName);
        return manager != null && manager.isLoadBearing();
    }

    private /* synthetic */ RigidBodyBasics lambda$new$2(RobotSide side) {
        return ((ContactablePlaneBody)this.feet.get((Enum)side)).getRigidBody();
    }

    private class AbortCondition
    implements StateTransitionCondition {
        private AbortCondition() {
        }

        public boolean testCondition(double timeInState) {
            if (!WalkingHighLevelHumanoidController.this.abortWalkingRequested.getBooleanValue()) {
                return false;
            }
            WalkingHighLevelHumanoidController.this.walkingMessageHandler.clearFootsteps();
            WalkingHighLevelHumanoidController.this.walkingMessageHandler.reportWalkingAbortRequested();
            WalkingHighLevelHumanoidController.this.abortWalkingRequested.set(false);
            return true;
        }
    }
}

