/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.JointControlBlender;
import us.ihmc.commons.MathTools;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.variable.YoDouble;

public class SmoothTransitionControllerState
extends HighLevelControllerState {
    private final BooleanProvider enableTimeBasedTransition;
    private final DoubleProvider standTransitionDuration;
    private final YoDouble standTransitionRatioCurrentValue;
    private final YoPolynomial transitionRatioTrajectory;
    private final PairList<OneDoFJointBasics, JointControlBlender> jointCommandBlenders = new PairList();
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final HighLevelControllerState initialControllerState;
    private final HighLevelControllerState finalControllerState;

    public SmoothTransitionControllerState(String namePrefix, HighLevelControllerName controllerState, HighLevelControllerState initialControllerState, HighLevelControllerState finalControllerState, OneDoFJointBasics[] controlledJoints, HighLevelControllerParameters highLevelControllerParameters) {
        super(namePrefix, controllerState, controlledJoints);
        this.initialControllerState = initialControllerState;
        this.finalControllerState = finalControllerState;
        this.enableTimeBasedTransition = new BooleanParameter(namePrefix + "EnableTimeBasedTransition", "When true, the ramp up follows a linear time-based trajectory, when false, the user has to ramp up manually TransitionRatioCurrentValue through SCS.", this.registry, true);
        this.standTransitionDuration = new DoubleParameter(namePrefix + "TransitionDuration", this.registry, highLevelControllerParameters.getTimeInStandTransition());
        this.standTransitionRatioCurrentValue = new YoDouble(namePrefix + "TransitionRatioCurrentValue", this.registry);
        this.transitionRatioTrajectory = new YoPolynomial(namePrefix + "TransitionRatioTrajectory", 2, this.registry);
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])controlledJoints);
        for (OneDoFJointBasics controlledJoint : controlledJoints) {
            JointControlBlender jointControlBlender = new JointControlBlender("_StandTransition", controlledJoint, this.registry);
            this.jointCommandBlenders.add((Object)controlledJoint, (Object)jointControlBlender);
        }
    }

    public void onEntry() {
        this.finalControllerState.onEntry();
        this.transitionRatioTrajectory.setLinear(0.0, this.standTransitionDuration.getValue(), 0.0, 1.0);
        this.standTransitionRatioCurrentValue.set(0.0);
    }

    public void doAction(double timeInState) {
        double gainRatio;
        this.initialControllerState.doAction(timeInState);
        this.finalControllerState.doAction(timeInState);
        if (this.enableTimeBasedTransition.getValue()) {
            double timeInBlending = MathTools.clamp((double)timeInState, (double)0.0, (double)this.standTransitionDuration.getValue());
            this.transitionRatioTrajectory.compute(timeInBlending);
            gainRatio = this.transitionRatioTrajectory.getValue();
            this.standTransitionRatioCurrentValue.set(gainRatio);
        } else {
            gainRatio = this.standTransitionRatioCurrentValue.getValue();
        }
        gainRatio = Double.isNaN(gainRatio) ? 0.0 : MathTools.clamp((double)gainRatio, (double)0.0, (double)1.0);
        JointDesiredOutputListReadOnly standReadyJointCommand = this.initialControllerState.getOutputForLowLevelController();
        JointDesiredOutputListReadOnly walkingJointCommand = this.finalControllerState.getOutputForLowLevelController();
        for (int jointIndex = 0; jointIndex < this.jointCommandBlenders.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointCommandBlenders.get(jointIndex)).getLeft();
            JointControlBlender jointControlBlender = (JointControlBlender)((ImmutablePair)this.jointCommandBlenders.get(jointIndex)).getRight();
            JointDesiredOutputBasics lowLevelJointData = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            lowLevelJointData.clear();
            jointControlBlender.computeAndUpdateJointControl(lowLevelJointData, standReadyJointCommand.getJointDesiredOutput((OneDoFJointReadOnly)joint), walkingJointCommand.getJointDesiredOutput((OneDoFJointReadOnly)joint), gainRatio);
        }
    }

    public void onExit(double timeInState) {
        this.initialControllerState.onExit(timeInState);
    }

    @Override
    public boolean isDone(double timeInState) {
        if (this.enableTimeBasedTransition.getValue()) {
            return timeInState > this.standTransitionDuration.getValue();
        }
        return this.standTransitionRatioCurrentValue.getValue() >= 1.0;
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }
}

