/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandBuffer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialForce;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LegElasticityDebuggator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final SideDependentList<RigidBodyBasics> feet;
    private final YoFixedFrameSpatialForce footExternalWrenchOffset;
    private final SideDependentList<YoFramePose3D> footPosesMidZUp;
    private final SideDependentList<YoFramePose3D> footPosesOppFrame;
    private final YoFrameVector3D footSpacingMidZUp;
    private final YoFunctionGenerator footExternalForceOffsetX;
    private final YoFunctionGenerator footExternalForceOffsetY;
    private final InverseDynamicsCommandBuffer output = new InverseDynamicsCommandBuffer();

    public LegElasticityDebuggator(CommonHumanoidReferenceFrames referenceFrames, SideDependentList<RigidBodyBasics> feet, DoubleProvider time, YoRegistry parentRegistry) {
        this.referenceFrames = referenceFrames;
        this.feet = feet;
        MovingReferenceFrame midFeetZUpFrame = referenceFrames.getMidFeetZUpFrame();
        this.footExternalWrenchOffset = new YoFixedFrameSpatialForce("FootExternalWrenchOffset", (ReferenceFrame)midFeetZUpFrame, this.registry);
        this.footExternalForceOffsetX = new YoFunctionGenerator("FootExternalForceX", time, this.registry);
        this.footExternalForceOffsetY = new YoFunctionGenerator("FootExternalForceY", time, this.registry);
        this.footPosesMidZUp = new SideDependentList(side -> new YoFramePose3D(side.getCamelCaseName() + "FootPoseMidZUp", (ReferenceFrame)midFeetZUpFrame, this.registry));
        this.footPosesOppFrame = new SideDependentList(side -> new YoFramePose3D(side.getCamelCaseName() + "FootPoseOppFrame", (ReferenceFrame)referenceFrames.getSoleFrame((Enum)side), this.registry));
        this.footSpacingMidZUp = new YoFrameVector3D("FootSpacingMidZUp", (ReferenceFrame)midFeetZUpFrame, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        for (RobotSide robotSide : RobotSide.values) {
            ((YoFramePose3D)this.footPosesMidZUp.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)this.referenceFrames.getSoleFrame((Enum)robotSide));
            ((YoFramePose3D)this.footPosesOppFrame.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)this.referenceFrames.getSoleFrame((Enum)robotSide.getOppositeSide()));
        }
        this.footSpacingMidZUp.sub((FrameTuple3DReadOnly)((YoFramePose3D)this.footPosesMidZUp.get((Enum)RobotSide.LEFT)).getPosition(), (FrameTuple3DReadOnly)((YoFramePose3D)this.footPosesMidZUp.get((Enum)RobotSide.RIGHT)).getPosition());
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        if (this.footExternalForceOffsetX.getMode() != YoFunctionGeneratorMode.OFF) {
            this.footExternalWrenchOffset.setLinearPartX(this.footExternalForceOffsetX.getValue());
        }
        if (this.footExternalForceOffsetY.getMode() != YoFunctionGeneratorMode.OFF) {
            this.footExternalWrenchOffset.setLinearPartY(this.footExternalForceOffsetY.getValue());
        }
        this.output.clear();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = (RigidBodyBasics)this.feet.get((Enum)robotSide);
            ExternalWrenchCommand command = this.output.addExternalWrenchCommand();
            command.setRigidBody(foot);
            WrenchBasics footWrench = command.getExternalWrench();
            footWrench.setIncludingFrame((SpatialVectorReadOnly)this.footExternalWrenchOffset);
            footWrench.setBodyFrame((ReferenceFrame)foot.getBodyFixedFrame());
            footWrench.changeFrame((ReferenceFrame)foot.getBodyFixedFrame());
            if (robotSide != RobotSide.RIGHT) continue;
            footWrench.negate();
        }
        return this.output;
    }
}

