/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import controller_msgs.msg.dds.JointspaceTrajectoryStatusMessage;
import gnu.trove.map.hash.TIntIntHashMap;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.OneDoFJointTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.QueueableCommand;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.OneDoFJointTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.WholeBodyJointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.OneDoFTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.OneDoFTrajectoryPointBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutput;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class JointspacePositionControllerState
extends HighLevelControllerState {
    private final JointDesiredOutputListReadOnly highLevelControllerOutput;
    private final JointDesiredOutputList jointDesiredOutputList;
    private final OneDoFJointBasics[] joints;
    private final OneDoFJointManager[] jointManagers;
    private final TIntIntHashMap hashCodeToJointIndexMap = new TIntIntHashMap(40, 0.5f, -1, -1);
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final RecyclingArrayList<JointspaceTrajectoryStatusMessage> combinedStatuses = new RecyclingArrayList(JointspaceTrajectoryStatusMessage::new);

    public JointspacePositionControllerState(HighLevelControllerName stateEnum, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, OneDoFJointBasics[] controlledJoints, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControllerParameters highLevelControllerParameters, JointDesiredOutputListReadOnly highLevelControllerOutput) {
        super(stateEnum, highLevelControllerParameters, controlledJoints);
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.highLevelControllerOutput = highLevelControllerOutput;
        this.joints = controlledJoints;
        this.jointManagers = new OneDoFJointManager[this.joints.length];
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            OneDoFJointManager manager;
            OneDoFJointBasics joint = this.joints[jointIndex];
            this.jointManagers[jointIndex] = manager = new OneDoFJointManager(joint, (DoubleProvider)controllerToolbox.getYoTime(), this.registry);
            if (joint.hashCode() == this.hashCodeToJointIndexMap.getNoEntryKey()) {
                throw new IllegalStateException("Cannot register a joint's hash-code that is equal to the NO_ENTRY key value.");
            }
            this.hashCodeToJointIndexMap.put(joint.hashCode(), jointIndex);
        }
        this.jointDesiredOutputList = new JointDesiredOutputList((OneDoFJointReadOnly[])this.joints);
    }

    public void holdCurrent() {
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            this.jointManagers[jointIndex].holdCurrent();
        }
    }

    public void holdDesireds(JointDesiredOutputListReadOnly desiredsToHold) {
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            OneDoFJointBasics joint = this.joints[jointIndex];
            OneDoFJointManager manager = this.jointManagers[jointIndex];
            JointDesiredOutputReadOnly jointData = desiredsToHold.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            if (jointData == null || !jointData.hasDesiredPosition()) continue;
            manager.holdPosition(jointData.getDesiredPosition());
        }
    }

    public void onEntry() {
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            OneDoFJointBasics joint = this.joints[jointIndex];
            OneDoFJointManager manager = this.jointManagers[jointIndex];
            JointDesiredOutputReadOnly jointData = this.highLevelControllerOutput.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            if (jointData != null && jointData.hasDesiredPosition()) {
                manager.holdPosition(jointData.getDesiredPosition());
                continue;
            }
            manager.holdCurrent();
        }
    }

    public void doAction(double timeInState) {
        this.consumeCommands();
        this.combinedStatuses.clear();
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            OneDoFJointBasics joint = this.joints[jointIndex];
            OneDoFJointManager manager = this.jointManagers[jointIndex];
            JointDesiredOutput desiredOutput = this.jointDesiredOutputList.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            desiredOutput.clear();
            manager.doControl((JointDesiredOutputBasics)desiredOutput);
            JointspaceTrajectoryStatusMessage status = manager.pollStatusToReport();
            if (status == null) continue;
            this.combineStatus(status);
        }
        this.jointDesiredOutputList.completeWith((JointDesiredOutputListReadOnly)this.getStateSpecificJointSettings());
        for (int i = 0; i < this.combinedStatuses.size(); ++i) {
            this.statusOutputManager.reportStatusMessage(this.combinedStatuses.get(i));
        }
    }

    private void combineStatus(JointspaceTrajectoryStatusMessage jointStatus) {
        int i;
        JointspaceTrajectoryStatusMessage matchingCombinedStatus = null;
        for (i = 0; i < this.combinedStatuses.size(); ++i) {
            JointspaceTrajectoryStatusMessage candidate = (JointspaceTrajectoryStatusMessage)this.combinedStatuses.get(i);
            if (candidate.getTimestamp() != jointStatus.getTimestamp() || candidate.getSequenceId() != jointStatus.getSequenceId() || candidate.getTrajectoryExecutionStatus() != jointStatus.getTrajectoryExecutionStatus()) continue;
            matchingCombinedStatus = candidate;
            break;
        }
        if (matchingCombinedStatus == null) {
            matchingCombinedStatus = (JointspaceTrajectoryStatusMessage)this.combinedStatuses.add();
            matchingCombinedStatus.getJointNames().clear();
            matchingCombinedStatus.getActualJointPositions().reset();
            matchingCombinedStatus.getDesiredJointPositions().reset();
            matchingCombinedStatus.setTimestamp(jointStatus.getTimestamp());
            matchingCombinedStatus.setSequenceId(jointStatus.getSequenceId());
            matchingCombinedStatus.setTrajectoryExecutionStatus(jointStatus.getTrajectoryExecutionStatus());
        }
        for (i = 0; i < jointStatus.getJointNames().size(); ++i) {
            matchingCombinedStatus.getJointNames().add(jointStatus.getJointNames().getString(i));
            matchingCombinedStatus.getActualJointPositions().add(jointStatus.getActualJointPositions().get(i));
            matchingCombinedStatus.getDesiredJointPositions().add(jointStatus.getDesiredJointPositions().get(i));
        }
    }

    public void onExit() {
    }

    private void consumeCommands() {
        if (this.commandInputManager.isNewCommandAvailable(WholeBodyJointspaceTrajectoryCommand.class)) {
            WholeBodyJointspaceTrajectoryCommand command = (WholeBodyJointspaceTrajectoryCommand)this.commandInputManager.pollNewestCommand(WholeBodyJointspaceTrajectoryCommand.class);
            for (int commandIdx = 0; commandIdx < command.getNumberOfJoints(); ++commandIdx) {
                int jointHashCode = command.getJointHashCode(commandIdx);
                OneDoFJointTrajectoryCommand jointTrajectory = command.getJointTrajectoryPointList(commandIdx);
                int jointIndex = this.hashCodeToJointIndexMap.get(jointHashCode);
                if (jointIndex == -1) {
                    LogTools.warn((String)"Joint not supported, hash-code: {}", (Object)jointHashCode);
                    continue;
                }
                this.jointManagers[jointIndex].handleTrajectoryCommand(jointTrajectory, (QueueableCommand<?, ?>)command);
            }
        }
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.jointDesiredOutputList;
    }

    public static class OneDoFJointManager {
        public static final String shortName = "JointManager";
        private final OneDoFJointBasics joint;
        private final String warningPrefix;
        private final YoBoolean trajectoryDone;
        private final YoDouble trajectoryStartTime;
        private final MultipleWaypointsTrajectoryGenerator jointTrajectoryGenerator;
        private final RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue;
        private final YoInteger numberOfPointsInQueue;
        private final YoInteger numberOfPointsInGenerator;
        private final YoInteger numberOfPoints;
        private final OneDoFTrajectoryPoint lastPointAdded = new OneDoFTrajectoryPoint();
        private final OneDoFJointTrajectoryStatusMessageHelper statusHelper;
        private final YoLong lastCommandId;
        private final DoubleProvider time;

        public OneDoFJointManager(OneDoFJointBasics joint, DoubleProvider time, YoRegistry registry) {
            this.joint = joint;
            this.time = time;
            String jointName = joint.getName();
            this.warningPrefix = "JointManager for " + jointName + ": ";
            this.trajectoryDone = new YoBoolean(jointName + shortName + "Done", registry);
            this.trajectoryStartTime = new YoDouble(jointName + "_trajectoryStartTime", registry);
            this.jointTrajectoryGenerator = new MultipleWaypointsTrajectoryGenerator(jointName, 50, registry);
            this.pointQueue = new RecyclingArrayDeque(10000, OneDoFTrajectoryPoint::new, OneDoFTrajectoryPointBasics::set);
            this.numberOfPointsInQueue = new YoInteger(jointName + "_numberOfPointsInQueue", registry);
            this.numberOfPointsInGenerator = new YoInteger(jointName + "_numberOfPointsInGenerator", registry);
            this.numberOfPoints = new YoInteger(jointName + "_numberOfPoints", registry);
            this.statusHelper = new OneDoFJointTrajectoryStatusMessageHelper((OneDoFJointReadOnly)joint);
            this.lastCommandId = new YoLong(joint.getName() + "LastCommandId", registry);
            this.lastCommandId.set(0L);
        }

        public void doControl(JointDesiredOutputBasics jointDesiredOutput) {
            boolean generatorDone;
            double timeInTrajectory = this.time.getValue() - this.trajectoryStartTime.getValue();
            this.statusHelper.updateWithTimeInTrajectory(timeInTrajectory);
            boolean allDone = true;
            boolean bl = generatorDone = this.jointTrajectoryGenerator.isDone() || this.jointTrajectoryGenerator.getLastWaypointTime() <= timeInTrajectory;
            allDone = !this.trajectoryDone.getBooleanValue() && generatorDone ? this.fillAndReinitializeTrajectories() && allDone : this.trajectoryDone.getBooleanValue();
            this.jointTrajectoryGenerator.compute(timeInTrajectory);
            jointDesiredOutput.setDesiredPosition(this.jointTrajectoryGenerator.getValue());
            jointDesiredOutput.setDesiredVelocity(this.jointTrajectoryGenerator.getVelocity());
            jointDesiredOutput.setDesiredAcceleration(this.jointTrajectoryGenerator.getAcceleration());
            this.numberOfPointsInQueue.set(this.pointQueue.size());
            this.numberOfPointsInGenerator.set(this.jointTrajectoryGenerator.getCurrentNumberOfWaypoints());
            this.numberOfPoints.set(this.numberOfPointsInQueue.getIntegerValue() + this.numberOfPointsInGenerator.getIntegerValue());
            this.trajectoryDone.set(allDone);
        }

        private boolean fillAndReinitializeTrajectories() {
            if (this.pointQueue.isEmpty()) {
                return true;
            }
            if (!this.jointTrajectoryGenerator.isEmpty()) {
                this.jointTrajectoryGenerator.getLastWaypoint((OneDoFTrajectoryPointBasics)this.lastPointAdded);
                this.jointTrajectoryGenerator.clear();
                this.jointTrajectoryGenerator.appendWaypoint((OneDoFTrajectoryPointBasics)this.lastPointAdded);
            }
            int currentNumberOfWaypoints = this.jointTrajectoryGenerator.getCurrentNumberOfWaypoints();
            int pointsToAdd = this.jointTrajectoryGenerator.getMaximumNumberOfWaypoints() - currentNumberOfWaypoints;
            for (int pointIdx = 0; pointIdx < pointsToAdd && !this.pointQueue.isEmpty(); ++pointIdx) {
                OneDoFTrajectoryPoint pointToAdd = (OneDoFTrajectoryPoint)this.pointQueue.pollFirst();
                this.jointTrajectoryGenerator.appendWaypoint((OneDoFTrajectoryPointBasics)pointToAdd);
            }
            this.jointTrajectoryGenerator.initialize();
            return false;
        }

        public boolean handleTrajectoryCommand(OneDoFJointTrajectoryCommand command, QueueableCommand<?, ?> queueingProperties) {
            return this.handleTrajectoryCommand(command, queueingProperties, this.getJointDesiredPosition());
        }

        public boolean handleTrajectoryCommand(OneDoFJointTrajectoryCommand command, QueueableCommand<?, ?> queueingProperties, double initialJointPosition) {
            boolean override;
            if (!this.validateQueueableProperties(queueingProperties)) {
                return false;
            }
            boolean bl = override = queueingProperties.getExecutionMode() != ExecutionMode.QUEUE;
            if (override || this.isEmpty()) {
                this.overrideTrajectory();
                if (command.getNumberOfTrajectoryPoints() > 0) {
                    OneDoFTrajectoryPoint trajectoryPoint = command.getTrajectoryPoint(0);
                    if (trajectoryPoint.getTime() > 0.05) {
                        this.queueInitialPoint(initialJointPosition);
                    }
                } else {
                    this.queueInitialPoint(initialJointPosition);
                }
            }
            for (int pointIdx = 0; pointIdx < command.getNumberOfTrajectoryPoints(); ++pointIdx) {
                OneDoFTrajectoryPoint trajectoryPoint = command.getTrajectoryPoint(pointIdx);
                if (trajectoryPoint == null) continue;
                if (!this.checkTime(trajectoryPoint.getTime())) {
                    return false;
                }
                if (this.queuePoint(trajectoryPoint)) continue;
                return false;
            }
            this.trajectoryDone.set(false);
            this.statusHelper.registerNewTrajectory(command, queueingProperties.getExecutionMode());
            return true;
        }

        private boolean validateQueueableProperties(QueueableCommand<?, ?> queueingProperties) {
            boolean previousIdMatch;
            if (queueingProperties.getCommandId() == 0L) {
                LogTools.warn((String)(this.warningPrefix + "Recieved packet with invalid ID."));
                return false;
            }
            boolean wantToQueue = queueingProperties.getExecutionMode() == ExecutionMode.QUEUE;
            boolean bl = previousIdMatch = queueingProperties.getPreviousCommandId() == this.lastCommandId.getLongValue();
            if (!this.isEmpty() && wantToQueue && !previousIdMatch) {
                LogTools.warn((String)(this.warningPrefix + "Unexpected command ID. Msg previous id: " + queueingProperties.getPreviousCommandId() + " but was " + this.lastCommandId.getLongValue()));
                return false;
            }
            if (!wantToQueue || this.isEmpty()) {
                this.trajectoryStartTime.set(this.time.getValue());
            } else {
                queueingProperties.addTimeOffset(this.getLastTrajectoryPointTime());
            }
            this.lastCommandId.set(queueingProperties.getCommandId());
            this.trajectoryDone.set(false);
            return true;
        }

        public void holdCurrent() {
            this.holdPosition(this.joint.getQ());
        }

        public void holdCurrentDesired() {
            this.holdPosition(this.getJointDesiredPosition());
        }

        public void holdPosition(double position) {
            this.overrideTrajectory();
            this.resetLastCommandId();
            this.trajectoryStartTime.set(this.time.getValue());
            this.queueInitialPoint(position);
            this.trajectoryDone.set(false);
        }

        private void resetLastCommandId() {
            this.lastCommandId.set(0L);
        }

        public void queueInitialPointAtCurrent() {
            this.queueInitialPoint(this.joint.getQ());
        }

        public void queueInitialPointAtCurrentDesired() {
            this.queueInitialPoint(this.getJointDesiredPosition());
        }

        private void queueInitialPoint(double initialPosition) {
            ((OneDoFTrajectoryPoint)this.pointQueue.addLast()).set(0.0, initialPosition, 0.0);
        }

        private boolean queuePoint(OneDoFTrajectoryPoint trajectoryPoint) {
            if (this.atCapacityLimit(this.pointQueue)) {
                return false;
            }
            OneDoFTrajectoryPoint point = (OneDoFTrajectoryPoint)this.pointQueue.addLast();
            point.set((OneDoFTrajectoryPointBasics)trajectoryPoint);
            return true;
        }

        public void queuePointAtTimeWithZeroVelocity(double time, double jointPosition) {
            this.queuePoint(jointPosition, 0.0, time);
        }

        private boolean queuePoint(double q, double qd, double t) {
            if (this.atCapacityLimit(this.pointQueue)) {
                return false;
            }
            OneDoFTrajectoryPoint point = (OneDoFTrajectoryPoint)this.pointQueue.addLast();
            point.set(t, q, qd);
            return true;
        }

        private boolean atCapacityLimit(RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue) {
            if (pointQueue.size() >= 10000) {
                LogTools.info((String)(this.warningPrefix + "Reached maximum capacity of " + 10000 + " can not execute trajectory."));
                return true;
            }
            return false;
        }

        private boolean checkTime(double time) {
            boolean timeValid;
            boolean bl = timeValid = time > this.getLastTrajectoryPointTime();
            if (!timeValid) {
                LogTools.warn((String)(this.warningPrefix + "Time in trajectory must be strictly increasing."));
            }
            return timeValid;
        }

        private double getLastTrajectoryPointTime() {
            if (this.isEmpty()) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.pointQueue.isEmpty()) {
                return this.jointTrajectoryGenerator.getLastWaypointTime();
            }
            return ((OneDoFTrajectoryPoint)this.pointQueue.peekLast()).getTime();
        }

        private void overrideTrajectory() {
            this.jointTrajectoryGenerator.clear();
            this.pointQueue.clear();
        }

        private boolean isEmpty() {
            return this.pointQueue.isEmpty() && this.jointTrajectoryGenerator.isDone();
        }

        public double getJointDesiredPosition() {
            return this.jointTrajectoryGenerator.getValue();
        }

        public double getJointDesiredVelocity() {
            return this.jointTrajectoryGenerator.getVelocity();
        }

        public JointspaceTrajectoryStatusMessage pollStatusToReport() {
            return this.statusHelper.pollStatusMessage(this.joint.getQ(), this.getJointDesiredPosition());
        }
    }
}

