/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.filters.DeltaLimitedYoVariable;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointControlBlender {
    private static final boolean ENABLE_TAU_SCALE = false;
    private final YoDouble tauScale;
    private final DeltaLimitedYoVariable positionStepSizeLimiter;
    private final DeltaLimitedYoVariable velocityStepSizeLimiter;
    private final OneDoFJointBasics oneDoFJoint;

    public JointControlBlender(String nameSuffix, OneDoFJointBasics oneDoFJoint, YoRegistry parentRegistry) {
        this.oneDoFJoint = oneDoFJoint;
        String namePrefix = oneDoFJoint.getName();
        YoRegistry registry = new YoRegistry(namePrefix + nameSuffix + "JointControlBlender");
        this.positionStepSizeLimiter = new DeltaLimitedYoVariable(namePrefix + "PositionStepSizeLimiter", registry, 0.15);
        this.velocityStepSizeLimiter = new DeltaLimitedYoVariable(namePrefix + "VelocityStepSizeLimiter", registry, 1.5);
        this.tauScale = null;
        parentRegistry.addChild(registry);
    }

    public void initialize() {
        double q = this.oneDoFJoint.getQ();
        double qd = this.oneDoFJoint.getQd();
        this.positionStepSizeLimiter.updateOutput(q, q);
        this.velocityStepSizeLimiter.updateOutput(qd, qd);
    }

    public void computeAndUpdateJointControl(JointDesiredOutputBasics outputDataToPack, JointDesiredOutputReadOnly outputData0, JointDesiredOutputReadOnly outputData1, double blendingFactor) {
        double frequency;
        double frequency1;
        double frequency0;
        double maxError;
        double maxError1;
        double maxError0;
        if ((blendingFactor = MathTools.clamp((double)blendingFactor, (double)0.0, (double)1.0)) == 0.0) {
            outputDataToPack.set(outputData0);
            return;
        }
        if (blendingFactor == 1.0) {
            outputDataToPack.set(outputData1);
            return;
        }
        outputDataToPack.clear();
        outputDataToPack.setControlMode(outputData0.getControlMode());
        outputDataToPack.setLoadMode(outputData0.getLoadMode());
        double currentJointAngle = this.oneDoFJoint.getQ();
        double currentJointVelocity = this.oneDoFJoint.getQd();
        if (this.hasDesiredPosition(outputData0) || this.hasDesiredPosition(outputData1)) {
            double desiredPosition0 = this.hasDesiredPosition(outputData0) ? outputData0.getDesiredPosition() : this.oneDoFJoint.getQ();
            double desiredPosition1 = this.hasDesiredPosition(outputData1) ? outputData1.getDesiredPosition() : this.oneDoFJoint.getQ();
            double desiredPosition = EuclidCoreTools.interpolate((double)desiredPosition0, (double)desiredPosition1, (double)blendingFactor);
            this.positionStepSizeLimiter.updateOutput(currentJointAngle, desiredPosition);
            outputDataToPack.setDesiredPosition(this.positionStepSizeLimiter.getDoubleValue());
        }
        if (this.hasDesiredVelocity(outputData0) || this.hasDesiredVelocity(outputData1)) {
            double desiredVelocity0 = this.hasDesiredVelocity(outputData0) ? outputData0.getDesiredVelocity() : this.oneDoFJoint.getQd();
            double desiredVelocity1 = this.hasDesiredVelocity(outputData1) ? outputData1.getDesiredVelocity() : this.oneDoFJoint.getQd();
            double desiredVelocity = EuclidCoreTools.interpolate((double)desiredVelocity0, (double)desiredVelocity1, (double)blendingFactor);
            this.velocityStepSizeLimiter.updateOutput(currentJointVelocity, desiredVelocity);
            outputDataToPack.setDesiredVelocity(this.velocityStepSizeLimiter.getDoubleValue());
        }
        if (this.hasDesiredAcceleration(outputData0) || this.hasDesiredAcceleration(outputData1)) {
            double desiredAcceleration0 = this.hasDesiredAcceleration(outputData0) ? outputData0.getDesiredAcceleration() : 0.0;
            double desiredAcceleration1 = this.hasDesiredAcceleration(outputData1) ? outputData1.getDesiredAcceleration() : 0.0;
            double desiredAcceleration = EuclidCoreTools.interpolate((double)desiredAcceleration0, (double)desiredAcceleration1, (double)blendingFactor);
            outputDataToPack.setDesiredAcceleration(desiredAcceleration);
        }
        if (this.hasDesiredTorque(outputData0) || this.hasDesiredTorque(outputData1)) {
            double desiredTorque0 = this.hasDesiredTorque(outputData0) ? outputData0.getDesiredTorque() : 0.0;
            double desiredTorque1 = this.hasDesiredTorque(outputData1) ? outputData1.getDesiredTorque() : 0.0;
            double desiredTorque = EuclidCoreTools.interpolate((double)desiredTorque0, (double)desiredTorque1, (double)blendingFactor);
            outputDataToPack.setDesiredTorque(desiredTorque);
        }
        if (this.hasPositionFeedbackMaxError(outputData0) || this.hasPositionFeedbackMaxError(outputData1)) {
            maxError0 = this.hasPositionFeedbackMaxError(outputData0) ? outputData0.getPositionFeedbackMaxError() : 0.0;
            maxError1 = this.hasPositionFeedbackMaxError(outputData1) ? outputData1.getPositionFeedbackMaxError() : 0.0;
            maxError = EuclidCoreTools.interpolate((double)maxError0, (double)maxError1, (double)blendingFactor);
            outputDataToPack.setPositionFeedbackMaxError(maxError);
        }
        if (this.hasVelocityFeedbackMaxError(outputData0) || this.hasVelocityFeedbackMaxError(outputData1)) {
            maxError0 = this.hasVelocityFeedbackMaxError(outputData0) ? outputData0.getVelocityFeedbackMaxError() : 0.0;
            maxError1 = this.hasVelocityFeedbackMaxError(outputData1) ? outputData1.getVelocityFeedbackMaxError() : 0.0;
            maxError = EuclidCoreTools.interpolate((double)maxError0, (double)maxError1, (double)blendingFactor);
            outputDataToPack.setVelocityFeedbackMaxError(maxError);
        }
        if (this.hasStiffness(outputData0) || this.hasStiffness(outputData1)) {
            double stiffness0 = this.hasStiffness(outputData0) ? outputData0.getStiffness() : 0.0;
            double stiffness1 = this.hasStiffness(outputData1) ? outputData1.getStiffness() : 0.0;
            double stiffness = EuclidCoreTools.interpolate((double)stiffness0, (double)stiffness1, (double)blendingFactor);
            outputDataToPack.setStiffness(stiffness);
        }
        if (this.hasDamping(outputData0) || this.hasDamping(outputData1)) {
            double damping0 = this.hasDamping(outputData0) ? outputData0.getDamping() : 0.0;
            double damping1 = this.hasDamping(outputData1) ? outputData1.getDamping() : 0.0;
            double damping = EuclidCoreTools.interpolate((double)damping0, (double)damping1, (double)blendingFactor);
            outputDataToPack.setDamping(damping);
        }
        if (this.hasVelocityScaling(outputData0) || this.hasVelocityScaling(outputData1)) {
            double velocityScaling0 = this.hasVelocityScaling(outputData0) ? outputData0.getVelocityScaling() : 0.0;
            double velocityScaling1 = this.hasVelocityScaling(outputData1) ? outputData1.getVelocityScaling() : 0.0;
            double velocityScaling = EuclidCoreTools.interpolate((double)velocityScaling0, (double)velocityScaling1, (double)blendingFactor);
            outputDataToPack.setVelocityScaling(velocityScaling);
        }
        if (this.hasVelocityIntegrationMaxError(outputData0) || this.hasVelocityIntegrationMaxError(outputData1)) {
            maxError0 = this.hasVelocityIntegrationMaxError(outputData0) ? outputData0.getVelocityIntegrationMaxError() : 0.0;
            maxError1 = this.hasVelocityIntegrationMaxError(outputData1) ? outputData1.getVelocityIntegrationMaxError() : 0.0;
            maxError = EuclidCoreTools.interpolate((double)maxError0, (double)maxError1, (double)blendingFactor);
            outputDataToPack.setVelocityIntegrationMaxError(maxError);
        }
        if (this.hasVelocityIntegrationBreakFrequency(outputData0) || this.hasVelocityIntegrationBreakFrequency(outputData1)) {
            frequency0 = this.hasVelocityIntegrationBreakFrequency(outputData0) ? outputData0.getVelocityIntegrationBreakFrequency() : 0.0;
            frequency1 = this.hasVelocityIntegrationBreakFrequency(outputData1) ? outputData1.getVelocityIntegrationBreakFrequency() : 0.0;
            frequency = EuclidCoreTools.interpolate((double)frequency0, (double)frequency1, (double)blendingFactor);
            outputDataToPack.setVelocityIntegrationBreakFrequency(frequency);
        }
        if (this.hasPositionIntegrationMaxError(outputData0) || this.hasPositionIntegrationMaxError(outputData1)) {
            maxError0 = this.hasPositionIntegrationMaxError(outputData0) ? outputData0.getPositionIntegrationMaxError() : 0.0;
            maxError1 = this.hasPositionIntegrationMaxError(outputData1) ? outputData1.getPositionIntegrationMaxError() : 0.0;
            maxError = EuclidCoreTools.interpolate((double)maxError0, (double)maxError1, (double)blendingFactor);
            outputDataToPack.setPositionIntegrationMaxError(maxError);
        }
        if (this.hasPositionIntegrationBreakFrequency(outputData0) || this.hasPositionIntegrationBreakFrequency(outputData1)) {
            frequency0 = this.hasPositionIntegrationBreakFrequency(outputData0) ? outputData0.getPositionIntegrationBreakFrequency() : 0.0;
            frequency1 = this.hasPositionIntegrationBreakFrequency(outputData1) ? outputData1.getPositionIntegrationBreakFrequency() : 0.0;
            frequency = EuclidCoreTools.interpolate((double)frequency0, (double)frequency1, (double)blendingFactor);
            outputDataToPack.setPositionIntegrationBreakFrequency(frequency);
        }
        outputDataToPack.setResetIntegrators(this.pollResetIntegratorsRequest(outputData0) || this.pollResetIntegratorsRequest(outputData1));
    }

    private boolean hasDesiredPosition(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasDesiredPosition();
    }

    private boolean hasDesiredVelocity(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasDesiredVelocity();
    }

    private boolean hasDesiredAcceleration(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasDesiredAcceleration();
    }

    private boolean hasDesiredTorque(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasDesiredTorque();
    }

    private boolean hasPositionFeedbackMaxError(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasPositionFeedbackMaxError();
    }

    private boolean hasVelocityFeedbackMaxError(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasVelocityFeedbackMaxError();
    }

    private boolean hasStiffness(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasStiffness();
    }

    private boolean hasDamping(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasDamping();
    }

    private boolean hasVelocityScaling(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasVelocityScaling();
    }

    private boolean hasVelocityIntegrationBreakFrequency(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasVelocityIntegrationBreakFrequency();
    }

    private boolean hasVelocityIntegrationMaxError(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasVelocityIntegrationMaxError();
    }

    private boolean hasPositionIntegrationBreakFrequency(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasPositionIntegrationBreakFrequency();
    }

    private boolean hasPositionIntegrationMaxError(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.hasPositionIntegrationMaxError();
    }

    private boolean pollResetIntegratorsRequest(JointDesiredOutputReadOnly outputData) {
        return outputData != null && outputData.pollResetIntegratorsRequest();
    }
}

