/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.referenceFrames.ZUpPreserveYReferenceFrame;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DiagnosticsWhenHangingHelper {
    private static final boolean DEBUG = false;
    private final OneDoFJointBasics parentJoint;
    private final boolean isSpineJoint;
    private final CenterOfMassCalculator centerOfMassCalculator;
    private final YoFramePoint3D belowJointCoMInZUpFrame;
    private final YoFrameVector3D yoJointAxis;
    private final YoFrameVector3D yoJointToCenterOfMass;
    private final YoFrameVector3D yoForceVector;
    private final FramePoint3D centerOfMassPosition;
    private final FrameVector3D jointAxis = new FrameVector3D();
    private final FrameVector3D jointToCenterOfMass = new FrameVector3D();
    private FrameVector3D forceVector = new FrameVector3D();
    private FrameVector3D rCrossFVector = new FrameVector3D();
    private final YoDouble totalMass;
    private final YoDouble estimatedTorque;
    private final YoDouble torqueOffset;
    private final YoDouble appliedTorque;
    private final YoDouble torqueCorrectionAlpha;
    private final FrameVector3D jointAxisInWorld = new FrameVector3D();
    private final FrameVector3D jointToCenterOfMassInWorld = new FrameVector3D((FrameTuple3DReadOnly)this.jointToCenterOfMass);

    public DiagnosticsWhenHangingHelper(OneDoFJointBasics parentJoint, boolean preserveY, YoRegistry registry) {
        this(parentJoint, preserveY, false, null, registry);
    }

    public DiagnosticsWhenHangingHelper(OneDoFJointBasics parentJoint, boolean preserveY, boolean isSpineJoint, SideDependentList<JointBasics> topLegJointsIfSpine, YoRegistry registry) {
        this.parentJoint = parentJoint;
        this.isSpineJoint = isSpineJoint;
        this.centerOfMassCalculator = DiagnosticsWhenHangingHelper.createCenterOfMassCalculatorInJointZUpFrame((JointBasics)parentJoint, preserveY, isSpineJoint, topLegJointsIfSpine);
        this.belowJointCoMInZUpFrame = new YoFramePoint3D(parentJoint.getName() + "CoMInZUpFrame", this.centerOfMassCalculator.getReferenceFrame(), registry);
        this.centerOfMassPosition = new FramePoint3D(this.centerOfMassCalculator.getReferenceFrame());
        this.yoJointAxis = new YoFrameVector3D(parentJoint.getName() + "JointAxis", ReferenceFrame.getWorldFrame(), registry);
        this.yoJointToCenterOfMass = new YoFrameVector3D(parentJoint.getName() + "JointToCoM", ReferenceFrame.getWorldFrame(), registry);
        this.yoForceVector = new YoFrameVector3D(parentJoint.getName() + "ForceVector", ReferenceFrame.getWorldFrame(), registry);
        this.estimatedTorque = new YoDouble("tau_est_" + parentJoint.getName(), registry);
        this.torqueOffset = new YoDouble("tau_off_" + parentJoint.getName(), registry);
        this.appliedTorque = new YoDouble("tau_app_" + parentJoint.getName(), registry);
        this.totalMass = new YoDouble("totalMass_" + parentJoint.getName(), registry);
        this.torqueCorrectionAlpha = new YoDouble("torqueCorrectionAlpha_" + parentJoint.getName(), registry);
        this.torqueCorrectionAlpha.set(0.001);
    }

    private static CenterOfMassCalculator createCenterOfMassCalculatorInJointZUpFrame(JointBasics parentJoint, boolean preserveY, boolean spineJoint, SideDependentList<JointBasics> topLegJointsIfSpine) {
        MultiBodySystemReadOnly subSystem;
        MovingReferenceFrame jointFrame = parentJoint.getFrameAfterJoint();
        String jointName = parentJoint.getName();
        Object jointZUpFrame = preserveY ? new ZUpPreserveYReferenceFrame(ReferenceFrame.getWorldFrame(), (ReferenceFrame)jointFrame, jointName + "ZUp") : new ZUpFrame(ReferenceFrame.getWorldFrame(), (ReferenceFrame)jointFrame, jointName + "ZUp");
        if (spineJoint) {
            HashSet<JointBasics> jointsToConsider = new HashSet<JointBasics>();
            jointsToConsider.addAll(Arrays.asList(MultiBodySystemTools.collectSupportJoints((RigidBodyBasics)parentJoint.getPredecessor())));
            for (JointBasics legJoint : topLegJointsIfSpine) {
                legJoint.subtreeIterable().forEach(jointsToConsider::add);
            }
            subSystem = MultiBodySystemReadOnly.toMultiBodySystemInput(new ArrayList(jointsToConsider));
        } else {
            subSystem = MultiBodySystemReadOnly.toMultiBodySystemInput((List)parentJoint.subtreeList());
        }
        CenterOfMassCalculator centerOfMassCalculator = new CenterOfMassCalculator(subSystem, (ReferenceFrame)jointZUpFrame);
        return centerOfMassCalculator;
    }

    public double getTorqueToApply(double feedbackCorrectionTorque, boolean adaptTorqueOffset, double maxTorqueOffset) {
        this.appliedTorque.set(feedbackCorrectionTorque + this.estimatedTorque.getDoubleValue());
        if (adaptTorqueOffset) {
            this.torqueOffset.sub(feedbackCorrectionTorque * this.torqueCorrectionAlpha.getDoubleValue());
            if (this.torqueOffset.getDoubleValue() > maxTorqueOffset) {
                this.torqueOffset.set(maxTorqueOffset);
            }
            if (this.torqueOffset.getDoubleValue() < -maxTorqueOffset) {
                this.torqueOffset.set(-maxTorqueOffset);
            }
        }
        return this.appliedTorque.getDoubleValue() - this.torqueOffset.getDoubleValue();
    }

    public double getEstimatedTorque() {
        return this.estimatedTorque.getDoubleValue();
    }

    public double getAppliedTorque() {
        return this.appliedTorque.getDoubleValue();
    }

    public YoDouble getEstimatedTorqueYoVariable() {
        return this.estimatedTorque;
    }

    public YoDouble getAppliedTorqueYoVariable() {
        return this.appliedTorque;
    }

    public void update() {
        this.centerOfMassCalculator.getReferenceFrame().update();
        this.centerOfMassCalculator.reset();
        this.centerOfMassPosition.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassCalculator.getCenterOfMass());
        this.belowJointCoMInZUpFrame.set((FrameTuple3DReadOnly)this.centerOfMassPosition);
        this.jointAxis.setIncludingFrame((FrameTuple3DReadOnly)this.parentJoint.getJointAxis());
        this.jointAxis.changeFrame((ReferenceFrame)this.parentJoint.getFrameAfterJoint());
        this.jointAxisInWorld.setIncludingFrame((FrameTuple3DReadOnly)this.jointAxis);
        this.jointAxisInWorld.changeFrame(ReferenceFrame.getWorldFrame());
        this.yoJointAxis.set((FrameTuple3DReadOnly)this.jointAxisInWorld);
        this.centerOfMassPosition.changeFrame(this.jointAxis.getReferenceFrame());
        this.jointToCenterOfMass.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassPosition);
        this.jointToCenterOfMassInWorld.setIncludingFrame((FrameTuple3DReadOnly)this.jointToCenterOfMass);
        this.jointToCenterOfMassInWorld.changeFrame(ReferenceFrame.getWorldFrame());
        this.yoJointToCenterOfMass.set((FrameTuple3DReadOnly)this.jointToCenterOfMassInWorld);
        this.totalMass.set(this.centerOfMassCalculator.getTotalMass());
        this.forceVector.setIncludingFrame(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -9.81 * this.totalMass.getDoubleValue());
        this.forceVector.changeFrame(this.jointAxis.getReferenceFrame());
        FrameVector3D forceVectorInWorld = new FrameVector3D((FrameTuple3DReadOnly)this.forceVector);
        forceVectorInWorld.changeFrame(ReferenceFrame.getWorldFrame());
        this.yoForceVector.set((FrameTuple3DReadOnly)forceVectorInWorld);
        this.rCrossFVector.setToZero(this.jointAxis.getReferenceFrame());
        this.rCrossFVector.cross((FrameVector3DReadOnly)this.forceVector, (FrameVector3DReadOnly)this.jointToCenterOfMass);
        this.estimatedTorque.set(this.rCrossFVector.dot((FrameVector3DReadOnly)this.jointAxis));
        if (this.isSpineJoint) {
            this.estimatedTorque.mul(-1.0);
        }
    }

    public void addOffsetToEstimatedTorque() {
        this.estimatedTorque.add(this.torqueOffset);
    }

    public YoDouble getTorqueOffsetVariable() {
        return this.torqueOffset;
    }

    public double getTorqueOffset() {
        return this.torqueOffset.getDoubleValue();
    }

    public void setTorqueOffset(double torqueOffset) {
        this.torqueOffset.set(torqueOffset);
    }

    public void setAppliedTorque(double appliedTorque) {
        this.appliedTorque.set(appliedTorque);
    }
}

