/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ListOfPointsContactableFoot;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ListOfPointsContactablePlaneBody;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.SimpleContactPointPlaneBody;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSegment;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.screwTheory.ScrewTools;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.tools.factories.FactoryTools;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;

public class ContactableBodiesFactory<E extends Enum<E>> {
    private final RequiredFactoryField<SegmentDependentList<E, ? extends List<Point2D>>> feetContactPoints = new RequiredFactoryField("feetContactPoints");
    private final RequiredFactoryField<FullLeggedRobotModel<E>> fullRobotModel = new RequiredFactoryField("fullRobotModel");
    private final RequiredFactoryField<CommonLeggedReferenceFrames<E>> referenceFrames = new RequiredFactoryField("referenceFrames");
    private final OptionalFactoryField<SegmentDependentList<E, ? extends Point2D>> toeContactPoints = new OptionalFactoryField("toeContactPoints");
    private final OptionalFactoryField<SegmentDependentList<E, ? extends LineSegment2D>> toeContactLines = new OptionalFactoryField("toeContactLines");
    private final OptionalFactoryField<ArrayList<String>> additionalContactRigidBodyNames = new OptionalFactoryField("additionalContactRigidBodyNames");
    private final OptionalFactoryField<ArrayList<String>> additionalContactNames = new OptionalFactoryField("additionalContactNames");
    private final OptionalFactoryField<ArrayList<RigidBodyTransform>> additionalContactTransforms = new OptionalFactoryField("additionalContactTransforms");

    public void setFootContactPoints(SegmentDependentList<E, ? extends List<Point2D>> feetContactPoints) {
        this.feetContactPoints.set(feetContactPoints);
    }

    public void setFullRobotModel(FullLeggedRobotModel<E> fullRobotModel) {
        this.fullRobotModel.set(fullRobotModel);
    }

    public void setReferenceFrames(CommonLeggedReferenceFrames<E> referenceFrames) {
        this.referenceFrames.set(referenceFrames);
    }

    public void setToeContactParameters(SegmentDependentList<E, ? extends Point2D> toeContactPoints, SegmentDependentList<E, ? extends LineSegment2D> toeContactLines) {
        this.toeContactPoints.set(toeContactPoints);
        this.toeContactLines.set(toeContactLines);
    }

    public void addAdditionalContactPoint(String bodyName, String contactName, RigidBodyTransform transformFromParentLinkToPoint) {
        if (!this.additionalContactNames.hasValue()) {
            this.additionalContactRigidBodyNames.set(new ArrayList());
            this.additionalContactNames.set(new ArrayList());
            this.additionalContactTransforms.set(new ArrayList());
        } else if (((ArrayList)this.additionalContactRigidBodyNames.get()).contains(bodyName)) {
            throw new RuntimeException("Currently only supporting one additional contact point per rigid body.");
        }
        ((ArrayList)this.additionalContactRigidBodyNames.get()).add(bodyName);
        ((ArrayList)this.additionalContactNames.get()).add(contactName);
        ((ArrayList)this.additionalContactTransforms.get()).add(transformFromParentLinkToPoint);
    }

    public SegmentDependentList<E, ContactablePlaneBody> createFootContactablePlaneBodies() {
        FactoryTools.checkAllFactoryFieldsAreSet((Object)this);
        FullLeggedRobotModel fullRobotModel = (FullLeggedRobotModel)this.fullRobotModel.get();
        CommonLeggedReferenceFrames referenceFrames = (CommonLeggedReferenceFrames)this.referenceFrames.get();
        Enum[] robotSegments = fullRobotModel.getRobotSegments();
        SegmentDependentList footContactableBodies = new SegmentDependentList(((RobotSegment)robotSegments[0]).getClassType());
        for (Enum segment : robotSegments) {
            RigidBodyBasics foot = fullRobotModel.getFoot(segment);
            MovingReferenceFrame soleFrame = referenceFrames.getSoleFrame(segment);
            List contactPointsInSoleFrame = (List)((SegmentDependentList)this.feetContactPoints.get()).get(segment);
            ListOfPointsContactablePlaneBody footContactableBody = new ListOfPointsContactablePlaneBody(foot, (ReferenceFrame)soleFrame, contactPointsInSoleFrame);
            footContactableBodies.put(segment, (Object)footContactableBody);
        }
        this.feetContactPoints.dispose();
        this.toeContactPoints.dispose();
        this.toeContactLines.dispose();
        return footContactableBodies;
    }

    public SegmentDependentList<E, ContactableFoot> createFootContactableFeet() {
        FactoryTools.checkAllFactoryFieldsAreSet((Object)this);
        this.toeContactLines.get();
        this.toeContactPoints.get();
        FullLeggedRobotModel fullRobotModel = (FullLeggedRobotModel)this.fullRobotModel.get();
        CommonLeggedReferenceFrames referenceFrames = (CommonLeggedReferenceFrames)this.referenceFrames.get();
        Enum[] robotSegments = fullRobotModel.getRobotSegments();
        SegmentDependentList footContactableBodies = new SegmentDependentList(((RobotSegment)robotSegments[0]).getClassType());
        for (Enum segment : robotSegments) {
            RigidBodyBasics foot = fullRobotModel.getFoot(segment);
            MovingReferenceFrame soleFrame = referenceFrames.getSoleFrame(segment);
            List contactPointsInSoleFrame = (List)((SegmentDependentList)this.feetContactPoints.get()).get(segment);
            Point2D toeOffContactPoint = (Point2D)((SegmentDependentList)this.toeContactPoints.get()).get(segment);
            LineSegment2D toeOffContactLine = (LineSegment2D)((SegmentDependentList)this.toeContactLines.get()).get(segment);
            ListOfPointsContactableFoot footContactableBody = new ListOfPointsContactableFoot(foot, (ReferenceFrame)soleFrame, contactPointsInSoleFrame, toeOffContactPoint, toeOffContactLine);
            footContactableBodies.put(segment, (Object)footContactableBody);
        }
        this.feetContactPoints.dispose();
        this.toeContactPoints.dispose();
        this.toeContactLines.dispose();
        return footContactableBodies;
    }

    public List<ContactablePlaneBody> createAdditionalContactPoints() {
        ArrayList<ContactablePlaneBody> contactablePlaneBodies = new ArrayList<ContactablePlaneBody>();
        if (!this.additionalContactNames.hasValue()) {
            return contactablePlaneBodies;
        }
        FullLeggedRobotModel fullRobotModel = (FullLeggedRobotModel)this.fullRobotModel.get();
        RigidBodyBasics[] bodies = fullRobotModel.getElevator().subtreeArray();
        for (int pointIdx = 0; pointIdx < ((ArrayList)this.additionalContactRigidBodyNames.get()).size(); ++pointIdx) {
            String bodyName = (String)((ArrayList)this.additionalContactRigidBodyNames.get()).get(pointIdx);
            String contactName = (String)((ArrayList)this.additionalContactNames.get()).get(pointIdx);
            RigidBodyTransform contactFramePoseInJoint = (RigidBodyTransform)((ArrayList)this.additionalContactTransforms.get()).get(pointIdx);
            RigidBodyBasics[] rigidBodies = ScrewTools.findRigidBodiesWithNames((RigidBodyBasics[])bodies, (String[])new String[]{bodyName});
            if (rigidBodies.length == 0) {
                throw new RuntimeException("Did not find body with name " + bodyName);
            }
            if (rigidBodies.length > 1) {
                throw new RuntimeException("Found multiple bodies with name " + bodyName);
            }
            RigidBodyBasics rigidBody = rigidBodies[0];
            contactablePlaneBodies.add(new SimpleContactPointPlaneBody(contactName, rigidBody, contactFramePoseInJoint));
        }
        return contactablePlaneBodies;
    }

    public void disposeFactory() {
        FactoryTools.disposeFactory((Object)this);
    }
}

