/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.heightPlanning;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightPartialDerivativesData;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightPartialDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTrajectoryWaypoint;
import us.ihmc.commonWalkingControlModules.trajectories.OptimizedTrajectoryGenerator;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.StringStretcher2d;
import us.ihmc.tools.lists.ListSorter;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SplinedHeightTrajectory {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double constraintWeight = 1000.0;
    private final List<CoMHeightTrajectoryWaypoint> waypoints = new ArrayList<CoMHeightTrajectoryWaypoint>();
    private final Comparator<CoMHeightTrajectoryWaypoint> sorter = Comparator.comparingDouble(CoMHeightTrajectoryWaypoint::getX);
    private final YoFramePoint3D contactFrameZeroPosition;
    private final YoFramePoint3D contactFrameOnePosition;
    private final BagOfBalls bagOfBalls;
    private final OptimizedTrajectoryGenerator trajectoryGenerator;
    private ReferenceFrame referenceFrame;
    private final CoMHeightPartialDerivativesData comHeightPartialDerivativesData = new CoMHeightPartialDerivativesData();
    private final StringStretcher2d stringStretcher = new StringStretcher2d();
    private final List<Point2DBasics> stretchedStringWaypoints = new ArrayList<Point2DBasics>();
    private final FramePoint3D tempFramePoint = new FramePoint3D();
    private final FramePoint3D tempFramePoint2 = new FramePoint3D();
    private final Point2D pointToThrowAway = new Point2D();
    private final YoDouble partialDzDs;
    private final YoDouble partialD2zDs2;
    private final YoDouble partialD3zDs3;
    private final YoDouble partialDsDx;
    private final YoDouble partialDsDy;
    private final TDoubleArrayList heightWaypoints = new TDoubleArrayList();
    private final TDoubleArrayList alphaWaypoints = new TDoubleArrayList();
    private final Point2D tempPoint = new Point2D();

    public SplinedHeightTrajectory(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.trajectoryGenerator = new OptimizedTrajectoryGenerator("height", 10, 4, registry);
        this.partialDzDs = new YoDouble("partialDzDs", registry);
        this.partialDsDx = new YoDouble("partialDsDx", registry);
        this.partialDsDy = new YoDouble("partialDsDy", registry);
        this.partialD2zDs2 = new YoDouble("partialD2zDs2", registry);
        this.partialD3zDs3 = new YoDouble("partialD3zDs3", registry);
        this.contactFrameZeroPosition = new YoFramePoint3D("contactFrameZeroPosition", worldFrame, registry);
        this.contactFrameOnePosition = new YoFramePoint3D("contactFrameOnePosition", worldFrame, registry);
        this.bagOfBalls = yoGraphicsListRegistry != null ? new BagOfBalls(15, 0.01, "height", registry, yoGraphicsListRegistry) : null;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void clearWaypoints() {
        this.waypoints.clear();
    }

    public void addWaypoints(List<CoMHeightTrajectoryWaypoint> waypoints) {
        for (int i = 0; i < waypoints.size(); ++i) {
            this.addWaypoint(waypoints.get(i));
        }
    }

    public void addWaypoint(CoMHeightTrajectoryWaypoint waypoint) {
        this.waypoints.add(waypoint);
    }

    public void computeSpline() {
        int i;
        ListSorter.sort(this.waypoints, this.sorter);
        this.computeHeightsToUseByStretchingString(this.waypoints);
        int numberOfWaypoints = this.waypoints.size();
        this.alphaWaypoints.reset();
        this.heightWaypoints.reset();
        CoMHeightTrajectoryWaypoint startWaypoint = this.waypoints.get(0);
        CoMHeightTrajectoryWaypoint endWaypoint = this.waypoints.get(numberOfWaypoints - 1);
        for (i = 1; i < numberOfWaypoints - 1; ++i) {
            CoMHeightTrajectoryWaypoint waypoint = this.waypoints.get(i);
            double distanceIn = waypoint.getX() - startWaypoint.getX();
            double totalDistance = endWaypoint.getX() - startWaypoint.getX();
            double alpha = MathTools.epsilonEquals((double)distanceIn, (double)0.0, (double)1.0E-12) && MathTools.epsilonEquals((double)totalDistance, (double)0.0, (double)1.0E-12) ? 0.0 : distanceIn / (endWaypoint.getX() - startWaypoint.getX());
            this.heightWaypoints.add(waypoint.getHeight());
            this.alphaWaypoints.add(alpha);
        }
        this.trajectoryGenerator.reset();
        this.trajectoryGenerator.setEndpointConditions(startWaypoint.getHeight(), 0.0, endWaypoint.getHeight(), 0.0);
        this.trajectoryGenerator.setWaypoints(this.heightWaypoints);
        this.trajectoryGenerator.setWaypointTimes(this.alphaWaypoints);
        this.trajectoryGenerator.initialize();
        this.contactFrameZeroPosition.setMatchingFrame((FrameTuple3DReadOnly)this.waypoints.get(0).getWaypoint());
        this.contactFrameOnePosition.setMatchingFrame((FrameTuple3DReadOnly)this.waypoints.get(this.waypoints.size() - 1).getWaypoint());
        for (i = 0; i < this.waypoints.size(); ++i) {
            this.waypoints.get(i).update();
        }
        if (this.bagOfBalls != null) {
            this.bagOfBalls.reset();
            int numberOfPoints = this.bagOfBalls.getNumberOfBalls();
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                double alpha = (double)(i2 + 1) / (double)numberOfPoints;
                this.tempFramePoint2.interpolate((FrameTuple3DReadOnly)this.contactFrameZeroPosition, (FrameTuple3DReadOnly)this.contactFrameOnePosition, alpha);
                this.solve(this.comHeightPartialDerivativesData, (FramePoint3DBasics)this.tempFramePoint2, (Point2DBasics)this.pointToThrowAway);
                this.tempFramePoint2.checkReferenceFrameMatch(this.comHeightPartialDerivativesData.getFrameOfCoMHeight());
                this.tempFramePoint2.setZ(this.comHeightPartialDerivativesData.getComHeight());
                this.bagOfBalls.setBallLoop((FramePoint3DReadOnly)this.tempFramePoint2);
            }
        }
    }

    private void computeHeightsToUseByStretchingString(List<CoMHeightTrajectoryWaypoint> waypoints) {
        CoMHeightTrajectoryWaypoint waypoint;
        int i;
        CoMHeightTrajectoryWaypoint startWaypoint = waypoints.get(0);
        CoMHeightTrajectoryWaypoint lastWaypoint = waypoints.get(waypoints.size() - 1);
        this.stringStretcher.reset();
        this.stringStretcher.setStartPoint(startWaypoint.getX(), startWaypoint.getHeight());
        this.stringStretcher.setEndPoint(lastWaypoint.getX(), lastWaypoint.getHeight());
        for (i = 1; i < waypoints.size() - 1; ++i) {
            waypoint = waypoints.get(i);
            this.stringStretcher.addMinMaxPoints(waypoint.getX(), waypoint.getMinHeight(), waypoint.getX(), waypoint.getMaxHeight());
        }
        this.stringStretcher.stretchString(this.stretchedStringWaypoints);
        for (i = 0; i < waypoints.size(); ++i) {
            waypoint = waypoints.get(i);
            waypoint.setX(this.stretchedStringWaypoints.get(i).getX());
            waypoint.setHeight(this.stretchedStringWaypoints.get(i).getY());
        }
    }

    public double solve(CoMHeightPartialDerivativesDataBasics comHeightPartialDerivativesDataToPack, FramePoint3DBasics queryPoint, Point2DBasics pointOnSplineToPack) {
        this.tempPoint.set((Tuple3DReadOnly)queryPoint);
        EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)this.tempPoint, (double)this.contactFrameZeroPosition.getX(), (double)this.contactFrameZeroPosition.getY(), (double)this.contactFrameOnePosition.getX(), (double)this.contactFrameOnePosition.getY(), (Point2DBasics)this.tempPoint);
        double percentAlongSegment = EuclidGeometryTools.percentageAlongLineSegment2D((double)this.tempPoint.getX(), (double)this.tempPoint.getY(), (double)this.contactFrameZeroPosition.getX(), (double)this.contactFrameZeroPosition.getY(), (double)this.contactFrameOnePosition.getX(), (double)this.contactFrameOnePosition.getY());
        queryPoint.interpolate((FrameTuple3DReadOnly)this.contactFrameZeroPosition, (FrameTuple3DReadOnly)this.contactFrameOnePosition, percentAlongSegment);
        CoMHeightTrajectoryWaypoint startWaypoint = this.waypoints.get(0);
        CoMHeightTrajectoryWaypoint endWaypoint = this.waypoints.get(this.waypoints.size() - 1);
        double xLength = Math.max(1.0, Math.abs(endWaypoint.getX() - startWaypoint.getX()));
        double length = this.contactFrameZeroPosition.distance((FramePoint3DReadOnly)this.contactFrameOnePosition);
        double splineQuery = InterpolationTools.linearInterpolate((double)startWaypoint.getX(), (double)endWaypoint.getX(), (double)percentAlongSegment);
        this.trajectoryGenerator.compute(percentAlongSegment);
        double z = this.trajectoryGenerator.getPosition();
        this.tempFramePoint.setIncludingFrame(this.referenceFrame, 0.0, 0.0, z);
        this.tempFramePoint.changeFrame(worldFrame);
        comHeightPartialDerivativesDataToPack.zero();
        comHeightPartialDerivativesDataToPack.setCoMHeight(worldFrame, this.tempFramePoint.getZ());
        pointOnSplineToPack.set(splineQuery, z);
        if (MathTools.epsilonEquals((double)xLength, (double)0.0, (double)1.0E-5) || MathTools.epsilonEquals((double)length, (double)0.0, (double)1.0E-5) || this.heightWaypoints.size() == 2) {
            this.partialDzDs.set(0.0);
            this.partialD2zDs2.set(0.0);
            this.partialD3zDs3.set(0.0);
            this.partialDsDx.set(0.0);
            this.partialDsDy.set(0.0);
            return percentAlongSegment;
        }
        double dzds = this.trajectoryGenerator.getVelocity() / xLength;
        double d2zds2 = this.trajectoryGenerator.getAcceleration() / MathTools.square((double)xLength);
        double d3zds3 = this.trajectoryGenerator.getJerk() / MathTools.pow((double)xLength, (int)3);
        this.partialDzDs.set(dzds);
        this.partialD2zDs2.set(d2zds2);
        this.partialD3zDs3.set(d3zds3);
        double dsdx = (this.contactFrameOnePosition.getX() - this.contactFrameZeroPosition.getX()) / length;
        double dsdy = (this.contactFrameOnePosition.getY() - this.contactFrameZeroPosition.getY()) / length;
        this.partialDsDx.set(dsdx);
        this.partialDsDy.set(dsdy);
        double d2sdx2 = 0.0;
        double d2sdy2 = 0.0;
        double d2sdxdy = 0.0;
        double d3sdx3 = 0.0;
        double d3sdy3 = 0.0;
        double d3sdx2dy = 0.0;
        double d3sdxdy2 = 0.0;
        double dzdx = dsdx * dzds;
        double dzdy = dsdy * dzds;
        double d2zdx2 = dzds * d2sdx2 + d2zds2 * dsdx * dsdx;
        double d2zdy2 = dzds * d2sdy2 + d2zds2 * dsdy * dsdy;
        double d2zdxdy = d2zds2 * dsdx * dsdy + dzds * d2sdxdy;
        double d3zdx3 = d3zds3 * dsdx * dsdx * dsdx + 3.0 * d2zds2 * dsdx * d2sdx2 + dzds * d3sdx3;
        double d3zdy3 = d3zds3 * dsdy * dsdy * dsdy + 3.0 * d2zds2 * dsdy * d2sdy2 + dzds * d3sdy3;
        double d3zdx2dy = d3zds3 * dsdx * dsdx * dsdy + 2.0 * d2zds2 * dsdx * d2sdxdy + d2zds2 * d2sdx2 * dsdy + dzds * d3sdx2dy;
        double d3zdxdy2 = d3zds3 * dsdx * dsdy * dsdy + 2.0 * d2zds2 * dsdy * d2sdxdy + d2zds2 * dsdx * d2sdy2 + dzds * d3sdxdy2;
        comHeightPartialDerivativesDataToPack.setPartialDzDx(dzdx);
        comHeightPartialDerivativesDataToPack.setPartialDzDy(dzdy);
        comHeightPartialDerivativesDataToPack.setPartialD2zDxDy(d2zdxdy);
        comHeightPartialDerivativesDataToPack.setPartialD2zDx2(d2zdx2);
        comHeightPartialDerivativesDataToPack.setPartialD2zDy2(d2zdy2);
        comHeightPartialDerivativesDataToPack.setPartialD3zDx3(d3zdx3);
        comHeightPartialDerivativesDataToPack.setPartialD3zDy3(d3zdy3);
        comHeightPartialDerivativesDataToPack.setPartialD3zDx2Dy(d3zdx2dy);
        comHeightPartialDerivativesDataToPack.setPartialD3zDxDy2(d3zdxdy2);
        return percentAlongSegment;
    }

    public double getHeightSplineSetpoint() {
        return this.trajectoryGenerator.getPosition();
    }
}

