/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicReachability;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.configurations.DynamicReachabilityParameters;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolver;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.matrixlib.MatrixTools;

public class TimeAdjustmentSolver {
    private static final int currentInitialTransferIndex = 0;
    private static final int currentEndTransferIndex = 1;
    private static final int currentInitialSwingIndex = 2;
    private static final int currentEndSwingIndex = 3;
    private static final int nextInitialTransferIndex = 4;
    private static final int nextEndTransferIndex = 5;
    private final JavaQuadProgSolver javaSolver = new JavaQuadProgSolver();
    private final DynamicReachabilityParameters dynamicReachabilityParameters;
    private final double minimumInitialTransferDuration;
    private final double minimumEndTransferDuration;
    private final double minimumInitialSwingDuration;
    private final double minimumEndSwingDuration;
    private final double minimumTransferDuration;
    private final double maximumTransferDuration;
    private final double minimumSwingDuration;
    private final double maximumSwingDuration;
    private double desiredParallelAdjustment;
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_h;
    private final DMatrixRMaj segmentAdjustmentObjective_H;
    private final DMatrixRMaj stepAdjustmentObjective_H;
    private final DMatrixRMaj perpendicularObjective_H;
    private final DMatrixRMaj parallelObjective_H;
    private final DMatrixRMaj parallelObjective_h;
    private final DMatrixRMaj equalAdjustmentObjective_H;
    private final DMatrixRMaj parallel_J;
    private final DMatrixRMaj perpendicular_J;
    private final DMatrixRMaj equalAdjustment_J;
    private final DMatrixRMaj tempTrans_J;
    private final DMatrixRMaj solverInput_Ain;
    private final DMatrixRMaj solverInput_bin;
    private final DMatrixRMaj solution;
    private final boolean useHigherOrderSteps;
    private int numberOfFootstepsToConsider;
    private int numberOfFootstepsRegistered;
    private int numberOfHigherSteps;
    private int numberOfIterations;

    public TimeAdjustmentSolver(int maxNumberOfFootstepsToConsider, DynamicReachabilityParameters dynamicReachabilityParameters) {
        this.dynamicReachabilityParameters = dynamicReachabilityParameters;
        this.useHigherOrderSteps = dynamicReachabilityParameters.useHigherOrderSteps();
        this.minimumInitialTransferDuration = dynamicReachabilityParameters.getMinimumInitialTransferDuration();
        this.minimumEndTransferDuration = dynamicReachabilityParameters.getMinimumEndTransferDuration();
        this.minimumInitialSwingDuration = dynamicReachabilityParameters.getMinimumInitialSwingDuration();
        this.minimumEndSwingDuration = dynamicReachabilityParameters.getMinimumEndSwingDuration();
        this.minimumTransferDuration = dynamicReachabilityParameters.getMinimumTransferDuration();
        this.maximumTransferDuration = dynamicReachabilityParameters.getMaximumTransferDuration();
        this.minimumSwingDuration = dynamicReachabilityParameters.getMinimumSwingDuration();
        this.maximumSwingDuration = dynamicReachabilityParameters.getMaximumSwingDuration();
        int problemSize = 6 + 2 * (maxNumberOfFootstepsToConsider - 3);
        this.solverInput_H = new DMatrixRMaj(problemSize, problemSize);
        this.solverInput_h = new DMatrixRMaj(problemSize, 1);
        this.solverInput_Ain = new DMatrixRMaj(12, problemSize);
        this.solverInput_bin = new DMatrixRMaj(12, 1);
        this.solution = new DMatrixRMaj(problemSize, 1);
        this.parallel_J = new DMatrixRMaj(1, problemSize);
        this.perpendicular_J = new DMatrixRMaj(1, problemSize);
        this.equalAdjustment_J = new DMatrixRMaj(3, problemSize);
        this.tempTrans_J = new DMatrixRMaj(problemSize, problemSize);
        this.segmentAdjustmentObjective_H = new DMatrixRMaj(problemSize, problemSize);
        this.stepAdjustmentObjective_H = new DMatrixRMaj(problemSize, problemSize);
        this.perpendicularObjective_H = new DMatrixRMaj(problemSize, problemSize);
        this.equalAdjustmentObjective_H = new DMatrixRMaj(problemSize, problemSize);
        this.parallelObjective_H = new DMatrixRMaj(problemSize, problemSize);
        this.parallelObjective_h = new DMatrixRMaj(problemSize, 1);
    }

    public void setNumberOfFootstepsToConsider(int numberOfFootstepsToConsider) {
        this.numberOfFootstepsToConsider = numberOfFootstepsToConsider;
    }

    public void setNumberOfFootstepsRegistered(int numberOfFootstepsRegistered) {
        this.numberOfFootstepsRegistered = numberOfFootstepsRegistered;
    }

    public void reshape() {
        int problemSize = 6;
        if (this.numberOfFootstepsToConsider > 3 & this.numberOfFootstepsRegistered > 1 && this.useHigherOrderSteps) {
            this.numberOfHigherSteps = this.computeHigherOrderSteps();
            problemSize += 2 * this.numberOfHigherSteps;
        }
        this.solution.reshape(problemSize, 1);
        this.segmentAdjustmentObjective_H.reshape(problemSize, problemSize);
        this.stepAdjustmentObjective_H.reshape(problemSize, problemSize);
        this.perpendicularObjective_H.reshape(problemSize, problemSize);
        this.parallelObjective_H.reshape(problemSize, problemSize);
        this.equalAdjustmentObjective_H.reshape(problemSize, problemSize);
        this.parallelObjective_h.reshape(problemSize, 1);
        this.parallel_J.reshape(1, problemSize);
        this.perpendicular_J.reshape(1, problemSize);
        this.equalAdjustment_J.reshape(3, problemSize);
        this.solverInput_H.reshape(problemSize, problemSize);
        this.solverInput_h.reshape(problemSize, 1);
        this.solverInput_Ain.reshape(problemSize + 6, problemSize);
        this.solverInput_bin.reshape(problemSize + 6, 1);
        this.solution.zero();
        this.segmentAdjustmentObjective_H.zero();
        this.stepAdjustmentObjective_H.zero();
        this.perpendicularObjective_H.zero();
        this.parallelObjective_H.zero();
        this.equalAdjustmentObjective_H.zero();
        this.parallelObjective_h.zero();
        this.parallel_J.zero();
        this.perpendicular_J.zero();
        this.solverInput_H.zero();
        this.solverInput_h.zero();
        this.solverInput_Ain.zero();
        this.solverInput_bin.zero();
    }

    private int computeHigherOrderSteps() {
        if (this.useHigherOrderSteps) {
            return Math.min(this.numberOfFootstepsToConsider - 3, this.numberOfFootstepsRegistered - 1);
        }
        return 0;
    }

    public void zeroInputs() {
        this.solution.zero();
        this.segmentAdjustmentObjective_H.zero();
        this.stepAdjustmentObjective_H.zero();
        this.perpendicularObjective_H.zero();
        this.parallelObjective_H.zero();
        this.parallelObjective_h.zero();
        this.equalAdjustmentObjective_H.zero();
        this.solverInput_H.zero();
        this.solverInput_h.zero();
    }

    public void setCurrentInitialTransferGradient(FrameVector3D gradient) {
        this.setGradient(0, gradient);
    }

    public void setCurrentEndTransferGradient(FrameVector3D gradient) {
        this.setGradient(1, gradient);
    }

    public void setCurrentInitialSwingGradient(FrameVector3D gradient) {
        this.setGradient(2, gradient);
    }

    public void setCurrentEndSwingGradient(FrameVector3D gradient) {
        this.setGradient(3, gradient);
    }

    public void setNextInitialTransferGradient(FrameVector3D gradient) {
        this.setGradient(4, gradient);
    }

    public void setNextEndTransferGradient(FrameVector3D gradient) {
        this.setGradient(5, gradient);
    }

    public void setHigherSwingGradient(int higherIndex, FrameVector3D swingGradient) {
        this.setGradient(6 + 2 * higherIndex, swingGradient);
    }

    public void setHigherTransferGradient(int higherIndex, FrameVector3D transferGradient) {
        this.setGradient(7 + 2 * higherIndex, transferGradient);
    }

    private void setGradient(int colIndex, FrameVector3D gradient) {
        double parallel = gradient.getX();
        double perpendicular = gradient.getY();
        this.parallel_J.set(0, colIndex, parallel);
        this.perpendicular_J.set(0, colIndex, perpendicular);
    }

    public void setDesiredParallelAdjustment(double adjustment) {
        this.desiredParallelAdjustment = adjustment;
    }

    public void setCurrentTransferDuration(double duration, double alpha) {
        double initialDuration = alpha * duration;
        double endDuration = (1.0 - alpha) * duration;
        this.solverInput_bin.set(0, 0, -this.minimumTransferDuration + duration);
        this.solverInput_bin.set(3, 0, this.maximumTransferDuration - duration);
        this.solverInput_bin.set(6, 0, -(this.minimumInitialTransferDuration - initialDuration));
        this.solverInput_bin.set(7, 0, -(this.minimumEndTransferDuration - endDuration));
    }

    public void setCurrentSwingDuration(double duration, double alpha) {
        double initialDuration = alpha * duration;
        double endDuration = (1.0 - alpha) * duration;
        this.solverInput_bin.set(1, 0, -this.minimumSwingDuration + duration);
        this.solverInput_bin.set(4, 0, this.maximumSwingDuration - duration);
        this.solverInput_bin.set(8, 0, -(this.minimumInitialSwingDuration - initialDuration));
        this.solverInput_bin.set(9, 0, -(this.minimumEndSwingDuration - endDuration));
    }

    public void setNextTransferDuration(double duration, double alpha) {
        double initialDuration = alpha * duration;
        double endDuration = (1.0 - alpha) * duration;
        this.solverInput_bin.set(2, 0, -this.minimumTransferDuration + duration);
        this.solverInput_bin.set(5, 0, this.maximumTransferDuration - duration);
        this.solverInput_bin.set(10, 0, -(this.minimumInitialTransferDuration - initialDuration));
        this.solverInput_bin.set(11, 0, -(this.minimumEndTransferDuration - endDuration));
    }

    public void setHigherSwingDuration(int higherIndex, double duration) {
        this.solverInput_Ain.set(12 + 2 * higherIndex, 6 + 2 * higherIndex, -1.0);
        this.solverInput_bin.set(12 + 2 * higherIndex, 0, -(this.minimumSwingDuration - duration));
    }

    public void setHigherTransferDuration(int higherIndex, double duration) {
        this.solverInput_Ain.set(13 + 2 * higherIndex, 7 + 2 * higherIndex, -1.0);
        this.solverInput_bin.set(13 + 2 * higherIndex, 0, -(this.minimumTransferDuration - duration));
    }

    public void compute() throws NoConvergenceException {
        this.zeroInputs();
        double scalarCost = this.computeDesiredAdjustmentObjective();
        this.computePerpendicularAdjustmentMinimizationObjective();
        this.computeEqualAdjustmentObjective();
        this.computeTimeAdjustmentMinimizationObjective();
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.segmentAdjustmentObjective_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.stepAdjustmentObjective_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.perpendicularObjective_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.parallelObjective_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.equalAdjustmentObjective_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_h, (DMatrixD1)this.parallelObjective_h);
        this.assembleTimingConstraints();
        this.javaSolver.clear();
        this.javaSolver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_h, scalarCost);
        this.javaSolver.setLinearInequalityConstraints((DMatrix)this.solverInput_Ain, (DMatrix)this.solverInput_bin);
        this.numberOfIterations = this.javaSolver.solve((DMatrix)this.solution);
        if (MatrixTools.containsNaN((DMatrix1Row)this.solution)) {
            this.solution.zero();
            throw new NoConvergenceException(this.numberOfIterations);
        }
    }

    private double computeDesiredAdjustmentObjective() {
        double constraintWeight = this.dynamicReachabilityParameters.getConstraintWeight();
        CommonOps_DDRM.multTransA((DMatrix1Row)this.parallel_J, (DMatrix1Row)this.parallel_J, (DMatrix1Row)this.parallelObjective_H);
        CommonOps_DDRM.scale((double)constraintWeight, (DMatrixD1)this.parallelObjective_H);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.parallel_J, (DMatrixRMaj)this.parallelObjective_h);
        CommonOps_DDRM.scale((double)(-this.desiredParallelAdjustment * constraintWeight), (DMatrixD1)this.parallelObjective_h);
        return Math.pow(this.desiredParallelAdjustment, 2.0) * constraintWeight;
    }

    private void computePerpendicularAdjustmentMinimizationObjective() {
        double perpendicularWeight = this.dynamicReachabilityParameters.getPerpendicularWeight();
        CommonOps_DDRM.multTransA((DMatrix1Row)this.perpendicular_J, (DMatrix1Row)this.perpendicular_J, (DMatrix1Row)this.perpendicularObjective_H);
        CommonOps_DDRM.scale((double)perpendicularWeight, (DMatrixD1)this.perpendicularObjective_H);
    }

    private void computeEqualAdjustmentObjective() {
        double transferEqualAdjustmentWeight = this.dynamicReachabilityParameters.getTransferEqualAdjustmentWeight();
        double swingEqualAdjustmentWeight = this.dynamicReachabilityParameters.getSwingEqualAdjustmentWeight();
        this.equalAdjustment_J.set(0, 0, 1.0);
        this.equalAdjustment_J.set(0, 1, -1.0);
        this.equalAdjustment_J.set(1, 2, 1.0);
        this.equalAdjustment_J.set(1, 3, -1.0);
        this.equalAdjustment_J.set(2, 4, 1.0);
        this.equalAdjustment_J.set(2, 5, -1.0);
        this.tempTrans_J.reshape(this.equalAdjustment_J.numCols, this.equalAdjustment_J.numRows);
        this.tempTrans_J.zero();
        CommonOps_DDRM.transpose((DMatrixRMaj)this.equalAdjustment_J, (DMatrixRMaj)this.tempTrans_J);
        MatrixTools.scaleRow((double)transferEqualAdjustmentWeight, (int)0, (DMatrix1Row)this.equalAdjustment_J);
        MatrixTools.scaleRow((double)swingEqualAdjustmentWeight, (int)1, (DMatrix1Row)this.equalAdjustment_J);
        MatrixTools.scaleRow((double)transferEqualAdjustmentWeight, (int)2, (DMatrix1Row)this.equalAdjustment_J);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempTrans_J, (DMatrix1Row)this.equalAdjustment_J, (DMatrix1Row)this.equalAdjustmentObjective_H);
    }

    private void computeTimeAdjustmentMinimizationObjective() {
        double transferAdjustmentWeight = this.dynamicReachabilityParameters.getTransferAdjustmentWeight();
        double swingAdjustmentWeight = this.dynamicReachabilityParameters.getSwingAdjustmentWeight();
        double totalTransferAdjustmentWeight = this.dynamicReachabilityParameters.getTotalTransferAdjustmentWeight();
        double totalSwingAdjustmentWeight = this.dynamicReachabilityParameters.getTotalSwingAdjustmentWeight();
        this.segmentAdjustmentObjective_H.set(0, 0, transferAdjustmentWeight);
        this.segmentAdjustmentObjective_H.set(1, 1, transferAdjustmentWeight);
        this.segmentAdjustmentObjective_H.set(2, 2, swingAdjustmentWeight);
        this.segmentAdjustmentObjective_H.set(3, 3, swingAdjustmentWeight);
        this.segmentAdjustmentObjective_H.set(4, 4, transferAdjustmentWeight);
        this.segmentAdjustmentObjective_H.set(5, 5, transferAdjustmentWeight);
        for (int i = 0; i < this.numberOfHigherSteps; ++i) {
            this.segmentAdjustmentObjective_H.set(6 + 2 * i, 6 + 2 * i, swingAdjustmentWeight);
            this.segmentAdjustmentObjective_H.set(7 + 2 * i, 7 + 2 * i, transferAdjustmentWeight);
        }
        this.stepAdjustmentObjective_H.set(0, 0, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(0, 1, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(1, 0, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(1, 1, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(2, 2, totalSwingAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(2, 3, totalSwingAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(3, 2, totalSwingAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(3, 3, totalSwingAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(4, 4, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(4, 5, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(5, 4, totalTransferAdjustmentWeight);
        this.stepAdjustmentObjective_H.set(5, 5, totalTransferAdjustmentWeight);
    }

    private void assembleTimingConstraints() {
        this.solverInput_Ain.set(0, 0, -1.0);
        this.solverInput_Ain.set(0, 1, -1.0);
        this.solverInput_Ain.set(1, 2, -1.0);
        this.solverInput_Ain.set(1, 3, -1.0);
        this.solverInput_Ain.set(2, 4, -1.0);
        this.solverInput_Ain.set(2, 5, -1.0);
        this.solverInput_Ain.set(3, 0, 1.0);
        this.solverInput_Ain.set(3, 1, 1.0);
        this.solverInput_Ain.set(4, 2, 1.0);
        this.solverInput_Ain.set(4, 3, 1.0);
        this.solverInput_Ain.set(5, 4, 1.0);
        this.solverInput_Ain.set(5, 5, 1.0);
        this.solverInput_Ain.set(6, 0, -1.0);
        this.solverInput_Ain.set(7, 1, -1.0);
        this.solverInput_Ain.set(8, 2, -1.0);
        this.solverInput_Ain.set(9, 3, -1.0);
        this.solverInput_Ain.set(10, 4, -1.0);
        this.solverInput_Ain.set(11, 5, -1.0);
    }

    public double getCurrentInitialTransferAdjustment() {
        return this.solution.get(0, 0);
    }

    public double getCurrentEndTransferAdjustment() {
        return this.solution.get(1, 0);
    }

    public double getCurrentInitialSwingAdjustment() {
        return this.solution.get(2, 0);
    }

    public double getCurrentEndSwingAdjustment() {
        return this.solution.get(3, 0);
    }

    public double getNextInitialTransferAdjustment() {
        return this.solution.get(4, 0);
    }

    public double getNextEndTransferAdjustment() {
        return this.solution.get(5, 0);
    }

    public double getHigherSwingAdjustment(int higherIndex) {
        return this.solution.get(5 + 2 * (higherIndex + 1) - 1, 0);
    }

    public double getHigherTransferAdjustment(int higherIndex) {
        return this.solution.get(5 + 2 * (higherIndex + 1), 0);
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }
}

