/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicReachability;

public class SphereIntersectionTools {
    public static double computeDistanceToIntersectingPlane(double sphereSeparation, double radius1, double radius2) {
        return (Math.pow(sphereSeparation, 2.0) - Math.pow(radius2, 2.0) + Math.pow(radius1, 2.0)) / (2.0 * sphereSeparation);
    }

    public static double computeRadiusOfIntersectingPlane(double sphereSeparation, double radius1, double radius2) {
        double distanceToPlane = SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparation, radius1, radius2);
        return SphereIntersectionTools.computeEllipseMajorAxisRadius(radius1, distanceToPlane);
    }

    public static double computeDistanceToCenterOfIntersectionEllipse(double sphereSeparationX, double sphereSeparationZ, double radius1, double radius2) {
        double sphereSeparation = Math.sqrt(Math.pow(sphereSeparationX, 2.0) + Math.pow(sphereSeparationZ, 2.0));
        double angleOfSeparation = Math.atan(sphereSeparationZ / sphereSeparationX);
        return SphereIntersectionTools.computeDistanceToCenterOfIntersectionEllipseInternal(sphereSeparation, angleOfSeparation, radius1, radius2);
    }

    public static double computeDistanceToNearEdgeOfIntersectionEllipse(double sphereSeparationX, double sphereSeparationZ, double radius1, double radius2) {
        if (sphereSeparationZ == 0.0) {
            return SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparationX, radius1, radius2);
        }
        double sphereSeparation = Math.sqrt(Math.pow(sphereSeparationX, 2.0) + Math.pow(sphereSeparationZ, 2.0));
        double angleOfSeparation = Math.atan(sphereSeparationZ / sphereSeparationX);
        double distanceToPlane = SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparation, radius1, radius2);
        double horizontalDistanceToEllipse = SphereIntersectionTools.computeDistanceToCenterOfIntersectionEllipseInternal(sphereSeparation, angleOfSeparation, radius1, radius2);
        double minorAxisRadius = SphereIntersectionTools.computeEllipseMinorAxisRadius(radius1, distanceToPlane, angleOfSeparation);
        return horizontalDistanceToEllipse - minorAxisRadius;
    }

    public static double computeDistanceToFarEdgeOfIntersectionEllipse(double sphereSeparationX, double sphereSeparationZ, double radius1, double radius2) {
        if (sphereSeparationZ == 0.0) {
            return SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparationX, radius1, radius2);
        }
        double sphereSeparation = Math.sqrt(Math.pow(sphereSeparationX, 2.0) + Math.pow(sphereSeparationZ, 2.0));
        double angleOfSeparation = Math.atan(sphereSeparationZ / sphereSeparationX);
        double distanceToPlane = SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparation, radius1, radius2);
        double horizontalDistanceToEllipse = distanceToPlane * Math.cos(angleOfSeparation);
        double minorAxisRadius = SphereIntersectionTools.computeEllipseMinorAxisRadius(radius1, distanceToPlane, angleOfSeparation);
        return horizontalDistanceToEllipse + minorAxisRadius;
    }

    static double computeDistanceToCenterOfIntersectionEllipseInternal(double sphereSeparation, double angleOfSeparation, double radius1, double radius2) {
        double distanceToPlane = SphereIntersectionTools.computeDistanceToIntersectingPlane(sphereSeparation, radius1, radius2);
        return distanceToPlane * Math.cos(angleOfSeparation);
    }

    static double computeEllipseMajorAxisRadius(double sphereRadius1, double distanceToPlaneIntersection) {
        return Math.sqrt(Math.pow(sphereRadius1, 2.0) - Math.pow(distanceToPlaneIntersection, 2.0));
    }

    static double computeEllipseMinorAxisRadius(double sphereRadius1, double distanceToPlaneIntersection, double angleOfDistanceToHorizontal) {
        double majorAxisRadius = SphereIntersectionTools.computeEllipseMajorAxisRadius(sphereRadius1, distanceToPlaneIntersection);
        return SphereIntersectionTools.computeEllipseMinorAxisRadius(majorAxisRadius, angleOfDistanceToHorizontal);
    }

    static double computeEllipseMinorAxisRadius(double majorAxisRadius, double angleOfDistanceToHorizontal) {
        return majorAxisRadius * Math.sin(angleOfDistanceToHorizontal);
    }
}

