/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicReachability;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPPlannerInterface;
import us.ihmc.commonWalkingControlModules.configurations.DynamicReachabilityParameters;
import us.ihmc.commonWalkingControlModules.dynamicReachability.SphereIntersectionTools;
import us.ihmc.commonWalkingControlModules.dynamicReachability.TimeAdjustmentSolver;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.PrintTools;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.referenceFrames.TranslationReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class DynamicReachabilityCalculator {
    private static final boolean USE_CONSERVATIVE_REQUIRED_ADJUSTMENT = true;
    private static final boolean VISUALIZE = false;
    private static final boolean VISUALIZE_REACHABILITY = false;
    private static final double epsilon = 0.005;
    private static final double stanceLegLengthToeOffFactor = 1.02;
    private static final double gradientThresholdForConsideration = 0.005;
    private final double transferTwiddleSizeDuration;
    private final double swingTwiddleSizeDuration;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble requiredAdjustmentSafetyFactor = new YoDouble("requiredAdjustmentSafetyFactor", this.registry);
    private final YoDouble requiredAdjustmentFeedbackGain = new YoDouble("requiredAdjustmentFeedbackGain", this.registry);
    private final YoDouble widthOfReachableRegion = new YoDouble("widthOfReachableRegion", this.registry);
    private final YoDouble minimumLegLength = new YoDouble("minimumLegLength", this.registry);
    private final YoDouble maximumLegLength = new YoDouble("maximumLegLength", this.registry);
    private final YoDouble maximumDesiredKneeBend = new YoDouble("maximumDesiredKneeBendForReachability", this.registry);
    private final YoDouble stanceLegMinimumHeight = new YoDouble("stanceLegMinimumHeight", this.registry);
    private final YoDouble stanceLegMaximumHeight = new YoDouble("stanceLegMaximumHeight", this.registry);
    private final YoDouble swingLegMinimumHeight = new YoDouble("swingLegMinimumHeight", this.registry);
    private final YoDouble swingLegMaximumHeight = new YoDouble("swingLegMaximumHeight", this.registry);
    private final YoBoolean isStepReachable = new YoBoolean("isStepReachable", this.registry);
    private final YoBoolean isModifiedStepReachable = new YoBoolean("isModifiedStepReachable", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfTimingAdjustmentIterations", this.registry);
    private final YoInteger numberOfAdjustments = new YoInteger("numberOfCoMAdjustments", this.registry);
    private final YoInteger maximumNumberOfAdjustments = new YoInteger("maxNumberOfCoMAdjustments", this.registry);
    private final YoDouble currentTransferAdjustment = new YoDouble("currentTransferAdjustment", this.registry);
    private final YoDouble currentSwingAdjustment = new YoDouble("currentSwingAdjustment", this.registry);
    private final YoDouble nextTransferAdjustment = new YoDouble("nextTransferAdjustment", this.registry);
    private final ArrayList<YoDouble> higherSwingAdjustments = new ArrayList();
    private final ArrayList<YoDouble> higherTransferAdjustments = new ArrayList();
    private final SideDependentList<YoFramePoint3D> hipMinimumLocations = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> hipMaximumLocations = new SideDependentList();
    private final ArrayList<YoDouble> requiredParallelCoMAdjustments = new ArrayList();
    private final ArrayList<YoDouble> achievedParallelCoMAdjustments = new ArrayList();
    private final YoDouble currentTransferAlpha = new YoDouble("currentTransferAlpha", this.registry);
    private final YoDouble currentSwingAlpha = new YoDouble("currentSwingAlpha", this.registry);
    private final YoDouble nextTransferAlpha = new YoDouble("nextTransferAlpha", this.registry);
    private final ExecutionTimer reachabilityTimer = new ExecutionTimer("reachabilityTimer", this.registry);
    private final FrameVector2D currentInitialTransferGradient = new FrameVector2D(worldFrame);
    private final FrameVector2D currentEndTransferGradient = new FrameVector2D(worldFrame);
    private final FrameVector2D currentInitialSwingGradient = new FrameVector2D(worldFrame);
    private final FrameVector2D currentEndSwingGradient = new FrameVector2D(worldFrame);
    private final FrameVector2D nextInitialTransferGradient = new FrameVector2D(worldFrame);
    private final FrameVector2D nextEndTransferGradient = new FrameVector2D(worldFrame);
    private final ArrayList<FrameVector2D> higherSwingGradients = new ArrayList();
    private final ArrayList<FrameVector2D> higherTransferGradients = new ArrayList();
    private final SideDependentList<FramePoint3D> ankleLocations = new SideDependentList();
    private final SideDependentList<RigidBodyTransform> transformsFromAnkleToSole = new SideDependentList();
    private final SideDependentList<FramePoint3D> adjustedAnkleLocations = new SideDependentList();
    private final SideDependentList<FrameVector3D> hipOffsets = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> yoAnkleLocations = new SideDependentList();
    private final SideDependentList<YoFramePoint3D> yoHipLocations = new SideDependentList();
    private Footstep nextFootstep;
    private boolean isInTransfer;
    private final LineSegment1D stanceHeightLine = new LineSegment1D();
    private final LineSegment1D stepHeightLine = new LineSegment1D();
    private final ReferenceFrame predictedCoMFrame;
    private final TranslationReferenceFrame predictedPelvisFrame;
    private final SideDependentList<ReferenceFrame> predictedHipFrames = new SideDependentList();
    private final SideDependentList<Vector2dZUpFrame> stepDirectionFrames = new SideDependentList();
    private final FramePoint3D adjustedCoMPosition = new FramePoint3D();
    private final FramePoint3D predictedCoMPosition = new FramePoint3D();
    private final FrameQuaternion predictedPelvisOrientation = new FrameQuaternion();
    private final FrameQuaternion stanceFootOrientation = new FrameQuaternion();
    private final FrameQuaternion footstepAnkleOrientation = new FrameQuaternion();
    private final FrameVector3D tempGradient = new FrameVector3D();
    private final FrameVector3D tempVector = new FrameVector3D();
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final FramePoint3D tempPoint3d = new FramePoint3D();
    private final FramePoint3D tempFinalCoM = new FramePoint3D();
    private final DynamicReachabilityParameters dynamicReachabilityParameters;
    private final double thighLength;
    private final double shinLength;
    private final double maximumKneeBend;
    private final TimeAdjustmentSolver solver;
    private final ICPPlannerInterface icpPlanner;
    private final FullHumanoidRobotModel fullRobotModel;
    private final TDoubleArrayList originalTransferDurations = new TDoubleArrayList();
    private final TDoubleArrayList originalSwingDurations = new TDoubleArrayList();
    private final TDoubleArrayList originalTransferAlphas = new TDoubleArrayList();
    private final TDoubleArrayList originalSwingAlphas = new TDoubleArrayList();
    private double transferDuration;
    private double swingDuration;
    private double finalTransferDuration;
    private double nextTransferDuration;

    public DynamicReachabilityCalculator(ICPPlannerInterface icpPlanner, FullHumanoidRobotModel fullRobotModel, ReferenceFrame centerOfMassFrame, DynamicReachabilityParameters dynamicReachabilityParameters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        int i;
        this.dynamicReachabilityParameters = dynamicReachabilityParameters;
        this.icpPlanner = icpPlanner;
        this.fullRobotModel = fullRobotModel;
        this.requiredAdjustmentSafetyFactor.set(dynamicReachabilityParameters.getRequiredAdjustmentSafetyFactor());
        this.requiredAdjustmentFeedbackGain.set(dynamicReachabilityParameters.getRequiredAdjustmentFeedbackGain());
        this.transferTwiddleSizeDuration = dynamicReachabilityParameters.getPercentOfTransferDurationToCalculateGradient();
        this.swingTwiddleSizeDuration = dynamicReachabilityParameters.getPercentOfSwingDurationToCalculateGradient();
        this.maximumDesiredKneeBend.set(dynamicReachabilityParameters.getMaximumDesiredKneeBend());
        this.maximumNumberOfAdjustments.set(dynamicReachabilityParameters.getMaximumNumberOfCoMAdjustments());
        this.maximumKneeBend = Math.min(Math.min(fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.KNEE_PITCH).getJointLimitUpper(), fullRobotModel.getLegJoint((Enum)RobotSide.RIGHT, LegJointName.KNEE_PITCH).getJointLimitUpper()), 1.7);
        this.solver = new TimeAdjustmentSolver(icpPlanner.getNumberOfFootstepsToConsider(), dynamicReachabilityParameters);
        for (RobotSide robotSide : RobotSide.values) {
            this.ankleLocations.put((Enum)robotSide, (Object)new FramePoint3D());
            this.adjustedAnkleLocations.put((Enum)robotSide, (Object)new FramePoint3D());
            this.hipOffsets.put((Enum)robotSide, (Object)new FrameVector3D());
            String prefix = robotSide.getShortLowerCaseName();
            YoFramePoint3D hipMaximumLocation = new YoFramePoint3D(prefix + "PredictedHipMaximumPoint", worldFrame, this.registry);
            YoFramePoint3D hipMinimumLocation = new YoFramePoint3D(prefix + "PredictedHipMinimumPoint", worldFrame, this.registry);
            this.hipMaximumLocations.put((Enum)robotSide, (Object)hipMaximumLocation);
            this.hipMinimumLocations.put((Enum)robotSide, (Object)hipMinimumLocation);
            MovingReferenceFrame soleFrame = fullRobotModel.getSoleFrame((Enum)robotSide);
            MovingReferenceFrame ankleFrame = fullRobotModel.getFoot((Enum)robotSide).getParentJoint().getFrameAfterJoint();
            RigidBodyTransform ankleToSole = new RigidBodyTransform();
            ankleFrame.getTransformToDesiredFrame(ankleToSole, (ReferenceFrame)soleFrame);
            this.transformsFromAnkleToSole.put((Enum)robotSide, (Object)ankleToSole);
        }
        int numberOfFootstepsToConsider = icpPlanner.getNumberOfFootstepsToConsider();
        for (i = 0; i < numberOfFootstepsToConsider - 3; ++i) {
            FrameVector2D higherSwingGradient = new FrameVector2D(worldFrame);
            FrameVector2D higherTransferGradient = new FrameVector2D(worldFrame);
            this.higherSwingGradients.add(higherSwingGradient);
            this.higherTransferGradients.add(higherTransferGradient);
            YoDouble higherSwingAdjustment = new YoDouble("higherSwingAdjustment" + i, this.registry);
            YoDouble higherTransferAdjustment = new YoDouble("higherTransferAdjustment" + i, this.registry);
            this.higherSwingAdjustments.add(higherSwingAdjustment);
            this.higherTransferAdjustments.add(higherTransferAdjustment);
        }
        for (i = 0; i < dynamicReachabilityParameters.getMaximumNumberOfCoMAdjustments(); ++i) {
            this.requiredParallelCoMAdjustments.add(new YoDouble("requiredParallelCoMAdjustment" + i, this.registry));
            this.achievedParallelCoMAdjustments.add(new YoDouble("achievedParallelCoMAdjustment" + i, this.registry));
        }
        MovingReferenceFrame hipPitchFrame = fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.HIP_PITCH).getFrameAfterJoint();
        FramePoint3D hipPoint = new FramePoint3D((ReferenceFrame)hipPitchFrame);
        FramePoint3D kneePoint = new FramePoint3D((ReferenceFrame)fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.KNEE_PITCH).getFrameBeforeJoint());
        kneePoint.changeFrame((ReferenceFrame)hipPitchFrame);
        this.thighLength = hipPoint.distance((FramePoint3DReadOnly)kneePoint);
        MovingReferenceFrame kneePitchFrame = fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.KNEE_PITCH).getFrameAfterJoint();
        kneePoint.setToZero((ReferenceFrame)kneePitchFrame);
        FramePoint3D anklePoint = new FramePoint3D((ReferenceFrame)fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.ANKLE_PITCH).getFrameBeforeJoint());
        anklePoint.changeFrame((ReferenceFrame)kneePitchFrame);
        this.shinLength = kneePoint.distance((FramePoint3DReadOnly)anklePoint);
        MovingReferenceFrame pelvisFrame = fullRobotModel.getPelvis().getBodyFixedFrame();
        FramePoint3D pelvis = new FramePoint3D((ReferenceFrame)pelvisFrame);
        FramePoint3D com = new FramePoint3D(centerOfMassFrame);
        pelvis.changeFrame(centerOfMassFrame);
        FrameVector3D translationToCoM = new FrameVector3D(centerOfMassFrame);
        translationToCoM.set((FrameTuple3DReadOnly)com);
        translationToCoM.sub((FrameTuple3DReadOnly)pelvis);
        translationToCoM.changeFrame((ReferenceFrame)pelvisFrame);
        this.predictedCoMFrame = new ReferenceFrame("Predicted CoM Position", worldFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                DynamicReachabilityCalculator.this.predictedCoMPosition.changeFrame(worldFrame);
                DynamicReachabilityCalculator.this.predictedPelvisOrientation.changeFrame(worldFrame);
                transformToParent.getTranslation().set((Tuple3DReadOnly)DynamicReachabilityCalculator.this.predictedCoMPosition);
                transformToParent.getRotation().set((Orientation3DReadOnly)DynamicReachabilityCalculator.this.predictedPelvisOrientation);
            }
        };
        this.predictedPelvisFrame = new TranslationReferenceFrame("Predicted Pelvis Frame", this.predictedCoMFrame);
        this.predictedPelvisFrame.updateTranslation((Tuple3DReadOnly)translationToCoM);
        for (RobotSide robotSide : RobotSide.values) {
            FrameVector3D translationToPelvis = new FrameVector3D((ReferenceFrame)pelvisFrame);
            FramePoint3D pelvisCenter = new FramePoint3D((ReferenceFrame)pelvisFrame);
            FramePoint3D hipJoint = new FramePoint3D((ReferenceFrame)fullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH).getFrameAfterJoint());
            hipJoint.changeFrame((ReferenceFrame)pelvisFrame);
            translationToPelvis.set((FrameTuple3DReadOnly)hipJoint);
            translationToPelvis.sub((FrameTuple3DReadOnly)pelvisCenter);
            TranslationReferenceFrame predictedHipFrame = new TranslationReferenceFrame(robotSide.getShortLowerCaseName() + " Predicted Hip Frame", (ReferenceFrame)this.predictedPelvisFrame);
            predictedHipFrame.updateTranslation((Tuple3DReadOnly)translationToPelvis);
            this.predictedHipFrames.put((Enum)robotSide, (Object)predictedHipFrame);
            Vector2dZUpFrame stepDirectionFrame = new Vector2dZUpFrame(robotSide.getShortLowerCaseName() + "Step Direction Frame", worldFrame);
            this.stepDirectionFrames.put((Enum)robotSide, (Object)stepDirectionFrame);
        }
        this.updateLegLengthLimits();
        if (yoGraphicsListRegistry != null) {
            this.setupVisualizers(yoGraphicsListRegistry);
        }
        parentRegistry.addChild(this.registry);
    }

    private void setupVisualizers(YoGraphicsListRegistry yoGraphicsListRegistry) {
        YoGraphicsList yoGraphicsList = new YoGraphicsList(this.getClass().getSimpleName());
        for (RobotSide side : RobotSide.values) {
            YoFramePoint3D hipMaximumLocation = (YoFramePoint3D)this.hipMaximumLocations.get((Enum)side);
            YoFramePoint3D hipMinimumLocation = (YoFramePoint3D)this.hipMinimumLocations.get((Enum)side);
            YoGraphicPosition hipMaximumLocationViz = new YoGraphicPosition(side.getSideNameFirstLetter() + "Predicted Maximum Hip Point", hipMaximumLocation, 0.01, YoAppearance.ForestGreen());
            YoGraphicPosition hipMinimumLocationViz = new YoGraphicPosition(side.getSideNameFirstLetter() + "Predicted Minimum Hip Point", hipMinimumLocation, 0.01, YoAppearance.Blue());
            yoGraphicsList.add((YoGraphic)hipMaximumLocationViz);
            yoGraphicsList.add((YoGraphic)hipMinimumLocationViz);
        }
        yoGraphicsList.setVisible(false);
        yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
    }

    private void updateFrames(Footstep nextFootstep) {
        RobotSide swingSide = nextFootstep.getRobotSide();
        RobotSide stanceSide = swingSide.getOppositeSide();
        this.icpPlanner.getFinalDesiredCenterOfMassPosition((FramePoint3DBasics)this.tempFinalCoM);
        this.predictedCoMPosition.setToZero(worldFrame);
        this.predictedCoMPosition.set(this.tempFinalCoM);
        this.stanceFootOrientation.setToZero((ReferenceFrame)this.fullRobotModel.getFoot((Enum)stanceSide).getBodyFixedFrame());
        nextFootstep.getAnkleOrientation(this.footstepAnkleOrientation, (RigidBodyTransform)this.transformsFromAnkleToSole.get((Enum)nextFootstep.getRobotSide()));
        MovingReferenceFrame pelvisFrame = this.fullRobotModel.getPelvis().getBodyFixedFrame();
        this.stanceFootOrientation.changeFrame((ReferenceFrame)pelvisFrame);
        this.footstepAnkleOrientation.changeFrame((ReferenceFrame)pelvisFrame);
        this.predictedPelvisOrientation.setToZero((ReferenceFrame)pelvisFrame);
        this.predictedPelvisOrientation.interpolate((FrameQuaternionReadOnly)this.stanceFootOrientation, (FrameQuaternionReadOnly)this.footstepAnkleOrientation, 0.5);
        FramePoint3D stanceAnkleLocation = (FramePoint3D)this.ankleLocations.get((Enum)stanceSide);
        FramePoint3D upcomingStepLocation = (FramePoint3D)this.ankleLocations.get((Enum)swingSide);
        stanceAnkleLocation.setToZero((ReferenceFrame)this.fullRobotModel.getLegJoint((Enum)stanceSide, LegJointName.ANKLE_PITCH).getFrameAfterJoint());
        nextFootstep.getAnklePosition(upcomingStepLocation, (RigidBodyTransform)this.transformsFromAnkleToSole.get((Enum)nextFootstep.getRobotSide()));
        upcomingStepLocation.changeFrame(worldFrame);
        stanceAnkleLocation.changeFrame(worldFrame);
        this.predictedCoMFrame.update();
        this.predictedPelvisFrame.update();
        for (RobotSide robotSide : RobotSide.values) {
            ((ReferenceFrame)this.predictedHipFrames.get((Enum)robotSide)).update();
        }
    }

    private void updateLegLengthLimits() {
        this.maximumLegLength.set(this.thighLength + this.shinLength);
        double minimumLegLength = DynamicReachabilityCalculator.computeLegLength(this.thighLength, this.shinLength, this.maximumDesiredKneeBend.getDoubleValue());
        this.minimumLegLength.set(minimumLegLength);
    }

    private static double computeLegLength(double thighLength, double shinLength, double kneeAngle) {
        double minimumLegLength = Math.pow(thighLength, 2.0) + Math.pow(shinLength, 2.0) + 2.0 * thighLength * shinLength * Math.cos(kneeAngle);
        minimumLegLength = Math.sqrt(minimumLegLength);
        return minimumLegLength;
    }

    private void computeHeightLineFromStance(RobotSide supportSide, double minimumStanceLegLength, double maximumStanceLegLength) {
        double maximumHeight;
        double minimumHeight;
        FramePoint3D ankleLocation = (FramePoint3D)this.ankleLocations.get((Enum)supportSide);
        ankleLocation.changeFrame(worldFrame);
        this.tempPoint3d.set(ankleLocation);
        this.tempPoint.setToZero((ReferenceFrame)this.predictedHipFrames.get((Enum)supportSide));
        this.tempPoint.changeFrame(worldFrame);
        this.tempFinalCoM.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
        this.tempFinalCoM.changeFrame(worldFrame);
        ((YoFramePoint3D)this.hipMaximumLocations.get((Enum)supportSide)).set((FrameTuple3DReadOnly)this.tempFinalCoM);
        ((YoFramePoint3D)this.hipMinimumLocations.get((Enum)supportSide)).set((FrameTuple3DReadOnly)this.tempFinalCoM);
        double planarDistance = this.tempFinalCoM.distance((FramePoint3DReadOnly)this.tempPoint3d);
        if (planarDistance >= minimumStanceLegLength) {
            minimumHeight = 0.0;
        } else {
            minimumHeight = Math.sqrt(Math.pow(minimumStanceLegLength, 2.0) - Math.pow(planarDistance, 2.0));
            minimumHeight += ankleLocation.getZ();
        }
        if (planarDistance >= maximumStanceLegLength) {
            maximumHeight = 0.0;
        } else {
            maximumHeight = Math.sqrt(Math.pow(maximumStanceLegLength, 2.0) - Math.pow(planarDistance, 2.0));
            maximumHeight += ankleLocation.getZ();
        }
        ((YoFramePoint3D)this.hipMaximumLocations.get((Enum)supportSide)).setZ(maximumHeight);
        ((YoFramePoint3D)this.hipMinimumLocations.get((Enum)supportSide)).setZ(minimumHeight);
        this.stanceLegMinimumHeight.set(minimumHeight);
        this.stanceLegMaximumHeight.set(maximumHeight);
        this.stanceHeightLine.set(minimumHeight, maximumHeight);
    }

    private void computeHeightLineFromStep(Footstep nextFootstep, double minimumStepLegLength, double maximumStepLegLength) {
        double maximumHeight;
        double minimumHeight;
        RobotSide swingSide = nextFootstep.getRobotSide();
        FramePoint3D ankleLocation = (FramePoint3D)this.ankleLocations.get((Enum)swingSide);
        ankleLocation.changeFrame(worldFrame);
        this.tempPoint3d.set(ankleLocation);
        this.tempPoint.setToZero((ReferenceFrame)this.predictedHipFrames.get((Enum)swingSide));
        this.tempPoint.changeFrame(worldFrame);
        this.tempFinalCoM.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
        double planarDistance = this.tempFinalCoM.distance((FramePoint3DReadOnly)this.tempPoint3d);
        this.tempFinalCoM.changeFrame(worldFrame);
        ankleLocation.changeFrame(worldFrame);
        ((YoFramePoint3D)this.hipMaximumLocations.get((Enum)swingSide)).set((FrameTuple3DReadOnly)this.tempFinalCoM);
        ((YoFramePoint3D)this.hipMinimumLocations.get((Enum)swingSide)).set((FrameTuple3DReadOnly)this.tempFinalCoM);
        if (planarDistance >= minimumStepLegLength) {
            minimumHeight = 0.0;
        } else {
            minimumHeight = Math.sqrt(Math.pow(minimumStepLegLength, 2.0) - Math.pow(planarDistance, 2.0));
            minimumHeight += ankleLocation.getZ();
        }
        if (planarDistance >= maximumStepLegLength) {
            maximumHeight = 0.0;
        } else {
            maximumHeight = Math.sqrt(Math.pow(maximumStepLegLength, 2.0) - Math.pow(planarDistance, 2.0));
            maximumHeight += ankleLocation.getZ();
        }
        ((YoFramePoint3D)this.hipMaximumLocations.get((Enum)swingSide)).setZ(maximumHeight);
        ((YoFramePoint3D)this.hipMinimumLocations.get((Enum)swingSide)).setZ(minimumHeight);
        this.swingLegMinimumHeight.set(minimumHeight);
        this.swingLegMaximumHeight.set(maximumHeight);
        this.stepHeightLine.set(minimumHeight, maximumHeight);
    }

    private void reset() {
        int i;
        this.numberOfAdjustments.set(0);
        this.originalTransferDurations.clear();
        this.originalTransferAlphas.clear();
        this.originalSwingDurations.clear();
        this.originalSwingAlphas.clear();
        this.currentTransferAdjustment.set(0.0);
        this.currentSwingAdjustment.set(0.0);
        this.nextTransferAdjustment.set(0.0);
        this.currentTransferAlpha.setToNaN();
        this.currentSwingAlpha.setToNaN();
        this.nextTransferAlpha.setToNaN();
        this.currentInitialTransferGradient.setToNaN();
        this.currentEndTransferGradient.setToNaN();
        this.currentInitialSwingGradient.setToNaN();
        this.currentEndSwingGradient.setToNaN();
        this.nextInitialTransferGradient.setToNaN();
        this.nextEndTransferGradient.setToNaN();
        for (i = 0; i < this.higherSwingAdjustments.size(); ++i) {
            this.higherSwingGradients.get(i).setToNaN();
            this.higherTransferGradients.get(i).setToNaN();
            this.higherSwingAdjustments.get(i).setToNaN();
            this.higherTransferAdjustments.get(i).setToNaN();
        }
        for (i = 0; i < this.requiredParallelCoMAdjustments.size(); ++i) {
            this.requiredParallelCoMAdjustments.get(i).setToNaN();
            this.achievedParallelCoMAdjustments.get(i).setToNaN();
        }
    }

    public void setUpcomingFootstep(Footstep nextFootstep) {
        this.nextFootstep = nextFootstep;
    }

    public void setInTransfer() {
        this.isInTransfer = true;
    }

    public void setInSwing() {
        this.isInTransfer = false;
    }

    public boolean checkReachabilityOfStep() {
        boolean isStepReachable = this.checkReachabilityInternal();
        this.isStepReachable.set(isStepReachable);
        return isStepReachable;
    }

    public void verifyAndEnsureReachability() {
        this.reachabilityTimer.startMeasurement();
        this.reset();
        boolean isStepReachable = this.checkReachabilityInternal();
        this.isStepReachable.set(isStepReachable);
        this.isModifiedStepReachable.set(isStepReachable);
        if (!isStepReachable) {
            double originalRequiredAdjustment = this.computeRequiredAdjustment();
            double requiredAdjustment = originalRequiredAdjustment;
            isStepReachable = MathTools.intervalContains((double)requiredAdjustment, (double)-0.005, (double)0.005);
            if (isStepReachable) {
                this.isStepReachable.set(true);
                this.isModifiedStepReachable.set(true);
                return;
            }
            int numberOfHigherSteps = this.computeNumberOfHigherSteps();
            for (int i = 0; i < 1 + numberOfHigherSteps; ++i) {
                this.originalTransferDurations.add(this.icpPlanner.getTransferDuration(i));
                this.originalTransferAlphas.add(this.icpPlanner.getTransferDurationAlpha(i));
                this.originalSwingDurations.add(this.icpPlanner.getSwingDuration(i));
                this.originalSwingAlphas.add(this.icpPlanner.getSwingDurationAlpha(i));
            }
            this.originalTransferDurations.add(this.icpPlanner.getTransferDuration(numberOfHigherSteps + 1));
            this.originalTransferAlphas.add(this.icpPlanner.getTransferDurationAlpha(numberOfHigherSteps + 1));
            this.computeGradients(numberOfHigherSteps);
            this.submitGradientInformationToSolver(numberOfHigherSteps);
            while (!isStepReachable && this.numberOfAdjustments.getIntegerValue() < this.maximumNumberOfAdjustments.getIntegerValue()) {
                this.solver.setDesiredParallelAdjustment(requiredAdjustment);
                this.requiredParallelCoMAdjustments.get(this.numberOfAdjustments.getIntegerValue()).set(requiredAdjustment);
                try {
                    this.solver.compute();
                    this.numberOfIterations.set(this.solver.getNumberOfIterations());
                }
                catch (NoConvergenceException e) {
                    e.printStackTrace();
                    PrintTools.warn((Object)this, (String)("Only showing the stack trace of the first " + ((Object)((Object)e)).getClass().getSimpleName() + ". This may be happening more than once. The Timing optimization solver failed on iteration " + this.numberOfAdjustments.getIntegerValue() + ", so sticking with the last solution."));
                    break;
                }
                this.extractTimingSolutionsFromSolver(numberOfHigherSteps);
                this.submitTimingAdjustmentsToPlanner(numberOfHigherSteps);
                this.initializePlan(this.tempFinalCoM);
                this.updateFrames(this.nextFootstep);
                double remainingAdjustment = this.computeRequiredAdjustment();
                isStepReachable = MathTools.intervalContains((double)remainingAdjustment, (double)-0.005, (double)0.005);
                double achievedAdjustment = Math.signum(remainingAdjustment) != Math.signum(originalRequiredAdjustment) ? (Math.signum(remainingAdjustment) < 0.0 ? originalRequiredAdjustment + this.widthOfReachableRegion.getDoubleValue() - remainingAdjustment : originalRequiredAdjustment - this.widthOfReachableRegion.getDoubleValue() + remainingAdjustment) : originalRequiredAdjustment - remainingAdjustment;
                this.achievedParallelCoMAdjustments.get(this.numberOfAdjustments.getIntegerValue()).set(achievedAdjustment);
                requiredAdjustment += this.requiredAdjustmentFeedbackGain.getDoubleValue() * (originalRequiredAdjustment - achievedAdjustment);
                this.isModifiedStepReachable.set(isStepReachable);
                this.numberOfAdjustments.increment();
            }
            this.computeTimingAdjustmentsForController(numberOfHigherSteps);
        }
        this.reachabilityTimer.stopMeasurement();
    }

    public boolean wasTimingAdjusted() {
        return this.numberOfAdjustments.getIntegerValue() > 0;
    }

    private boolean checkReachabilityInternal() {
        double minimumStanceLegLength;
        double minimumStepLegLength;
        RobotSide supportSide = this.nextFootstep.getRobotSide().getOppositeSide();
        this.updateFrames(this.nextFootstep);
        this.updateLegLengthLimits();
        double heightChange = this.computeChangeInHeight(this.nextFootstep);
        if (heightChange > this.dynamicReachabilityParameters.getThresholdForStepUp()) {
            minimumStepLegLength = DynamicReachabilityCalculator.computeLegLength(this.thighLength, this.shinLength, this.maximumKneeBend);
            minimumStanceLegLength = this.minimumLegLength.getDoubleValue();
        } else if (heightChange < this.dynamicReachabilityParameters.getThresholdForStepDown()) {
            minimumStanceLegLength = DynamicReachabilityCalculator.computeLegLength(this.thighLength, this.shinLength, this.maximumKneeBend);
            minimumStepLegLength = this.minimumLegLength.getDoubleValue();
        } else {
            minimumStanceLegLength = this.minimumLegLength.getDoubleValue();
            minimumStepLegLength = this.minimumLegLength.getDoubleValue();
        }
        this.computeHeightLineFromStance(supportSide, minimumStanceLegLength, 1.02 * this.maximumLegLength.getDoubleValue());
        this.computeHeightLineFromStep(this.nextFootstep, minimumStepLegLength, this.maximumLegLength.getDoubleValue());
        return this.stanceHeightLine.isOverlappingExclusive(this.stepHeightLine);
    }

    private double computeChangeInHeight(Footstep footstep) {
        RobotSide stanceSide = footstep.getRobotSide().getOppositeSide();
        FramePoint3D stanceAnkleLocation = (FramePoint3D)this.ankleLocations.get((Enum)stanceSide);
        FramePoint3D stepAnkleLocation = (FramePoint3D)this.ankleLocations.get((Enum)stanceSide.getOppositeSide());
        stanceAnkleLocation.changeFrame(worldFrame);
        stepAnkleLocation.changeFrame(worldFrame);
        return stepAnkleLocation.getZ() - stanceAnkleLocation.getZ();
    }

    private double computeRequiredAdjustment() {
        double minimumStanceLegLength;
        double minimumStepLegLength;
        RobotSide stepSide = this.nextFootstep.getRobotSide();
        RobotSide stanceSide = stepSide.getOppositeSide();
        ReferenceFrame stanceHipFrame = (ReferenceFrame)this.predictedHipFrames.get((Enum)stanceSide);
        ReferenceFrame stepHipFrame = (ReferenceFrame)this.predictedHipFrames.get((Enum)stepSide);
        Vector2dZUpFrame stepDirectionFrame = (Vector2dZUpFrame)((Object)this.stepDirectionFrames.get((Enum)stanceSide));
        FramePoint3D upcomingAnklePoint = (FramePoint3D)this.ankleLocations.get((Enum)stepSide);
        FramePoint3D stanceAnklePoint = (FramePoint3D)this.ankleLocations.get((Enum)stanceSide);
        FramePoint3D adjustedUpcomingAnklePoint = (FramePoint3D)this.adjustedAnkleLocations.get((Enum)stepSide);
        FramePoint3D adjustedStanceAnklePoint = (FramePoint3D)this.adjustedAnkleLocations.get((Enum)stanceSide);
        FrameVector3D stepHipVector = (FrameVector3D)this.hipOffsets.get((Enum)stepSide);
        FrameVector3D stanceHipVector = (FrameVector3D)this.hipOffsets.get((Enum)stanceSide);
        this.tempPoint.setToZero(stepHipFrame);
        this.tempPoint.changeFrame(this.predictedCoMFrame);
        stepHipVector.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
        stepHipVector.changeFrame(worldFrame);
        this.tempPoint.setToZero(stanceHipFrame);
        this.tempPoint.changeFrame(this.predictedCoMFrame);
        stanceHipVector.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
        stanceHipVector.changeFrame(worldFrame);
        adjustedUpcomingAnklePoint.setIncludingFrame((FrameTuple3DReadOnly)upcomingAnklePoint);
        adjustedUpcomingAnklePoint.changeFrame(worldFrame);
        adjustedUpcomingAnklePoint.sub((FrameTuple3DReadOnly)stepHipVector);
        adjustedStanceAnklePoint.setIncludingFrame((FrameTuple3DReadOnly)stanceAnklePoint);
        adjustedStanceAnklePoint.changeFrame(worldFrame);
        adjustedStanceAnklePoint.sub((FrameTuple3DReadOnly)stanceHipVector);
        this.tempVector.setIncludingFrame((FrameTuple3DReadOnly)adjustedUpcomingAnklePoint);
        this.tempVector.sub((FrameTuple3DReadOnly)adjustedStanceAnklePoint);
        stepDirectionFrame.setXAxis(this.tempVector);
        this.tempVector.changeFrame((ReferenceFrame)stepDirectionFrame);
        double stepHeight = this.tempVector.getZ();
        double stepDistance = this.tempVector.getX();
        if (stepHeight > this.dynamicReachabilityParameters.getThresholdForStepUp()) {
            minimumStepLegLength = DynamicReachabilityCalculator.computeLegLength(this.thighLength, this.shinLength, this.maximumKneeBend);
            minimumStanceLegLength = this.minimumLegLength.getDoubleValue();
        } else if (stepHeight < this.dynamicReachabilityParameters.getThresholdForStepDown()) {
            minimumStanceLegLength = DynamicReachabilityCalculator.computeLegLength(this.thighLength, this.shinLength, this.maximumKneeBend);
            minimumStepLegLength = this.minimumLegLength.getDoubleValue();
        } else {
            minimumStanceLegLength = this.minimumLegLength.getDoubleValue();
            minimumStepLegLength = this.minimumLegLength.getDoubleValue();
        }
        double minimumStanceHipPosition = SphereIntersectionTools.computeDistanceToCenterOfIntersectionEllipse(stepDistance, stepHeight, minimumStanceLegLength, this.maximumLegLength.getDoubleValue());
        double maximumStepHipPosition = SphereIntersectionTools.computeDistanceToCenterOfIntersectionEllipse(stepDistance, stepHeight, 1.02 * this.maximumLegLength.getDoubleValue(), minimumStepLegLength);
        this.tempPoint.setToZero(this.predictedCoMFrame);
        this.tempPoint.changeFrame(worldFrame);
        this.tempPoint.sub((FrameTuple3DReadOnly)adjustedStanceAnklePoint);
        this.tempPoint.changeFrame((ReferenceFrame)stepDirectionFrame);
        this.widthOfReachableRegion.set(maximumStepHipPosition);
        this.widthOfReachableRegion.sub(minimumStanceHipPosition);
        double safetyMultiplier = this.requiredAdjustmentSafetyFactor.getDoubleValue();
        double requiredAdjustment = this.tempPoint.getX() > maximumStepHipPosition ? maximumStepHipPosition - this.tempPoint.getX() - safetyMultiplier * this.widthOfReachableRegion.getDoubleValue() : (this.tempPoint.getX() < minimumStanceHipPosition ? minimumStanceHipPosition - this.tempPoint.getX() + safetyMultiplier * this.widthOfReachableRegion.getDoubleValue() : 0.0);
        return requiredAdjustment;
    }

    private int computeNumberOfHigherSteps() {
        if (this.dynamicReachabilityParameters.useHigherOrderSteps()) {
            int numberOfFootstepsToConsider = this.icpPlanner.getNumberOfFootstepsToConsider();
            int numberOfFootstepsRegistered = this.icpPlanner.getNumberOfFootstepsRegistered();
            return Math.min(numberOfFootstepsToConsider - 3, numberOfFootstepsRegistered - 1);
        }
        return 0;
    }

    private void extractTimingSolutionsFromSolver(int numberOfHigherSteps) {
        double currentInitialTransferAdjustment = this.solver.getCurrentInitialTransferAdjustment();
        double currentEndTransferAdjustment = this.solver.getCurrentEndTransferAdjustment();
        double currentInitialTransferDuration = this.originalTransferAlphas.get(0) * this.originalTransferDurations.get(0);
        double currentEndTransferDuration = (1.0 - this.originalTransferAlphas.get(0)) * this.originalTransferDurations.get(0);
        this.currentTransferAdjustment.set(currentInitialTransferAdjustment + currentEndTransferAdjustment);
        this.currentTransferAlpha.set((currentInitialTransferDuration += currentInitialTransferAdjustment) / (currentInitialTransferDuration + (currentEndTransferDuration += currentEndTransferAdjustment)));
        double currentInitialSwingAdjustment = this.solver.getCurrentInitialSwingAdjustment();
        double currentEndSwingAdjustment = this.solver.getCurrentEndSwingAdjustment();
        double currentSwingInitialDuration = this.originalSwingAlphas.get(0) * this.originalSwingDurations.get(0);
        double currentSwingEndDuration = (1.0 - this.originalSwingAlphas.get(0)) * this.originalSwingDurations.get(0);
        this.currentSwingAdjustment.set(currentInitialSwingAdjustment + currentEndSwingAdjustment);
        this.currentSwingAlpha.set((currentSwingInitialDuration += currentInitialSwingAdjustment) / (currentSwingInitialDuration + (currentSwingEndDuration += currentEndSwingAdjustment)));
        double nextInitialTransferAdjustment = this.solver.getNextInitialTransferAdjustment();
        double nextEndTransferAdjustment = this.solver.getNextEndTransferAdjustment();
        double nextInitialTransferDuration = this.originalTransferAlphas.get(1) * this.originalTransferDurations.get(1);
        double nextEndTransferDuration = (1.0 - this.originalTransferAlphas.get(1)) * this.originalTransferDurations.get(1);
        this.nextTransferAdjustment.set(nextInitialTransferAdjustment + nextEndTransferAdjustment);
        this.nextTransferAlpha.set((nextInitialTransferDuration += nextInitialTransferAdjustment) / (nextInitialTransferDuration + (nextEndTransferDuration += nextEndTransferAdjustment)));
        for (int i = 0; i < numberOfHigherSteps; ++i) {
            double higherSwingAdjustment = this.solver.getHigherSwingAdjustment(i);
            double higherTransferAdjustment = this.solver.getHigherTransferAdjustment(i);
            this.higherSwingAdjustments.get(i).set(higherSwingAdjustment);
            this.higherTransferAdjustments.get(i).set(higherTransferAdjustment);
        }
    }

    private void submitTimingAdjustmentsToPlanner(int numberOfHigherSteps) {
        int numberOfFootstepsRegistered = this.icpPlanner.getNumberOfFootstepsRegistered();
        this.icpPlanner.setTransferDuration(0, this.originalTransferDurations.get(0) + this.currentTransferAdjustment.getDoubleValue());
        this.icpPlanner.setTransferDurationAlpha(0, this.currentTransferAlpha.getDoubleValue());
        this.icpPlanner.setSwingDuration(0, this.originalSwingDurations.get(0) + this.currentSwingAdjustment.getDoubleValue());
        this.icpPlanner.setSwingDurationAlpha(0, this.currentSwingAlpha.getDoubleValue());
        boolean isThisTheFinalTransfer = numberOfFootstepsRegistered == 1;
        double adjustedTransferDuration = this.originalTransferDurations.get(1) + this.nextTransferAdjustment.getDoubleValue();
        if (isThisTheFinalTransfer) {
            this.icpPlanner.setFinalTransferDuration(adjustedTransferDuration);
            this.icpPlanner.setFinalTransferDurationAlpha(this.nextTransferAlpha.getDoubleValue());
        } else {
            this.icpPlanner.setTransferDuration(1, adjustedTransferDuration);
            this.icpPlanner.setTransferDurationAlpha(1, this.nextTransferAlpha.getDoubleValue());
        }
        for (int i = 0; i < numberOfHigherSteps; ++i) {
            double swingDuration = this.originalSwingDurations.get(i + 1);
            double swingAdjustment = this.higherSwingAdjustments.get(i).getDoubleValue();
            this.icpPlanner.setSwingDuration(i + 1, swingDuration + swingAdjustment);
            int transferIndex = i + 2;
            double transferDuration = this.originalTransferDurations.get(transferIndex);
            double transferAdjustment = this.higherTransferAdjustments.get(i).getDoubleValue();
            boolean bl = isThisTheFinalTransfer = numberOfFootstepsRegistered == transferIndex;
            if (isThisTheFinalTransfer) {
                this.icpPlanner.setFinalTransferDuration(transferDuration + transferAdjustment);
                continue;
            }
            this.icpPlanner.setTransferDuration(transferIndex, transferDuration + transferAdjustment);
        }
    }

    private void computeTimingAdjustmentsForController(int numberOfHigherSteps) {
        this.finalTransferDuration = Double.NaN;
        this.nextTransferDuration = Double.NaN;
        int numberOfFootstepsRegistered = this.icpPlanner.getNumberOfFootstepsRegistered();
        this.transferDuration = this.originalTransferDurations.get(0) + this.currentTransferAdjustment.getDoubleValue();
        this.swingDuration = this.originalSwingDurations.get(0) + this.currentSwingAdjustment.getDoubleValue();
        boolean isThisTheFinalTransfer = numberOfFootstepsRegistered == 1;
        double adjustedTransferDuration = this.originalTransferDurations.get(1) + this.nextTransferAdjustment.getDoubleValue();
        if (isThisTheFinalTransfer) {
            this.finalTransferDuration = adjustedTransferDuration;
        } else {
            this.nextTransferDuration = adjustedTransferDuration;
        }
        for (int i = 0; i < numberOfHigherSteps; ++i) {
            int transferIndex = i + 2;
            double transferDuration = this.originalTransferDurations.get(transferIndex);
            double transferAdjustment = this.higherTransferAdjustments.get(i).getDoubleValue();
            boolean bl = isThisTheFinalTransfer = numberOfFootstepsRegistered == transferIndex;
            if (!isThisTheFinalTransfer) continue;
            this.finalTransferDuration = transferDuration + transferAdjustment;
        }
    }

    public double getFinalTransferDuration() {
        return this.finalTransferDuration;
    }

    public double getNextTransferDuration() {
        return this.nextTransferDuration;
    }

    public double getTransferDuration() {
        return this.transferDuration;
    }

    public double getSwingDuration() {
        return this.swingDuration;
    }

    private void computeGradients(int numberOfHigherSteps) {
        this.computeCurrentTransferGradient();
        this.computeCurrentSwingGradient();
        this.computeNextTransferGradient();
        for (int stepIndex = 0; stepIndex < numberOfHigherSteps; ++stepIndex) {
            this.computeHigherSwingGradient(stepIndex + 1);
            this.computeHigherTransferGradient(stepIndex + 2);
        }
    }

    private void computeCurrentTransferGradient() {
        int stepNumber = 0;
        double currentTransferDuration = this.originalTransferDurations.get(stepNumber);
        double currentTransferDurationAlpha = this.originalTransferAlphas.get(stepNumber);
        double currentInitialTransferDuration = currentTransferDurationAlpha * currentTransferDuration;
        double currentEndTransferDuration = (1.0 - currentTransferDurationAlpha) * currentTransferDuration;
        double variation = -this.transferTwiddleSizeDuration * currentInitialTransferDuration;
        double modifiedTransferDurationAlpha = (currentInitialTransferDuration + variation) / (currentTransferDuration + variation);
        this.submitTransferTiming(stepNumber, currentTransferDuration + variation, modifiedTransferDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.currentInitialTransferGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        variation = -this.transferTwiddleSizeDuration * currentEndTransferDuration;
        modifiedTransferDurationAlpha = 1.0 - (currentEndTransferDuration + variation) / (currentTransferDuration + variation);
        this.submitTransferTiming(stepNumber, currentTransferDuration + variation, modifiedTransferDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.currentEndTransferGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        this.submitTransferTiming(stepNumber, currentTransferDuration, currentTransferDurationAlpha);
    }

    private void computeNextTransferGradient() {
        int stepNumber = 1;
        double nextTransferDuration = this.originalTransferDurations.get(stepNumber);
        double nextTransferDurationAlpha = this.originalTransferAlphas.get(stepNumber);
        if (nextTransferDuration == 0.0) {
            this.nextEndTransferGradient.setToZero();
            this.nextInitialTransferGradient.setToZero();
            return;
        }
        double nextInitialTransferDuration = nextTransferDurationAlpha * nextTransferDuration;
        double nextEndTransferDuration = (1.0 - nextTransferDurationAlpha) * nextTransferDuration;
        double variation = -this.transferTwiddleSizeDuration * nextInitialTransferDuration;
        double modifiedTransferDurationAlpha = (nextInitialTransferDuration + variation) / (nextTransferDuration + variation);
        this.submitTransferTiming(stepNumber, nextTransferDuration + variation, modifiedTransferDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.nextInitialTransferGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        variation = -this.transferTwiddleSizeDuration * nextEndTransferDuration;
        modifiedTransferDurationAlpha = 1.0 - (nextEndTransferDuration + variation) / (nextTransferDuration + variation);
        this.submitTransferTiming(stepNumber, nextTransferDuration + variation, modifiedTransferDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.nextEndTransferGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        this.submitTransferTiming(stepNumber, nextTransferDuration, nextTransferDurationAlpha);
    }

    private void computeHigherTransferGradient(int stepIndex) {
        double originalDuration = this.originalTransferDurations.get(stepIndex);
        double variation = -this.transferTwiddleSizeDuration * originalDuration;
        this.submitTransferTiming(stepIndex, originalDuration + variation, -1.0);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.higherTransferGradients.get(stepIndex - 2).set((FrameTuple3DReadOnly)this.tempGradient);
        this.submitTransferTiming(stepIndex, originalDuration, -1.0);
    }

    private void computeCurrentSwingGradient() {
        int stepNumber = 0;
        double currentSwingDuration = this.originalSwingDurations.get(stepNumber);
        double currentSwingDurationAlpha = this.originalSwingAlphas.get(stepNumber);
        double currentInitialSwingDuration = currentSwingDurationAlpha * currentSwingDuration;
        double currentEndSwingDuration = (1.0 - currentSwingDurationAlpha) * currentSwingDuration;
        double variation = -this.swingTwiddleSizeDuration * currentInitialSwingDuration;
        double modifiedSwingDurationAlpha = (currentInitialSwingDuration + variation) / (currentSwingDuration + variation);
        this.submitSwingTiming(stepNumber, currentSwingDuration + variation, modifiedSwingDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.currentInitialSwingGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        variation = -this.swingTwiddleSizeDuration * currentEndSwingDuration;
        modifiedSwingDurationAlpha = 1.0 - (currentEndSwingDuration + variation) / (currentSwingDuration + variation);
        this.submitSwingTiming(stepNumber, currentSwingDuration + variation, modifiedSwingDurationAlpha);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.currentEndSwingGradient.set((FrameTuple3DReadOnly)this.tempGradient);
        this.submitSwingTiming(stepNumber, currentSwingDuration, currentSwingDurationAlpha);
    }

    private void computeHigherSwingGradient(int stepIndex) {
        double duration = this.originalSwingDurations.get(stepIndex);
        double variation = -this.swingTwiddleSizeDuration * duration;
        this.submitSwingTiming(stepIndex, duration + variation, -1.0);
        this.applyVariation(this.adjustedCoMPosition);
        this.computeGradient(this.predictedCoMPosition, this.adjustedCoMPosition, variation, this.tempGradient);
        this.higherSwingGradients.get(stepIndex - 1).set((FrameTuple3DReadOnly)this.tempGradient);
        this.submitSwingTiming(stepIndex, duration, -1.0);
    }

    private void submitTransferTiming(int stepNumber, double duration, double alpha) {
        boolean isThisTheFinalTransfer;
        boolean bl = isThisTheFinalTransfer = this.icpPlanner.getNumberOfFootstepsRegistered() == stepNumber;
        if (alpha != -1.0) {
            if (isThisTheFinalTransfer) {
                this.icpPlanner.setFinalTransferDurationAlpha(alpha);
            } else {
                this.icpPlanner.setTransferDurationAlpha(stepNumber, alpha);
            }
        }
        if (isThisTheFinalTransfer) {
            this.icpPlanner.setFinalTransferDuration(duration);
        } else {
            this.icpPlanner.setTransferDuration(stepNumber, duration);
        }
    }

    private void submitSwingTiming(int stepNumber, double duration, double alpha) {
        if (alpha != -1.0) {
            this.icpPlanner.setSwingDurationAlpha(stepNumber, alpha);
        }
        this.icpPlanner.setSwingDuration(stepNumber, duration);
    }

    private void applyVariation(FramePoint3D comToPack) {
        if (this.isInTransfer) {
            this.icpPlanner.computeFinalCoMPositionInTransfer();
        } else {
            this.icpPlanner.computeFinalCoMPositionInSwing();
        }
        this.icpPlanner.getFinalDesiredCenterOfMassPosition((FramePoint3DBasics)comToPack);
    }

    private void initializePlan(FramePoint3D comToPack) {
        double currentInitialTime = this.icpPlanner.getInitialTime();
        if (this.isInTransfer) {
            this.icpPlanner.initializeForTransfer(currentInitialTime);
        } else {
            this.icpPlanner.initializeForSingleSupport(currentInitialTime);
        }
        this.icpPlanner.getFinalDesiredCenterOfMassPosition((FramePoint3DBasics)comToPack);
    }

    private void computeGradient(FramePoint3D originalPosition, FramePoint3D adjustedPosition, double variation, FrameVector3D gradientToPack) {
        originalPosition.changeFrame(worldFrame);
        this.tempPoint.setToZero(worldFrame);
        this.tempPoint.set(originalPosition);
        this.tempPoint.setZ(0.0);
        gradientToPack.setToZero(worldFrame);
        gradientToPack.set((FrameTuple3DReadOnly)adjustedPosition);
        gradientToPack.sub((FrameTuple3DReadOnly)this.tempPoint);
        gradientToPack.scale(1.0 / variation);
        if (MathTools.intervalContains((double)gradientToPack.getX(), (double)0.005)) {
            gradientToPack.setX(0.0);
        }
        if (MathTools.intervalContains((double)gradientToPack.getY(), (double)0.005)) {
            gradientToPack.setY(0.0);
        }
    }

    private void submitGradientInformationToSolver(int numberOfHigherSteps) {
        RobotSide stanceSide = this.nextFootstep.getRobotSide().getOppositeSide();
        int numberOfFootstepsRegistered = this.icpPlanner.getNumberOfFootstepsRegistered();
        this.solver.setNumberOfFootstepsToConsider(this.icpPlanner.getNumberOfFootstepsToConsider());
        this.solver.setNumberOfFootstepsRegistered(numberOfFootstepsRegistered);
        this.solver.reshape();
        this.extractGradient(this.currentInitialTransferGradient, stanceSide, this.tempGradient);
        this.solver.setCurrentInitialTransferGradient(this.tempGradient);
        this.extractGradient(this.currentEndTransferGradient, stanceSide, this.tempGradient);
        this.solver.setCurrentEndTransferGradient(this.tempGradient);
        this.extractGradient(this.currentInitialSwingGradient, stanceSide, this.tempGradient);
        this.solver.setCurrentInitialSwingGradient(this.tempGradient);
        this.extractGradient(this.currentEndSwingGradient, stanceSide, this.tempGradient);
        this.solver.setCurrentEndSwingGradient(this.tempGradient);
        this.extractGradient(this.nextInitialTransferGradient, stanceSide, this.tempGradient);
        this.solver.setNextInitialTransferGradient(this.tempGradient);
        this.extractGradient(this.nextEndTransferGradient, stanceSide, this.tempGradient);
        this.solver.setNextEndTransferGradient(this.tempGradient);
        for (int i = 0; i < numberOfHigherSteps; ++i) {
            this.extractGradient(this.higherSwingGradients.get(i), stanceSide, this.tempGradient);
            this.solver.setHigherSwingGradient(i, this.tempGradient);
            this.extractGradient(this.higherTransferGradients.get(i), stanceSide, this.tempGradient);
            this.solver.setHigherTransferGradient(i, this.tempGradient);
        }
        double currentTransferDuration = this.icpPlanner.getTransferDuration(0);
        double currentTransferAlpha = this.icpPlanner.getTransferDurationAlpha(0);
        double currentSwingDuration = this.icpPlanner.getSwingDuration(0);
        double currentSwingAlpha = this.icpPlanner.getSwingDurationAlpha(0);
        double nextTransferDuration = this.icpPlanner.getTransferDuration(1);
        double nextTransferAlpha = this.icpPlanner.getTransferDurationAlpha(1);
        this.solver.setCurrentTransferDuration(currentTransferDuration, currentTransferAlpha);
        this.solver.setCurrentSwingDuration(currentSwingDuration, currentSwingAlpha);
        this.solver.setNextTransferDuration(nextTransferDuration, nextTransferAlpha);
        for (int i = 0; i < numberOfHigherSteps; ++i) {
            double swingDuration = this.icpPlanner.getSwingDuration(i + 1);
            double transferDuration = this.icpPlanner.getTransferDuration(i + 2);
            this.solver.setHigherSwingDuration(i, swingDuration);
            this.solver.setHigherTransferDuration(i, transferDuration);
        }
    }

    private void extractGradient(FrameVector2D gradientToExtract, RobotSide stanceSide, FrameVector3D gradientToPack) {
        gradientToPack.setToZero(worldFrame);
        gradientToPack.set((FrameTuple2DReadOnly)gradientToExtract);
        gradientToPack.changeFrame((ReferenceFrame)this.stepDirectionFrames.get((Enum)stanceSide));
    }

    private static class Vector2dZUpFrame
    extends ReferenceFrame {
        private final FrameVector2D xAxis;
        private final Vector3D x = new Vector3D();
        private final Vector3D y = new Vector3D();
        private final Vector3D z = new Vector3D();
        private final RotationMatrix rotation = new RotationMatrix();

        public Vector2dZUpFrame(String string, ReferenceFrame parentFrame) {
            super(string, parentFrame);
            this.xAxis = new FrameVector2D(parentFrame);
        }

        public void setXAxis(FrameVector3D xAxis) {
            xAxis.changeFrame(this.getParent());
            this.xAxis.set((FrameTuple3DReadOnly)xAxis);
            this.xAxis.normalize();
            this.update();
        }

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            this.x.set(this.xAxis.getX(), this.xAxis.getY(), 0.0);
            this.z.set(0.0, 0.0, 1.0);
            this.y.cross((Tuple3DReadOnly)this.z, (Tuple3DReadOnly)this.x);
            this.rotation.setColumns((Tuple3DReadOnly)this.x, (Tuple3DReadOnly)this.y, (Tuple3DReadOnly)this.z);
            transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.rotation);
        }
    }
}

