/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicReachability;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;

public class CoMIntegrationTools {
    public static void integrateCoMPositionUsingConstantCMP(double duration, double omega0, FramePoint3DReadOnly constantCMP, FramePoint3DReadOnly initialICP, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionUsingConstantCMP(0.0, duration, omega0, constantCMP, initialICP, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingConstantCMP(double duration, double omega0, FramePoint3DReadOnly constantCMP, FramePoint3DReadOnly initialICP, FramePoint2DReadOnly initialCoM, FramePoint2D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionUsingConstantCMP(0.0, duration, omega0, constantCMP, initialICP, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingConstantCMP(double initialTime, double finalTime, double omega0, FramePoint3DReadOnly constantCMP, FramePoint3DReadOnly initialICP, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)constantCMP);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)initialICP);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMToPack);
        finalCoMToPack.set((FrameTuple3DReadOnly)initialCoM);
        double timeDelta = Math.max(finalTime - initialTime, 0.0);
        if (timeDelta == 0.0) {
            return;
        }
        double xPosition = CoMIntegrationTools.integrateCoMPositionWithConstantCMP(timeDelta, omega0, initialICP.getX(), initialCoM.getX(), constantCMP.getX());
        double yPosition = CoMIntegrationTools.integrateCoMPositionWithConstantCMP(timeDelta, omega0, initialICP.getY(), initialCoM.getY(), constantCMP.getY());
        finalCoMToPack.setX(xPosition);
        finalCoMToPack.setY(yPosition);
    }

    public static void integrateCoMPositionUsingConstantCMP(double initialTime, double finalTime, double omega0, FramePoint3DReadOnly constantCMP, FramePoint3DReadOnly initialICP, FramePoint2DReadOnly initialCoM, FramePoint2D finalCoMToPack) {
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)constantCMP);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)initialICP);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMToPack);
        finalCoMToPack.set((FrameTuple2DReadOnly)initialCoM);
        double timeDelta = Math.max(finalTime - initialTime, 0.0);
        if (timeDelta == 0.0) {
            return;
        }
        double xPosition = CoMIntegrationTools.integrateCoMPositionWithConstantCMP(timeDelta, omega0, initialICP.getX(), initialCoM.getX(), constantCMP.getX());
        double yPosition = CoMIntegrationTools.integrateCoMPositionWithConstantCMP(timeDelta, omega0, initialICP.getY(), initialCoM.getY(), constantCMP.getY());
        finalCoMToPack.setX(xPosition);
        finalCoMToPack.setY(yPosition);
    }

    private static double integrateCoMPositionWithConstantCMP(double duration, double omega0, double initialICPPosition, double initialCoMPosition, double cmpPosition) {
        if (duration == 0.0) {
            return initialCoMPosition;
        }
        double position = 0.5 * Math.exp(omega0 * duration) * (initialICPPosition - cmpPosition);
        position += Math.exp(-omega0 * duration) * (initialCoMPosition - 0.5 * (initialICPPosition + cmpPosition));
        return position += cmpPosition;
    }

    public static void integrateCoMPositionFromCubicICP(double duration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionFromCubicICP(duration, omega0, polynomialFrame, xPolynomial, yPolynomial, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingCubicICP(double time, double duration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionUsingCubicICP(0.0, MathTools.clamp((double)time, (double)0.0, (double)duration), duration, omega0, polynomialFrame, xPolynomial, yPolynomial, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingCubicICP(double time, double duration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, FramePoint2DReadOnly initialCoM, FramePoint2D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionUsingCubicICP(0.0, MathTools.clamp((double)time, (double)0.0, (double)duration), duration, omega0, polynomialFrame, xPolynomial, yPolynomial, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingCubicICP(double initialTime, double finalTime, double duration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        initialCoM.checkReferenceFrameMatch(polynomialFrame);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMToPack);
        if (xPolynomial.getNumberOfCoefficients() != yPolynomial.getNumberOfCoefficients() && yPolynomial.getNumberOfCoefficients() != 4) {
            throw new RuntimeException("The number of coefficients in the polynomials are wrong!");
        }
        double integrationDuration = finalTime - initialTime;
        integrationDuration = MathTools.clamp((double)integrationDuration, (double)0.0, (double)duration);
        finalCoMToPack.set((FrameTuple3DReadOnly)initialCoM);
        if (integrationDuration == 0.0) {
            return;
        }
        double xPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getX(), integrationDuration, omega0, xPolynomial);
        double yPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getY(), integrationDuration, omega0, yPolynomial);
        finalCoMToPack.setX(xPosition);
        finalCoMToPack.setY(yPosition);
    }

    public static void integrateCoMPositionUsingCubicICP(double initialTime, double finalTime, double duration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, FramePoint2DReadOnly initialCoM, FramePoint2D finalCoMToPack) {
        initialCoM.checkReferenceFrameMatch(polynomialFrame);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMToPack);
        if (xPolynomial.getNumberOfCoefficients() != yPolynomial.getNumberOfCoefficients() && yPolynomial.getNumberOfCoefficients() != 4) {
            throw new RuntimeException("The number of coefficients in the polynomials are wrong!");
        }
        double integrationDuration = finalTime - initialTime;
        integrationDuration = MathTools.clamp((double)integrationDuration, (double)0.0, (double)duration);
        finalCoMToPack.set((FrameTuple2DReadOnly)initialCoM);
        if (integrationDuration == 0.0) {
            return;
        }
        double xPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getX(), integrationDuration, omega0, xPolynomial);
        double yPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getY(), integrationDuration, omega0, yPolynomial);
        finalCoMToPack.setX(xPosition);
        finalCoMToPack.setY(yPosition);
    }

    public static void integrateFinalCoMPositionFromCubicDCM(double segmentDuration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, YoPolynomial zPolynomial, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        CoMIntegrationTools.integrateCoMPositionUsingCubicDCM(0.0, segmentDuration, segmentDuration, omega0, polynomialFrame, xPolynomial, yPolynomial, zPolynomial, initialCoM, finalCoMToPack);
    }

    public static void integrateCoMPositionUsingCubicDCM(double initialTime, double finalTime, double segmentDuration, double omega0, ReferenceFrame polynomialFrame, YoPolynomial xPolynomial, YoPolynomial yPolynomial, YoPolynomial zPolynomial, FramePoint3DReadOnly initialCoM, FramePoint3D finalCoMToPack) {
        initialCoM.checkReferenceFrameMatch(polynomialFrame);
        initialCoM.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMToPack);
        if (xPolynomial.getNumberOfCoefficients() != yPolynomial.getNumberOfCoefficients() && yPolynomial.getNumberOfCoefficients() != zPolynomial.getNumberOfCoefficients() && zPolynomial.getNumberOfCoefficients() != 4) {
            throw new RuntimeException("The number of coefficients in the polynomials are wrong!");
        }
        double integrationDuration = finalTime - initialTime;
        integrationDuration = MathTools.clamp((double)integrationDuration, (double)0.0, (double)segmentDuration);
        double xPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getX(), integrationDuration, omega0, xPolynomial);
        double yPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getY(), integrationDuration, omega0, yPolynomial);
        double zPosition = CoMIntegrationTools.integrateCoMPositionOverPolynomial(initialCoM.getZ(), integrationDuration, omega0, zPolynomial);
        finalCoMToPack.setToZero(initialCoM.getReferenceFrame());
        finalCoMToPack.set(xPosition, yPosition, zPosition);
    }

    private static double integrateCoMPositionOverPolynomial(double initialPosition, double integrationDuration, double omega0, YoPolynomial polynomial) {
        if (integrationDuration == 0.0) {
            return initialPosition;
        }
        double position = polynomial.getCoefficient(3) * Math.pow(integrationDuration, 3.0);
        position += (polynomial.getCoefficient(2) + -3.0 / omega0 * polynomial.getCoefficient(3)) * Math.pow(integrationDuration, 2.0);
        position += (polynomial.getCoefficient(1) - 2.0 / omega0 * polynomial.getCoefficient(2) + 6.0 / Math.pow(omega0, 2.0) * polynomial.getCoefficient(3)) * integrationDuration;
        position += polynomial.getCoefficient(0) - 1.0 / omega0 * polynomial.getCoefficient(1) + 2.0 / Math.pow(omega0, 2.0) * polynomial.getCoefficient(2) - 6.0 / Math.pow(omega0, 3.0) * polynomial.getCoefficient(3);
        return position += Math.exp(-omega0 * integrationDuration) * (initialPosition - polynomial.getCoefficient(0) + 1.0 / omega0 * polynomial.getCoefficient(1) - 2.0 / Math.pow(omega0, 2.0) * polynomial.getCoefficient(2) + 6.0 / Math.pow(omega0, 3.0) * polynomial.getCoefficient(3));
    }
}

