/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;

public class SLIPTerminalCost
implements LQTrackingCostFunction<SLIPState> {
    static double qX = 1.0E10;
    static double qY = 1.0E10;
    static double qZ = 1.0E12;
    static double qThetaX = 1.0E10;
    static double qThetaY = 1.0E10;
    static double qThetaZ = 1.0E10;
    static double qXDot = 1.0E15;
    static double qYDot = 1.0E15;
    static double qZDot = 1.0E15;
    static double qThetaDotX = 1.0E10;
    static double qThetaDotY = 1.0E10;
    static double qThetaDotZ = 1.0E10;
    static double rFx = 0.0;
    static double rFy = 0.0;
    static double rFz = 0.0;
    static double rTauX = 0.0;
    static double rTauY = 0.0;
    static double rTauZ = 0.0;
    static double rXf = 100000.0;
    static double rYf = 100000.0;
    static double rK = 0.0;
    private final DMatrixRMaj Q = new DMatrixRMaj(12, 12);
    private final DMatrixRMaj R = new DMatrixRMaj(9, 9);
    private DMatrixRMaj tempStateMatrix = new DMatrixRMaj(12, 1);
    private DMatrixRMaj tempControlMatrix = new DMatrixRMaj(9, 1);
    private DMatrixRMaj tempWX = new DMatrixRMaj(12, 1);
    private DMatrixRMaj tempWU = new DMatrixRMaj(9, 1);

    public SLIPTerminalCost() {
        this.Q.set(0, 0, qX);
        this.Q.set(1, 1, qY);
        this.Q.set(2, 2, qZ);
        this.Q.set(3, 3, qThetaX);
        this.Q.set(4, 4, qThetaY);
        this.Q.set(5, 5, qThetaZ);
        this.Q.set(6, 6, qXDot);
        this.Q.set(7, 7, qYDot);
        this.Q.set(8, 8, qZDot);
        this.Q.set(9, 9, qThetaDotX);
        this.Q.set(10, 10, qThetaDotY);
        this.Q.set(11, 11, qThetaDotZ);
        this.R.set(0, 0, rFx);
        this.R.set(1, 1, rFy);
        this.R.set(2, 2, rFz);
        this.R.set(3, 3, rTauX);
        this.R.set(4, 4, rTauY);
        this.R.set(5, 5, rTauZ);
        this.R.set(6, 6, rXf);
        this.R.set(7, 7, rYf);
        this.R.set(8, 8, rK);
    }

    public double getCost(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVector, (DMatrixD1)this.tempControlMatrix);
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)this.tempWX);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)this.tempWU);
        return CommonOps_DDRM.dot((DMatrixD1)this.tempControlMatrix, (DMatrixD1)this.tempWU) + CommonOps_DDRM.dot((DMatrixD1)this.tempStateMatrix, (DMatrixD1)this.tempWX);
    }

    public void getCostStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVecotr, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVecotr, (DMatrixD1)this.tempControlMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostStateHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.Q, (DMatrixD1)matrixToPack);
    }

    public void getCostControlHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.R, (DMatrixD1)matrixToPack);
    }

    public void getCostStateGradientOfControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(9, 12);
    }

    public void getCostControlGradientOfStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(12, 9);
    }
}

