/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.ContinuousSLIPDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.ContinuousSimpleReactionDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.trajectoryOptimization.LQCostFunction;

public class SLIPModelForceTrackingCost
implements LQCostFunction<SLIPState> {
    static double qFX = 5.0;
    static double qFY = 5.0;
    static double qFZ = 5.0;
    static double qTauX = 1.0;
    static double qTauY = 1.0;
    static double qTauZ = 1.0;
    private final DMatrixRMaj Q = new DMatrixRMaj(6, 6);
    private final ContinuousSimpleReactionDynamics simpleReactionDynamics;
    private final ContinuousSLIPDynamics slipDynamics;
    private final DMatrixRMaj dynamicsError = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj stateGradientError = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj controlGradientError = new DMatrixRMaj(6, 9);
    private final DMatrixRMaj slipFunction = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj simpleReactionFunction = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj slipStateGradient = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj simpleStateGradient = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj slipControlGradient = new DMatrixRMaj(6, 9);
    private final DMatrixRMaj simpleControlGradient = new DMatrixRMaj(6, 9);
    private final DMatrixRMaj scalarCost = new DMatrixRMaj(1, 1);
    private final double pendulumMass;
    private static final Vector3D boxSize = new Vector3D(0.3, 0.3, 0.5);
    private final Vector3D inertia = new Vector3D();
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);

    public SLIPModelForceTrackingCost(double pendulumMass, double gravityZ) {
        this.pendulumMass = pendulumMass;
        this.simpleReactionDynamics = new ContinuousSimpleReactionDynamics(pendulumMass, gravityZ);
        this.slipDynamics = new ContinuousSLIPDynamics(pendulumMass, gravityZ);
        this.Q.set(0, 0, qFX);
        this.Q.set(1, 1, qFY);
        this.Q.set(2, 2, qFZ);
        this.Q.set(3, 3, qTauX);
        this.Q.set(4, 4, qTauY);
        this.Q.set(5, 5, qTauZ);
        this.inertia.setX(boxSize.getY() * boxSize.getY() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setY(boxSize.getX() * boxSize.getX() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setZ(boxSize.getX() * boxSize.getX() + boxSize.getY() * boxSize.getY());
        this.inertia.scale(pendulumMass / 12.0);
    }

    public double getCost(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants) {
        this.simpleReactionDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.simpleReactionFunction);
        this.slipDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.slipFunction);
        CommonOps_DDRM.subtract((DMatrixD1)this.simpleReactionFunction, (DMatrixD1)this.slipFunction, (DMatrixD1)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)0, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)1, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)2, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getX(), (int)3, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getY(), (int)4, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getZ(), (int)5, (DMatrix1Row)this.dynamicsError);
        this.multQuad(this.dynamicsError, this.Q, this.dynamicsError, this.scalarCost);
        return this.scalarCost.get(0);
    }

    public void getCostStateGradient(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.getNumRows() != 12 && matrixToPack.getNumCols() != 1) {
            throw new RuntimeException("Matrix control gradient is the improper size.");
        }
        this.simpleReactionDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.simpleReactionFunction);
        this.slipDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.slipFunction);
        this.simpleReactionDynamics.getDynamicsStateGradient(hybridState, stateVector, controlVector, constants, this.simpleStateGradient);
        this.slipDynamics.getDynamicsStateGradient(hybridState, stateVector, controlVector, constants, this.slipStateGradient);
        CommonOps_DDRM.subtract((DMatrixD1)this.simpleReactionFunction, (DMatrixD1)this.slipFunction, (DMatrixD1)this.dynamicsError);
        CommonOps_DDRM.subtract((DMatrixD1)this.simpleStateGradient, (DMatrixD1)this.slipStateGradient, (DMatrixD1)this.stateGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)0, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)1, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)2, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getX(), (int)3, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getY(), (int)4, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getZ(), (int)5, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)0, (DMatrix1Row)this.stateGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)1, (DMatrix1Row)this.stateGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)2, (DMatrix1Row)this.stateGradientError);
        MatrixTools.scaleRow((double)this.inertia.getX(), (int)3, (DMatrix1Row)this.stateGradientError);
        MatrixTools.scaleRow((double)this.inertia.getY(), (int)4, (DMatrix1Row)this.stateGradientError);
        MatrixTools.scaleRow((double)this.inertia.getZ(), (int)5, (DMatrix1Row)this.stateGradientError);
        this.multQuad(2.0, this.stateGradientError, this.Q, this.dynamicsError, matrixToPack);
    }

    public void getCostControlGradient(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.getNumRows() != 9 && matrixToPack.getNumCols() != 1) {
            throw new RuntimeException("Matrix control gradient is the improper size.");
        }
        this.simpleReactionDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.simpleReactionFunction);
        this.slipDynamics.getDynamics(hybridState, stateVector, controlVector, constants, this.slipFunction);
        this.simpleReactionDynamics.getDynamicsControlGradient(hybridState, stateVector, controlVector, constants, this.simpleControlGradient);
        this.slipDynamics.getDynamicsControlGradient(hybridState, stateVector, controlVector, constants, this.slipControlGradient);
        CommonOps_DDRM.subtract((DMatrixD1)this.simpleReactionFunction, (DMatrixD1)this.slipFunction, (DMatrixD1)this.dynamicsError);
        CommonOps_DDRM.subtract((DMatrixD1)this.simpleControlGradient, (DMatrixD1)this.slipControlGradient, (DMatrixD1)this.controlGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)0, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)1, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)2, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getX(), (int)3, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getY(), (int)4, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.inertia.getZ(), (int)5, (DMatrix1Row)this.dynamicsError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)0, (DMatrix1Row)this.controlGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)1, (DMatrix1Row)this.controlGradientError);
        MatrixTools.scaleRow((double)this.pendulumMass, (int)2, (DMatrix1Row)this.controlGradientError);
        MatrixTools.scaleRow((double)this.inertia.getX(), (int)3, (DMatrix1Row)this.controlGradientError);
        MatrixTools.scaleRow((double)this.inertia.getY(), (int)4, (DMatrix1Row)this.controlGradientError);
        MatrixTools.scaleRow((double)this.inertia.getZ(), (int)5, (DMatrix1Row)this.controlGradientError);
        this.multQuad(2.0, this.controlGradientError, this.Q, this.dynamicsError, matrixToPack);
    }

    public void getCostStateHessian(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.getNumRows() != 12) {
            throw new RuntimeException("Matrix state hessian has improper number of rows.");
        }
        if (matrixToPack.getNumCols() != 12) {
            throw new RuntimeException("Matrix state hessian has improper number of columns.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                double x_k = stateVector.get(0);
                double y_k = stateVector.get(1);
                double z_k = stateVector.get(2);
                double xF_k = controlVector.get(6);
                double yF_k = controlVector.get(7);
                double zF_k = constants.get(0);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double fX_k = controlVector.get(0);
                double fY_k = controlVector.get(1);
                double fZ_k = controlVector.get(2);
                double K_k = controlVector.get(8);
                double currentLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                double l3 = Math.pow(currentLength, -3.0);
                double l5 = Math.pow(currentLength, -5.0);
                double nominalPendulumLength = constants.get(1);
                double normalizedSpringCompression = nominalPendulumLength / currentLength - 1.0;
                double normalizedSpringForce = K_k * normalizedSpringCompression;
                double xForceDifference = fX_k - normalizedSpringForce * relativeX;
                double yForceDifference = fY_k - normalizedSpringForce * relativeY;
                double zForceDifference = fZ_k - normalizedSpringForce * relativeZ;
                double qFx = this.Q.get(0, 0);
                double qFy = this.Q.get(1, 1);
                double qFz = this.Q.get(2, 2);
                double qTx = this.Q.get(3, 3);
                double qTy = this.Q.get(4, 4);
                double qTz = this.Q.get(5, 5);
                double dfXdx = K_k * (nominalPendulumLength * l3 * relativeX * relativeX - normalizedSpringCompression);
                double dfYdx = K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfZdx = K_k * nominalPendulumLength * l3 * relativeX * relativeZ;
                double dfXdy = K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfYdy = K_k * (nominalPendulumLength * l3 * relativeY * relativeY - normalizedSpringCompression);
                double dfZdy = K_k * nominalPendulumLength * l3 * relativeY * relativeZ;
                double dfXdz = K_k * nominalPendulumLength * l3 * relativeX * relativeZ;
                double dfYdz = K_k * nominalPendulumLength * l3 * relativeY * relativeZ;
                double dfZdz = K_k * (nominalPendulumLength * l3 * relativeZ * relativeZ - normalizedSpringCompression);
                double dfXdxdx = 3.0 * K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * Math.pow(relativeX, 3.0) * l5;
                double dfYdxdx = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5;
                double dfZdxdx = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeZ * l5;
                double dfXdxdy = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5;
                double dfYdxdy = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5;
                double dfZdxdy = -3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfXdxdz = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeZ * l5;
                double dfYdxdz = -3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfZdxdz = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeZ * relativeZ * l5;
                double dfXdydy = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5;
                double dfYdydy = 3.0 * K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * Math.pow(relativeY, 3.0) * l5;
                double dfZdydy = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeY * relativeY * relativeZ * l5;
                double dfXdydz = -3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfYdydz = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeY * relativeY * relativeZ * l5;
                double dfZdydz = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeY * relativeZ * relativeZ * l5;
                double dfXdzdz = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeZ * relativeZ * l5;
                double dfYdzdz = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeY * relativeZ * relativeZ * l5;
                double dfZdzdz = 3.0 * K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * Math.pow(relativeZ, 3.0) * l5;
                double Jxx = 2.0 * qFx * (dfXdxdx * xForceDifference + dfXdx * dfXdx);
                Jxx += 2.0 * qFy * (dfYdxdx * yForceDifference + dfYdx * dfYdx);
                Jxx += 2.0 * qFz * (dfZdxdx * zForceDifference + dfZdx * dfZdx);
                Jxx += 2.0 * qTy * fZ_k * fZ_k + 2.0 * qTz * fY_k * fY_k;
                double Jxy = 2.0 * qFx * (dfXdxdy * xForceDifference + dfXdx * dfXdy);
                Jxy += 2.0 * qFy * (dfYdxdy * yForceDifference + dfYdx * dfYdy);
                Jxy += 2.0 * qFz * (dfZdxdy * zForceDifference + dfZdx * dfZdy);
                Jxy -= 2.0 * qTz * fY_k * fX_k;
                double Jxz = 2.0 * qFx * (dfXdxdz * xForceDifference + dfXdx * dfXdz);
                Jxz += 2.0 * qFy * (dfYdxdz * yForceDifference + dfYdx * dfYdz);
                Jxz += 2.0 * qFz * (dfZdxdz * zForceDifference + dfZdx * dfZdz);
                Jxz -= 2.0 * qTy * fZ_k * fX_k;
                double Jyy = 2.0 * qFx * (dfXdydy * xForceDifference + dfXdy * dfXdy);
                Jyy += 2.0 * qFy * (dfYdydy * yForceDifference + dfYdy * dfYdy);
                Jyy += 2.0 * qFz * (dfZdydy * zForceDifference + dfZdy * dfZdy);
                Jyy += 2.0 * qTz * fX_k * fX_k + 2.0 * qTx * fZ_k * fZ_k;
                double Jyz = 2.0 * qFx * (dfXdydz * xForceDifference + dfXdy * dfXdz);
                Jyz += 2.0 * qFy * (dfYdydz * yForceDifference + dfYdy * dfYdz);
                Jyz += 2.0 * qFz * (dfZdydz * zForceDifference + dfZdy * dfZdz);
                Jyz -= 2.0 * qTx * fZ_k * fY_k;
                double Jzz = 2.0 * qFx * (dfXdzdz * xForceDifference + dfXdz * dfXdz);
                Jzz += 2.0 * qFy * (dfYdzdz * yForceDifference + dfYdz * dfYdz);
                Jzz += 2.0 * qFz * (dfZdzdz * zForceDifference + dfZdz * dfZdz);
                Jzz += 2.0 * qTx * fY_k * fY_k + 2.0 * qTy * fX_k * fX_k;
                matrixToPack.set(0, 0, Jxx);
                matrixToPack.set(0, 1, Jxy);
                matrixToPack.set(0, 2, Jxz);
                matrixToPack.set(1, 0, Jxy);
                matrixToPack.set(1, 1, Jyy);
                matrixToPack.set(1, 2, Jyz);
                matrixToPack.set(2, 0, Jxz);
                matrixToPack.set(2, 1, Jyz);
                matrixToPack.set(2, 2, Jzz);
                break;
            }
        }
    }

    public void getCostControlHessian(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.getNumRows() != 9) {
            throw new RuntimeException("Matrix state hessian has improper number of rows.");
        }
        if (matrixToPack.getNumCols() != 9) {
            throw new RuntimeException("Matrix state hessian has improper number of columns.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                double x_k = stateVector.get(0);
                double y_k = stateVector.get(1);
                double z_k = stateVector.get(2);
                double xF_k = controlVector.get(6);
                double yF_k = controlVector.get(7);
                double zF_k = constants.get(0);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double fX_k = controlVector.get(0);
                double fY_k = controlVector.get(1);
                double fZ_k = controlVector.get(2);
                double tauX_k = controlVector.get(3);
                double tauY_k = controlVector.get(4);
                double tauZ_k = controlVector.get(5);
                double K_k = controlVector.get(8);
                double currentLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                double nominalPendulumLength = constants.get(1);
                double normalizedSpringCompression = nominalPendulumLength / currentLength - 1.0;
                double normalizedSpringForce = K_k * normalizedSpringCompression;
                double l3 = Math.pow(currentLength, -3.0);
                double l5 = Math.pow(currentLength, -5.0);
                double qFx = this.Q.get(0, 0);
                double qFy = this.Q.get(1, 1);
                double qFz = this.Q.get(2, 2);
                double qTx = this.Q.get(3, 3);
                double qTy = this.Q.get(4, 4);
                double qTz = this.Q.get(5, 5);
                double Jfxfx = 2.0 * qFx + 2.0 * qTy * relativeZ * relativeZ + 2.0 * qTz * relativeY * relativeY;
                double Jfxfy = -2.0 * qTz * relativeX * relativeY;
                double Jfxfz = -2.0 * qTy * relativeX * relativeZ;
                double Jfxtx = 0.0;
                double Jfxty = -2.0 * qTy * relativeZ;
                double Jfxtz = 2.0 * qTz * relativeY;
                double Jfxxf = 2.0 * qFz * (K_k * (nominalPendulumLength / currentLength - nominalPendulumLength * relativeX * relativeX * l3 - 1.0)) + 2.0 * qTy * relativeZ * fZ_k + 2.0 * qTz * relativeY * fY_k;
                double Jfxyf = -2.0 * qFx * (K_k * nominalPendulumLength * relativeX * relativeY * l3) + 2.0 * qTz * (-fX_k * relativeY - (tauZ_k + relativeY * fX_k - relativeX * fY_k));
                double Jfxk = -2.0 * qFx * normalizedSpringCompression * relativeX;
                double Jfyfy = 2.0 * qFy + 2.0 * qTx * relativeZ * relativeZ + 2.0 * qTz * relativeX * relativeX;
                double Jfyfz = -2.0 * qTx * relativeZ * relativeY;
                double Jfytx = 2.0 * qTx * relativeZ;
                double Jfyty = 0.0;
                double Jfytz = -2.0 * qTz * relativeX;
                double Jfyxf = -2.0 * qFy * (K_k * nominalPendulumLength * relativeX * relativeY * l3) + 2.0 * qTz * (-fY_k * relativeX + (tauZ_k + relativeY * fX_k - relativeX * fY_k));
                double Jfyyf = 2.0 * qFy * (K_k * (nominalPendulumLength / currentLength - nominalPendulumLength * relativeY * relativeY * l3 - 1.0)) + 2.0 * qTx * relativeZ * fZ_k + 2.0 * qTz * relativeX * fX_k;
                double Jfyk = -2.0 * qFy * (normalizedSpringCompression * relativeY);
                double Jfzfz = 2.0 * qFz + 2.0 * qTx * relativeY * relativeY + 2.0 * qTy * relativeX * relativeX;
                double Jfztx = -2.0 * qTx * relativeY;
                double Jfzty = 2.0 * qTy * relativeX;
                double Jfztz = 0.0;
                double Jfzxf = -2.0 * qFx * (K_k * nominalPendulumLength * relativeX * relativeZ * l3) + 2.0 * qTy * (-fZ_k * relativeX - (tauY_k - relativeZ * fX_k + relativeX * fZ_k));
                double Jfzyf = -2.0 * qFx * (K_k * nominalPendulumLength * relativeY * relativeZ * l3) + 2.0 * qTx * (-fZ_k * relativeY + (tauX_k + relativeZ * fY_k - relativeY * fZ_k));
                double Jfzk = -2.0 * qFz * (normalizedSpringCompression * relativeZ);
                double Jtxtx = 2.0 * qTx;
                double Jtxty = 0.0;
                double Jtxtz = 0.0;
                double Jtxxf = 0.0;
                double Jtxyf = 2.0 * qTx * fZ_k;
                double Jtxk = 0.0;
                double Jtyty = 2.0 * qTy;
                double Jtytz = 0.0;
                double Jtyxf = -2.0 * qTy * fZ_k;
                double Jtyyf = 0.0;
                double Jtyk = 0.0;
                double Jtztz = 2.0 * qTz;
                double Jtzxf = 2.0 * qTz * fY_k;
                double Jtzyf = -2.0 * qTz * fX_k;
                double Jtzk = 0.0;
                double xForceDifference = fX_k - normalizedSpringForce * relativeX;
                double yForceDifference = fY_k - normalizedSpringForce * relativeY;
                double zForceDifference = fZ_k - normalizedSpringForce * relativeZ;
                double dfXxf = K_k * (-nominalPendulumLength * l3 * relativeX * relativeX + normalizedSpringCompression);
                double dfYxf = -K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfZxf = -K_k * nominalPendulumLength * l3 * relativeX * relativeZ;
                double dfXyf = -K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfYyf = K_k * (-nominalPendulumLength * l3 * relativeY * relativeY + normalizedSpringCompression);
                double dfZyf = -K_k * nominalPendulumLength * l3 * relativeY * relativeZ;
                double dfXxfxf = 3.0 * K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * Math.pow(relativeX, 3.0) * l5;
                double dfYxfxf = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5;
                double dfZxfxf = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeZ * l5;
                double dfXxfyf = K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5;
                double dfYxfyf = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5;
                double dfZxfyf = -3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfXyfyf = K_k * nominalPendulumLength * relativeX * l3 - 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5;
                double dfYyfyf = 3.0 * K_k * nominalPendulumLength * relativeY * l3 - 3.0 * K_k * nominalPendulumLength * Math.pow(relativeY, 3.0) * l5;
                double dfZyfyf = K_k * nominalPendulumLength * relativeZ * l3 - 3.0 * K_k * nominalPendulumLength * relativeY * relativeY * relativeZ * l5;
                double Jxfxf = 2.0 * qFx * (dfXxfxf * xForceDifference + dfXxf * dfXxf);
                Jxfxf += 2.0 * qFy * (dfYxfxf * yForceDifference + dfYxf * dfYxf);
                Jxfxf += 2.0 * qFz * (dfZxfxf * zForceDifference + dfZxf * dfZxf);
                Jxfxf += 2.0 * qTy * fZ_k * fZ_k + 2.0 * qTz * fY_k * fY_k;
                double Jxfyf = 2.0 * qFx * (dfXxfyf * xForceDifference + dfXxf * dfXyf);
                Jxfyf += 2.0 * qFy * (dfYxfyf * yForceDifference + dfYxf * dfYyf);
                Jxfyf += 2.0 * qFz * (dfZxfyf * zForceDifference + dfZxf * dfZyf);
                Jxfyf -= 2.0 * qTz * fY_k * fX_k;
                double Jyfyf = 2.0 * qFx * (dfXyfyf * xForceDifference + dfXyf * dfXyf);
                Jyfyf += 2.0 * qFy * (dfYyfyf * yForceDifference + dfYyf * dfYyf);
                Jyfyf += 2.0 * qFz * (dfZyfyf * zForceDifference + dfZyf * dfZyf);
                Jyfyf += 2.0 * qTx * fZ_k * fZ_k + 2.0 * qTz * fX_k * fX_k;
                double Jxfk = 2.0 * qFx * ((-nominalPendulumLength * l3 * relativeX * relativeX + normalizedSpringCompression) * xForceDifference - normalizedSpringCompression * relativeX * (K_k * (-nominalPendulumLength * l3 * relativeX * relativeX + normalizedSpringCompression)));
                Jxfk += 2.0 * qFy * (-nominalPendulumLength * l3 * relativeX * relativeY * yForceDifference - normalizedSpringCompression * relativeY * (-K_k * nominalPendulumLength * l3 * relativeX * relativeY));
                Jxfk += 2.0 * qFy * (-nominalPendulumLength * l3 * relativeX * relativeZ * zForceDifference - normalizedSpringCompression * relativeZ * (-K_k * nominalPendulumLength * l3 * relativeX * relativeZ));
                double Jyfk = 2.0 * qFx * (-nominalPendulumLength * l3 * relativeX * relativeY * xForceDifference - normalizedSpringCompression * relativeX * (-K_k * nominalPendulumLength * l3 * relativeX * relativeY));
                Jyfk += 2.0 * qFy * ((-nominalPendulumLength * l3 * relativeY * relativeY + normalizedSpringCompression) * yForceDifference - normalizedSpringCompression * relativeY * (K_k * (-nominalPendulumLength * l3 * relativeY * relativeY + normalizedSpringCompression)));
                Jyfk += 2.0 * qFz * (-nominalPendulumLength * l3 * relativeY * relativeZ * zForceDifference - normalizedSpringCompression * relativeZ * (-K_k * nominalPendulumLength * l3 * relativeY * relativeZ));
                double Jkk = qFx * relativeX * relativeX + qFy * relativeY * relativeY + qFy * relativeZ * relativeZ;
                Jkk *= 2.0 * normalizedSpringCompression * normalizedSpringCompression;
                matrixToPack.set(0, 0, Jfxfx);
                matrixToPack.set(0, 1, Jfxfy);
                matrixToPack.set(0, 2, Jfxfz);
                matrixToPack.set(0, 3, Jfxtx);
                matrixToPack.set(0, 4, Jfxty);
                matrixToPack.set(0, 5, Jfxtz);
                matrixToPack.set(0, 6, Jfxxf);
                matrixToPack.set(0, 7, Jfxyf);
                matrixToPack.set(0, 8, Jfxk);
                matrixToPack.set(1, 0, Jfxfy);
                matrixToPack.set(1, 1, Jfyfy);
                matrixToPack.set(1, 2, Jfyfz);
                matrixToPack.set(1, 3, Jfytx);
                matrixToPack.set(1, 4, Jfyty);
                matrixToPack.set(1, 5, Jfytz);
                matrixToPack.set(1, 6, Jfyxf);
                matrixToPack.set(1, 7, Jfyyf);
                matrixToPack.set(1, 8, Jfyk);
                matrixToPack.set(2, 0, Jfxfz);
                matrixToPack.set(2, 1, Jfyfz);
                matrixToPack.set(2, 2, Jfzfz);
                matrixToPack.set(2, 3, Jfztx);
                matrixToPack.set(2, 4, Jfzty);
                matrixToPack.set(2, 5, Jfztz);
                matrixToPack.set(2, 6, Jfzxf);
                matrixToPack.set(2, 7, Jfzyf);
                matrixToPack.set(2, 8, Jfzk);
                matrixToPack.set(3, 0, Jfxtx);
                matrixToPack.set(3, 1, Jfytx);
                matrixToPack.set(3, 2, Jfztx);
                matrixToPack.set(3, 3, Jtxtx);
                matrixToPack.set(3, 4, Jtxty);
                matrixToPack.set(3, 5, Jtxtz);
                matrixToPack.set(3, 6, Jtxxf);
                matrixToPack.set(3, 7, Jtxyf);
                matrixToPack.set(3, 8, Jtxk);
                matrixToPack.set(4, 0, Jfxty);
                matrixToPack.set(4, 1, Jfyty);
                matrixToPack.set(4, 2, Jfzty);
                matrixToPack.set(4, 3, Jtxty);
                matrixToPack.set(4, 4, Jtyty);
                matrixToPack.set(4, 5, Jtytz);
                matrixToPack.set(4, 6, Jtyxf);
                matrixToPack.set(4, 7, Jtyyf);
                matrixToPack.set(4, 8, Jtyk);
                matrixToPack.set(5, 0, Jfxtz);
                matrixToPack.set(5, 1, Jfytz);
                matrixToPack.set(5, 2, Jfztz);
                matrixToPack.set(5, 3, Jtxtz);
                matrixToPack.set(5, 4, Jtytz);
                matrixToPack.set(5, 5, Jtztz);
                matrixToPack.set(5, 6, Jtzxf);
                matrixToPack.set(5, 7, Jtzyf);
                matrixToPack.set(5, 8, Jtzk);
                matrixToPack.set(6, 0, Jfxxf);
                matrixToPack.set(6, 1, Jfyxf);
                matrixToPack.set(6, 2, Jfzxf);
                matrixToPack.set(6, 3, Jtxxf);
                matrixToPack.set(6, 4, Jtyxf);
                matrixToPack.set(6, 5, Jtzxf);
                matrixToPack.set(6, 6, Jxfxf);
                matrixToPack.set(6, 7, Jxfyf);
                matrixToPack.set(6, 8, Jxfk);
                matrixToPack.set(7, 0, Jfxyf);
                matrixToPack.set(7, 1, Jfyyf);
                matrixToPack.set(7, 2, Jfzyf);
                matrixToPack.set(7, 3, Jtxyf);
                matrixToPack.set(7, 4, Jtyyf);
                matrixToPack.set(7, 5, Jtzyf);
                matrixToPack.set(7, 6, Jxfyf);
                matrixToPack.set(7, 7, Jyfyf);
                matrixToPack.set(7, 8, Jyfk);
                matrixToPack.set(8, 0, Jfxk);
                matrixToPack.set(8, 1, Jfyk);
                matrixToPack.set(8, 2, Jfzk);
                matrixToPack.set(8, 3, Jtxk);
                matrixToPack.set(8, 4, Jtyk);
                matrixToPack.set(8, 5, Jtzk);
                matrixToPack.set(8, 6, Jxfk);
                matrixToPack.set(8, 7, Jyfk);
                matrixToPack.set(8, 8, Jkk);
                break;
            }
        }
    }

    public void getCostStateGradientOfControlGradient(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
    }

    public void getCostControlGradientOfStateGradient(SLIPState hybridState, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.getNumRows() != 12) {
            throw new RuntimeException("The hessian has the wrong number of rows.");
        }
        if (matrixToPack.getNumCols() != 9) {
            throw new RuntimeException("The hessian has the wrong number of cols.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                double x_k = stateVector.get(0);
                double y_k = stateVector.get(1);
                double z_k = stateVector.get(2);
                double xF_k = controlVector.get(6);
                double yF_k = controlVector.get(7);
                double zF_k = constants.get(0);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double fX_k = controlVector.get(0);
                double fY_k = controlVector.get(1);
                double fZ_k = controlVector.get(2);
                double tauX_k = controlVector.get(3);
                double tauY_k = controlVector.get(4);
                double tauZ_k = controlVector.get(5);
                double K_k = controlVector.get(8);
                double currentLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                double nominalPendulumLength = constants.get(1);
                double normalizedSpringCompression = nominalPendulumLength / currentLength - 1.0;
                double normalizedSpringForce = K_k * normalizedSpringCompression;
                double l3 = Math.pow(currentLength, -3.0);
                double l5 = Math.pow(currentLength, -5.0);
                double qFx = this.Q.get(0, 0);
                double qFy = this.Q.get(1, 1);
                double qFz = this.Q.get(2, 2);
                double qTx = this.Q.get(3, 3);
                double qTy = this.Q.get(4, 4);
                double qTz = this.Q.get(5, 5);
                double xForceDifference = fX_k - normalizedSpringForce * relativeX;
                double yForceDifference = fY_k - normalizedSpringForce * relativeY;
                double zForceDifference = fZ_k - normalizedSpringForce * relativeZ;
                double dfXdx = K_k * (nominalPendulumLength * l3 * relativeX * relativeX - normalizedSpringCompression);
                double dfYdx = K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfZdx = K_k * nominalPendulumLength * l3 * relativeX * relativeZ;
                double dfXdy = K_k * nominalPendulumLength * l3 * relativeX * relativeY;
                double dfYdy = K_k * (nominalPendulumLength * l3 * relativeY * relativeY - normalizedSpringCompression);
                double dfZdy = K_k * nominalPendulumLength * l3 * relativeY * relativeZ;
                double dfXdz = K_k * nominalPendulumLength * l3 * relativeX * relativeZ;
                double dfYdz = K_k * nominalPendulumLength * l3 * relativeY * relativeZ;
                double dfZdz = K_k * (nominalPendulumLength * l3 * relativeZ * relativeZ - normalizedSpringCompression);
                double dfXdxdxf = 3.0 * K_k * nominalPendulumLength * Math.pow(relativeX, 3.0) * l5 - 3.0 * K_k * nominalPendulumLength * relativeX * l3;
                double dfYdxdxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5 - K_k * nominalPendulumLength * relativeY * l3;
                double dfZdxdxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeZ * l5 - K_k * nominalPendulumLength * relativeZ * l3;
                double dfXdxdyf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5 - K_k * nominalPendulumLength * relativeY * l3;
                double dfYdxdyf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5 - K_k * nominalPendulumLength * relativeX * l3;
                double dfZdxdyf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double Jxfx = 2.0 * qFx * (K_k * (nominalPendulumLength * l3 * relativeX * relativeX - normalizedSpringCompression)) - 2.0 * qTy * fZ_k * relativeZ - 2.0 * qTz * fY_k * relativeY;
                double Jxfy = 2.0 * qFy * K_k * nominalPendulumLength * l3 * relativeX * relativeY + 2.0 * qTz * (fY_k * relativeX - (tauZ_k + relativeY * fX_k - relativeX * fY_k));
                double Jxfz = 2.0 * qFz * K_k * nominalPendulumLength * l3 * relativeX * relativeZ + 2.0 * qTy * (fZ_k * relativeX + (tauY_k - relativeZ * fX_k + relativeX * fZ_k));
                double Jxtaux = 0.0;
                double Jxtauy = 2.0 * qTy * fZ_k;
                double Jxtauz = -2.0 * qTz * fY_k;
                double Jxxf = 2.0 * qFx * (dfXdxdxf * xForceDifference - dfXdx * dfXdx);
                Jxxf += 2.0 * qFy * (dfYdxdxf * yForceDifference - dfYdx * dfYdx);
                Jxxf += 2.0 * qFz * (dfZdxdxf * zForceDifference - dfZdx * dfZdx);
                Jxxf -= 2.0 * qTy * fZ_k * fZ_k + 2.0 * qTz * fY_k * fY_k;
                double Jxyf = 2.0 * qFx * (dfXdxdyf * xForceDifference - dfXdx * dfXdy);
                Jxyf += 2.0 * qFy * (dfYdxdyf * yForceDifference - dfYdx * dfYdy);
                Jxyf += 2.0 * qFz * (dfZdxdyf * zForceDifference - dfZdx * dfZdy);
                Jxyf += 2.0 * qTz * fX_k * fY_k;
                double Jxk = 2.0 * qFx * ((nominalPendulumLength * l3 * relativeX * relativeX - normalizedSpringCompression) * xForceDifference - dfXdx * normalizedSpringCompression * relativeX);
                Jxk += 2.0 * qFy * (nominalPendulumLength * l3 * relativeX * relativeY * yForceDifference - dfYdx * normalizedSpringCompression * relativeY);
                Jxk += 2.0 * qFz * (nominalPendulumLength * l3 * relativeX * relativeZ * zForceDifference - dfZdx * normalizedSpringCompression * relativeZ);
                double Jyfx = 2.0 * qFx * (K_k * nominalPendulumLength * l3 * relativeX * relativeY) + 2.0 * qTz * (fX_k * relativeY + (tauZ_k + relativeY * fX_k - relativeX * fY_k));
                double Jyfy = 2.0 * qFy * (K_k * (nominalPendulumLength * l3 * relativeY * relativeY - normalizedSpringCompression)) - 2.0 * qTx * fZ_k * relativeZ - 2.0 * qTz * fX_k * relativeX;
                double Jyfz = 2.0 * qFz * K_k * nominalPendulumLength * l3 * relativeY * relativeZ + 2.0 * qTx * (fZ_k * relativeY - (tauX_k + relativeZ * fY_k - relativeY * fZ_k));
                double Jytaux = -2.0 * qTx * fZ_k;
                double Jytauy = 0.0;
                double Jytauz = 2.0 * qTz * fX_k;
                double dfXdydxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeY * l5 - K_k * nominalPendulumLength * relativeY * l3;
                double dfYdydxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5 - K_k * nominalPendulumLength * relativeX * l3;
                double dfZdydxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfXdydyf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeY * l5 - K_k * nominalPendulumLength * relativeX * l3;
                double dfYdydyf = 3.0 * K_k * nominalPendulumLength * Math.pow(relativeY, 3.0) * l5 - 3.0 * K_k * nominalPendulumLength * relativeY * l3;
                double dfZdydyf = 3.0 * K_k * nominalPendulumLength * relativeY * relativeY * relativeZ * l5 - K_k * nominalPendulumLength * relativeZ * l3;
                double Jyxf = 2.0 * qFx * (dfXdydxf * xForceDifference - dfXdx * dfXdy);
                Jyxf += 2.0 * qFy * (dfYdydxf * yForceDifference - dfYdx * dfYdy);
                Jyxf += 2.0 * qFz * (dfZdydxf * zForceDifference - dfZdx * dfZdy);
                Jyxf += 2.0 * qTz * fX_k * fY_k;
                double Jyyf = 2.0 * qFx * (dfXdydyf * xForceDifference - dfXdy * dfXdy);
                Jyyf += 2.0 * qFy * (dfYdydyf * yForceDifference - dfYdy * dfYdy);
                Jyyf += 2.0 * qFz * (dfZdydyf * zForceDifference - dfZdy * dfZdy);
                Jyyf -= 2.0 * (qTx * fZ_k * fZ_k + qTz * fX_k * fX_k);
                double Jyk = 2.0 * qFx * (nominalPendulumLength * l3 * relativeX * relativeY * xForceDifference - normalizedSpringCompression * relativeX * dfXdy);
                Jyk += 2.0 * qFy * ((nominalPendulumLength * l3 * relativeY * relativeY - normalizedSpringCompression) * yForceDifference - normalizedSpringCompression * relativeY * dfYdy);
                Jyk += 2.0 * qFz * (nominalPendulumLength * l3 * relativeY * relativeZ * zForceDifference - normalizedSpringCompression * relativeZ * dfZdy);
                double Jzfx = 2.0 * qFx * (K_k * nominalPendulumLength * l3 * relativeX * relativeZ) + 2.0 * qTy * (fX_k * relativeZ - (tauY_k - relativeZ * fX_k + relativeX * fZ_k));
                double Jzfy = 2.0 * qFy * (K_k * nominalPendulumLength * l3 * relativeY * relativeZ) + 2.0 * qTx * (fY_k * relativeZ + (tauX_k + relativeZ * fY_k - relativeY * fZ_k));
                double Jzfz = 2.0 * qFz * (K_k * (nominalPendulumLength * l3 * relativeZ * relativeZ - normalizedSpringCompression)) - 2.0 * qTx * fY_k * relativeY - 2.0 * qTy * fX_k * relativeX;
                double Jztaux = 2.0 * qTx * fY_k;
                double Jztauy = -2.0 * qTy * fX_k;
                double Jztauz = 0.0;
                double dfXdzdxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeX * relativeZ * l5 - K_k * nominalPendulumLength * relativeZ * l3;
                double dfYdzdxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfZdzdxf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeZ * relativeZ * l5 - K_k * nominalPendulumLength * relativeX * l3;
                double dfXdzdyf = 3.0 * K_k * nominalPendulumLength * relativeX * relativeY * relativeZ * l5;
                double dfYdzdyf = 3.0 * K_k * nominalPendulumLength * relativeY * relativeY * relativeZ * l5 - K_k * nominalPendulumLength * relativeZ * l3;
                double dfZdzdyf = 3.0 * K_k * nominalPendulumLength * relativeZ * relativeZ * relativeY * l5 - K_k * nominalPendulumLength * relativeY * l3;
                double Jzxf = 2.0 * qFx * (dfXdzdxf * xForceDifference - dfXdx * dfXdz);
                Jzxf += 2.0 * qFy * (dfYdzdxf * yForceDifference - dfYdx * dfYdz);
                Jzxf += 2.0 * qFz * (dfZdzdxf * zForceDifference - dfZdx * dfZdz);
                Jzxf += 2.0 * qTz * fX_k * fZ_k;
                double Jzyf = 2.0 * qFx * (dfXdzdyf * xForceDifference - dfXdz * dfXdy);
                Jzyf += 2.0 * qFy * (dfYdzdyf * yForceDifference - dfYdz * dfYdy);
                Jzyf += 2.0 * qFz * (dfZdzdyf * zForceDifference - dfZdz * dfZdy);
                Jzyf += 2.0 * qTx * fY_k * fZ_k;
                double Jzk = 2.0 * qFx * (nominalPendulumLength * l3 * relativeX * relativeZ * xForceDifference - normalizedSpringCompression * relativeX * dfXdz);
                Jzk += 2.0 * qFy * (nominalPendulumLength * l3 * relativeY * relativeZ * yForceDifference - normalizedSpringCompression * relativeY * dfYdz);
                Jzk += 2.0 * qFz * ((nominalPendulumLength * l3 * relativeZ * relativeZ - normalizedSpringCompression) * zForceDifference - normalizedSpringCompression * relativeZ * dfZdz);
                matrixToPack.set(0, 0, Jxfx);
                matrixToPack.set(0, 1, Jxfy);
                matrixToPack.set(0, 2, Jxfz);
                matrixToPack.set(0, 3, Jxtaux);
                matrixToPack.set(0, 4, Jxtauy);
                matrixToPack.set(0, 5, Jxtauz);
                matrixToPack.set(0, 6, Jxxf);
                matrixToPack.set(0, 7, Jxyf);
                matrixToPack.set(0, 8, Jxk);
                matrixToPack.set(1, 0, Jyfx);
                matrixToPack.set(1, 1, Jyfy);
                matrixToPack.set(1, 2, Jyfz);
                matrixToPack.set(1, 3, Jytaux);
                matrixToPack.set(1, 4, Jytauy);
                matrixToPack.set(1, 5, Jytauz);
                matrixToPack.set(1, 6, Jyxf);
                matrixToPack.set(1, 7, Jyyf);
                matrixToPack.set(1, 8, Jyk);
                matrixToPack.set(2, 0, Jzfx);
                matrixToPack.set(2, 1, Jzfy);
                matrixToPack.set(2, 2, Jzfz);
                matrixToPack.set(2, 3, Jztaux);
                matrixToPack.set(2, 4, Jztauy);
                matrixToPack.set(2, 5, Jztauz);
                matrixToPack.set(2, 6, Jzxf);
                matrixToPack.set(2, 7, Jzyf);
                matrixToPack.set(2, 8, Jzk);
                break;
            }
        }
    }

    private void multQuad(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj d) {
        this.tempMatrix.reshape(a.numCols, b.numCols);
        CommonOps_DDRM.multTransA((DMatrix1Row)a, (DMatrix1Row)b, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempMatrix, (DMatrix1Row)c, (DMatrix1Row)d);
    }

    private void multQuad(double alpha, DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj d) {
        this.tempMatrix.reshape(a.numCols, b.numCols);
        CommonOps_DDRM.multTransA((double)alpha, (DMatrix1Row)a, (DMatrix1Row)b, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempMatrix, (DMatrix1Row)c, (DMatrix1Row)d);
    }
}

