/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.trajectoryOptimization.ContinuousHybridDynamics;

public class ContinuousSLIPDynamics
implements ContinuousHybridDynamics<SLIPState> {
    private final double pendulumMass;
    private final double gravityZ;
    private static final Vector3D boxSize = new Vector3D(0.3, 0.3, 0.5);
    private final Vector3D inertia = new Vector3D();

    public ContinuousSLIPDynamics(double pendulumMass, double gravityZ) {
        this.pendulumMass = pendulumMass;
        this.gravityZ = gravityZ;
        this.inertia.setX(boxSize.getY() * boxSize.getY() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setY(boxSize.getX() * boxSize.getX() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setZ(boxSize.getX() * boxSize.getX() + boxSize.getY() * boxSize.getY());
        this.inertia.scale(pendulumMass / 12.0);
    }

    public int getStateVectorSize() {
        return 6;
    }

    public int getControlVectorSize() {
        return 9;
    }

    public void getDynamics(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 1) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case FLIGHT: {
                matrixToPack.set(2, 0, -this.gravityZ);
                break;
            }
            case STANCE: {
                double x_k = currentState.get(0, 0);
                double y_k = currentState.get(1, 0);
                double z_k = currentState.get(2, 0);
                double fX_k = currentControl.get(0, 0);
                double fY_k = currentControl.get(1, 0);
                double fZ_k = currentControl.get(2, 0);
                double xF_k = currentControl.get(6, 0);
                double yF_k = currentControl.get(7, 0);
                double zF_k = constants.get(0, 0);
                double nominalPendulumLength = constants.get(1, 0);
                double K = currentControl.get(8, 0);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double pendulumLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                matrixToPack.set(0, 0, K / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeX);
                matrixToPack.set(1, 0, K / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeY);
                matrixToPack.set(2, 0, K / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeZ - this.gravityZ);
                matrixToPack.set(3, 0, 1.0 / this.inertia.getX() * (-relativeZ * fY_k + relativeY * fZ_k));
                matrixToPack.set(4, 0, 1.0 / this.inertia.getY() * (relativeZ * fX_k - relativeX * fZ_k));
                matrixToPack.set(5, 0, 1.0 / this.inertia.getZ() * (-relativeY * fX_k + relativeX * fY_k));
            }
        }
    }

    public void getDynamicsStateGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                double x_k = currentState.get(0, 0);
                double y_k = currentState.get(1, 0);
                double z_k = currentState.get(2, 0);
                double fX_k = currentControl.get(0, 0);
                double fY_k = currentControl.get(1, 0);
                double fZ_k = currentControl.get(2, 0);
                double xF_k = currentControl.get(6, 0);
                double yF_k = currentControl.get(7, 0);
                double K = currentControl.get(8, 0);
                double zF_k = constants.get(0, 0);
                double nominalPendulumLength = constants.get(1, 0);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double pendulumLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                matrixToPack.set(0, 0, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeX + nominalPendulumLength / pendulumLength - 1.0));
                matrixToPack.set(0, 1, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeY));
                matrixToPack.set(0, 2, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeZ));
                matrixToPack.set(1, 0, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeY));
                matrixToPack.set(1, 1, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeY * relativeY + nominalPendulumLength / pendulumLength - 1.0));
                matrixToPack.set(1, 2, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeY * relativeZ));
                matrixToPack.set(2, 0, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeZ));
                matrixToPack.set(2, 1, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeY * relativeZ));
                matrixToPack.set(2, 2, K / this.pendulumMass * (-nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeZ * relativeZ + nominalPendulumLength / pendulumLength - 1.0));
                matrixToPack.set(3, 1, 1.0 / this.inertia.getX() * fZ_k);
                matrixToPack.set(3, 2, 1.0 / this.inertia.getX() * -fY_k);
                matrixToPack.set(4, 0, 1.0 / this.inertia.getY() * -fZ_k);
                matrixToPack.set(4, 2, 1.0 / this.inertia.getY() * fX_k);
                matrixToPack.set(5, 0, 1.0 / this.inertia.getZ() * fY_k);
                matrixToPack.set(5, 1, 1.0 / this.inertia.getZ() * -fX_k);
            }
        }
    }

    public void getDynamicsControlGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 9) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                double x_k = currentState.get(0, 0);
                double y_k = currentState.get(1, 0);
                double z_k = currentState.get(2, 0);
                double xF_k = currentControl.get(6, 0);
                double yF_k = currentControl.get(7, 0);
                double fx_k = currentControl.get(0, 0);
                double fy_k = currentControl.get(1, 0);
                double fz_k = currentControl.get(2, 0);
                double K = currentControl.get(8, 0);
                double zF_k = constants.get(0, 0);
                double nominalPendulumLength = constants.get(1);
                double relativeX = x_k - xF_k;
                double relativeY = y_k - yF_k;
                double relativeZ = z_k - zF_k;
                double pendulumLength = Math.sqrt(relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ);
                matrixToPack.set(0, 6, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeX - nominalPendulumLength / pendulumLength + 1.0));
                matrixToPack.set(0, 7, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeY));
                matrixToPack.set(0, 8, 1.0 / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeX);
                matrixToPack.set(1, 6, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeY));
                matrixToPack.set(1, 7, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeY * relativeY - nominalPendulumLength / pendulumLength + 1.0));
                matrixToPack.set(1, 8, 1.0 / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeY);
                matrixToPack.set(2, 6, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeX * relativeZ));
                matrixToPack.set(2, 7, K / this.pendulumMass * (nominalPendulumLength / Math.pow(pendulumLength, 3.0) * relativeY * relativeZ));
                matrixToPack.set(2, 8, 1.0 / this.pendulumMass * (nominalPendulumLength / pendulumLength - 1.0) * relativeZ);
                matrixToPack.set(3, 1, 1.0 / this.inertia.getX() * -relativeZ);
                matrixToPack.set(3, 2, 1.0 / this.inertia.getX() * relativeY);
                matrixToPack.set(3, 7, 1.0 / this.inertia.getX() * -fz_k);
                matrixToPack.set(4, 0, 1.0 / this.inertia.getY() * relativeZ);
                matrixToPack.set(4, 2, 1.0 / this.inertia.getY() * -relativeX);
                matrixToPack.set(4, 6, 1.0 / this.inertia.getY() * fz_k);
                matrixToPack.set(5, 0, 1.0 / this.inertia.getZ() * -relativeY);
                matrixToPack.set(5, 1, 1.0 / this.inertia.getZ() * relativeX);
                matrixToPack.set(5, 6, 1.0 / this.inertia.getZ() * -fy_k);
                matrixToPack.set(5, 7, 1.0 / this.inertia.getZ() * fx_k);
            }
        }
    }
}

