/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.trajectoryOptimization.DefaultDiscreteState;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;

public class SimpleLIPMDynamics
implements DiscreteHybridDynamics<DefaultDiscreteState> {
    static final int stateVectorSize = 4;
    static final int controlVectorSize = 2;
    static final int constantVectorSize = 0;
    private double deltaT;
    private double deltaT2;
    private final double pendulumHeight;
    private final double gravityZ;

    public SimpleLIPMDynamics(double deltaT, double pendulumHeight, double gravityZ) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
        this.pendulumHeight = pendulumHeight;
        this.gravityZ = gravityZ;
    }

    public void setTimeStepSize(double deltaT) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
    }

    public int getStateVectorSize() {
        return 4;
    }

    public int getControlVectorSize() {
        return 2;
    }

    public int getConstantVectorSize() {
        return 0;
    }

    public void getNextState(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constant, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 1) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double xdot_k = currentState.get(2);
        double ydot_k = currentState.get(3);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double x_k1 = x_k + this.deltaT * xdot_k + 0.5 * this.deltaT2 * (x_k - px_k) * this.gravityZ / this.pendulumHeight;
        double y_k1 = y_k + this.deltaT * ydot_k + 0.5 * this.deltaT2 * (y_k - py_k) * this.gravityZ / this.pendulumHeight;
        double xdot_k1 = xdot_k + this.deltaT * (x_k - px_k) * this.gravityZ / this.pendulumHeight;
        double ydot_k1 = ydot_k + this.deltaT * (y_k - py_k) * this.gravityZ / this.pendulumHeight;
        matrixToPack.set(0, 0, x_k1);
        matrixToPack.set(1, 0, y_k1);
        matrixToPack.set(2, 0, xdot_k1);
        matrixToPack.set(3, 0, ydot_k1);
    }

    public void getDynamicsStateGradient(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        double value1 = 0.5 * this.deltaT2 * this.gravityZ / this.pendulumHeight;
        double value2 = this.deltaT * this.gravityZ / this.pendulumHeight;
        matrixToPack.set(0, 0, 1.0 + value1);
        matrixToPack.set(0, 2, this.deltaT);
        matrixToPack.set(1, 1, matrixToPack.get(0, 0));
        matrixToPack.set(1, 3, this.deltaT);
        matrixToPack.set(2, 0, value2);
        matrixToPack.set(2, 2, 1.0);
        matrixToPack.set(3, 1, matrixToPack.get(2, 0));
        matrixToPack.set(3, 3, 1.0);
    }

    public void getDynamicsControlGradient(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 2) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        double value2 = -this.deltaT2 * this.gravityZ / (2.0 * this.pendulumHeight);
        double value1 = -this.deltaT * this.gravityZ / this.pendulumHeight;
        matrixToPack.set(0, 0, value2);
        matrixToPack.set(1, 1, value2);
        matrixToPack.set(2, 0, value1);
        matrixToPack.set(3, 1, value1);
    }

    public void getDynamicsStateHessian(DefaultDiscreteState state, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (stateVariable >= 4) {
            throw new RuntimeException("Too big a state variable.");
        }
        matrixToPack.zero();
    }

    public void getDynamicsControlHessian(DefaultDiscreteState state, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 2) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (controlVariable >= 2) {
            throw new RuntimeException("Too big a state variable.");
        }
        matrixToPack.zero();
    }

    public void getDynamicsStateGradientOfControlGradient(DefaultDiscreteState state, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 2) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (stateVariable >= 4) {
            throw new RuntimeException("Too big a state variable.");
        }
        matrixToPack.zero();
    }

    public void getDynamicsControlGradientOfStateGradient(DefaultDiscreteState state, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 4) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (controlVariable >= 2) {
            throw new RuntimeException("Too big a control variable.");
        }
        matrixToPack.zero();
    }

    public void getContinuousAMatrix(DMatrixRMaj matrixToPack) {
        matrixToPack.set(0, 2, 1.0);
        matrixToPack.set(1, 3, 1.0);
        matrixToPack.set(2, 0, this.gravityZ / this.pendulumHeight);
        matrixToPack.set(3, 1, this.gravityZ / this.pendulumHeight);
    }

    public void getContinuousBMatrix(DMatrixRMaj matrixToPack) {
        matrixToPack.set(2, 0, -this.gravityZ / this.pendulumHeight);
        matrixToPack.set(3, 1, -this.gravityZ / this.pendulumHeight);
    }
}

