/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.SimpleLIPMDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.SimpleLIPMSimpleCostFunction;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.SimpleLIPMTerminalCostFunction;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.trajectoryOptimization.DDPSolver;
import us.ihmc.trajectoryOptimization.DefaultDiscreteState;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationData;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationTrajectory;
import us.ihmc.trajectoryOptimization.DiscreteSequence;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;

public class SimpleLIPMDDPCalculator {
    private final DiscreteHybridDynamics<DefaultDiscreteState> dynamics;
    private double deltaT;
    private double modifiedDeltaT;
    private final DiscreteOptimizationTrajectory desiredTrajectory;
    private final DiscreteSequence constants;
    private int numberOfTimeSteps;
    private final LQTrackingCostFunction<DefaultDiscreteState> costFunction;
    private final LQTrackingCostFunction<DefaultDiscreteState> terminalCostFunction;
    private final DDPSolver<DefaultDiscreteState> ddpSolver;
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final FrameVector3D tempVector = new FrameVector3D();

    public SimpleLIPMDDPCalculator(double deltaT, double mass, double gravityZ) {
        this.dynamics = new SimpleLIPMDynamics(deltaT, 1.0, gravityZ);
        this.costFunction = new SimpleLIPMSimpleCostFunction();
        this.terminalCostFunction = new SimpleLIPMTerminalCostFunction();
        this.deltaT = deltaT;
        this.ddpSolver = new DDPSolver(this.dynamics, true);
        int stateSize = this.dynamics.getStateVectorSize();
        int controlSize = this.dynamics.getControlVectorSize();
        int constantSize = this.dynamics.getConstantVectorSize();
        this.desiredTrajectory = new DiscreteOptimizationTrajectory(stateSize, controlSize);
        this.constants = new DiscreteSequence(constantSize);
    }

    public void setDeltaT(double deltaT) {
        this.dynamics.setTimeStepSize(deltaT);
        this.deltaT = deltaT;
        this.modifiedDeltaT = deltaT;
    }

    public void initialize(DMatrixRMaj currentState, MultipleWaypointsPositionTrajectoryGenerator copDesiredPlan) {
        this.modifiedDeltaT = this.computeDeltaT(copDesiredPlan.getLastWaypointTime());
        this.dynamics.setTimeStepSize(this.modifiedDeltaT);
        this.desiredTrajectory.setTrajectoryDuration(0.0, copDesiredPlan.getLastWaypointTime(), this.deltaT);
        this.constants.setLength(this.desiredTrajectory.size());
        double time = 0.0;
        copDesiredPlan.compute(time);
        this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getPosition());
        this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getVelocity());
        DMatrixRMaj desiredState = this.desiredTrajectory.getState(0);
        desiredState.set(0, this.tempPoint.getX());
        desiredState.set(1, this.tempPoint.getY());
        desiredState.set(2, this.tempVector.getX());
        desiredState.set(3, this.tempVector.getY());
        DMatrixRMaj desiredControl = this.desiredTrajectory.getControl(0);
        desiredControl.set(0, this.tempPoint.getX());
        desiredControl.set(1, this.tempPoint.getY());
        time += this.modifiedDeltaT;
        for (int i = 1; i < this.numberOfTimeSteps; ++i) {
            copDesiredPlan.compute(time);
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getPosition());
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getVelocity());
            desiredState = this.desiredTrajectory.getState(i);
            desiredState.set(0, this.tempPoint.getX());
            desiredState.set(1, this.tempPoint.getY());
            desiredState.set(2, this.tempVector.getX());
            desiredState.set(3, this.tempVector.getY());
            desiredControl = this.desiredTrajectory.getControl(i);
            desiredControl.set(0, this.tempPoint.getX());
            desiredControl.set(1, this.tempPoint.getY());
            time += this.modifiedDeltaT;
        }
        this.ddpSolver.initializeSequencesFromDesireds(currentState, (DiscreteOptimizationData)this.desiredTrajectory, this.constants);
    }

    private double computeDeltaT(double trajectoryLength) {
        this.numberOfTimeSteps = (int)Math.floor(trajectoryLength / this.deltaT);
        return trajectoryLength / (double)this.numberOfTimeSteps;
    }

    public double getDT() {
        return this.modifiedDeltaT;
    }
}

