/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.trajectoryOptimization.DefaultDiscreteState;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;

public class LIPMDynamics
implements DiscreteHybridDynamics<DefaultDiscreteState> {
    private static final boolean incorporateAccelerationIntoPosition = true;
    static final int stateVectorSize = 6;
    static final int controlVectorSize = 3;
    static final int constantVectorSize = 0;
    private double deltaT;
    private double deltaT2;
    private final double pendulumMass;
    private final double gravityZ;

    public LIPMDynamics(double deltaT, double pendulumMass, double gravityZ) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
        this.pendulumMass = pendulumMass;
        this.gravityZ = gravityZ;
    }

    public void setTimeStepSize(double deltaT) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
    }

    public int getStateVectorSize() {
        return 6;
    }

    public int getControlVectorSize() {
        return 3;
    }

    public int getConstantVectorSize() {
        return 0;
    }

    public void getNextState(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 1) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double xdot_k = currentState.get(3);
        double ydot_k = currentState.get(4);
        double zdot_k = currentState.get(5);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        double x_k1 = x_k + this.deltaT * xdot_k;
        double y_k1 = y_k + this.deltaT * ydot_k;
        double z_k1 = z_k + this.deltaT * zdot_k;
        x_k1 += 0.5 * this.deltaT2 * (x_k - px_k) * fz_k / (this.pendulumMass * z_k);
        y_k1 += 0.5 * this.deltaT2 * (y_k - py_k) * fz_k / (this.pendulumMass * z_k);
        z_k1 += 0.5 * this.deltaT2 * (fz_k / this.pendulumMass - this.gravityZ);
        double xdot_k1 = xdot_k + this.deltaT * (x_k - px_k) * fz_k / (this.pendulumMass * z_k);
        double ydot_k1 = ydot_k + this.deltaT * (y_k - py_k) * fz_k / (this.pendulumMass * z_k);
        double zdot_k1 = zdot_k + this.deltaT * (fz_k / this.pendulumMass - this.gravityZ);
        matrixToPack.set(0, 0, x_k1);
        matrixToPack.set(1, 0, y_k1);
        matrixToPack.set(2, 0, z_k1);
        matrixToPack.set(3, 0, xdot_k1);
        matrixToPack.set(4, 0, ydot_k1);
        matrixToPack.set(5, 0, zdot_k1);
    }

    public void getDynamicsStateGradient(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        matrixToPack.zero();
        double value1 = this.deltaT2 / (2.0 * this.pendulumMass * z_k);
        double value2 = this.deltaT / (this.pendulumMass * z_k);
        matrixToPack.set(0, 0, 1.0 + fz_k * value1);
        matrixToPack.set(0, 2, (px_k - x_k) * fz_k / z_k * value1);
        matrixToPack.set(0, 3, this.deltaT);
        matrixToPack.set(1, 1, matrixToPack.get(0, 0));
        matrixToPack.set(1, 2, (py_k - y_k) * fz_k / z_k * value1);
        matrixToPack.set(1, 4, this.deltaT);
        matrixToPack.set(2, 2, 1.0);
        matrixToPack.set(2, 5, this.deltaT);
        matrixToPack.set(3, 0, fz_k * value2);
        matrixToPack.set(3, 2, (px_k - x_k) * fz_k / z_k * value2);
        matrixToPack.set(3, 3, 1.0);
        matrixToPack.set(4, 1, matrixToPack.get(3, 0));
        matrixToPack.set(4, 2, (py_k - y_k) * fz_k / z_k * value2);
        matrixToPack.set(4, 4, 1.0);
        matrixToPack.set(5, 5, 1.0);
    }

    public void getDynamicsControlGradient(DefaultDiscreteState state, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 3) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        matrixToPack.zero();
        double value = this.deltaT / (this.pendulumMass * z_k);
        double value2 = this.deltaT2 / (2.0 * this.pendulumMass * z_k);
        matrixToPack.set(0, 0, value2 * -fz_k);
        matrixToPack.set(0, 2, value2 * (x_k - px_k));
        matrixToPack.set(1, 1, value2 * -fz_k);
        matrixToPack.set(1, 2, value2 * (y_k - py_k));
        matrixToPack.set(2, 2, value2 * z_k);
        matrixToPack.set(3, 0, value * -fz_k);
        matrixToPack.set(3, 2, value * (x_k - px_k));
        matrixToPack.set(4, 1, value * -fz_k);
        matrixToPack.set(4, 2, value * (y_k - py_k));
        matrixToPack.set(5, 2, value * z_k);
    }

    public void getDynamicsStateHessian(DefaultDiscreteState state, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (stateVariable >= 6) {
            throw new RuntimeException("Too big a state variable.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        matrixToPack.zero();
        double value = -this.deltaT * fz_k / (this.pendulumMass * z_k * z_k);
        double value2 = -this.deltaT2 * fz_k / (2.0 * this.pendulumMass * z_k * z_k);
        switch (stateVariable) {
            case 0: {
                matrixToPack.set(0, 2, value2);
                matrixToPack.set(3, 2, value);
                break;
            }
            case 1: {
                matrixToPack.set(1, 2, value2);
                matrixToPack.set(4, 2, value);
                break;
            }
            case 2: {
                matrixToPack.set(0, 0, value2);
                matrixToPack.set(0, 2, 2.0 * value2 * (px_k - x_k) / z_k);
                matrixToPack.set(1, 1, value2);
                matrixToPack.set(1, 2, 2.0 * value2 * (py_k - y_k) / z_k);
                matrixToPack.set(3, 0, value);
                matrixToPack.set(3, 2, 2.0 * value * (px_k - x_k) / z_k);
                matrixToPack.set(4, 1, value);
                matrixToPack.set(4, 2, 2.0 * value * (py_k - y_k) / z_k);
            }
        }
    }

    public void getDynamicsControlHessian(DefaultDiscreteState state, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 3) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (controlVariable >= 3) {
            throw new RuntimeException("Too big a state variable.");
        }
        double z_k = currentState.get(2);
        matrixToPack.zero();
        double value = -this.deltaT / (this.pendulumMass * z_k);
        double value2 = -this.deltaT2 / (2.0 * this.pendulumMass * z_k);
        switch (controlVariable) {
            case 0: {
                matrixToPack.set(0, 2, value2);
                matrixToPack.set(3, 2, value);
                break;
            }
            case 1: {
                matrixToPack.set(1, 2, value2);
                matrixToPack.set(4, 2, value);
                break;
            }
            case 2: {
                matrixToPack.set(0, 0, value2);
                matrixToPack.set(1, 1, value2);
                matrixToPack.set(3, 0, value);
                matrixToPack.set(4, 1, value);
            }
        }
    }

    public void getDynamicsStateGradientOfControlGradient(DefaultDiscreteState state, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 3) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (stateVariable >= 6) {
            throw new RuntimeException("Too big a state variable.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        matrixToPack.zero();
        double value = this.deltaT / (this.pendulumMass * z_k * z_k);
        double value2 = this.deltaT2 / (2.0 * this.pendulumMass * z_k * z_k);
        switch (stateVariable) {
            case 0: {
                matrixToPack.set(0, 2, value2 * z_k);
                matrixToPack.set(3, 2, value * z_k);
                break;
            }
            case 1: {
                matrixToPack.set(1, 2, value2 * z_k);
                matrixToPack.set(4, 2, value * z_k);
                break;
            }
            case 2: {
                matrixToPack.set(0, 0, value2 * fz_k);
                matrixToPack.set(0, 2, value2 * (px_k - x_k));
                matrixToPack.set(1, 1, value2 * fz_k);
                matrixToPack.set(1, 2, value2 * (py_k - y_k));
                matrixToPack.set(3, 0, value * fz_k);
                matrixToPack.set(3, 2, value * (px_k - x_k));
                matrixToPack.set(4, 1, value * fz_k);
                matrixToPack.set(4, 2, value * (py_k - y_k));
            }
        }
    }

    public void getDynamicsControlGradientOfStateGradient(DefaultDiscreteState state, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (controlVariable >= 3) {
            throw new RuntimeException("Too big a control variable.");
        }
        double x_k = currentState.get(0);
        double y_k = currentState.get(1);
        double z_k = currentState.get(2);
        double px_k = currentControl.get(0);
        double py_k = currentControl.get(1);
        double fz_k = currentControl.get(2);
        matrixToPack.zero();
        double value = this.deltaT / (this.pendulumMass * z_k * z_k);
        double value2 = this.deltaT2 / (2.0 * this.pendulumMass * z_k * z_k);
        switch (controlVariable) {
            case 0: {
                matrixToPack.set(0, 2, fz_k * value2);
                matrixToPack.set(3, 2, fz_k * value);
                break;
            }
            case 1: {
                matrixToPack.set(1, 2, fz_k * value2);
                matrixToPack.set(4, 2, fz_k * value);
                break;
            }
            case 2: {
                matrixToPack.set(0, 0, value2 * z_k);
                matrixToPack.set(0, 2, value2 * (px_k - x_k));
                matrixToPack.set(1, 1, value2 * z_k);
                matrixToPack.set(1, 2, value2 * (py_k - y_k));
                matrixToPack.set(3, 0, value * z_k);
                matrixToPack.set(3, 2, value * (px_k - x_k));
                matrixToPack.set(4, 1, value * z_k);
                matrixToPack.set(4, 2, value * (py_k - y_k));
            }
        }
    }

    public void getContinuousAMatrix(DMatrixRMaj matrixToPack) {
        matrixToPack.set(0, 2, 1.0);
        matrixToPack.set(1, 3, 1.0);
        matrixToPack.set(2, 0, this.gravityZ / 1.0);
        matrixToPack.set(3, 1, this.gravityZ / 1.0);
    }

    public void getContinuousBMatrix(DMatrixRMaj matrixToPack) {
        matrixToPack.set(2, 0, -this.gravityZ / 1.0);
        matrixToPack.set(3, 1, -this.gravityZ / 1.0);
    }
}

