/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPoint;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class WrenchTrajectorySegment
implements TimeIntervalProvider,
Settable<WrenchTrajectorySegment>,
ReferenceFrameHolder {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final WrenchBasics[] coefficients = new WrenchBasics[]{new Wrench(worldFrame, worldFrame), new Wrench(worldFrame, worldFrame), new Wrench(worldFrame, worldFrame), new Wrench(worldFrame, worldFrame)};
    private final WrenchBasics pointCoefficient = new Wrench(worldFrame, worldFrame);
    private final FrameVector3D linearCoefficient = new FrameVector3D();
    private static final FrameVector3DReadOnly zero = new FrameVector3D();
    private double currentTime;
    private double mass = 1.0;
    private double omega = 3.0;
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private final WrenchBasics desiredWrench = new Wrench(ReferenceFrame.getWorldFrame(), ReferenceFrame.getWorldFrame());

    public void reset() {
        this.currentTime = Double.NaN;
        for (WrenchBasics coefficient : this.coefficients) {
            coefficient.setToNaN();
        }
        this.timeInterval.reset();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.getWrench().getReferenceFrame();
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }

    public void set(WrenchTrajectorySegment other) {
        this.getTimeInterval().set((TimeIntervalReadOnly)other.getTimeInterval());
        this.setCoefficients(other);
        this.currentTime = other.currentTime;
        this.omega = other.omega;
        this.mass = other.mass;
        this.desiredWrench.setIncludingFrame((WrenchReadOnly)other.desiredWrench);
    }

    public void setCoefficients(List<MPCContactPlane> mpcContactPlanes) {
        for (WrenchBasics coefficient : this.coefficients) {
            coefficient.setToZero(ReferenceFrame.getWorldFrame());
        }
        for (int planeIdx = 0; planeIdx < mpcContactPlanes.size(); ++planeIdx) {
            this.addCoefficients(mpcContactPlanes.get(planeIdx));
        }
    }

    private void addCoefficients(MPCContactPlane mpcContactPlane) {
        for (int pointIdx = 0; pointIdx < mpcContactPlane.getNumberOfContactPoints(); ++pointIdx) {
            MPCContactPoint contactPoint = mpcContactPlane.getContactPointHelper(pointIdx);
            DMatrixRMaj trajectoryCoeff = contactPoint.getContactForceCoefficientMatrix();
            for (int coefficientIdx = 0; coefficientIdx < this.coefficients.length; ++coefficientIdx) {
                for (int element = 0; element < 3; ++element) {
                    this.linearCoefficient.setElement(element, trajectoryCoeff.get(element, coefficientIdx));
                }
                this.linearCoefficient.scale(this.mass);
                this.pointCoefficient.set(ReferenceFrame.getWorldFrame(), ReferenceFrame.getWorldFrame(), (Vector3DReadOnly)zero, (Vector3DReadOnly)this.linearCoefficient, (Point3DReadOnly)contactPoint.getBasisVectorOrigin());
                this.coefficients[coefficientIdx].add((WrenchReadOnly)this.pointCoefficient);
            }
        }
    }

    public void setCoefficients(WrenchTrajectorySegment other) {
        this.setCoefficients((WrenchReadOnly[])other.coefficients);
    }

    public void setCoefficients(WrenchReadOnly[] coefficients) {
        for (int coefficientIdx = 0; coefficientIdx < coefficients.length; ++coefficientIdx) {
            this.coefficients[coefficientIdx].setIncludingFrame(coefficients[coefficientIdx]);
        }
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void compute(double time) {
        this.compute(time, this.desiredWrench);
    }

    public void compute(double time, WrenchBasics wrenchToPack) {
        wrenchToPack.setToZero(this.coefficients[0].getReferenceFrame());
        double omega2 = this.omega * this.omega;
        double exponential = Math.exp(this.omega * time);
        WrenchTrajectorySegment.scaleAddWrench(wrenchToPack, omega2 * exponential, (WrenchReadOnly)this.coefficients[0]);
        WrenchTrajectorySegment.scaleAddWrench(wrenchToPack, omega2 / exponential, (WrenchReadOnly)this.coefficients[1]);
        WrenchTrajectorySegment.scaleAddWrench(wrenchToPack, 6.0 * time, (WrenchReadOnly)this.coefficients[2]);
        WrenchTrajectorySegment.scaleAddWrench(wrenchToPack, 2.0, (WrenchReadOnly)this.coefficients[3]);
    }

    public WrenchReadOnly getWrench() {
        return this.desiredWrench;
    }

    private static void scaleAddWrench(WrenchBasics wrenchToPack, double scaleFactor, WrenchReadOnly wrenchToAdd) {
        wrenchToPack.getAngularPart().scaleAdd(scaleFactor, (FrameTuple3DReadOnly)wrenchToAdd.getAngularPart(), (FrameTuple3DReadOnly)wrenchToPack.getAngularPart());
        wrenchToPack.getLinearPart().scaleAdd(scaleFactor, (FrameTuple3DReadOnly)wrenchToAdd.getLinearPart(), (FrameTuple3DReadOnly)wrenchToPack.getLinearPart());
    }
}

