/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerInterface;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanningCostPolicy;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class TakeOffHeightObjectivePolicy
implements CoMTrajectoryPlanningCostPolicy {
    private final DoubleProvider omega;
    private final double weight;

    public TakeOffHeightObjectivePolicy(DoubleProvider omega, double weight) {
        this.omega = omega;
        this.weight = weight;
    }

    @Override
    public void assessPolicy(CoMTrajectoryPlannerInterface comTrajectoryPlanner, List<? extends ContactStateProvider> contactSequence, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        for (int sequenceId = 1; sequenceId < contactSequence.size(); ++sequenceId) {
            boolean isStartTakeOff;
            ContactStateProvider contactState = contactSequence.get(sequenceId);
            boolean bl = isStartTakeOff = contactSequence.get(sequenceId - 1).getContactState().isLoadBearing() && !contactState.getContactState().isLoadBearing();
            if (!isStartTakeOff) continue;
            double copHeight = contactSequence.get(sequenceId - 1).getECMPEndPosition().getZ();
            double objectiveCoMHeight = copHeight + comTrajectoryPlanner.getNominalCoMHeight();
            CoMTrajectoryPlannerTools.addValueObjective(this.weight, sequenceId, this.omega.getValue(), 0.0, objectiveCoMHeight, CoMTrajectoryPlannerTools.comPositionCoefficientProvider, CoMTrajectoryPlannerTools.comPositionCoefficientSelectedProvider, hessianToPack, zGradientToPack);
        }
    }
}

