/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CenterOfMassDynamicsTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class SimpleCoMTrajectoryPlanner
implements CoMTrajectoryProvider {
    private double nominalCoMHeight;
    private final FramePoint3D initialCoMPosition = new FramePoint3D();
    private final RecyclingArrayList<FramePoint3D> dcmCornerPointPool = new RecyclingArrayList(FramePoint3D::new);
    final List<FramePoint3D> dcmCornerPoints = new ArrayList<FramePoint3D>();
    private final RecyclingArrayList<Polynomial3D> vrpTrajectoryPool = new RecyclingArrayList(() -> new Polynomial3D(4));
    private final RecyclingArrayList<LineSegment3D> vrpWaypointPools = new RecyclingArrayList(LineSegment3D::new);
    private final List<Polynomial3DBasics> vrpTrajectories = new ArrayList<Polynomial3DBasics>();
    private final List<LineSegment3D> vrpWaypoints = new ArrayList<LineSegment3D>();
    final RecyclingArrayList<FramePoint3D> comCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final DoubleProvider omega0;
    private final FramePoint3D desiredDCMPosition = new FramePoint3D();
    private final FrameVector3D desiredDCMVelocity = new FrameVector3D();
    private final FramePoint3D desiredCoMPosition = new FramePoint3D();
    private final FrameVector3D desiredCoMVelocity = new FrameVector3D();
    private final FrameVector3D desiredCoMAcceleration = new FrameVector3D();
    private final FramePoint3D desiredVRPPosition = new FramePoint3D();
    private final FramePoint3D desiredECMPPosition = new FramePoint3D();
    private CornerPointViewer viewer = null;
    private final FramePoint3D finalVRP = new FramePoint3D();
    private final FramePoint3D startVRP = new FramePoint3D();

    public SimpleCoMTrajectoryPlanner(DoubleProvider omega0) {
        this.omega0 = omega0;
    }

    public void setCornerPointViewer(CornerPointViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.nominalCoMHeight = nominalCoMHeight;
    }

    @Override
    public double getNominalCoMHeight() {
        return this.nominalCoMHeight;
    }

    @Override
    public void solveForTrajectory(List<? extends ContactStateProvider> contactSequence) {
        this.computeDCMCornerPoints(contactSequence);
        this.computeCoMCornerPoints();
        if (this.viewer != null) {
            this.viewer.updateDCMCornerPoints(this.dcmCornerPoints);
            this.viewer.updateCoMCornerPoints((List<FramePoint3D>)this.comCornerPoints);
            this.viewer.updateVRPWaypoints(this.vrpWaypoints);
        }
    }

    private void computeDCMCornerPoints(List<? extends ContactStateProvider> contactSequence) {
        this.dcmCornerPointPool.clear();
        this.dcmCornerPoints.clear();
        this.vrpTrajectoryPool.clear();
        this.vrpTrajectories.clear();
        this.vrpWaypointPools.clear();
        this.vrpWaypoints.clear();
        FramePoint3DReadOnly finalCoP = contactSequence.get(contactSequence.size() - 1).getECMPEndPosition();
        FramePoint3D finalDCM = (FramePoint3D)this.dcmCornerPointPool.add();
        finalDCM.set((FrameTuple3DReadOnly)finalCoP);
        finalDCM.addZ(this.nominalCoMHeight);
        this.dcmCornerPoints.add(finalDCM);
        for (int i = contactSequence.size() - 1; i >= 0; --i) {
            ContactStateProvider contact = contactSequence.get(i);
            double duration = contact.getTimeInterval().getDuration();
            this.finalVRP.set((FrameTuple3DReadOnly)contact.getECMPEndPosition());
            this.startVRP.set((FrameTuple3DReadOnly)contact.getECMPStartPosition());
            this.finalVRP.addZ(this.nominalCoMHeight);
            this.startVRP.addZ(this.nominalCoMHeight);
            FramePoint3D nextCornerPoint = (FramePoint3D)this.dcmCornerPointPool.add();
            this.dcmCornerPoints.add(nextCornerPoint);
            CenterOfMassDynamicsTools.computeDesiredDCMPositionBackwardTime(this.omega0.getValue(), duration, duration, (FramePoint3DReadOnly)finalDCM, (FramePoint3DReadOnly)this.startVRP, (FramePoint3DReadOnly)this.finalVRP, (FixedFramePoint3DBasics)nextCornerPoint);
            LineSegment3D vrpSegment = (LineSegment3D)this.vrpWaypointPools.add();
            Polynomial3D vrpTrajectory = (Polynomial3D)this.vrpTrajectoryPool.add();
            this.vrpTrajectories.add((Polynomial3DBasics)vrpTrajectory);
            this.vrpWaypoints.add(vrpSegment);
            vrpTrajectory.setLinear(0.0, duration, (Point3DReadOnly)this.startVRP, (Point3DReadOnly)this.finalVRP);
            vrpSegment.set((Point3DReadOnly)this.startVRP, (Point3DReadOnly)this.finalVRP);
            finalDCM = nextCornerPoint;
        }
        Collections.reverse(this.dcmCornerPoints);
        Collections.reverse(this.vrpTrajectories);
        Collections.reverse(this.vrpWaypoints);
    }

    private void computeCoMCornerPoints() {
        this.comCornerPoints.clear();
        ((FramePoint3D)this.comCornerPoints.add()).set(this.initialCoMPosition);
        for (int i = 0; i < this.dcmCornerPoints.size() - 1; ++i) {
            FramePoint3D initialCoMPosition = (FramePoint3D)this.comCornerPoints.get(i);
            FramePoint3D initialDCMPosition = this.dcmCornerPoints.get(i);
            double duration = this.vrpTrajectories.get(i).getDuration();
            this.startVRP.set((Tuple3DReadOnly)this.vrpWaypoints.get(i).getFirstEndpoint());
            this.finalVRP.set((Tuple3DReadOnly)this.vrpWaypoints.get(i).getSecondEndpoint());
            FramePoint3D finalCoMPosition = (FramePoint3D)this.comCornerPoints.add();
            CenterOfMassDynamicsTools.computeDesiredCoMPositionForwardTime(this.omega0.getValue(), duration, duration, (FramePoint3DReadOnly)initialCoMPosition, (FramePoint3DReadOnly)initialDCMPosition, (FramePoint3DReadOnly)this.startVRP, (FramePoint3DReadOnly)this.finalVRP, (FixedFramePoint3DBasics)finalCoMPosition);
        }
    }

    @Override
    public void compute(int segmentId, double timeInPhase) {
        this.compute(segmentId, timeInPhase, (FixedFramePoint3DBasics)this.desiredCoMPosition, (FixedFrameVector3DBasics)this.desiredCoMVelocity, (FixedFrameVector3DBasics)this.desiredCoMAcceleration, (FixedFramePoint3DBasics)this.desiredDCMPosition, (FixedFrameVector3DBasics)this.desiredDCMVelocity, (FixedFramePoint3DBasics)this.desiredVRPPosition, (FixedFramePoint3DBasics)this.desiredECMPPosition);
    }

    @Override
    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        Polynomial3DBasics vrpTrajectory = this.vrpTrajectories.get(segmentId);
        LineSegment3DReadOnly vrpSegment = (LineSegment3DReadOnly)this.vrpWaypoints.get(segmentId);
        this.startVRP.set((Tuple3DReadOnly)vrpSegment.getFirstEndpoint());
        this.finalVRP.set((Tuple3DReadOnly)vrpSegment.getSecondEndpoint());
        double omega = this.omega0.getValue();
        double duration = vrpTrajectory.getDuration();
        vrpTrajectory.compute(timeInPhase);
        FramePoint3DReadOnly initialDCM = (FramePoint3DReadOnly)this.dcmCornerPoints.get(segmentId);
        FramePoint3DReadOnly initialCoM = (FramePoint3DReadOnly)this.comCornerPoints.get(segmentId);
        CenterOfMassDynamicsTools.computeDesiredDCMPositionForwardTime(omega, timeInPhase, duration, initialDCM, (FramePoint3DReadOnly)this.startVRP, (FramePoint3DReadOnly)this.finalVRP, dcmPositionToPack);
        vrpPositionToPack.set((Tuple3DReadOnly)vrpTrajectory.getPosition());
        ecmpPositionToPack.set((FrameTuple3DReadOnly)vrpPositionToPack);
        ecmpPositionToPack.subZ(this.nominalCoMHeight);
        CapturePointTools.computeCapturePointVelocity((FramePoint3DReadOnly)dcmPositionToPack, (FramePoint3DReadOnly)vrpPositionToPack, omega, dcmVelocityToPack);
        CenterOfMassDynamicsTools.computeDesiredCoMPositionForwardTime(omega, timeInPhase, duration, initialCoM, initialDCM, (FramePoint3DReadOnly)this.startVRP, (FramePoint3DReadOnly)this.finalVRP, comPositionToPack);
        CapturePointTools.computeCenterOfMassVelocity((FramePoint3DReadOnly)comPositionToPack, (FramePoint3DReadOnly)dcmPositionToPack, omega, comVelocityToPack);
        CapturePointTools.computeCenterOfMassAcceleration((FrameVector3DReadOnly)comVelocityToPack, (FrameVector3DReadOnly)dcmVelocityToPack, omega, comAccelerationToPack);
    }

    @Override
    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.initialCoMPosition.set((FrameTuple3DReadOnly)centerOfMassPosition);
    }

    @Override
    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.desiredDCMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.desiredDCMVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.desiredCoMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.desiredCoMVelocity;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.desiredCoMAcceleration;
    }

    @Override
    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.desiredVRPPosition;
    }

    @Override
    public FramePoint3DReadOnly getDesiredECMPPosition() {
        return this.desiredECMPPosition;
    }

    @Override
    public List<? extends Polynomial3DReadOnly> getVRPTrajectories() {
        return this.vrpTrajectories;
    }

    @Override
    public MultipleSegmentPositionTrajectoryGenerator<?> getCoMTrajectory() {
        throw new IllegalArgumentException();
    }
}

