/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateBasics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class SettableContactStateProvider
implements ContactStateBasics<SettableContactStateProvider> {
    private ContactState contactState = ContactState.IN_CONTACT;
    private final FramePoint3D startECMPPosition = new FramePoint3D();
    private final FramePoint3D endECMPPosition = new FramePoint3D();
    private final FrameVector3D startECMPVelocity = new FrameVector3D();
    private final FrameVector3D endECMPVelocity = new FrameVector3D();
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private final List<String> bodiesInContact = new ArrayList<String>();

    public SettableContactStateProvider() {
        this.startECMPPosition.setToNaN();
        this.endECMPPosition.setToNaN();
        this.startECMPVelocity.setToNaN();
        this.endECMPVelocity.setToNaN();
    }

    @Override
    public void reset() {
        this.startECMPPosition.setToNaN();
        this.startECMPVelocity.setToNaN();
        this.endECMPPosition.setToNaN();
        this.endECMPVelocity.setToNaN();
        this.bodiesInContact.clear();
    }

    public void set(SettableContactStateProvider other) {
        this.set((ContactStateProvider<?>)other);
    }

    @Override
    public void setStartECMPPosition(FramePoint3DReadOnly startECMPPosition) {
        this.startECMPPosition.set((FrameTuple3DReadOnly)startECMPPosition);
    }

    @Override
    public void setStartECMPVelocity(FrameVector3DReadOnly startECMPVelocity) {
        this.startECMPVelocity.set((FrameTuple3DReadOnly)startECMPVelocity);
    }

    public void setStartECMPPosition(FramePoint2DReadOnly startECMPPosition, double height) {
        this.startECMPPosition.checkReferenceFrameMatch((ReferenceFrameHolder)startECMPPosition);
        this.setStartECMPPosition((Point2DReadOnly)startECMPPosition, height);
    }

    public void setStartECMPPosition(Point2DReadOnly startECMPPosition, double height) {
        this.startECMPPosition.set((Tuple2DReadOnly)startECMPPosition, height);
    }

    @Override
    public void setEndECMPPosition(FramePoint3DReadOnly endECMPPosition) {
        this.endECMPPosition.set((FrameTuple3DReadOnly)endECMPPosition);
    }

    @Override
    public void setEndECMPVelocity(FrameVector3DReadOnly endECMPVelocity) {
        this.endECMPVelocity.set((FrameTuple3DReadOnly)endECMPVelocity);
    }

    public void setEndECMPPosition(FramePoint2DReadOnly endECMPPosition, double height) {
        this.endECMPPosition.checkReferenceFrameMatch((ReferenceFrameHolder)endECMPPosition);
        this.setEndECMPPosition((Point2DReadOnly)endECMPPosition, height);
    }

    public void setEndECMPPosition(Point2DReadOnly endECMPPosition, double height) {
        this.endECMPPosition.set((Tuple2DReadOnly)endECMPPosition, height);
    }

    public void setLinearECMPVelocity() {
        this.startECMPVelocity.sub((FrameTuple3DReadOnly)this.getECMPEndPosition(), (FrameTuple3DReadOnly)this.getECMPStartPosition());
        this.startECMPVelocity.scale(1.0 / Math.min(this.getTimeInterval().getDuration(), 10.0));
        this.endECMPVelocity.set(this.startECMPVelocity);
    }

    public void setTimeInterval(TimeIntervalReadOnly timeInterval) {
        this.timeInterval.set(timeInterval);
    }

    @Override
    public void setContactState(ContactState contactState) {
        this.contactState = contactState;
    }

    public void addBodyInContact(String name) {
        this.bodiesInContact.add(name);
    }

    @Override
    public FramePoint3DReadOnly getECMPStartPosition() {
        return this.startECMPPosition;
    }

    @Override
    public FramePoint3DReadOnly getECMPEndPosition() {
        return this.endECMPPosition;
    }

    @Override
    public FrameVector3DReadOnly getECMPStartVelocity() {
        if (this.startECMPVelocity.containsNaN()) {
            this.setLinearECMPVelocity();
        }
        return this.startECMPVelocity;
    }

    @Override
    public FrameVector3DReadOnly getECMPEndVelocity() {
        if (this.endECMPVelocity.containsNaN()) {
            this.setLinearECMPVelocity();
        }
        return this.endECMPVelocity;
    }

    @Override
    public ContactState getContactState() {
        return this.contactState;
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }

    public void setDuration(double duration) {
        this.setEndTime(this.getTimeInterval().getStartTime() + duration);
    }

    public void setStartTime(double startTime) {
        this.getTimeInterval().setStartTime(startTime);
    }

    public void setEndTime(double endTime) {
        this.getTimeInterval().setEndTime(endTime);
    }

    public void setStartFromEnd(ContactStateProvider<?> previousContactState) {
        this.setStartTime(previousContactState.getTimeInterval().getEndTime());
        this.setStartECMPPosition(previousContactState.getECMPEndPosition());
    }

    public List<String> getBodiesInContact() {
        return this.bodiesInContact;
    }
}

