/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerIndexHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanningCostPolicy;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProviderTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ModifiedOptimizedCoMTrajectoryPlanner
implements CoMTrajectoryProvider {
    private static boolean verbose = false;
    private static final int maxCapacity = 10;
    private static final boolean includeVelocityObjective = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final double MEDIUM_WEIGHT = 10.0;
    public static final double LOW_WEIGHT = 0.01;
    private double jerkMinimizationWeight = 0.0;
    private double accelerationMinimizationWeight = 0.0;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DMatrixSparseCSC hessian = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC xGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC yGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC zGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC vrpXWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpYWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpZWaypoints = new DMatrixSparseCSC(0, 1);
    private final LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> sparseSolver = LinearSolverFactory_DSCC.lu((FillReducing)FillReducing.NONE);
    final DMatrixSparseCSC xCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC yCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC zCoefficientVector = new DMatrixSparseCSC(0, 1);
    private final List<CoMTrajectoryPlanningCostPolicy> costPolicies = new ArrayList<CoMTrajectoryPlanningCostPolicy>();
    private final DoubleProvider omega;
    private final YoDouble comHeight = new YoDouble("comHeightForPlanning", this.registry);
    private final double gravityZ;
    private final CoMTrajectoryPlannerIndexHandler indexHandler = new CoMTrajectoryPlannerIndexHandler();
    private final FixedFramePoint3DBasics desiredCoMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMVelocity = new FrameVector3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMAcceleration = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredDCMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredDCMVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredVRPPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredVRPVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredECMPPosition = new FramePoint3D(worldFrame);
    private final RecyclingArrayList<FramePoint3D> startVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> endVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final YoBoolean maintainInitialCoMVelocityContinuity = new YoBoolean("maintainInitialCoMVelocityContinuity", this.registry);
    private final YoFramePoint3D finalDCMPosition = new YoFramePoint3D("goalDCMPosition", worldFrame, this.registry);
    private final YoFramePoint3D currentCoMPosition = new YoFramePoint3D("currentCoMPosition", worldFrame, this.registry);
    private final YoFrameVector3D currentCoMVelocity = new YoFrameVector3D("currentCoMVelocity", worldFrame, this.registry);
    private final YoFramePoint3D yoFirstCoefficient = new YoFramePoint3D("comFirstCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoSecondCoefficient = new YoFramePoint3D("comSecondCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoThirdCoefficient = new YoFramePoint3D("comThirdCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoFourthCoefficient = new YoFramePoint3D("comFourthCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoFifthCoefficient = new YoFramePoint3D("comFifthCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoSixthCoefficient = new YoFramePoint3D("comSixthCoefficient", worldFrame, this.registry);
    private final RecyclingArrayList<FramePoint3D> dcmCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> comCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<Polynomial3D> vrpTrajectoryPool = new RecyclingArrayList(() -> new Polynomial3D(4));
    private final RecyclingArrayList<LineSegment3D> vrpSegments = new RecyclingArrayList(LineSegment3D::new);
    private final List<Polynomial3D> vrpTrajectories = new ArrayList<Polynomial3D>();
    private CornerPointViewer viewer = null;
    private BagOfBalls comTrajectoryViewer = null;
    private final FramePoint3D comPositionToThrowAway = new FramePoint3D();
    private final FramePoint3D dcmPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D comVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D comAccelerationToThrowAway = new FrameVector3D();
    private final FrameVector3D dcmVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D vrpVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D vrpStartPosition = new FramePoint3D();
    private final FrameVector3D vrpStartVelocity = new FrameVector3D();
    private final FramePoint3D vrpEndPosition = new FramePoint3D();
    private final FrameVector3D vrpEndVelocity = new FrameVector3D();
    private final FramePoint3D ecmpPositionToThrowAway = new FramePoint3D();
    private final FramePoint3D firstCoefficient = new FramePoint3D();
    private final FramePoint3D secondCoefficient = new FramePoint3D();
    private final FramePoint3D thirdCoefficient = new FramePoint3D();
    private final FramePoint3D fourthCoefficient = new FramePoint3D();
    private final FramePoint3D fifthCoefficient = new FramePoint3D();
    private final FramePoint3D sixthCoefficient = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();

    public ModifiedOptimizedCoMTrajectoryPlanner(double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry) {
        this.gravityZ = Math.abs(gravityZ);
        YoDouble omega = new YoDouble("omegaForPlanning", this.registry);
        this.comHeight.addListener(v -> omega.set(Math.sqrt(Math.abs(gravityZ) / this.comHeight.getDoubleValue())));
        this.comHeight.set(nominalCoMHeight);
        this.omega = omega;
        parentRegistry.addChild(this.registry);
    }

    public ModifiedOptimizedCoMTrajectoryPlanner(double gravityZ, YoDouble omega, YoRegistry parentRegistry) {
        this.omega = omega;
        this.gravityZ = Math.abs(gravityZ);
        omega.addListener(v -> this.comHeight.set(gravityZ / MathTools.square((double)omega.getValue())));
        omega.notifyListeners();
        parentRegistry.addChild(this.registry);
    }

    public void setMaintainInitialCoMVelocityContinuity(boolean maintainInitialCoMVelocityContinuity) {
        this.maintainInitialCoMVelocityContinuity.set(maintainInitialCoMVelocityContinuity);
    }

    public void setCornerPointViewer(CornerPointViewer viewer) {
        this.viewer = viewer;
    }

    public void setupCoMTrajectoryViewer(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.comTrajectoryViewer = new BagOfBalls(50, 0.01, YoAppearance.Black(), this.registry, yoGraphicsListRegistry);
    }

    public void addCostPolicy(CoMTrajectoryPlanningCostPolicy costPolicy) {
        this.costPolicies.add(costPolicy);
    }

    public void setAccelerationMinimizationWeight(double accelerationMinimizationWeight) {
        this.accelerationMinimizationWeight = accelerationMinimizationWeight;
    }

    public void setJerkMinimizationWeight(double jerkMinimizationWeight) {
        this.jerkMinimizationWeight = jerkMinimizationWeight;
    }

    @Override
    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.comHeight.set(nominalCoMHeight);
    }

    @Override
    public double getNominalCoMHeight() {
        return this.comHeight.getDoubleValue();
    }

    @Override
    public void solveForTrajectory(List<? extends ContactStateProvider> contactSequence) {
        if (!ContactStateProviderTools.checkContactSequenceIsValid(contactSequence)) {
            throw new IllegalArgumentException("The contact sequence is not valid.");
        }
        this.indexHandler.update(contactSequence);
        this.resetMatrices();
        CoMTrajectoryPlannerTools.computeVRPWaypoints(this.comHeight.getDoubleValue(), this.gravityZ, this.omega.getValue(), (FrameVector3DReadOnly)this.currentCoMVelocity, contactSequence, this.startVRPPositions, this.endVRPPositions, true);
        this.solveForCoefficientConstraintMatrix(contactSequence);
        int firstCoefficientIndex = 0;
        int secondCoefficientIndex = 1;
        int thirdCoefficientIndex = 2;
        int fourthCoefficientIndex = 3;
        int fifthCoefficientIndex = 4;
        int sixthCoefficientIndex = 5;
        this.yoFirstCoefficient.setX(this.xCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoFirstCoefficient.setY(this.yCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoFirstCoefficient.setZ(this.zCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoSecondCoefficient.setX(this.xCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoSecondCoefficient.setY(this.yCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoSecondCoefficient.setZ(this.zCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoThirdCoefficient.setX(this.xCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoThirdCoefficient.setY(this.yCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoThirdCoefficient.setZ(this.zCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoFourthCoefficient.setX(this.xCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFourthCoefficient.setY(this.yCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFourthCoefficient.setZ(this.zCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFifthCoefficient.setX(this.xCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoFifthCoefficient.setY(this.yCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoFifthCoefficient.setZ(this.zCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoSixthCoefficient.setX(this.xCoefficientVector.get(sixthCoefficientIndex, 0));
        this.yoSixthCoefficient.setY(this.yCoefficientVector.get(sixthCoefficientIndex, 0));
        this.yoSixthCoefficient.setZ(this.zCoefficientVector.get(sixthCoefficientIndex, 0));
        this.updateCornerPoints(contactSequence);
        if (this.viewer != null) {
            this.viewer.updateDCMCornerPoints((List<FramePoint3D>)this.dcmCornerPoints);
            this.viewer.updateCoMCornerPoints((List<FramePoint3D>)this.comCornerPoints);
            this.viewer.updateVRPWaypoints((List<LineSegment3D>)this.vrpSegments);
        }
        if (this.comTrajectoryViewer != null) {
            this.updateCoMTrajectoryViewer();
        }
    }

    private void solveForCoefficientConstraintMatrix(List<? extends ContactStateProvider> contactSequence) {
        int numberOfPhases = contactSequence.size();
        int numberOfTransitions = numberOfPhases - 1;
        CoMTrajectoryPlannerTools.addCoMPositionObjective(10.0, (FramePoint3DReadOnly)this.currentCoMPosition, this.omega.getValue(), 0.0, 0, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
        this.addDynamicsInitialObjective(10.0, 10.0, contactSequence, 0);
        int transition = 0;
        if (numberOfTransitions > 0) {
            double previousDuration = contactSequence.get(0).getTimeInterval().getDuration();
            CoMTrajectoryPlannerTools.addCoMPositionContinuityObjective(10.0, 0, 1, this.omega.getValue(), previousDuration, (DMatrix)this.hessian);
            CoMTrajectoryPlannerTools.addCoMVelocityContinuityObjective(10.0, 0, 1, this.omega.getValue(), previousDuration, (DMatrix)this.hessian);
            this.addDynamicsFinalObjective(10.0, 10.0, contactSequence, 0);
            this.addDynamicsInitialObjective(10.0, 10.0, contactSequence, 1);
        }
        ++transition;
        while (transition < numberOfTransitions) {
            int previousSequence = transition;
            int nextSequence = transition + 1;
            double previousDuration = contactSequence.get(previousSequence).getTimeInterval().getDuration();
            CoMTrajectoryPlannerTools.addCoMPositionContinuityObjective(10.0, previousSequence, nextSequence, this.omega.getValue(), previousDuration, (DMatrix)this.hessian);
            CoMTrajectoryPlannerTools.addCoMVelocityContinuityObjective(10.0, previousSequence, nextSequence, this.omega.getValue(), previousDuration, (DMatrix)this.hessian);
            this.addDynamicsFinalObjective(10.0, 10.0, contactSequence, previousSequence);
            this.addDynamicsInitialObjective(10.0, 10.0, contactSequence, nextSequence);
            ++transition;
        }
        ContactStateProvider lastContactPhase = contactSequence.get(numberOfPhases - 1);
        this.finalDCMPosition.set((FrameTuple3DReadOnly)this.endVRPPositions.getLast());
        double finalDuration = Math.min(lastContactPhase.getTimeInterval().getDuration(), 10.0);
        CoMTrajectoryPlannerTools.addDCMPositionObjective(10.0, (FramePoint3DReadOnly)this.finalDCMPosition, this.omega.getValue(), finalDuration, numberOfPhases - 1, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
        this.addDynamicsFinalObjective(10.0, 10.0, contactSequence, numberOfPhases - 1);
        for (int segment = 0; segment < numberOfPhases; ++segment) {
            ContactStateProvider contactStateProvider = contactSequence.get(segment);
            if (!contactStateProvider.getContactState().isLoadBearing()) continue;
            double duration = contactStateProvider.getTimeInterval().getDuration();
            CoMTrajectoryPlannerTools.addMinimizeCoMAccelerationObjective(this.accelerationMinimizationWeight, 0.0, duration, this.omega.getValue(), segment, (DMatrix)this.hessian);
            CoMTrajectoryPlannerTools.addMinimizeCoMJerkObjective(this.jerkMinimizationWeight, 0.0, duration, this.omega.getValue(), segment, (DMatrix)this.hessian);
        }
        for (int i = 0; i < this.costPolicies.size(); ++i) {
            this.costPolicies.get(i).assessPolicy(this, contactSequence, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
        }
        CommonOps_DSCC.scale((double)-0.5, (DMatrixSparseCSC)this.xGradient, (DMatrixSparseCSC)this.xGradient);
        CommonOps_DSCC.scale((double)-0.5, (DMatrixSparseCSC)this.yGradient, (DMatrixSparseCSC)this.yGradient);
        CommonOps_DSCC.scale((double)-0.5, (DMatrixSparseCSC)this.zGradient, (DMatrixSparseCSC)this.zGradient);
        this.sparseSolver.setA((Matrix)this.hessian);
        this.sparseSolver.solveSparse((Matrix)this.xGradient, (Matrix)this.xCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.yGradient, (Matrix)this.yCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.zGradient, (Matrix)this.zCoefficientVector);
    }

    private void updateCornerPoints(List<? extends ContactStateProvider> contactSequence) {
        this.vrpTrajectoryPool.clear();
        this.vrpTrajectories.clear();
        this.comCornerPoints.clear();
        this.dcmCornerPoints.clear();
        this.vrpSegments.clear();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int segmentId = 0; segmentId < Math.min(contactSequence.size(), 11); ++segmentId) {
            double duration = contactSequence.get(segmentId).getTimeInterval().getDuration();
            duration = Math.min(duration, 10.0);
            this.compute(segmentId, 0.0, (FixedFramePoint3DBasics)this.comCornerPoints.add(), (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmCornerPoints.add(), (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFrameVector3DBasics)this.vrpStartVelocity, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.compute(segmentId, duration, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFrameVector3DBasics)this.vrpEndVelocity, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            Polynomial3D trajectory3D = (Polynomial3D)this.vrpTrajectoryPool.add();
            trajectory3D.setCubic(0.0, duration, (Point3DReadOnly)this.vrpStartPosition, (Vector3DReadOnly)this.vrpStartVelocity, (Point3DReadOnly)this.vrpEndPosition, (Vector3DReadOnly)this.vrpEndVelocity);
            this.vrpTrajectories.add(trajectory3D);
            ((LineSegment3D)this.vrpSegments.add()).set((Point3DReadOnly)this.vrpStartPosition, (Point3DReadOnly)this.vrpEndPosition);
        }
        verbose = verboseBefore;
    }

    private void updateCoMTrajectoryViewer() {
        this.comTrajectoryViewer.reset();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int i = 0; i < this.comTrajectoryViewer.getNumberOfBalls(); ++i) {
            double time = 0.05 * (double)i;
            int segmentId = this.getSegmentNumber(time);
            double timeInSegment = this.getTimeInSegment(segmentId, time);
            this.compute(segmentId, timeInSegment, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.comTrajectoryViewer.setBall((FramePoint3DReadOnly)this.comPositionToThrowAway);
        }
        verbose = verboseBefore;
    }

    @Override
    public void compute(int segmentId, double timeInPhase) {
        this.compute(segmentId, timeInPhase, this.desiredCoMPosition, this.desiredCoMVelocity, this.desiredCoMAcceleration, this.desiredDCMPosition, this.desiredDCMVelocity, this.desiredVRPPosition, this.desiredECMPPosition);
        if (verbose) {
            LogTools.info((String)("At time " + timeInPhase + ", Desired DCM = " + this.desiredDCMPosition + ", Desired CoM = " + this.desiredCoMPosition));
        }
    }

    @Override
    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        this.compute(segmentId, timeInPhase, comPositionToPack, comVelocityToPack, comAccelerationToPack, dcmPositionToPack, dcmVelocityToPack, vrpPositionToPack, (FixedFrameVector3DBasics)this.vrpVelocityToThrowAway, ecmpPositionToPack);
    }

    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        if (segmentId < 0) {
            throw new IllegalArgumentException("time is invalid.");
        }
        int startIndex = this.indexHandler.getContactSequenceStartIndex(segmentId);
        this.firstCoefficient.setX(this.xCoefficientVector.get(startIndex, 0));
        this.firstCoefficient.setY(this.yCoefficientVector.get(startIndex, 0));
        this.firstCoefficient.setZ(this.zCoefficientVector.get(startIndex, 0));
        int secondCoefficientIndex = startIndex + 1;
        this.secondCoefficient.setX(this.xCoefficientVector.get(secondCoefficientIndex, 0));
        this.secondCoefficient.setY(this.yCoefficientVector.get(secondCoefficientIndex, 0));
        this.secondCoefficient.setZ(this.zCoefficientVector.get(secondCoefficientIndex, 0));
        int thirdCoefficientIndex = startIndex + 2;
        this.thirdCoefficient.setX(this.xCoefficientVector.get(thirdCoefficientIndex, 0));
        this.thirdCoefficient.setY(this.yCoefficientVector.get(thirdCoefficientIndex, 0));
        this.thirdCoefficient.setZ(this.zCoefficientVector.get(thirdCoefficientIndex, 0));
        int fourthCoefficientIndex = startIndex + 3;
        this.fourthCoefficient.setX(this.xCoefficientVector.get(fourthCoefficientIndex, 0));
        this.fourthCoefficient.setY(this.yCoefficientVector.get(fourthCoefficientIndex, 0));
        this.fourthCoefficient.setZ(this.zCoefficientVector.get(fourthCoefficientIndex, 0));
        int fifthCoefficientIndex = startIndex + 4;
        this.fifthCoefficient.setX(this.xCoefficientVector.get(fifthCoefficientIndex, 0));
        this.fifthCoefficient.setY(this.yCoefficientVector.get(fifthCoefficientIndex, 0));
        this.fifthCoefficient.setZ(this.zCoefficientVector.get(fifthCoefficientIndex, 0));
        int sixthCoefficientIndex = startIndex + 5;
        this.sixthCoefficient.setX(this.xCoefficientVector.get(sixthCoefficientIndex, 0));
        this.sixthCoefficient.setY(this.yCoefficientVector.get(sixthCoefficientIndex, 0));
        this.sixthCoefficient.setZ(this.zCoefficientVector.get(sixthCoefficientIndex, 0));
        double omega = this.omega.getValue();
        CoMTrajectoryPlannerTools.constructDesiredCoMPosition(comPositionToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredCoMVelocity(comVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredCoMAcceleration(comAccelerationToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredVRPVelocity(vrpVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CapturePointTools.computeCapturePointPosition((FramePoint3DReadOnly)comPositionToPack, (FrameVector3DReadOnly)comVelocityToPack, omega, dcmPositionToPack);
        CapturePointTools.computeCapturePointVelocity((FrameVector3DReadOnly)comVelocityToPack, (FrameVector3DReadOnly)comAccelerationToPack, omega, dcmVelocityToPack);
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint3DReadOnly)dcmPositionToPack, (FrameVector3DReadOnly)dcmVelocityToPack, omega, vrpPositionToPack);
        ecmpPositionToPack.set((FrameTuple3DReadOnly)vrpPositionToPack);
        ecmpPositionToPack.subZ(this.comHeight.getDoubleValue());
    }

    @Override
    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.currentCoMPosition.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassPosition);
        this.currentCoMVelocity.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassVelocity);
    }

    @Override
    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.desiredDCMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.desiredDCMVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.desiredCoMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.desiredCoMVelocity;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.desiredCoMAcceleration;
    }

    @Override
    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.desiredVRPPosition;
    }

    public FrameVector3DReadOnly getDesiredVRPVelocity() {
        return this.desiredVRPVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredECMPPosition() {
        return this.desiredECMPPosition;
    }

    private void resetMatrices() {
        int size = this.indexHandler.getTotalNumberOfCoefficients();
        int numberOfVRPWaypoints = this.indexHandler.getNumberOfVRPWaypoints();
        this.hessian.reshape(size, size);
        this.xGradient.reshape(size, 1);
        this.yGradient.reshape(size, 1);
        this.zGradient.reshape(size, 1);
        this.vrpXWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpYWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpZWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.xCoefficientVector.reshape(size, 1);
        this.yCoefficientVector.reshape(size, 1);
        this.zCoefficientVector.reshape(size, 1);
        this.hessian.zero();
        this.vrpXWaypoints.zero();
        this.vrpYWaypoints.zero();
        this.vrpZWaypoints.zero();
    }

    private void addDynamicsInitialObjective(double positionWeight, double velocityWeight, List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        if (contactState.isLoadBearing()) {
            this.addContactDynamicsObjective(positionWeight, velocityWeight, 0.0, sequenceId, (FramePoint3D)this.startVRPPositions.get(sequenceId));
        } else {
            this.addFlightDynamicsObjective(0.0, sequenceId);
        }
    }

    private void addDynamicsFinalObjective(double positionWeight, double velocityWeight, List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        double duration = contactStateProvider.getTimeInterval().getDuration();
        if (contactState.isLoadBearing()) {
            this.addContactDynamicsObjective(positionWeight, velocityWeight, duration, sequenceId, (FramePoint3D)this.endVRPPositions.get(sequenceId));
        } else {
            this.addFlightDynamicsObjective(duration, sequenceId);
        }
    }

    private void addContactDynamicsObjective(double positionWeight, double velocityWeight, double time, int sequenceId, FramePoint3D desiredVRPPosition) {
        CoMTrajectoryPlannerTools.addVRPPositionObjective(positionWeight, (FramePoint3DReadOnly)desiredVRPPosition, this.omega.getValue(), time, sequenceId, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
        CoMTrajectoryPlannerTools.addVRPVelocityObjective(velocityWeight, (FrameVector3DReadOnly)this.desiredVelocity, this.omega.getValue(), time, sequenceId, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
    }

    private void addFlightDynamicsObjective(double time, int sequenceId) {
        CoMTrajectoryPlannerTools.addCoMAccelerationIsGravityObjective(10.0, sequenceId, this.omega.getValue(), time, -this.gravityZ, (DMatrix)this.hessian, (DMatrix)this.zGradient);
        CoMTrajectoryPlannerTools.addCoMJerkObjective(10.0, null, this.omega.getValue(), time, sequenceId, (DMatrix)this.hessian, null, null, null);
    }

    public List<Polynomial3D> getVRPTrajectories() {
        return this.vrpTrajectories;
    }

    @Override
    public MultipleSegmentPositionTrajectoryGenerator<?> getCoMTrajectory() {
        throw new UnsupportedOperationException();
    }
}

