/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.robotics.time.TimeIntervalTools;

public class ContactStateProviderTools {
    static double epsilonForContinuity = 0.01;

    public static boolean checkContactSequenceIsValid(List<? extends ContactStateProvider> contactStateSequence) {
        if (!ContactStateProviderTools.checkContactSequenceDoesNotEndInFlight(contactStateSequence)) {
            return false;
        }
        return ContactStateProviderTools.checkContactSequenceIsContinuous(contactStateSequence);
    }

    static boolean checkContactSequenceIsContinuous(List<? extends ContactStateProvider> contactStateSequence) {
        return TimeIntervalTools.isTimeSequenceContinuous(contactStateSequence, (double)epsilonForContinuity);
    }

    static boolean checkContactSequenceDoesNotEndInFlight(List<? extends ContactStateProvider> contactStateSequence) {
        return contactStateSequence.get(contactStateSequence.size() - 1).getContactState().isLoadBearing();
    }
}

