/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class CoMTrajectorySegment
implements FixedFramePositionTrajectoryGenerator,
TimeIntervalProvider,
Settable<CoMTrajectorySegment> {
    private final FramePoint3D firstCoefficient = new FramePoint3D();
    private final FramePoint3D secondCoefficient = new FramePoint3D();
    private final FramePoint3D thirdCoefficient = new FramePoint3D();
    private final FramePoint3D fourthCoefficient = new FramePoint3D();
    private final FramePoint3D fifthCoefficient = new FramePoint3D();
    private final FramePoint3D sixthCoefficient = new FramePoint3D();
    private final FramePoint3D comPosition = new FramePoint3D();
    private final FrameVector3D comVelocity = new FrameVector3D();
    private final FrameVector3D comAcceleration = new FrameVector3D();
    private final FramePoint3D dcmPosition = new FramePoint3D();
    private final FrameVector3D dcmVelocity = new FrameVector3D();
    private final FramePoint3D vrpPosition = new FramePoint3D();
    private final FrameVector3D vrpVelocity = new FrameVector3D();
    private double currentTime;
    private double omega = 3.0;
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private final FramePoint3D modifiedFourthCoefficient = new FramePoint3D();
    private final FramePoint3D modifiedFifthCoefficient = new FramePoint3D();
    private final FramePoint3D modifiedSixthCoefficient = new FramePoint3D();

    public void reset() {
        this.currentTime = Double.NaN;
        this.firstCoefficient.setToNaN();
        this.secondCoefficient.setToNaN();
        this.thirdCoefficient.setToNaN();
        this.fourthCoefficient.setToNaN();
        this.fifthCoefficient.setToNaN();
        this.sixthCoefficient.setToNaN();
        this.timeInterval.reset();
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }

    public void set(CoMTrajectorySegment other) {
        this.getTimeInterval().set((TimeIntervalReadOnly)other.getTimeInterval());
        this.currentTime = other.currentTime;
        this.omega = other.omega;
        this.setCoefficients(other);
        this.comPosition.set(other.comPosition);
        this.comVelocity.set(other.comVelocity);
        this.comAcceleration.set(other.comAcceleration);
        this.dcmPosition.set(other.dcmPosition);
        this.dcmVelocity.set(other.dcmVelocity);
        this.vrpPosition.set(other.vrpPosition);
        this.vrpVelocity.set(other.vrpVelocity);
    }

    public void setCoefficients(DMatrixRMaj coefficients) {
        this.setCoefficients(coefficients, 0);
    }

    public void setCoefficients(DMatrixRMaj coefficients, int startRow) {
        this.setFirstCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow, 0), coefficients.get(startRow, 1), coefficients.get(startRow, 2));
        this.setSecondCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow + 1, 0), coefficients.get(startRow + 1, 1), coefficients.get(startRow + 1, 2));
        this.setThirdCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow + 2, 0), coefficients.get(startRow + 2, 1), coefficients.get(startRow + 2, 2));
        this.setFourthCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow + 3, 0), coefficients.get(startRow + 3, 1), coefficients.get(startRow + 3, 2));
        this.setFifthCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow + 4, 0), coefficients.get(startRow + 4, 1), coefficients.get(startRow + 4, 2));
        this.setSixthCoefficient(ReferenceFrame.getWorldFrame(), coefficients.get(startRow + 5, 0), coefficients.get(startRow + 5, 1), coefficients.get(startRow + 5, 2));
    }

    public void setCoefficients(CoMTrajectorySegment other) {
        this.setCoefficients((FramePoint3DReadOnly)other.firstCoefficient, (FramePoint3DReadOnly)other.secondCoefficient, (FramePoint3DReadOnly)other.thirdCoefficient, (FramePoint3DReadOnly)other.fourthCoefficient, (FramePoint3DReadOnly)other.fifthCoefficient, (FramePoint3DReadOnly)other.sixthCoefficient);
    }

    public void setCoefficients(FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient) {
        this.setFirstCoefficient(firstCoefficient);
        this.setSecondCoefficient(secondCoefficient);
        this.setThirdCoefficient(thirdCoefficient);
        this.setFourthCoefficient(fourthCoefficient);
        this.setFifthCoefficient(fifthCoefficient);
        this.setSixthCoefficient(sixthCoefficient);
    }

    public void setFirstCoefficient(FramePoint3DReadOnly firstCoefficient) {
        this.setFirstCoefficient(firstCoefficient.getReferenceFrame(), firstCoefficient.getX(), firstCoefficient.getY(), firstCoefficient.getZ());
    }

    public void setFirstCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.firstCoefficient.set(frame, x, y, z);
    }

    public void setSecondCoefficient(FramePoint3DReadOnly secondCoefficient) {
        this.secondCoefficient.set((FrameTuple3DReadOnly)secondCoefficient);
    }

    public void setSecondCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.secondCoefficient.set(frame, x, y, z);
    }

    public void setThirdCoefficient(FramePoint3DReadOnly thirdCoefficient) {
        this.thirdCoefficient.set((FrameTuple3DReadOnly)thirdCoefficient);
    }

    public void setThirdCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.thirdCoefficient.set(frame, x, y, z);
    }

    public void setFourthCoefficient(FramePoint3DReadOnly fourthCoefficient) {
        this.fourthCoefficient.set((FrameTuple3DReadOnly)fourthCoefficient);
    }

    public void setFourthCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.fourthCoefficient.set(frame, x, y, z);
    }

    public void setFifthCoefficient(FramePoint3DReadOnly fifthCoefficient) {
        this.fifthCoefficient.set((FrameTuple3DReadOnly)fifthCoefficient);
    }

    public void setFifthCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.fifthCoefficient.set(frame, x, y, z);
    }

    public void setSixthCoefficient(FramePoint3DReadOnly sixthCoefficient) {
        this.sixthCoefficient.set((FrameTuple3DReadOnly)sixthCoefficient);
    }

    public void setSixthCoefficient(ReferenceFrame frame, double x, double y, double z) {
        this.sixthCoefficient.set(frame, x, y, z);
    }

    public void shiftStartOfSegment(double durationToShift) {
        double originalDuration = this.getTimeInterval().getDuration();
        if (durationToShift > originalDuration) {
            throw new IllegalArgumentException("New start time " + durationToShift + " must be less than end time " + originalDuration);
        }
        double d2 = durationToShift * durationToShift;
        double d3 = d2 * durationToShift;
        double startTime = this.getTimeInterval().getStartTime();
        this.getTimeInterval().setInterval(startTime + durationToShift, this.getTimeInterval().getEndTime());
        double exponential = Math.exp(this.omega * durationToShift);
        this.firstCoefficient.scale(exponential);
        this.secondCoefficient.scale(1.0 / exponential);
        this.modifiedFourthCoefficient.scaleAdd(3.0 * durationToShift, (FrameTuple3DReadOnly)this.thirdCoefficient, (FrameTuple3DReadOnly)this.fourthCoefficient);
        this.modifiedFifthCoefficient.scaleAdd(3.0 * d2, (FrameTuple3DReadOnly)this.thirdCoefficient, (FrameTuple3DReadOnly)this.fifthCoefficient);
        this.modifiedFifthCoefficient.scaleAdd(2.0 * durationToShift, (FrameTuple3DReadOnly)this.fourthCoefficient, (FrameTuple3DReadOnly)this.modifiedFifthCoefficient);
        this.modifiedSixthCoefficient.scaleAdd(d3, (FrameTuple3DReadOnly)this.thirdCoefficient, (FrameTuple3DReadOnly)this.sixthCoefficient);
        this.modifiedSixthCoefficient.scaleAdd(d2, (FrameTuple3DReadOnly)this.fourthCoefficient, (FrameTuple3DReadOnly)this.modifiedSixthCoefficient);
        this.modifiedSixthCoefficient.scaleAdd(durationToShift, (FrameTuple3DReadOnly)this.fifthCoefficient, (FrameTuple3DReadOnly)this.modifiedSixthCoefficient);
        this.fourthCoefficient.set(this.modifiedFourthCoefficient);
        this.fifthCoefficient.set(this.modifiedFifthCoefficient);
        this.sixthCoefficient.set(this.modifiedSixthCoefficient);
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void computeCoMPosition(double time, FixedFramePoint3DBasics comPositionToPack) {
        CoMTrajectoryPlannerTools.constructDesiredCoMPosition(comPositionToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, time, this.omega);
    }

    public void computeCoMVelocity(double time, FixedFrameVector3DBasics comVelocityToPack) {
        CoMTrajectoryPlannerTools.constructDesiredCoMVelocity(comVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, time, this.omega);
    }

    public void computeCoMAcceleration(double time, FixedFrameVector3DBasics comAccelerationToPack) {
        CoMTrajectoryPlannerTools.constructDesiredCoMAcceleration(comAccelerationToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, time, this.omega);
    }

    public void computeVRPVelocity(double time, FixedFrameVector3DBasics vrpVelocityToPack) {
        CoMTrajectoryPlannerTools.constructDesiredVRPVelocity(vrpVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, time, this.omega);
    }

    public void initialize() {
    }

    public void compute(double time) {
        this.compute(time, (FixedFramePoint3DBasics)this.comPosition, (FixedFrameVector3DBasics)this.comVelocity, (FixedFrameVector3DBasics)this.comAcceleration, (FixedFramePoint3DBasics)this.dcmPosition, (FixedFrameVector3DBasics)this.dcmVelocity, (FixedFramePoint3DBasics)this.vrpPosition, (FixedFrameVector3DBasics)this.vrpVelocity);
    }

    public void compute(double time, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityTPack) {
        this.currentTime = time;
        this.computeCoMPosition(time, comPositionToPack);
        this.computeCoMVelocity(time, comVelocityToPack);
        this.computeCoMAcceleration(time, comAccelerationToPack);
        CoMTrajectoryPlannerTools.constructDesiredVRPVelocity(vrpVelocityTPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, time, this.omega);
        CapturePointTools.computeCapturePointPosition((FramePoint3DReadOnly)comPositionToPack, (FrameVector3DReadOnly)comVelocityToPack, this.omega, dcmPositionToPack);
        CapturePointTools.computeCapturePointVelocity((FrameVector3DReadOnly)comVelocityToPack, (FrameVector3DReadOnly)comAccelerationToPack, this.omega, dcmVelocityToPack);
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint3DReadOnly)dcmPositionToPack, (FrameVector3DReadOnly)dcmVelocityToPack, this.omega, vrpPositionToPack);
    }

    public FramePoint3DReadOnly getPosition() {
        return this.comPosition;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.comVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.comAcceleration;
    }

    public FramePoint3DReadOnly getDCMPosition() {
        return this.dcmPosition;
    }

    public FrameVector3DReadOnly getDCMVelocity() {
        return this.dcmVelocity;
    }

    public FramePoint3DReadOnly getVRPPosition() {
        return this.vrpPosition;
    }

    public FrameVector3DReadOnly getVRPVelocity() {
        return this.vrpVelocity;
    }

    public FramePoint3DReadOnly getFirstCoefficient() {
        return this.firstCoefficient;
    }

    public FramePoint3DReadOnly getSecondCoefficient() {
        return this.secondCoefficient;
    }

    public FramePoint3DReadOnly getThirdCoefficient() {
        return this.thirdCoefficient;
    }

    public FramePoint3DReadOnly getFourthCoefficient() {
        return this.fourthCoefficient;
    }

    public FramePoint3DReadOnly getFifthCoefficient() {
        return this.fifthCoefficient;
    }

    public FramePoint3DReadOnly getSixthCoefficient() {
        return this.sixthCoefficient;
    }

    public boolean isDone() {
        return this.currentTime >= this.getTimeInterval().getEndTime();
    }

    public void hideVisualization() {
    }

    public void showVisualization() {
    }
}

